/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLExpressionNode;

@NodeInfo(language="SL", description="The root of all SL execution trees")
public abstract class SLRootNode
extends RootNode {
    protected transient boolean isCloningAllowed;

    public SLRootNode(SLLanguage language, FrameDescriptor frameDescriptor) {
        super((TruffleLanguage)language, frameDescriptor);
    }

    public abstract SourceSection getSourceSection();

    public abstract SLExpressionNode getBodyNode();

    public String getName() {
        TruffleString name = this.getTSName();
        return name == null ? null : name.toJavaStringUncached();
    }

    public abstract TruffleString getTSName();

    public void setCloningAllowed(boolean isCloningAllowed) {
        this.isCloningAllowed = isCloningAllowed;
    }

    public boolean isCloningAllowed() {
        return this.isCloningAllowed;
    }

    public String toString() {
        return "root " + String.valueOf(this.getTSName());
    }

    public abstract Object[] getLocalValues(FrameInstance var1);

    public abstract Object[] getLocalNames(FrameInstance var1);

    public abstract void setLocalValues(FrameInstance var1, Object[] var2);

    public abstract SourceSection ensureSourceSection();
}

