/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.builtins;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.sl.SLException;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;
import com.oracle.truffle.sl.runtime.SLContext;
import com.oracle.truffle.sl.runtime.SLNull;

@NodeInfo(shortName="new")
@ImportStatic(value={SLContext.class})
public abstract class SLNewObjectBuiltin
extends SLBuiltinNode {
    @Specialization
    public Object newObject(SLNull o, @Cached(value="lookup()", neverDefault=true) AllocationReporter reporter, @Bind SLLanguage language) {
        return language.createObject(reporter);
    }

    final AllocationReporter lookup() {
        return SLContext.get(this).getAllocationReporter();
    }

    @Specialization(guards={"!values.isNull(obj)"}, limit="3")
    public Object newObject(Object obj, @CachedLibrary(value="obj") InteropLibrary values) {
        try {
            return values.instantiate(obj, new Object[0]);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw SLException.undefinedFunction(this, obj);
        }
    }
}

