/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.bytecode.BytecodeConfig;
import com.oracle.truffle.api.bytecode.BytecodeNode;
import com.oracle.truffle.api.bytecode.BytecodeParser;
import com.oracle.truffle.api.bytecode.BytecodeTier;
import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLFileDetector;
import com.oracle.truffle.sl.SLLanguageOptionDescriptors;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;
import com.oracle.truffle.sl.bytecode.SLBytecodeRootNode;
import com.oracle.truffle.sl.bytecode.SLBytecodeRootNodeGen;
import com.oracle.truffle.sl.nodes.SLAstRootNode;
import com.oracle.truffle.sl.nodes.SLBuiltinAstNode;
import com.oracle.truffle.sl.nodes.SLBuiltinAstNodeGen;
import com.oracle.truffle.sl.nodes.SLEvalRootNode;
import com.oracle.truffle.sl.nodes.SLRootNode;
import com.oracle.truffle.sl.nodes.SLUndefinedFunctionRootNode;
import com.oracle.truffle.sl.parser.SLBytecodeParser;
import com.oracle.truffle.sl.parser.SLNodeParser;
import com.oracle.truffle.sl.runtime.SLContext;
import com.oracle.truffle.sl.runtime.SLLanguageView;
import com.oracle.truffle.sl.runtime.SLObject;
import com.oracle.truffle.sl.runtime.SLStrings;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.options.OptionValues;

@TruffleLanguage.Registration(id="sl", name="SL", defaultMimeType="application/x-sl", characterMimeTypes={"application/x-sl"}, contextPolicy=TruffleLanguage.ContextPolicy.SHARED, fileTypeDetectors={SLFileDetector.class}, website="https://www.graalvm.org/graalvm-as-a-platform/implement-language/")
@ProvidedTags(value={StandardTags.CallTag.class, StandardTags.StatementTag.class, StandardTags.RootTag.class, StandardTags.RootBodyTag.class, StandardTags.ExpressionTag.class, DebuggerTags.AlwaysHalt.class, StandardTags.ReadVariableTag.class, StandardTags.WriteVariableTag.class})
@Bind.DefaultExpression(value="get($node)")
public final class SLLanguage
extends TruffleLanguage<SLContext> {
    public static volatile int counter;
    public static final String ID = "sl";
    public static final String MIME_TYPE = "application/x-sl";
    private static final Source BUILTIN_SOURCE;
    private static final boolean TRACE_INSTRUMENTATION_TREE = false;
    public static final TruffleString.Encoding STRING_ENCODING;
    private final Assumption singleContext = Truffle.getRuntime().createAssumption("Single SL context.");
    private final Map<NodeFactory<? extends SLBuiltinNode>, RootCallTarget> builtinTargets = new ConcurrentHashMap<NodeFactory<? extends SLBuiltinNode>, RootCallTarget>();
    private final Map<TruffleString, RootCallTarget> undefinedFunctions = new ConcurrentHashMap<TruffleString, RootCallTarget>();
    private final Shape rootShape;
    @Option(help="Use the SL interpreter implemented using the Truffle Bytecode DSL", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL)
    public static final OptionKey<Boolean> UseBytecode;
    @Option(help="Forces the bytecode interpreter to only use the CACHED or UNCACHED tier. Useful for testing and reproducing bugs.", category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL)
    public static final OptionKey<BytecodeTier> ForceBytecodeTier;
    private boolean useBytecode;
    private BytecodeTier forceBytecodeTier;
    private static final TruffleLanguage.LanguageReference<SLLanguage> REFERENCE;
    private static final List<NodeFactory<? extends SLBuiltinNode>> EXTERNAL_BUILTINS;

    public SLLanguage() {
        ++counter;
        this.rootShape = Shape.newBuilder().layout(SLObject.class, MethodHandles.lookup()).build();
    }

    protected SLContext createContext(TruffleLanguage.Env env) {
        this.useBytecode = (Boolean)UseBytecode.getValue(env.getOptions());
        this.forceBytecodeTier = (BytecodeTier)ForceBytecodeTier.getValue(env.getOptions());
        return new SLContext(this, env, new ArrayList<NodeFactory<? extends SLBuiltinNode>>(EXTERNAL_BUILTINS));
    }

    protected boolean patchContext(SLContext context, TruffleLanguage.Env newEnv) {
        context.patchContext(newEnv);
        return true;
    }

    protected OptionDescriptors getOptionDescriptors() {
        return new SLLanguageOptionDescriptors();
    }

    public boolean isUseBytecode() {
        return this.useBytecode;
    }

    public BytecodeTier getForceBytecodeTier() {
        return this.forceBytecodeTier;
    }

    protected boolean areOptionsCompatible(OptionValues firstOptions, OptionValues newOptions) {
        return ((Boolean)UseBytecode.getValue(firstOptions)).equals(UseBytecode.getValue(newOptions));
    }

    public RootCallTarget getOrCreateUndefinedFunction(TruffleString name) {
        RootCallTarget other;
        RootCallTarget target = this.undefinedFunctions.get(name);
        if (target == null && (other = this.undefinedFunctions.putIfAbsent(name, target = new SLUndefinedFunctionRootNode(this, name).getCallTarget())) != null) {
            target = other;
        }
        return target;
    }

    public RootCallTarget lookupBuiltin(NodeFactory<? extends SLBuiltinNode> factory) {
        RootCallTarget target = this.builtinTargets.get(factory);
        if (target != null) {
            return target;
        }
        int argumentCount = factory.getExecutionSignature().size();
        TruffleString name = SLStrings.fromJavaString(SLLanguage.lookupNodeInfo(factory.getNodeClass()).shortName());
        SLBytecodeRootNode rootNode = this.useBytecode ? this.createBytecodeBuiltin(name, argumentCount, factory) : this.createASTBuiltin(name, argumentCount, (SLBuiltinNode)((Object)factory.createNode(new Object[0])));
        RootCallTarget newTarget = rootNode.getCallTarget();
        RootCallTarget oldTarget = this.builtinTargets.putIfAbsent(factory, newTarget);
        if (oldTarget != null) {
            return oldTarget;
        }
        return newTarget;
    }

    private SLBytecodeRootNode createBytecodeBuiltin(TruffleString name, int argumentCount, NodeFactory<? extends SLBuiltinNode> factory) {
        SLBytecodeRootNode node = (SLBytecodeRootNode)((Object)SLBytecodeRootNodeGen.create(this, BytecodeConfig.DEFAULT, (BytecodeParser<SLBytecodeRootNodeGen.Builder>)((BytecodeParser)b -> {
            b.beginSource(BUILTIN_SOURCE);
            b.beginSourceSectionUnavailable();
            b.beginRoot();
            b.beginReturn();
            b.beginTag(StandardTags.RootTag.class, StandardTags.RootBodyTag.class);
            b.emitBuiltin(factory, argumentCount);
            b.endTag(StandardTags.RootTag.class, StandardTags.RootBodyTag.class);
            b.endReturn();
            b.endRoot().setTSName(name);
            b.endSourceSectionUnavailable();
            b.endSource();
        })).getNodes().get(0));
        node.getBytecodeNode().setUncachedThreshold(0);
        return node;
    }

    private RootNode createASTBuiltin(TruffleString name, int argumentCount, SLBuiltinNode builtinNode) {
        SLBuiltinAstNode builtinBodyNode = SLBuiltinAstNodeGen.create(argumentCount, builtinNode);
        builtinBodyNode.addRootTag();
        builtinBodyNode.setUnavailableSourceSection();
        return new SLAstRootNode(this, new FrameDescriptor(), builtinBodyNode, BUILTIN_SOURCE.createUnavailableSection(), name);
    }

    public static NodeInfo lookupNodeInfo(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        NodeInfo info = clazz.getAnnotation(NodeInfo.class);
        if (info != null) {
            return info;
        }
        return SLLanguage.lookupNodeInfo(clazz.getSuperclass());
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) throws Exception {
        Source source = request.getSource();
        if (!request.getArgumentNames().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("function main(");
            String sep = "";
            for (String argumentName : request.getArgumentNames()) {
                sb.append(sep);
                sb.append(argumentName);
                sep = ",";
            }
            sb.append(") { return ");
            sb.append(source.getCharacters());
            sb.append(";}");
            String language = source.getLanguage() == null ? ID : source.getLanguage();
            source = Source.newBuilder((String)language, (CharSequence)sb.toString(), (String)source.getName()).build();
        }
        Map<TruffleString, RootCallTarget> targets = this.useBytecode ? SLBytecodeParser.parseSL(this, source) : SLNodeParser.parseSL(this, source);
        RootCallTarget rootTarget = targets.get(SLStrings.MAIN);
        return new SLEvalRootNode(this, rootTarget, targets).getCallTarget();
    }

    public static void printInstrumentationTree(PrintStream w, String indent, Node node) {
        ProvidedTags tags = SLLanguage.class.getAnnotation(ProvidedTags.class);
        Class[] tagClasses = tags.value();
        if (node instanceof SLRootNode) {
            SLRootNode root = (SLRootNode)node;
            w.println(root.getQualifiedName());
            w.println(root.getSourceSection().getCharacters());
        }
        if (node instanceof BytecodeNode) {
            BytecodeNode bytecode = (BytecodeNode)node;
            w.println(bytecode.dump());
        }
        Object newIndent = indent;
        List<Class<? extends Tag>> foundTags = SLLanguage.getTags(node, tagClasses);
        if (!foundTags.isEmpty()) {
            int lineLength = 0;
            w.print(indent);
            lineLength += indent.length();
            w.print("(");
            ++lineLength;
            String sep = "";
            for (Class<? extends Tag> tag : foundTags) {
                String identifier = Tag.getIdentifier(tag);
                if (identifier == null) {
                    identifier = tag.getSimpleName();
                }
                w.print(sep);
                lineLength += sep.length();
                w.print(identifier);
                lineLength += identifier.length();
                sep = ",";
            }
            w.print(")");
            SourceSection sourceSection = node.getSourceSection();
            int spaces = 60 - ++lineLength;
            for (int i = 0; i < spaces; ++i) {
                w.print(" ");
            }
            Object characters = sourceSection.getCharacters().toString();
            if (((String)(characters = ((String)characters).replaceAll("\\n", ""))).length() > 60) {
                characters = String.valueOf(((String)characters).subSequence(0, 57)) + "...";
            }
            w.printf("%s %3s:%-3s-%3s:%-3s | %3s:%-3s   %s%n", sourceSection.getSource().getName(), sourceSection.getStartLine(), sourceSection.getStartColumn(), sourceSection.getEndLine(), sourceSection.getEndColumn(), sourceSection.getCharIndex(), sourceSection.getCharLength(), characters);
            newIndent = (String)newIndent + "  ";
        }
        for (Node child : node.getChildren()) {
            SLLanguage.printInstrumentationTree(w, (String)newIndent, child);
        }
    }

    private static List<Class<? extends Tag>> getTags(Node node, Class<?>[] tags) {
        InstrumentableNode instrumentableNode;
        if (node instanceof InstrumentableNode && (instrumentableNode = (InstrumentableNode)node).isInstrumentable()) {
            ArrayList<Class<? extends Tag>> foundTags = new ArrayList<Class<? extends Tag>>();
            for (Class<?> tag : tags) {
                if (!instrumentableNode.hasTag(tag)) continue;
                foundTags.add(tag);
            }
            return foundTags;
        }
        return List.of();
    }

    protected void initializeMultipleContexts() {
        this.singleContext.invalidate();
    }

    public boolean isSingleContext() {
        return this.singleContext.isValid();
    }

    protected Object getLanguageView(SLContext context, Object value) {
        return SLLanguageView.create(value);
    }

    protected boolean isVisible(SLContext context, Object value) {
        return !((InteropLibrary)InteropLibrary.getFactory().getUncached(value)).isNull(value);
    }

    protected Object getScope(SLContext context) {
        return context.getFunctionRegistry().getFunctionsObject();
    }

    public Shape getRootShape() {
        return this.rootShape;
    }

    public SLObject createObject(AllocationReporter reporter) {
        reporter.onEnter(null, 0L, Long.MIN_VALUE);
        SLObject object = new SLObject(this.rootShape);
        reporter.onReturnValue((Object)object, 0L, Long.MIN_VALUE);
        return object;
    }

    public static SLLanguage get(Node node) {
        return (SLLanguage)REFERENCE.get(node);
    }

    public static void installBuiltin(NodeFactory<? extends SLBuiltinNode> builtin) {
        EXTERNAL_BUILTINS.add(builtin);
    }

    protected void exitContext(SLContext context, TruffleLanguage.ExitMode exitMode, int exitCode) {
        context.runShutdownHooks();
    }

    static {
        BUILTIN_SOURCE = Source.newBuilder((String)ID, (CharSequence)"", (String)"SL builtin").build();
        STRING_ENCODING = TruffleString.Encoding.UTF_16;
        UseBytecode = new OptionKey((Object)false);
        ForceBytecodeTier = new OptionKey(null, new OptionType("bytecodeTier", s -> {
            switch (s) {
                case "CACHED": {
                    return BytecodeTier.CACHED;
                }
                case "UNCACHED": {
                    return BytecodeTier.UNCACHED;
                }
                case "": {
                    return null;
                }
            }
            throw new IllegalArgumentException("Unexpected value: " + s);
        }));
        REFERENCE = TruffleLanguage.LanguageReference.create(SLLanguage.class);
        EXTERNAL_BUILTINS = Collections.synchronizedList(new ArrayList());
    }
}

