/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.runtime.SLBigInteger;

@ExportLibrary(value=InteropLibrary.class)
public final class SLType
implements TruffleObject {
    public static final SLType NUMBER = new SLType("Number", (l, v) -> l.fitsInLong(v) || v instanceof SLBigInteger);
    public static final SLType NULL = new SLType("NULL", (l, v) -> l.isNull(v));
    public static final SLType STRING = new SLType("String", (l, v) -> l.isString(v));
    public static final SLType BOOLEAN = new SLType("Boolean", (l, v) -> l.isBoolean(v));
    public static final SLType OBJECT = new SLType("Object", (l, v) -> l.hasMembers(v));
    public static final SLType FUNCTION = new SLType("Function", (l, v) -> l.isExecutable(v));
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final SLType[] PRECEDENCE = new SLType[]{NULL, NUMBER, STRING, BOOLEAN, FUNCTION, OBJECT};
    private final String name;
    private final TypeCheck isInstance;

    private SLType(String name, TypeCheck isInstance) {
        this.name = name;
        this.isInstance = isInstance;
    }

    public boolean isInstance(Object value, InteropLibrary interop) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        return this.isInstance.check(interop, value);
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return SLLanguage.class;
    }

    @ExportMessage
    boolean isMetaObject() {
        return true;
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="getMetaQualifiedName"), @ExportMessage(name="getMetaSimpleName")})
    public Object getName() {
        return this.name;
    }

    @ExportMessage(name="toDisplayString")
    Object toDisplayString(boolean allowSideEffects) {
        return this.name;
    }

    public String toString() {
        return "SLType[" + this.name + "]";
    }

    @FunctionalInterface
    static interface TypeCheck {
        public boolean check(InteropLibrary var1, Object var2);
    }

    @ExportMessage
    static class IsMetaInstance {
        IsMetaInstance() {
        }

        @Specialization(guards={"type == cachedType"}, limit="3")
        static boolean doCached(SLType type, Object value, @Cached(value="type") SLType cachedType, @CachedLibrary(value="value") InteropLibrary valueLib) {
            return cachedType.isInstance.check(valueLib, value);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(replaces={"doCached"})
        static boolean doGeneric(SLType type, Object value) {
            return type.isInstance.check((InteropLibrary)InteropLibrary.getFactory().getUncached(), value);
        }
    }
}

