/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.local;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.NodeFields;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.interop.NodeObjectDescriptor;

@NodeChild(value="valueNode")
@NodeFields(value={@NodeField(name="slot", type=int.class), @NodeField(name="nameNode", type=SLExpressionNode.class), @NodeField(name="declaration", type=boolean.class)})
public abstract class SLWriteLocalVariableNode
extends SLExpressionNode {
    protected abstract int getSlot();

    protected abstract SLExpressionNode getNameNode();

    public abstract boolean isDeclaration();

    public final TruffleString getSlotName() {
        return (TruffleString)this.getRootNode().getFrameDescriptor().getSlotName(this.getSlot());
    }

    @Specialization(guards={"isLongOrIllegal(frame)"})
    protected long writeLong(VirtualFrame frame, long value) {
        frame.getFrameDescriptor().setSlotKind(this.getSlot(), FrameSlotKind.Long);
        frame.setLong(this.getSlot(), value);
        return value;
    }

    @Specialization(guards={"isBooleanOrIllegal(frame)"})
    protected boolean writeBoolean(VirtualFrame frame, boolean value) {
        frame.getFrameDescriptor().setSlotKind(this.getSlot(), FrameSlotKind.Boolean);
        frame.setBoolean(this.getSlot(), value);
        return value;
    }

    @Specialization(replaces={"writeLong", "writeBoolean"})
    protected Object write(VirtualFrame frame, Object value) {
        frame.getFrameDescriptor().setSlotKind(this.getSlot(), FrameSlotKind.Object);
        frame.setObject(this.getSlot(), value);
        return value;
    }

    public abstract void executeWrite(VirtualFrame var1, Object var2);

    protected boolean isLongOrIllegal(VirtualFrame frame) {
        FrameSlotKind kind = frame.getFrameDescriptor().getSlotKind(this.getSlot());
        return kind == FrameSlotKind.Long || kind == FrameSlotKind.Illegal;
    }

    protected boolean isBooleanOrIllegal(VirtualFrame frame) {
        FrameSlotKind kind = frame.getFrameDescriptor().getSlotKind(this.getSlot());
        return kind == FrameSlotKind.Boolean || kind == FrameSlotKind.Illegal;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        return tag == StandardTags.WriteVariableTag.class || super.hasTag(tag);
    }

    public Object getNodeObject() {
        SourceSection nameSourceSection;
        SLExpressionNode nameNode = this.getNameNode();
        if (nameNode.getSourceCharIndex() == -1) {
            nameSourceSection = null;
        } else {
            SourceSection rootSourceSection = this.getRootNode().getSourceSection();
            if (rootSourceSection == null) {
                nameSourceSection = null;
            } else {
                Source source = rootSourceSection.getSource();
                nameSourceSection = source.createSection(nameNode.getSourceCharIndex(), nameNode.getSourceLength());
            }
        }
        return NodeObjectDescriptor.writeVariable((TruffleString)this.getRootNode().getFrameDescriptor().getSlotName(this.getSlot()), nameSourceSection);
    }
}

