/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.runtime.SLContext;
import com.oracle.truffle.sl.runtime.SLNull;
import com.oracle.truffle.sl.runtime.SLStrings;
import java.util.Collections;
import java.util.Map;

public final class SLEvalRootNode
extends RootNode {
    private static final TruffleString ROOT_EVAL = SLStrings.constant("root eval");
    private final Map<TruffleString, RootCallTarget> functions;
    @CompilerDirectives.CompilationFinal
    private boolean registered;
    @Node.Child
    private DirectCallNode mainCallNode;
    private final SLLanguage language;

    public SLEvalRootNode(SLLanguage language, RootCallTarget rootFunction, Map<TruffleString, RootCallTarget> functions) {
        super((TruffleLanguage)language);
        this.language = language;
        this.functions = Collections.unmodifiableMap(functions);
        this.mainCallNode = rootFunction != null ? DirectCallNode.create((CallTarget)rootFunction) : null;
    }

    public boolean isInternal() {
        return true;
    }

    protected boolean isInstrumentable() {
        return false;
    }

    public String getName() {
        return ROOT_EVAL.toJavaStringUncached();
    }

    public static TruffleString getTSName() {
        return ROOT_EVAL;
    }

    public String toString() {
        return this.getName();
    }

    public Object execute(VirtualFrame frame) {
        if (this.language.isSingleContext()) {
            if (!this.registered) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.registerFunctions();
                this.registered = true;
            }
        } else {
            this.registerFunctions();
        }
        if (this.mainCallNode == null) {
            return SLNull.SINGLETON;
        }
        Object[] arguments = frame.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = SLContext.fromForeignValue(arguments[i]);
        }
        return this.mainCallNode.call(arguments);
    }

    @CompilerDirectives.TruffleBoundary
    private void registerFunctions() {
        SLContext.get((Node)this).getFunctionRegistry().register(this.functions);
    }
}

