/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.bytecode;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.bytecode.BytecodeBuilder;
import com.oracle.truffle.api.bytecode.BytecodeConfig;
import com.oracle.truffle.api.bytecode.BytecodeConfigEncoder;
import com.oracle.truffle.api.bytecode.BytecodeDSLAccess;
import com.oracle.truffle.api.bytecode.BytecodeEncodingException;
import com.oracle.truffle.api.bytecode.BytecodeLabel;
import com.oracle.truffle.api.bytecode.BytecodeLocal;
import com.oracle.truffle.api.bytecode.BytecodeLocation;
import com.oracle.truffle.api.bytecode.BytecodeNode;
import com.oracle.truffle.api.bytecode.BytecodeParser;
import com.oracle.truffle.api.bytecode.BytecodeRootNode;
import com.oracle.truffle.api.bytecode.BytecodeRootNodes;
import com.oracle.truffle.api.bytecode.BytecodeSupport;
import com.oracle.truffle.api.bytecode.BytecodeTier;
import com.oracle.truffle.api.bytecode.ExceptionHandler;
import com.oracle.truffle.api.bytecode.Instruction;
import com.oracle.truffle.api.bytecode.LocalVariable;
import com.oracle.truffle.api.bytecode.SourceInformation;
import com.oracle.truffle.api.bytecode.SourceInformationTree;
import com.oracle.truffle.api.bytecode.TagTree;
import com.oracle.truffle.api.bytecode.TagTreeNode;
import com.oracle.truffle.api.bytecode.serialization.BytecodeDeserializer;
import com.oracle.truffle.api.bytecode.serialization.BytecodeSerializer;
import com.oracle.truffle.api.bytecode.serialization.SerializationUtils;
import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameExtensions;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;
import com.oracle.truffle.sl.bytecode.SLBytecodeRootNode;
import com.oracle.truffle.sl.bytecode.SLBytecodeScopeExports;
import com.oracle.truffle.sl.nodes.SLTypes;
import com.oracle.truffle.sl.nodes.SLTypesGen;
import com.oracle.truffle.sl.nodes.expression.SLAddNode;
import com.oracle.truffle.sl.nodes.expression.SLDivNode;
import com.oracle.truffle.sl.nodes.expression.SLEqualNode;
import com.oracle.truffle.sl.nodes.expression.SLFunctionLiteralNode;
import com.oracle.truffle.sl.nodes.expression.SLLessOrEqualNode;
import com.oracle.truffle.sl.nodes.expression.SLLessThanNode;
import com.oracle.truffle.sl.nodes.expression.SLLogicalNotNode;
import com.oracle.truffle.sl.nodes.expression.SLMulNode;
import com.oracle.truffle.sl.nodes.expression.SLReadPropertyNode;
import com.oracle.truffle.sl.nodes.expression.SLSubNode;
import com.oracle.truffle.sl.nodes.expression.SLWritePropertyNode;
import com.oracle.truffle.sl.nodes.util.SLToBooleanNode;
import com.oracle.truffle.sl.nodes.util.SLToMemberNode;
import com.oracle.truffle.sl.nodes.util.SLToMemberNodeGen;
import com.oracle.truffle.sl.nodes.util.SLToTruffleStringNode;
import com.oracle.truffle.sl.nodes.util.SLToTruffleStringNodeGen;
import com.oracle.truffle.sl.nodes.util.SLUnboxNode;
import com.oracle.truffle.sl.runtime.SLBigInteger;
import com.oracle.truffle.sl.runtime.SLFunction;
import com.oracle.truffle.sl.runtime.SLNull;
import com.oracle.truffle.sl.runtime.SLObject;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

public final class SLBytecodeRootNodeGen
extends SLBytecodeRootNode {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final BytecodeDSLAccess ACCESS = BytecodeDSLAccess.lookup((Object)BytecodeRootNodesImpl.VISIBLE_TOKEN, (boolean)true);
    private static final ByteArraySupport BYTES = ACCESS.getByteArraySupport();
    private static final FrameExtensions FRAMES = ACCESS.getFrameExtensions();
    private static final int BCI_INDEX = 0;
    private static final int USER_LOCALS_START_INDEX = 1;
    private static final AtomicReferenceFieldUpdater<SLBytecodeRootNodeGen, AbstractBytecodeNode> BYTECODE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SLBytecodeRootNodeGen.class, AbstractBytecodeNode.class, "bytecode");
    private static final Class<? extends VirtualFrame> FRAME_TYPE = Truffle.getRuntime().createVirtualFrame(EMPTY_ARRAY, FrameDescriptor.newBuilder().build()).getClass();
    private static final int EXCEPTION_HANDLER_OFFSET_START_BCI = 0;
    private static final int EXCEPTION_HANDLER_OFFSET_END_BCI = 1;
    private static final int EXCEPTION_HANDLER_OFFSET_KIND = 2;
    private static final int EXCEPTION_HANDLER_OFFSET_HANDLER_BCI = 3;
    private static final int EXCEPTION_HANDLER_OFFSET_HANDLER_SP = 4;
    private static final int EXCEPTION_HANDLER_LENGTH = 5;
    private static final int SOURCE_INFO_OFFSET_START_BCI = 0;
    private static final int SOURCE_INFO_OFFSET_END_BCI = 1;
    private static final int SOURCE_INFO_OFFSET_SOURCE = 2;
    private static final int SOURCE_INFO_OFFSET_START = 3;
    private static final int SOURCE_INFO_OFFSET_LENGTH = 4;
    private static final int SOURCE_INFO_LENGTH = 5;
    private static final int LOCALS_OFFSET_START_BCI = 0;
    private static final int LOCALS_OFFSET_END_BCI = 1;
    private static final int LOCALS_OFFSET_LOCAL_INDEX = 2;
    private static final int LOCALS_OFFSET_FRAME_INDEX = 3;
    private static final int LOCALS_OFFSET_NAME = 4;
    private static final int LOCALS_OFFSET_INFO = 5;
    private static final int LOCALS_LENGTH = 6;
    private static final int HANDLER_CUSTOM = 0;
    private static final int HANDLER_TAG_EXCEPTIONAL = 1;
    private static final ConcurrentHashMap<Integer, Class<? extends Tag>[]> TAG_MASK_TO_TAGS = new ConcurrentHashMap();
    private static final ClassValue<Integer> CLASS_TO_TAG_MASK = SLBytecodeRootNodeGen.initializeTagMaskToClass();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<DynamicObjectLibrary> DYNAMIC_OBJECT_LIBRARY_ = LibraryFactory.resolve(DynamicObjectLibrary.class);
    @Node.Child
    private volatile AbstractBytecodeNode bytecode;
    private final BytecodeRootNodesImpl nodes;
    private final int maxLocals;
    private final int numLocals;
    private final int buildIndex;
    private BytecodeSupport.CloneReferenceList<SLBytecodeRootNodeGen> clones;

    private SLBytecodeRootNodeGen(SLLanguage language, FrameDescriptor.Builder builder, BytecodeRootNodesImpl nodes, int maxLocals, int numLocals, int buildIndex, byte[] bytecodes, Object[] constants, int[] handlers, int[] locals, int[] sourceInfo, List<Source> sources, int numNodes, TagRootNode tagRoot) {
        super(language, builder.build());
        this.nodes = nodes;
        this.maxLocals = maxLocals;
        this.numLocals = numLocals;
        this.buildIndex = buildIndex;
        this.bytecode = (AbstractBytecodeNode)this.insert((Node)new UncachedBytecodeNode(bytecodes, constants, handlers, locals, sourceInfo, sources, numNodes, tagRoot));
    }

    public Object execute(VirtualFrame frame) {
        return this.continueAt(this.bytecode, 0, this.maxLocals, frame);
    }

    private Object continueAt(AbstractBytecodeNode bc, int bci, int sp, VirtualFrame frame) {
        long state = ((long)sp & 0xFFFFL) << 32 | (long)bci & 0xFFFFFFFFL;
        while ((int)(state = bc.continueAt(this, frame, state)) != -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            AbstractBytecodeNode oldBytecode = bc;
            bc = this.bytecode;
            state = oldBytecode.transitionState(bc, state);
        }
        return FRAMES.uncheckedGetObject((Frame)frame, (int)((short)(state >>> 32)));
    }

    private void transitionToCached(Frame frame, int bci) {
        AbstractBytecodeNode newBytecode;
        AbstractBytecodeNode oldBytecode;
        CompilerDirectives.transferToInterpreterAndInvalidate();
        do {
            oldBytecode = this.bytecode;
            newBytecode = (AbstractBytecodeNode)this.insert((Node)oldBytecode.toCached(this.numLocals));
            if (bci > 0) {
                int localCount = newBytecode.getLocalCount(bci);
                for (int localOffset = 0; localOffset < localCount; ++localOffset) {
                    newBytecode.setLocalValue(bci, frame, localOffset, newBytecode.getLocalValue(bci, frame, localOffset));
                }
            }
            VarHandle.storeStoreFence();
            if (oldBytecode != newBytecode) continue;
            return;
        } while (!BYTECODE_UPDATER.compareAndSet(this, oldBytecode, newBytecode));
    }

    private AbstractBytecodeNode updateBytecode(byte[] bytecodes_, Object[] constants_, int[] handlers_, int[] locals_, int[] sourceInfo_, List<Source> sources_, int numNodes_, TagRootNode tagRoot_, CharSequence reason) {
        AbstractBytecodeNode newBytecode;
        AbstractBytecodeNode oldBytecode;
        CompilerAsserts.neverPartOfCompilation();
        do {
            oldBytecode = this.bytecode;
            newBytecode = (AbstractBytecodeNode)this.insert((Node)oldBytecode.update(bytecodes_, constants_, handlers_, locals_, sourceInfo_, sources_, numNodes_, tagRoot_));
            if (bytecodes_ == null) {
                newBytecode.adoptNodesAfterUpdate();
            }
            VarHandle.storeStoreFence();
        } while (!BYTECODE_UPDATER.compareAndSet(this, oldBytecode, newBytecode));
        if (bytecodes_ != null) {
            oldBytecode.invalidate(newBytecode, reason);
        }
        assert (Thread.holdsLock((Object)this.nodes));
        BytecodeSupport.CloneReferenceList<SLBytecodeRootNodeGen> cloneReferences = this.clones;
        if (cloneReferences != null) {
            cloneReferences.forEach(clone -> {
                AbstractBytecodeNode cloneNewBytecode;
                AbstractBytecodeNode cloneOldBytecode;
                do {
                    cloneOldBytecode = clone.bytecode;
                    cloneNewBytecode = (AbstractBytecodeNode)clone.insert((Node)this.bytecode.cloneUninitialized());
                    if (bytecodes_ == null) {
                        cloneNewBytecode.adoptNodesAfterUpdate();
                    }
                    VarHandle.storeStoreFence();
                } while (!BYTECODE_UPDATER.compareAndSet((SLBytecodeRootNodeGen)((Object)clone), cloneOldBytecode, cloneNewBytecode));
                if (bytecodes_ != null) {
                    cloneOldBytecode.invalidate(cloneNewBytecode, reason);
                }
            });
        }
        return newBytecode;
    }

    protected boolean isInstrumentable() {
        return true;
    }

    protected void prepareForInstrumentation(Set<Class<?>> materializedTags) {
        BytecodeConfig.Builder b = SLBytecodeRootNodeGen.newConfigBuilder();
        b.addSource();
        for (Class<?> tag : materializedTags) {
            b.addTag(tag);
        }
        this.getRootNodes().update(b.build());
    }

    protected boolean prepareForCompilation(boolean rootCompilation, int compilationTier, boolean lastTier) {
        return this.bytecode.getTier() != BytecodeTier.UNCACHED;
    }

    protected Node findInstrumentableCallNode(Node callNode, Frame frame, int bytecodeIndex) {
        BytecodeNode bc = BytecodeNode.get((Node)callNode);
        if (bc == null || !(bc instanceof AbstractBytecodeNode)) {
            return super.findInstrumentableCallNode(callNode, frame, bytecodeIndex);
        }
        AbstractBytecodeNode bytecodeNode = (AbstractBytecodeNode)bc;
        return bytecodeNode.findInstrumentableCallNode(bytecodeIndex);
    }

    protected boolean isCloneUninitializedSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RootNode cloneUninitialized() {
        SLBytecodeRootNodeGen clone;
        BytecodeRootNodesImpl bytecodeRootNodesImpl = this.nodes;
        synchronized (bytecodeRootNodesImpl) {
            clone = (SLBytecodeRootNodeGen)this.copy();
            clone.clones = null;
            clone.bytecode = (AbstractBytecodeNode)this.insert((Node)this.bytecode.cloneUninitialized());
            BytecodeSupport.CloneReferenceList localClones = this.clones;
            if (localClones == null) {
                this.clones = localClones = new BytecodeSupport.CloneReferenceList();
            }
            localClones.add((Object)clone);
        }
        VarHandle.storeStoreFence();
        return clone;
    }

    protected int findBytecodeIndex(Node node, Frame frame) {
        AbstractBytecodeNode bytecode = null;
        Node prev = node;
        Node current = node;
        while (current != null) {
            if (current instanceof AbstractBytecodeNode) {
                AbstractBytecodeNode b;
                bytecode = b = (AbstractBytecodeNode)current;
                break;
            }
            prev = current;
            current = prev.getParent();
        }
        if (bytecode == null) {
            return -1;
        }
        return bytecode.findBytecodeIndex(frame, prev);
    }

    protected boolean isCaptureFramesForTrace(boolean compiled) {
        return !compiled;
    }

    public BytecodeNode getBytecodeNode() {
        return this.bytecode;
    }

    private AbstractBytecodeNode getBytecodeNodeImpl() {
        return this.bytecode;
    }

    private SLBytecodeRootNodeGen getBytecodeRootNodeImpl(int index) {
        return (SLBytecodeRootNodeGen)this.nodes.getNode(index);
    }

    public BytecodeRootNodes<SLBytecodeRootNode> getRootNodes() {
        return this.nodes;
    }

    protected boolean countsTowardsStackTraceLimit() {
        return true;
    }

    @Override
    public SourceSection getSourceSection() {
        return this.bytecode.getSourceSection();
    }

    @Override
    protected Object translateStackTraceElement(TruffleStackTraceElement stackTraceElement) {
        return AbstractBytecodeNode.createStackTraceElement(stackTraceElement);
    }

    protected int computeSize() {
        return this.bytecode.bytecodes.length / 10;
    }

    private static long expectLong(Object value) throws UnexpectedResultException {
        if (value instanceof Long) {
            return (Long)value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    private static boolean expectBoolean(Object value) throws UnexpectedResultException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static BytecodeConfig.Builder newConfigBuilder() {
        return BytecodeConfig.newBuilder((BytecodeConfigEncoder)BytecodeConfigEncoderImpl.INSTANCE);
    }

    private static int encodeTags(Class<?> ... tags) {
        if (tags == null) {
            return 0;
        }
        int tagMask = 0;
        for (Class<?> tag : tags) {
            tagMask |= CLASS_TO_TAG_MASK.get(tag).intValue();
        }
        return tagMask;
    }

    public static BytecodeRootNodes<SLBytecodeRootNode> create(SLLanguage language, BytecodeConfig config, BytecodeParser<Builder> parser) {
        BytecodeRootNodesImpl nodes = new BytecodeRootNodesImpl(parser, config);
        Builder builder = new Builder(language, nodes, config);
        parser.parse((BytecodeBuilder)builder);
        builder.finish();
        return nodes;
    }

    @CompilerDirectives.TruffleBoundary
    public static void serialize(DataOutput buffer, BytecodeSerializer callback, BytecodeParser<Builder> parser) throws IOException {
        Builder builder = new Builder(null, new BytecodeRootNodesImpl(parser, BytecodeConfig.COMPLETE), BytecodeConfig.COMPLETE);
        SLBytecodeRootNodeGen.doSerialize(buffer, callback, builder, null);
    }

    @CompilerDirectives.TruffleBoundary
    private static void doSerialize(DataOutput buffer, BytecodeSerializer callback, Builder builder, List<SLBytecodeRootNode> existingNodes) throws IOException {
        try {
            builder.serialize(buffer, callback, existingNodes);
        }
        catch (IOError e) {
            throw (IOException)e.getCause();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static BytecodeRootNodes<SLBytecodeRootNode> deserialize(SLLanguage language, BytecodeConfig config, Supplier<DataInput> input, BytecodeDeserializer callback) throws IOException {
        try {
            return SLBytecodeRootNodeGen.create(language, config, (BytecodeParser<Builder>)((BytecodeParser)b -> b.deserialize(input, callback, null)));
        }
        catch (IOError e) {
            throw (IOException)e.getCause();
        }
    }

    private static Class<? extends Tag>[] mapTagMaskToTagsArray(int tagMask) {
        ArrayList<Class> tags = new ArrayList<Class>();
        if ((tagMask & 1) != 0) {
            tags.add(StandardTags.CallTag.class);
        }
        if ((tagMask & 2) != 0) {
            tags.add(StandardTags.StatementTag.class);
        }
        if ((tagMask & 4) != 0) {
            tags.add(StandardTags.RootTag.class);
        }
        if ((tagMask & 8) != 0) {
            tags.add(StandardTags.RootBodyTag.class);
        }
        if ((tagMask & 0x10) != 0) {
            tags.add(StandardTags.ExpressionTag.class);
        }
        if ((tagMask & 0x20) != 0) {
            tags.add(DebuggerTags.AlwaysHalt.class);
        }
        if ((tagMask & 0x40) != 0) {
            tags.add(StandardTags.ReadVariableTag.class);
        }
        if ((tagMask & 0x80) != 0) {
            tags.add(StandardTags.WriteVariableTag.class);
        }
        return tags.toArray(new Class[tags.size()]);
    }

    private static ClassValue<Integer> initializeTagMaskToClass() {
        return new ClassValue<Integer>(){

            @Override
            protected Integer computeValue(Class<?> type) {
                if (type == StandardTags.CallTag.class) {
                    return 1;
                }
                if (type == StandardTags.StatementTag.class) {
                    return 2;
                }
                if (type == StandardTags.RootTag.class) {
                    return 4;
                }
                if (type == StandardTags.RootBodyTag.class) {
                    return 8;
                }
                if (type == StandardTags.ExpressionTag.class) {
                    return 16;
                }
                if (type == DebuggerTags.AlwaysHalt.class) {
                    return 32;
                }
                if (type == StandardTags.ReadVariableTag.class) {
                    return 64;
                }
                if (type == StandardTags.WriteVariableTag.class) {
                    return 128;
                }
                throw new IllegalArgumentException(String.format("Invalid tag specified. Tag '%s' not provided by language 'com.oracle.truffle.sl.SLLanguage'.", type.getName()));
            }
        };
    }

    private static <E extends Throwable> RuntimeException sneakyThrow(Throwable e) throws E {
        throw e;
    }

    @CompilerDirectives.TruffleBoundary
    private static AssertionError assertionFailed(String message) {
        throw new AssertionError((Object)message);
    }

    @ExplodeLoop
    private static Object[] readVariadic(VirtualFrame frame, int sp, int variadicCount) {
        Object[] result = new Object[variadicCount];
        for (int i = 0; i < variadicCount; ++i) {
            int index = sp - variadicCount + i;
            result[i] = FRAMES.uncheckedGetObject((Frame)frame, index);
            FRAMES.clear((Frame)frame, index);
        }
        return result;
    }

    private static Object[] mergeVariadic(Object[] array) {
        int currentLength;
        int currentLength2;
        Object[] current = array;
        int length = 0;
        do {
            currentLength2 = current.length - 1;
            length += currentLength2;
        } while ((current = (Object[])current[currentLength2]) != null);
        Object[] newArray = new Object[length];
        current = array;
        int index = 0;
        do {
            currentLength = current.length - 1;
            System.arraycopy(current, 0, newArray, index, currentLength);
            index += currentLength;
        } while ((current = (Object[])current[currentLength]) != null);
        return newArray;
    }

    private static short applyQuickeningLong(short $operand) {
        switch ($operand) {
            case 1: 
            case 2: {
                return 2;
            }
            case 4: 
            case 5: {
                return 5;
            }
            case 8: 
            case 9: {
                return 9;
            }
            case 47: 
            case 48: {
                return 48;
            }
            case 59: 
            case 60: {
                return 60;
            }
            case 62: 
            case 63: {
                return 63;
            }
            case 84: 
            case 85: {
                return 85;
            }
            case 88: 
            case 89: {
                return 89;
            }
            case 94: 
            case 95: {
                return 95;
            }
            case 104: 
            case 105: {
                return 105;
            }
        }
        return -1;
    }

    private static boolean isQuickeningLong(short operand) {
        switch (operand) {
            case 2: 
            case 5: 
            case 9: 
            case 48: 
            case 60: 
            case 63: 
            case 85: 
            case 89: 
            case 95: 
            case 105: {
                return true;
            }
        }
        return false;
    }

    private static short applyQuickeningBoolean(short $operand) {
        switch ($operand) {
            case 1: 
            case 3: {
                return 3;
            }
            case 4: 
            case 6: {
                return 6;
            }
            case 10: 
            case 11: {
                return 11;
            }
            case 49: 
            case 50: {
                return 50;
            }
            case 65: 
            case 66: {
                return 66;
            }
            case 67: 
            case 68: {
                return 68;
            }
            case 64: 
            case 69: {
                return 69;
            }
            case 71: 
            case 72: {
                return 72;
            }
            case 73: 
            case 74: {
                return 74;
            }
            case 76: 
            case 77: {
                return 77;
            }
            case 75: 
            case 78: {
                return 78;
            }
            case 80: 
            case 81: {
                return 81;
            }
            case 79: 
            case 82: {
                return 82;
            }
            case 92: 
            case 93: {
                return 93;
            }
            case 98: 
            case 99: {
                return 99;
            }
            case 97: 
            case 100: {
                return 100;
            }
            case 106: 
            case 107: {
                return 107;
            }
        }
        return -1;
    }

    private static boolean isQuickeningBoolean(short operand) {
        switch (operand) {
            case 3: 
            case 6: 
            case 11: 
            case 50: 
            case 66: 
            case 68: 
            case 69: 
            case 72: 
            case 74: 
            case 77: 
            case 78: 
            case 81: 
            case 82: 
            case 93: 
            case 99: 
            case 100: 
            case 107: {
                return true;
            }
        }
        return false;
    }

    private static short undoQuickening(short $operand) {
        switch ($operand) {
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 4;
            }
            case 9: {
                return 8;
            }
            case 11: {
                return 10;
            }
            case 24: {
                return 22;
            }
            case 48: {
                return 47;
            }
            case 50: {
                return 49;
            }
            case 60: {
                return 59;
            }
            case 63: {
                return 62;
            }
            case 66: {
                return 65;
            }
            case 68: {
                return 67;
            }
            case 69: {
                return 64;
            }
            case 72: {
                return 71;
            }
            case 74: {
                return 73;
            }
            case 77: {
                return 76;
            }
            case 78: {
                return 75;
            }
            case 81: {
                return 80;
            }
            case 82: {
                return 79;
            }
            case 85: {
                return 84;
            }
            case 89: {
                return 88;
            }
            case 93: {
                return 92;
            }
            case 95: {
                return 94;
            }
            case 99: {
                return 98;
            }
            case 100: {
                return 97;
            }
            case 105: {
                return 104;
            }
            case 107: {
                return 106;
            }
        }
        return $operand;
    }

    private static final class BytecodeRootNodesImpl
    extends BytecodeRootNodes<SLBytecodeRootNode> {
        private static final Object VISIBLE_TOKEN = TOKEN;
        @CompilerDirectives.CompilationFinal
        private volatile long encoding;

        BytecodeRootNodesImpl(BytecodeParser<Builder> generator, BytecodeConfig config) {
            super(VISIBLE_TOKEN, generator);
            this.encoding = BytecodeConfigEncoderImpl.decode(config);
        }

        protected boolean updateImpl(BytecodeConfigEncoder encoder, long encoding) {
            long oldEncoding = this.encoding;
            long maskedEncoding = BytecodeConfigEncoderImpl.decode(encoder, encoding);
            long newEncoding = maskedEncoding | oldEncoding;
            if ((oldEncoding | newEncoding) == oldEncoding) {
                return false;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.performUpdate(maskedEncoding);
        }

        private synchronized boolean performUpdate(long maskedEncoding) {
            boolean needsSourceReparse;
            CompilerAsserts.neverPartOfCompilation();
            long oldEncoding = this.encoding;
            long newEncoding = maskedEncoding | oldEncoding;
            if ((oldEncoding | newEncoding) == oldEncoding) {
                return false;
            }
            boolean oldSources = (oldEncoding & 1L) != 0L;
            int oldInstrumentations = (int)(oldEncoding >> 1 & Integer.MAX_VALUE);
            int oldTags = (int)(oldEncoding >> 32 & 0xFFFFFFFFFFFFFFFFL);
            boolean newSources = (newEncoding & 1L) != 0L;
            int newInstrumentations = (int)(newEncoding >> 1 & Integer.MAX_VALUE);
            int newTags = (int)(newEncoding >> 32 & 0xFFFFFFFFFFFFFFFFL);
            boolean needsBytecodeReparse = newInstrumentations != oldInstrumentations || newTags != oldTags;
            boolean bl = needsSourceReparse = newSources != oldSources || needsBytecodeReparse && newSources;
            if (!needsBytecodeReparse && !needsSourceReparse) {
                return false;
            }
            BytecodeParser<Builder> parser = this.getParserImpl();
            UpdateReason reason = new UpdateReason(oldSources != newSources, newInstrumentations & ~oldInstrumentations, newTags & ~oldTags);
            Builder builder = new Builder(this, needsBytecodeReparse, newTags, newInstrumentations, needsSourceReparse, reason);
            for (SLBytecodeRootNode node : (SLBytecodeRootNode[])this.nodes) {
                builder.builtNodes.add((SLBytecodeRootNodeGen)node);
            }
            parser.parse((BytecodeBuilder)builder);
            builder.finish();
            this.encoding = newEncoding;
            return true;
        }

        private void setNodes(SLBytecodeRootNodeGen[] nodes) {
            if (this.nodes != null) {
                throw new AssertionError();
            }
            this.nodes = nodes;
            for (SLBytecodeRootNodeGen node : nodes) {
                if (node.getRootNodes() != this) {
                    throw new AssertionError();
                }
                if (node != nodes[node.buildIndex]) {
                    throw new AssertionError();
                }
            }
        }

        private BytecodeParser<Builder> getParserImpl() {
            return super.getParser();
        }

        private boolean validate() {
            for (SLBytecodeRootNode node : (SLBytecodeRootNode[])this.nodes) {
                ((SLBytecodeRootNodeGen)node).getBytecodeNodeImpl().validateBytecodes();
            }
            return true;
        }

        private SLLanguage getLanguage() {
            if (((SLBytecodeRootNode[])this.nodes).length == 0) {
                return null;
            }
            return (SLLanguage)((SLBytecodeRootNode[])this.nodes)[0].getLanguage(SLLanguage.class);
        }

        public void serialize(DataOutput buffer, BytecodeSerializer callback) throws IOException {
            ArrayList<SLBytecodeRootNode> existingNodes = new ArrayList<SLBytecodeRootNode>(((SLBytecodeRootNode[])this.nodes).length);
            for (int i = 0; i < ((SLBytecodeRootNode[])this.nodes).length; ++i) {
                existingNodes.add((SLBytecodeRootNodeGen)((SLBytecodeRootNode[])this.nodes)[i]);
            }
            SLBytecodeRootNodeGen.doSerialize(buffer, callback, new Builder(this.getLanguage(), this, BytecodeConfig.COMPLETE), existingNodes);
        }

        private static final class UpdateReason
        implements CharSequence {
            private final boolean newSources;
            private final int newInstrumentations;
            private final int newTags;

            UpdateReason(boolean newSources, int newInstrumentations, int newTags) {
                this.newSources = newSources;
                this.newInstrumentations = newInstrumentations;
                this.newTags = newTags;
            }

            @Override
            public int length() {
                return this.toString().length();
            }

            @Override
            public char charAt(int index) {
                return this.toString().charAt(index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return this.toString().subSequence(start, end);
            }

            @Override
            public String toString() {
                StringBuilder message = new StringBuilder();
                message.append("SLBytecodeRootNode requested ");
                String sep = "";
                if (this.newSources) {
                    message.append("SourceInformation");
                    sep = ", ";
                }
                if (this.newTags != 0) {
                    if ((this.newTags & 1) != 0) {
                        message.append(sep);
                        message.append("Tag[CallTag]");
                        sep = ", ";
                    }
                    if ((this.newTags & 2) != 0) {
                        message.append(sep);
                        message.append("Tag[StatementTag]");
                        sep = ", ";
                    }
                    if ((this.newTags & 4) != 0) {
                        message.append(sep);
                        message.append("Tag[RootTag]");
                        sep = ", ";
                    }
                    if ((this.newTags & 8) != 0) {
                        message.append(sep);
                        message.append("Tag[RootBodyTag]");
                        sep = ", ";
                    }
                    if ((this.newTags & 0x10) != 0) {
                        message.append(sep);
                        message.append("Tag[ExpressionTag]");
                        sep = ", ";
                    }
                    if ((this.newTags & 0x20) != 0) {
                        message.append(sep);
                        message.append("Tag[AlwaysHalt]");
                        sep = ", ";
                    }
                    if ((this.newTags & 0x40) != 0) {
                        message.append(sep);
                        message.append("Tag[ReadVariableTag]");
                        sep = ", ";
                    }
                    if ((this.newTags & 0x80) != 0) {
                        message.append(sep);
                        message.append("Tag[WriteVariableTag]");
                        sep = ", ";
                    }
                }
                message.append(".");
                return message.toString();
            }
        }
    }

    @DenyReplace
    private static final class UncachedBytecodeNode
    extends AbstractBytecodeNode {
        private int uncachedExecuteCount_;

        UncachedBytecodeNode(byte[] bytecodes, Object[] constants, int[] handlers, int[] locals, int[] sourceInfo, List<Source> sources, int numNodes, TagRootNode tagRoot) {
            super(bytecodes, constants, handlers, locals, sourceInfo, sources, numNodes, tagRoot);
            this.uncachedExecuteCount_ = 16;
        }

        UncachedBytecodeNode(byte[] bytecodes, Object[] constants, int[] handlers, int[] locals, int[] sourceInfo, List<Source> sources, int numNodes, TagRootNode tagRoot, int uncachedExecuteCount_) {
            super(bytecodes, constants, handlers, locals, sourceInfo, sources, numNodes, tagRoot);
            this.uncachedExecuteCount_ = uncachedExecuteCount_;
        }

        /*
         * Exception decompiling
         */
        @Override
        @HostCompilerDirectives.BytecodeInterpreterSwitch
        long continueAt(SLBytecodeRootNodeGen $root, VirtualFrame frame_, long startState) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 22[CASE]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void doLoadLocal(Frame frame, byte[] bc, int bci, int sp) {
            FRAMES.setObject(frame, sp, FRAMES.requireObject(frame, (int)BYTES.getShort(bc, bci + 2)));
        }

        private void doStoreLocal(Frame frame, byte[] bc, int bci, int sp) {
            Object local = FRAMES.requireObject(frame, sp - 1);
            FRAMES.setObject(frame, (int)BYTES.getShort(bc, bci + 2), local);
            FRAMES.clear(frame, sp - 1);
        }

        @HostCompilerDirectives.InliningCutoff
        private void doTagEnter(VirtualFrame frame, byte[] bc, int bci, int sp) {
            TagNode tagNode = (TagNode)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])this.tagRoot.tagNodes, BYTES.getIntUnaligned(bc, bci + 2)), TagNode.class));
            tagNode.findProbe().onEnter(frame);
        }

        private void doTagLeave(VirtualFrame frame, byte[] bc, int bci, int sp) {
            Object returnValue;
            try {
                returnValue = FRAMES.expectObject((Frame)frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                this.doTagLeave(frame, bc, bci, sp);
                return;
            }
            TagNode tagNode = (TagNode)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])this.tagRoot.tagNodes, BYTES.getIntUnaligned(bc, bci + 2)), TagNode.class));
            tagNode.findProbe().onReturnValue(frame, returnValue);
        }

        @HostCompilerDirectives.InliningCutoff
        private void doTagLeaveVoid(VirtualFrame frame, byte[] bc, int bci, int sp) {
            TagNode tagNode = (TagNode)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])this.tagRoot.tagNodes, BYTES.getIntUnaligned(bc, bci + 2)), TagNode.class));
            tagNode.findProbe().onReturnValue(frame, null);
        }

        private void doSLAlwaysHalt_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            SLAlwaysHalt_Node.UNCACHED.executeUncached(frame, this, bc, bci, sp);
        }

        private void doSLLoadArgument_(VirtualFrame frame, byte[] bc, int bci, int sp, Object[] consts) {
            FRAMES.setInt((Frame)frame, 0, bci);
            Object result = SLLoadArgument_Node.UNCACHED.executeUncached(frame, (Integer)ACCESS.uncheckedCast(ACCESS.readObject(consts, BYTES.getIntUnaligned(bc, bci + 2)), Integer.class), this, bc, bci, sp, consts);
            FRAMES.setObject((Frame)frame, sp, result);
        }

        private void doBuiltin_(VirtualFrame frame, byte[] bc, int bci, int sp, Object[] consts) {
            FRAMES.setInt((Frame)frame, 0, bci);
            Object result = Builtin_Node.UNCACHED.executeUncached(frame, (NodeFactory)ACCESS.uncheckedCast(ACCESS.readObject(consts, BYTES.getIntUnaligned(bc, bci + 2)), NodeFactory.class), (Integer)ACCESS.uncheckedCast(ACCESS.readObject(consts, BYTES.getIntUnaligned(bc, bci + 6)), Integer.class), this, bc, bci, sp, consts);
            FRAMES.setObject((Frame)frame, sp, result);
        }

        private void doSLInvoke_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            FRAMES.setInt((Frame)frame, 0, bci);
            Object result = SLInvoke_Node.UNCACHED.executeUncached(frame, FRAMES.uncheckedGetObject((Frame)frame, sp - 2), (Object[])FRAMES.uncheckedGetObject((Frame)frame, sp - 1), this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLAdd_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            FRAMES.setInt((Frame)frame, 0, bci);
            Object result = SLAdd_Node.UNCACHED.executeUncached(frame, FRAMES.uncheckedGetObject((Frame)frame, sp - 2), FRAMES.uncheckedGetObject((Frame)frame, sp - 1), this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLDiv_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            FRAMES.setInt((Frame)frame, 0, bci);
            Object result = SLDiv_Node.UNCACHED.executeUncached(frame, FRAMES.uncheckedGetObject((Frame)frame, sp - 2), FRAMES.uncheckedGetObject((Frame)frame, sp - 1), this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLEqual_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            FRAMES.setInt((Frame)frame, 0, bci);
            boolean result = SLEqual_Node.UNCACHED.executeUncached(frame, FRAMES.uncheckedGetObject((Frame)frame, sp - 2), FRAMES.uncheckedGetObject((Frame)frame, sp - 1), this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, (Object)result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLLessOrEqual_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            FRAMES.setInt((Frame)frame, 0, bci);
            Object result = SLLessOrEqual_Node.UNCACHED.executeUncached(frame, FRAMES.uncheckedGetObject((Frame)frame, sp - 2), FRAMES.uncheckedGetObject((Frame)frame, sp - 1), this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLLessThan_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            FRAMES.setInt((Frame)frame, 0, bci);
            boolean result = SLLessThan_Node.UNCACHED.executeUncached(frame, FRAMES.uncheckedGetObject((Frame)frame, sp - 2), FRAMES.uncheckedGetObject((Frame)frame, sp - 1), this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, (Object)result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLLogicalNot_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            FRAMES.setInt((Frame)frame, 0, bci);
            boolean result = SLLogicalNot_Node.UNCACHED.executeUncached(frame, FRAMES.uncheckedGetObject((Frame)frame, sp - 1), this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 1, (Object)result);
        }

        private void doSLMul_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            FRAMES.setInt((Frame)frame, 0, bci);
            Object result = SLMul_Node.UNCACHED.executeUncached(frame, FRAMES.uncheckedGetObject((Frame)frame, sp - 2), FRAMES.uncheckedGetObject((Frame)frame, sp - 1), this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLReadProperty_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            FRAMES.setInt((Frame)frame, 0, bci);
            Object result = SLReadProperty_Node.UNCACHED.executeUncached(frame, FRAMES.uncheckedGetObject((Frame)frame, sp - 2), FRAMES.uncheckedGetObject((Frame)frame, sp - 1), this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLSub_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            FRAMES.setInt((Frame)frame, 0, bci);
            Object result = SLSub_Node.UNCACHED.executeUncached(frame, FRAMES.uncheckedGetObject((Frame)frame, sp - 2), FRAMES.uncheckedGetObject((Frame)frame, sp - 1), this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLWriteProperty_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            FRAMES.setInt((Frame)frame, 0, bci);
            Object result = SLWriteProperty_Node.UNCACHED.executeUncached(frame, FRAMES.uncheckedGetObject((Frame)frame, sp - 3), FRAMES.uncheckedGetObject((Frame)frame, sp - 2), FRAMES.uncheckedGetObject((Frame)frame, sp - 1), this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 3, result);
            FRAMES.clear((Frame)frame, sp - 2);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLUnbox_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            FRAMES.setInt((Frame)frame, 0, bci);
            Object result = SLUnbox_Node.UNCACHED.executeUncached(frame, FRAMES.uncheckedGetObject((Frame)frame, sp - 1), this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 1, result);
        }

        private void doSLFunctionLiteral_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            FRAMES.setInt((Frame)frame, 0, bci);
            SLFunction result = SLFunctionLiteral_Node.UNCACHED.executeUncached(frame, FRAMES.uncheckedGetObject((Frame)frame, sp - 1), this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 1, (Object)result);
        }

        private void doSLToBoolean_(VirtualFrame frame, byte[] bc, int bci, int sp) {
            FRAMES.setInt((Frame)frame, 0, bci);
            boolean result = SLToBoolean_Node.UNCACHED.executeUncached(frame, FRAMES.uncheckedGetObject((Frame)frame, sp - 1), this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 1, (Object)result);
        }

        public void setUncachedThreshold(int threshold) {
            CompilerAsserts.neverPartOfCompilation();
            if (threshold < 0 && threshold != Integer.MIN_VALUE) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException("threshold cannot be a negative value other than Integer.MIN_VALUE");
            }
            this.uncachedExecuteCount_ = threshold;
        }

        public BytecodeTier getTier() {
            return BytecodeTier.UNCACHED;
        }

        @HostCompilerDirectives.InliningCutoff
        private Throwable resolveThrowable(SLBytecodeRootNodeGen $root, VirtualFrame frame, int bci, Throwable throwable) {
            if (throwable instanceof AbstractTruffleException) {
                AbstractTruffleException ate = (AbstractTruffleException)throwable;
                return ate;
            }
            if (throwable instanceof ControlFlowException) {
                ControlFlowException cfe = (ControlFlowException)throwable;
                throw cfe;
            }
            if (throwable instanceof ThreadDeath) {
                ThreadDeath cfe = (ThreadDeath)throwable;
                return cfe;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw SLBytecodeRootNodeGen.sneakyThrow(throwable);
        }

        private Object doTagExceptional(VirtualFrame frame, TagNode node, int nodeId, byte[] bc, int bci, Throwable exception) throws Throwable {
            return node.findProbe().onReturnExceptionalOrUnwind(frame, exception, switch (this.readValidBytecode(bc, bci)) {
                case 46, 47, 48, 49, 50, 51 -> BYTES.getIntUnaligned(bc, bci + 2) == nodeId;
                case 52 -> BYTES.getIntUnaligned(bc, bci + 2) == nodeId;
                default -> false;
            });
        }

        @Override
        byte[] getLocalTags() {
            return null;
        }

        public Object getLocalValue(int bci, Frame frame, int localOffset) {
            assert (this.validateBytecodeIndex(bci));
            CompilerAsserts.partialEvaluationConstant((int)bci);
            CompilerAsserts.partialEvaluationConstant((int)localOffset);
            assert (localOffset >= 0 && localOffset < this.getLocalCount(bci)) : "Invalid out-of-bounds local offset provided.";
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            int frameIndex = 1 + localOffset;
            if (frame.isObject(frameIndex)) {
                return frame.getObject(frameIndex);
            }
            return null;
        }

        public void setLocalValue(int bci, Frame frame, int localOffset, Object value) {
            assert (this.validateBytecodeIndex(bci));
            CompilerAsserts.partialEvaluationConstant((int)bci);
            CompilerAsserts.partialEvaluationConstant((int)localOffset);
            assert (localOffset >= 0 && localOffset < this.getLocalCount(bci)) : "Invalid out-of-bounds local offset provided.";
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            frame.setObject(localOffset + 1, value);
        }

        protected Object getLocalValueInternal(Frame frame, int localOffset, int localIndex) {
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            return frame.getObject(1 + localOffset);
        }

        @Override
        protected void setLocalValueInternal(Frame frame, int localOffset, int localIndex, Object value) {
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            frame.setObject(1 + localOffset, value);
        }

        protected long getLocalValueInternalLong(Frame frame, int localOffset, int localIndex) throws UnexpectedResultException {
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            Object value = frame.getObject(1 + localOffset);
            if (value instanceof Long) {
                Long castValue = (Long)value;
                return castValue;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(value);
        }

        protected void setLocalValueInternalLong(Frame frame, int localOffset, int localIndex, long value) {
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            frame.setObject(1 + localOffset, (Object)value);
        }

        protected boolean getLocalValueInternalBoolean(Frame frame, int localOffset, int localIndex) throws UnexpectedResultException {
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            Object value = frame.getObject(1 + localOffset);
            if (value instanceof Boolean) {
                Boolean castValue = (Boolean)value;
                return castValue;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(value);
        }

        protected void setLocalValueInternalBoolean(Frame frame, int localOffset, int localIndex, boolean value) {
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            frame.setObject(1 + localOffset, (Object)value);
        }

        @Override
        byte getCachedLocalTagInternal(byte[] localTags, int localIndex) {
            return 0;
        }

        @Override
        void setCachedLocalTagInternal(byte[] localTags, int localIndex, byte tag) {
        }

        @Override
        AbstractBytecodeNode toCached(int numLocals) {
            return new CachedBytecodeNode(this.bytecodes, this.constants, this.handlers, this.locals, this.sourceInfo, this.sources, this.numNodes, this.tagRoot, numLocals);
        }

        @Override
        AbstractBytecodeNode update(byte[] bytecodes_, Object[] constants_, int[] handlers_, int[] locals_, int[] sourceInfo_, List<Source> sources_, int numNodes_, TagRootNode tagRoot_) {
            List sources__;
            int[] sourceInfo__;
            TagRootNode tagRoot__;
            int[] locals__;
            int numNodes__;
            int[] handlers__;
            Object[] constants__;
            byte[] bytecodes__;
            assert (bytecodes_ != null || sourceInfo_ != null);
            if (bytecodes_ != null) {
                bytecodes__ = bytecodes_;
                constants__ = constants_;
                handlers__ = handlers_;
                numNodes__ = numNodes_;
                locals__ = locals_;
                tagRoot__ = tagRoot_;
            } else {
                bytecodes__ = this.bytecodes;
                constants__ = this.constants;
                handlers__ = this.handlers;
                numNodes__ = this.numNodes;
                locals__ = this.locals;
                tagRoot__ = this.tagRoot;
            }
            if (sourceInfo_ != null) {
                sourceInfo__ = sourceInfo_;
                sources__ = sources_;
            } else {
                sourceInfo__ = this.sourceInfo;
                sources__ = this.sources;
            }
            return new UncachedBytecodeNode(bytecodes__, constants__, handlers__, locals__, sourceInfo__, sources__, numNodes__, tagRoot__, this.uncachedExecuteCount_);
        }

        @Override
        AbstractBytecodeNode cloneUninitialized() {
            return new UncachedBytecodeNode(Arrays.copyOf(this.bytecodes, this.bytecodes.length), this.constants, this.handlers, this.locals, this.sourceInfo, this.sources, this.numNodes, this.tagRoot != null ? (TagRootNode)this.tagRoot.deepCopy() : null);
        }

        @Override
        Node[] getCachedNodes() {
            return null;
        }

        @Override
        int[] getBranchProfiles() {
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        protected int findBytecodeIndex(FrameInstance frameInstance) {
            return frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY).getInt(0);
        }

        @Override
        protected int findBytecodeIndex(Frame frame, Node node) {
            return frame.getInt(0);
        }

        int findBytecodeIndexOfOperationNode(Node operationNode) {
            return -1;
        }

        public String toString() {
            return String.format("BytecodeNode [name=%s, sources=%s, tier=uncached]", ((RootNode)this.getParent()).getQualifiedName(), this.sourceInfo != null);
        }

        private static void doPop(Frame frame, byte[] bc, int bci, int sp) {
            FRAMES.clear(frame, sp - 1);
        }

        private static void doMergeConditional(Frame frame, byte[] bc, int bci, int sp) {
            Object value = FRAMES.requireObject(frame, sp - 1);
            FRAMES.setObject(frame, sp - 2, value);
            FRAMES.clear(frame, sp - 1);
        }

        @ExplodeLoop
        private static int resolveHandler(int bci, int handler, int[] localHandlers) {
            for (int i = handler; i < localHandlers.length; i += 5) {
                if (localHandlers[i + 0] > bci || localHandlers[i + 1] <= bci) continue;
                return i;
            }
            return -1;
        }
    }

    private static final class TagRootNode
    extends Node {
        @Node.Child
        TagNode root;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final TagNode[] tagNodes;
        @Node.Child
        ProbeNode probe;

        TagRootNode(TagNode root, TagNode[] tagNodes) {
            this.root = root;
            this.tagNodes = tagNodes;
        }

        ProbeNode getProbe() {
            ProbeNode localProbe = this.probe;
            if (localProbe == null) {
                this.probe = localProbe = (ProbeNode)this.insert((Node)this.root.createProbe(null));
            }
            return localProbe;
        }

        public Node copy() {
            TagRootNode copy = (TagRootNode)super.copy();
            copy.probe = null;
            return copy;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class AbstractBytecodeNode
    extends BytecodeNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final byte[] bytecodes;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final Object[] constants;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final int[] handlers;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final int[] locals;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final int[] sourceInfo;
        final List<Source> sources;
        final int numNodes;
        @Node.Child
        TagRootNode tagRoot;
        volatile byte[] oldBytecodes;

        protected AbstractBytecodeNode(byte[] bytecodes, Object[] constants, int[] handlers, int[] locals, int[] sourceInfo, List<Source> sources, int numNodes, TagRootNode tagRoot) {
            super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
            this.bytecodes = bytecodes;
            this.constants = constants;
            this.handlers = handlers;
            this.locals = locals;
            this.sourceInfo = sourceInfo;
            this.sources = sources;
            this.numNodes = numNodes;
            this.tagRoot = tagRoot;
        }

        final Node findInstrumentableCallNode(int bci) {
            int[] localHandlers = this.handlers;
            for (int i = 0; i < localHandlers.length; i += 5) {
                int handlerKind;
                if (localHandlers[i + 0] > bci || localHandlers[i + 1] <= bci || (handlerKind = localHandlers[i + 2]) != 1) continue;
                int nodeId = localHandlers[i + 3];
                return this.tagRoot.tagNodes[nodeId];
            }
            return null;
        }

        protected abstract int findBytecodeIndex(Frame var1, Node var2);

        final int readValidBytecode(byte[] bc, int bci) {
            short op = BYTES.getShort(bc, bci);
            switch (op) {
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return BYTES.getShort(this.oldBytecodes, bci);
                }
            }
            return op;
        }

        abstract long continueAt(SLBytecodeRootNodeGen var1, VirtualFrame var2, long var3);

        final SLBytecodeRootNodeGen getRoot() {
            return (SLBytecodeRootNodeGen)this.getParent();
        }

        abstract AbstractBytecodeNode toCached(int var1);

        abstract AbstractBytecodeNode update(byte[] var1, Object[] var2, int[] var3, int[] var4, int[] var5, List<Source> var6, int var7, TagRootNode var8);

        final void invalidate(AbstractBytecodeNode newNode, CharSequence reason) {
            byte[] bc = this.bytecodes;
            int bci = 0;
            this.oldBytecodes = Arrays.copyOf(bc, bc.length);
            VarHandle.loadLoadFence();
            while (bci < bc.length) {
                short op = BYTES.getShort(bc, bci);
                switch (op) {
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 53: 
                    case 109: {
                        BYTES.putShort(bc, bci, (short)109);
                        bci += 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 13: 
                    case 44: 
                    case 110: {
                        BYTES.putShort(bc, bci, (short)110);
                        bci += 4;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 20: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 45: 
                    case 52: 
                    case 57: 
                    case 86: 
                    case 90: 
                    case 96: 
                    case 111: {
                        BYTES.putShort(bc, bci, (short)111);
                        bci += 6;
                        break;
                    }
                    case 112: {
                        BYTES.putShort(bc, bci, (short)112);
                        bci += 8;
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 21: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 54: 
                    case 55: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 113: {
                        BYTES.putShort(bc, bci, (short)113);
                        bci += 10;
                        break;
                    }
                    case 114: {
                        BYTES.putShort(bc, bci, (short)114);
                        bci += 12;
                        break;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 115: {
                        BYTES.putShort(bc, bci, (short)115);
                        bci += 14;
                    }
                }
            }
            this.reportReplace((Node)this, (Node)newNode, reason);
        }

        private final boolean validateBytecodes() {
            TagNode[] tagNodes;
            byte[] bc = this.bytecodes;
            if (bc == null) {
                return true;
            }
            Node[] cachedNodes = this.getCachedNodes();
            int[] branchProfiles = this.getBranchProfiles();
            int bci = 0;
            TagNode[] tagNodeArray = tagNodes = this.tagRoot != null ? this.tagRoot.tagNodes : null;
            if (bc.length == 0) {
                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error: bytecode array must not be null%n%s", this.dumpInvalid(this.findLocation(bci))));
            }
            block38: while (bci < bc.length) {
                try {
                    switch (BYTES.getShort(bc, bci)) {
                        case 1: 
                        case 2: 
                        case 3: {
                            bci += 4;
                            continue block38;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            int constant = BYTES.getIntUnaligned(bc, bci + 2);
                            if (constant < 0 || constant >= this.constants.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. constant is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 6;
                            continue block38;
                        }
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            short frame_index = BYTES.getShort(bc, bci + 2);
                            SLBytecodeRootNodeGen root = this.getRoot();
                            if (frame_index < 1 || frame_index >= root.maxLocals) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. local offset is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            short local_index = BYTES.getShort(bc, bci + 4);
                            if (local_index < 0 || local_index >= root.numLocals) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. local index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 6;
                            continue block38;
                        }
                        case 13: {
                            short frame_index = BYTES.getShort(bc, bci + 2);
                            SLBytecodeRootNodeGen root = this.getRoot();
                            if (frame_index < 1 || frame_index >= root.maxLocals) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. local offset is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 4;
                            continue block38;
                        }
                        case 14: 
                        case 19: {
                            short frame_index = BYTES.getShort(bc, bci + 2);
                            SLBytecodeRootNodeGen root = this.getRoot();
                            if (frame_index < 1 || frame_index >= root.maxLocals) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. local offset is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            short local_index = BYTES.getShort(bc, bci + 4);
                            if (local_index < 0 || local_index >= root.numLocals) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. local index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int child0 = BYTES.getIntUnaligned(bc, bci + 6);
                            if (child0 < -1 || child0 >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 10;
                            continue block38;
                        }
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: {
                            short frame_index = BYTES.getShort(bc, bci + 2);
                            SLBytecodeRootNodeGen root = this.getRoot();
                            if (frame_index < 1 || frame_index >= root.maxLocals) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. local offset is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            short local_index = BYTES.getShort(bc, bci + 4);
                            if (local_index < 0 || local_index >= root.numLocals) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. local index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int child0 = BYTES.getIntUnaligned(bc, bci + 6);
                            if (child0 < 0 || child0 >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 10;
                            continue block38;
                        }
                        case 20: {
                            int branch_target = BYTES.getIntUnaligned(bc, bci + 2);
                            if (branch_target < 0 || branch_target >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 6;
                            continue block38;
                        }
                        case 21: {
                            int branch_target = BYTES.getIntUnaligned(bc, bci + 2);
                            if (branch_target < 0 || branch_target >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int loop_header_branch_profile = BYTES.getIntUnaligned(bc, bci + 6);
                            if (branchProfiles != null && (loop_header_branch_profile < 0 || loop_header_branch_profile >= branchProfiles.length)) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. branch profile is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 10;
                            continue block38;
                        }
                        case 22: 
                        case 23: 
                        case 24: {
                            int branch_target = BYTES.getIntUnaligned(bc, bci + 2);
                            if (branch_target < 0 || branch_target >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int branch_profile = BYTES.getIntUnaligned(bc, bci + 6);
                            if (branchProfiles != null && (branch_profile < 0 || branch_profile >= branchProfiles.length)) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. branch profile is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int child0 = BYTES.getIntUnaligned(bc, bci + 10);
                            if (child0 < 0 || child0 >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 14;
                            continue block38;
                        }
                        case 25: 
                        case 28: {
                            int child0 = BYTES.getIntUnaligned(bc, bci + 2);
                            if (child0 < -1 || child0 >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 6;
                            continue block38;
                        }
                        case 26: 
                        case 27: {
                            int child0 = BYTES.getIntUnaligned(bc, bci + 2);
                            if (child0 < 0 || child0 >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 6;
                            continue block38;
                        }
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 53: 
                        case 109: {
                            bci += 2;
                            continue block38;
                        }
                        case 44: {
                            short exception_sp = BYTES.getShort(bc, bci + 2);
                            SLBytecodeRootNodeGen root = this.getRoot();
                            int maxStackHeight = root.getFrameDescriptor().getNumberOfSlots() - root.maxLocals;
                            if (exception_sp < 0 || exception_sp > maxStackHeight) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. stack pointer is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 4;
                            continue block38;
                        }
                        case 45: 
                        case 52: {
                            TagNode node;
                            int tag = BYTES.getIntUnaligned(bc, bci + 2);
                            if (tagNodes != null && (node = this.tagRoot.tagNodes[tag]) == null) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. tagNode is null%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 6;
                            continue block38;
                        }
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: {
                            TagNode node;
                            int tag = BYTES.getIntUnaligned(bc, bci + 2);
                            if (tagNodes != null && (node = this.tagRoot.tagNodes[tag]) == null) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. tagNode is null%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int child0 = BYTES.getIntUnaligned(bc, bci + 6);
                            if (child0 < 0 || child0 >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 10;
                            continue block38;
                        }
                        case 54: 
                        case 55: {
                            int index = BYTES.getIntUnaligned(bc, bci + 2);
                            if (index < 0 || index >= this.constants.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. constant is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int node = BYTES.getIntUnaligned(bc, bci + 6);
                            if (node < 0 || node >= this.numNodes) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. node profile is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 10;
                            continue block38;
                        }
                        case 56: {
                            int factory = BYTES.getIntUnaligned(bc, bci + 2);
                            if (factory < 0 || factory >= this.constants.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. constant is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int argumentCount = BYTES.getIntUnaligned(bc, bci + 6);
                            if (argumentCount < 0 || argumentCount >= this.constants.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. constant is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int node = BYTES.getIntUnaligned(bc, bci + 10);
                            if (node < 0 || node >= this.numNodes) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. node profile is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 14;
                            continue block38;
                        }
                        case 57: 
                        case 86: 
                        case 90: 
                        case 96: {
                            int node = BYTES.getIntUnaligned(bc, bci + 2);
                            if (node < 0 || node >= this.numNodes) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. node profile is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 6;
                            continue block38;
                        }
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 87: 
                        case 88: 
                        case 89: {
                            int node = BYTES.getIntUnaligned(bc, bci + 2);
                            if (node < 0 || node >= this.numNodes) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. node profile is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int child0 = BYTES.getIntUnaligned(bc, bci + 6);
                            if (child0 < 0 || child0 >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int child1 = BYTES.getIntUnaligned(bc, bci + 10);
                            if (child1 < 0 || child1 >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 14;
                            continue block38;
                        }
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 98: 
                        case 99: 
                        case 100: {
                            int node = BYTES.getIntUnaligned(bc, bci + 2);
                            if (node < 0 || node >= this.numNodes) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. node profile is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int child0 = BYTES.getIntUnaligned(bc, bci + 6);
                            if (child0 < 0 || child0 >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 10;
                            continue block38;
                        }
                        case 97: {
                            int node = BYTES.getIntUnaligned(bc, bci + 2);
                            if (node < 0 || node >= this.numNodes) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. node profile is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int child0 = BYTES.getIntUnaligned(bc, bci + 6);
                            if (child0 < -1 || child0 >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 10;
                            continue block38;
                        }
                        case 101: 
                        case 102: {
                            int branch_target = BYTES.getIntUnaligned(bc, bci + 2);
                            if (branch_target < 0 || branch_target >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int branch_profile = BYTES.getIntUnaligned(bc, bci + 6);
                            if (branchProfiles != null && (branch_profile < 0 || branch_profile >= branchProfiles.length)) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. branch profile is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 10;
                            continue block38;
                        }
                        case 103: 
                        case 108: {
                            int child0 = BYTES.getIntUnaligned(bc, bci + 2);
                            if (child0 < -1 || child0 >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int child1 = BYTES.getIntUnaligned(bc, bci + 6);
                            if (child1 < -1 || child1 >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 10;
                            continue block38;
                        }
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: {
                            int child0 = BYTES.getIntUnaligned(bc, bci + 2);
                            if (child0 < 0 || child0 >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            int child1 = BYTES.getIntUnaligned(bc, bci + 6);
                            if (child1 < 0 || child1 >= bc.length) {
                                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error at index: %s. bytecode index is out of bounds%n%s", bci, this.dumpInvalid(this.findLocation(bci))));
                            }
                            bci += 10;
                            continue block38;
                        }
                        case 110: {
                            bci += 4;
                            continue block38;
                        }
                        case 111: {
                            bci += 6;
                            continue block38;
                        }
                        case 112: {
                            bci += 8;
                            continue block38;
                        }
                        case 113: {
                            bci += 10;
                            continue block38;
                        }
                        case 114: {
                            bci += 12;
                            continue block38;
                        }
                        case 115: {
                            bci += 14;
                            continue block38;
                        }
                    }
                    throw CompilerDirectives.shouldNotReachHere((String)("Invalid BCI at index: " + bci));
                }
                catch (AssertionError e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error:%n%s", this.dumpInvalid(this.findLocation(bci))), (Throwable)e);
                }
            }
            int[] ex = this.handlers;
            if (ex.length % 5 != 0) {
                throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error: exception handler table size is incorrect%n%s", this.dumpInvalid(this.findLocation(bci))));
            }
            block39: for (int i = 0; i < ex.length; i += 5) {
                int startBci = ex[i + 0];
                int endBci = ex[i + 1];
                int handlerKind = ex[i + 2];
                int handlerBci = ex[i + 3];
                int handlerSp = ex[i + 4];
                if (startBci < 0 || startBci >= bc.length) {
                    throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error: exception handler startBci is out of bounds%n%s", this.dumpInvalid(this.findLocation(bci))));
                }
                if (endBci < 0 || endBci > bc.length) {
                    throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error: exception handler endBci is out of bounds%n%s", this.dumpInvalid(this.findLocation(bci))));
                }
                if (startBci > endBci) {
                    throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error: exception handler bci range is malformed%n%s", this.dumpInvalid(this.findLocation(bci))));
                }
                switch (handlerKind) {
                    case 1: {
                        TagNode node;
                        if (tagNodes == null || (node = this.tagRoot.tagNodes[handlerBci]) != null) continue block39;
                        throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error: tagNode is null%n%s", this.dumpInvalid(this.findLocation(bci))));
                    }
                    default: {
                        if (handlerKind != 0) {
                            throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error: unexpected handler kind%n%s", this.dumpInvalid(this.findLocation(bci))));
                        }
                        if (handlerBci >= 0 && handlerBci < bc.length) continue block39;
                        throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error: exception handler handlerBci is out of bounds%n%s", this.dumpInvalid(this.findLocation(bci))));
                    }
                }
            }
            int[] info = this.sourceInfo;
            List<Source> localSources = this.sources;
            if (info != null) {
                for (int i = 0; i < info.length; i += 5) {
                    int startBci = info[i + 0];
                    int endBci = info[i + 1];
                    int sourceIndex = info[i + 2];
                    if (startBci > endBci) {
                        throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error: source bci range is malformed%n%s", this.dumpInvalid(this.findLocation(bci))));
                    }
                    if (sourceIndex >= 0 && sourceIndex <= localSources.size()) continue;
                    throw CompilerDirectives.shouldNotReachHere((String)String.format("Bytecode validation error: source index is out of bounds%n%s", this.dumpInvalid(this.findLocation(bci))));
                }
            }
            return true;
        }

        private final String dumpInvalid(BytecodeLocation highlightedLocation) {
            try {
                return this.dump(highlightedLocation);
            }
            catch (Throwable t) {
                return "<dump error>";
            }
        }

        abstract AbstractBytecodeNode cloneUninitialized();

        abstract Node[] getCachedNodes();

        abstract int[] getBranchProfiles();

        abstract byte[] getLocalTags();

        abstract byte getCachedLocalTagInternal(byte[] var1, int var2);

        abstract void setCachedLocalTagInternal(byte[] var1, int var2, byte var3);

        @CompilerDirectives.TruffleBoundary
        public SourceSection getSourceSection() {
            int[] info = this.sourceInfo;
            if (info == null) {
                return null;
            }
            int mostSpecific = -1;
            for (int i = info.length - 5; i >= 0 && info[i + 0] == 0 && info[i + 1] == this.bytecodes.length; i -= 5) {
                mostSpecific = i;
            }
            if (mostSpecific != -1) {
                return AbstractBytecodeNode.createSourceSection(this.sources, info, mostSpecific);
            }
            return null;
        }

        public final SourceSection getSourceLocation(int bci) {
            assert (this.validateBytecodeIndex(bci));
            int[] info = this.sourceInfo;
            if (info == null) {
                return null;
            }
            for (int i = 0; i < info.length; i += 5) {
                int startBci = info[i + 0];
                int endBci = info[i + 1];
                if (startBci > bci || bci >= endBci) continue;
                return AbstractBytecodeNode.createSourceSection(this.sources, info, i);
            }
            return null;
        }

        public final SourceSection[] getSourceLocations(int bci) {
            assert (this.validateBytecodeIndex(bci));
            int[] info = this.sourceInfo;
            if (info == null) {
                return null;
            }
            int sectionIndex = 0;
            SourceSection[] sections = new SourceSection[8];
            for (int i = 0; i < info.length; i += 5) {
                int startBci = info[i + 0];
                int endBci = info[i + 1];
                if (startBci > bci || bci >= endBci) continue;
                if (sectionIndex == sections.length) {
                    sections = Arrays.copyOf(sections, Math.min(sections.length * 2, info.length / 5));
                }
                sections[sectionIndex++] = AbstractBytecodeNode.createSourceSection(this.sources, info, i);
            }
            return Arrays.copyOf(sections, sectionIndex);
        }

        protected Instruction findInstruction(int bci) {
            return new InstructionImpl(this, bci, this.readValidBytecode(this.bytecodes, bci));
        }

        protected boolean validateBytecodeIndex(int bci) {
            byte[] bc = this.bytecodes;
            if (bci < 0 || bci >= bc.length) {
                throw new IllegalArgumentException("Bytecode index out of range " + bci);
            }
            int op = this.readValidBytecode(bc, bci);
            if (op < 0 || op > 115) {
                throw new IllegalArgumentException("Invalid op at bytecode index " + op);
            }
            return true;
        }

        public List<SourceInformation> getSourceInformation() {
            if (this.sourceInfo == null) {
                return null;
            }
            return new SourceInformationList(this);
        }

        public boolean hasSourceInformation() {
            return this.sourceInfo != null;
        }

        public SourceInformationTree getSourceInformationTree() {
            if (this.sourceInfo == null) {
                return null;
            }
            return SourceInformationTreeImpl.parse(this);
        }

        public List<ExceptionHandler> getExceptionHandlers() {
            return new ExceptionHandlerList(this);
        }

        public TagTree getTagTree() {
            if (this.tagRoot == null) {
                return null;
            }
            return this.tagRoot.root;
        }

        @ExplodeLoop
        public final int getLocalCount(int bci) {
            assert (this.validateBytecodeIndex(bci));
            CompilerAsserts.partialEvaluationConstant((int)bci);
            int count = 0;
            for (int index = 0; index < this.locals.length; index += 6) {
                int startIndex = this.locals[index + 0];
                int endIndex = this.locals[index + 1];
                if (bci < startIndex || bci >= endIndex) continue;
                ++count;
            }
            CompilerAsserts.partialEvaluationConstant((int)count);
            return count;
        }

        protected final void clearLocalValueInternal(Frame frame, int localOffset, int localIndex) {
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            int frameIndex = 1 + localOffset;
            frame.clear(frameIndex);
        }

        protected final boolean isLocalClearedInternal(Frame frame, int localOffset, int localIndex) {
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            int frameIndex = 1 + localOffset;
            return frame.getTag(frameIndex) == FrameSlotKind.Illegal.tag;
        }

        protected Object getLocalNameInternal(int localOffset, int localIndex) {
            int index = this.localIndexToAnyTableIndex(localIndex);
            int nameId = this.locals[index + 4];
            if (nameId == -1) {
                return null;
            }
            return ACCESS.readObject(this.constants, nameId);
        }

        protected Object getLocalInfoInternal(int localOffset, int localIndex) {
            int index = this.localIndexToAnyTableIndex(localIndex);
            int infoId = this.locals[index + 5];
            if (infoId == -1) {
                return null;
            }
            return ACCESS.readObject(this.constants, infoId);
        }

        protected abstract void setLocalValueInternal(Frame var1, int var2, int var3, Object var4);

        @ExplodeLoop
        protected final int localOffsetToTableIndex(int bci, int localOffset) {
            int count = 0;
            for (int index = 0; index < this.locals.length; index += 6) {
                int startIndex = this.locals[index + 0];
                int endIndex = this.locals[index + 1];
                if (bci < startIndex || bci >= endIndex) continue;
                if (count == localOffset) {
                    return index;
                }
                ++count;
            }
            return -1;
        }

        protected final int localOffsetToLocalIndex(int bci, int localOffset) {
            int tableIndex = this.localOffsetToTableIndex(bci, localOffset);
            assert (this.locals[tableIndex + 3] == localOffset + 1) : "Inconsistent indices.";
            return this.locals[tableIndex + 2];
        }

        @ExplodeLoop
        protected final int localIndexToAnyTableIndex(int localIndex) {
            for (int index = 0; index < this.locals.length; index += 6) {
                if (this.locals[index + 2] != localIndex) continue;
                return index;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new AssertionError((Object)"Local index not found in locals table");
        }

        public Object getLocalName(int bci, int localOffset) {
            assert (this.validateBytecodeIndex(bci));
            CompilerAsserts.partialEvaluationConstant((int)bci);
            CompilerAsserts.partialEvaluationConstant((int)localOffset);
            assert (localOffset >= 0 && localOffset < this.getLocalCount(bci)) : "Invalid out-of-bounds local offset provided.";
            int index = this.localOffsetToTableIndex(bci, localOffset);
            if (index == -1) {
                return null;
            }
            int nameId = this.locals[index + 4];
            if (nameId == -1) {
                return null;
            }
            return ACCESS.readObject(this.constants, nameId);
        }

        public Object getLocalInfo(int bci, int localOffset) {
            assert (this.validateBytecodeIndex(bci));
            CompilerAsserts.partialEvaluationConstant((int)bci);
            CompilerAsserts.partialEvaluationConstant((int)localOffset);
            assert (localOffset >= 0 && localOffset < this.getLocalCount(bci)) : "Invalid out-of-bounds local offset provided.";
            int index = this.localOffsetToTableIndex(bci, localOffset);
            if (index == -1) {
                return null;
            }
            int infoId = this.locals[index + 5];
            if (infoId == -1) {
                return null;
            }
            return ACCESS.readObject(this.constants, infoId);
        }

        public List<LocalVariable> getLocals() {
            return new LocalVariableList(this);
        }

        private TagNode[] getTagNodes() {
            return this.tagRoot != null ? this.tagRoot.tagNodes : null;
        }

        protected int translateBytecodeIndex(BytecodeNode newNode, int bytecodeIndex) {
            return (int)this.transitionState((AbstractBytecodeNode)newNode, (long)bytecodeIndex & 0xFFFFFFFFL);
        }

        final long transitionState(AbstractBytecodeNode newBytecode, long state) {
            byte[] oldBc = this.oldBytecodes;
            byte[] newBc = newBytecode.bytecodes;
            if (oldBc == null || this == newBytecode || this.bytecodes == newBc) {
                return state;
            }
            int oldBci = (int)state;
            int newBci = AbstractBytecodeNode.computeNewBci(oldBci, oldBc, newBc, this.getTagNodes(), newBytecode.getTagNodes());
            return state & 0xFFFF00000000L | (long)newBci & 0xFFFFFFFFL;
        }

        public void adoptNodesAfterUpdate() {
        }

        static BytecodeLocation findLocation(AbstractBytecodeNode node, int bci) {
            return node.findLocation(bci);
        }

        private static SourceSection createSourceSection(List<Source> sources, int[] info, int index) {
            int sourceIndex = info[index + 2];
            int start = info[index + 3];
            int length = info[index + 4];
            if (start == -1 && length == -1) {
                return sources.get(sourceIndex).createUnavailableSection();
            }
            assert (start >= 0) : "invalid source start index";
            assert (length >= 0) : "invalid source length";
            return sources.get(sourceIndex).createSection(start, length);
        }

        private static int toStableBytecodeIndex(byte[] bc, int searchBci) {
            int bci = 0;
            int stableBci = 0;
            block11: while (bci != searchBci && bci < bc.length) {
                switch (BYTES.getShort(bc, bci)) {
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 53: 
                    case 109: {
                        bci += 2;
                        stableBci += 2;
                        continue block11;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 13: 
                    case 44: 
                    case 110: {
                        bci += 4;
                        stableBci += 4;
                        continue block11;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 20: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 57: 
                    case 86: 
                    case 90: 
                    case 96: 
                    case 111: {
                        bci += 6;
                        stableBci += 6;
                        continue block11;
                    }
                    case 112: {
                        bci += 8;
                        stableBci += 8;
                        continue block11;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 21: 
                    case 54: 
                    case 55: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 113: {
                        bci += 10;
                        stableBci += 10;
                        continue block11;
                    }
                    case 114: {
                        bci += 12;
                        stableBci += 12;
                        continue block11;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 115: {
                        bci += 14;
                        stableBci += 14;
                        continue block11;
                    }
                    case 45: 
                    case 52: {
                        bci += 6;
                        continue block11;
                    }
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        bci += 10;
                        continue block11;
                    }
                }
                throw CompilerDirectives.shouldNotReachHere((String)"Invalid bytecode.");
            }
            if (bci >= bc.length) {
                throw CompilerDirectives.shouldNotReachHere((String)"Could not translate bytecode index.");
            }
            return stableBci;
        }

        private static int fromStableBytecodeIndex(byte[] bc, int stableSearchBci) {
            int bci = 0;
            int stableBci = 0;
            block11: while (stableBci != stableSearchBci && bci < bc.length) {
                switch (BYTES.getShort(bc, bci)) {
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 53: 
                    case 109: {
                        bci += 2;
                        stableBci += 2;
                        continue block11;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 13: 
                    case 44: 
                    case 110: {
                        bci += 4;
                        stableBci += 4;
                        continue block11;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 20: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 57: 
                    case 86: 
                    case 90: 
                    case 96: 
                    case 111: {
                        bci += 6;
                        stableBci += 6;
                        continue block11;
                    }
                    case 112: {
                        bci += 8;
                        stableBci += 8;
                        continue block11;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 21: 
                    case 54: 
                    case 55: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 113: {
                        bci += 10;
                        stableBci += 10;
                        continue block11;
                    }
                    case 114: {
                        bci += 12;
                        stableBci += 12;
                        continue block11;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 115: {
                        bci += 14;
                        stableBci += 14;
                        continue block11;
                    }
                    case 45: 
                    case 52: {
                        bci += 6;
                        continue block11;
                    }
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        bci += 10;
                        continue block11;
                    }
                }
                throw CompilerDirectives.shouldNotReachHere((String)"Invalid bytecode.");
            }
            if (bci >= bc.length) {
                throw CompilerDirectives.shouldNotReachHere((String)"Could not translate bytecode index.");
            }
            return bci;
        }

        private static int transitionInstrumentationIndex(byte[] oldBc, int oldBciBase, int oldBciTarget, byte[] newBc, int newBciBase, TagNode[] oldTagNodes, TagNode[] newTagNodes) {
            int opTags;
            short op;
            int oldBci = oldBciBase;
            int newBci = newBciBase;
            short searchOp = -1;
            int searchTags = -1;
            block12: while (oldBci < oldBciTarget) {
                short op2 = BYTES.getShort(oldBc, oldBci);
                searchOp = op2;
                switch (op2) {
                    case 45: 
                    case 52: {
                        searchTags = ((TagNode)((Object)SLBytecodeRootNodeGen.ACCESS.uncheckedCast((Object)SLBytecodeRootNodeGen.ACCESS.readObject((Object[])oldTagNodes, (int)SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])oldBc, (int)(oldBci + 2))), TagNode.class))).tags;
                        oldBci += 6;
                        continue block12;
                    }
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        searchTags = ((TagNode)((Object)SLBytecodeRootNodeGen.ACCESS.uncheckedCast((Object)SLBytecodeRootNodeGen.ACCESS.readObject((Object[])oldTagNodes, (int)SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])oldBc, (int)(oldBci + 2))), TagNode.class))).tags;
                        oldBci += 10;
                        continue block12;
                    }
                }
                throw CompilerDirectives.shouldNotReachHere((String)"Unexpected bytecode.");
            }
            assert (searchOp != -1);
            oldBci = oldBciBase;
            int opCounter = 0;
            block13: while (oldBci < oldBciTarget) {
                op = BYTES.getShort(oldBc, oldBci);
                switch (op) {
                    case 45: 
                    case 52: {
                        opTags = ((TagNode)((Object)SLBytecodeRootNodeGen.ACCESS.uncheckedCast((Object)SLBytecodeRootNodeGen.ACCESS.readObject((Object[])oldTagNodes, (int)SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])oldBc, (int)(oldBci + 2))), TagNode.class))).tags;
                        if (searchOp == op && searchTags == opTags) {
                            ++opCounter;
                        }
                        oldBci += 6;
                        continue block13;
                    }
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        opTags = ((TagNode)((Object)SLBytecodeRootNodeGen.ACCESS.uncheckedCast((Object)SLBytecodeRootNodeGen.ACCESS.readObject((Object[])oldTagNodes, (int)SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])oldBc, (int)(oldBci + 2))), TagNode.class))).tags;
                        if (searchOp == op && searchTags == opTags) {
                            ++opCounter;
                        }
                        oldBci += 10;
                        continue block13;
                    }
                }
                throw CompilerDirectives.shouldNotReachHere((String)"Unexpected bytecode.");
            }
            assert (opCounter > 0);
            block14: while (opCounter > 0) {
                op = BYTES.getShort(newBc, newBci);
                switch (op) {
                    case 45: 
                    case 52: {
                        opTags = ((TagNode)((Object)SLBytecodeRootNodeGen.ACCESS.uncheckedCast((Object)SLBytecodeRootNodeGen.ACCESS.readObject((Object[])newTagNodes, (int)SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])newBc, (int)(newBci + 2))), TagNode.class))).tags;
                        if (searchOp == op && searchTags == opTags) {
                            --opCounter;
                        }
                        newBci += 6;
                        continue block14;
                    }
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        opTags = ((TagNode)((Object)SLBytecodeRootNodeGen.ACCESS.uncheckedCast((Object)SLBytecodeRootNodeGen.ACCESS.readObject((Object[])newTagNodes, (int)SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])newBc, (int)(newBci + 2))), TagNode.class))).tags;
                        if (searchOp == op && searchTags == opTags) {
                            --opCounter;
                        }
                        newBci += 10;
                        continue block14;
                    }
                }
                throw CompilerDirectives.shouldNotReachHere((String)"Unexpected bytecode.");
            }
            return newBci;
        }

        static final int computeNewBci(int oldBci, byte[] oldBc, byte[] newBc, TagNode[] oldTagNodes, TagNode[] newTagNodes) {
            int stableBci = AbstractBytecodeNode.toStableBytecodeIndex(oldBc, oldBci);
            int newBci = AbstractBytecodeNode.fromStableBytecodeIndex(newBc, stableBci);
            int oldBciBase = AbstractBytecodeNode.fromStableBytecodeIndex(oldBc, stableBci);
            if (oldBci != oldBciBase) {
                newBci = AbstractBytecodeNode.transitionInstrumentationIndex(oldBc, oldBciBase, oldBci, newBc, newBci, oldTagNodes, newTagNodes);
            }
            return newBci;
        }

        private static Object createStackTraceElement(TruffleStackTraceElement stackTraceElement) {
            return AbstractBytecodeNode.createDefaultStackTraceElement((TruffleStackTraceElement)stackTraceElement);
        }
    }

    private static final class BytecodeConfigEncoderImpl
    extends BytecodeConfigEncoder {
        private static final BytecodeConfigEncoderImpl INSTANCE = new BytecodeConfigEncoderImpl();

        private BytecodeConfigEncoderImpl() {
            super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
        }

        protected long encodeInstrumentation(Class<?> c) throws IllegalArgumentException {
            throw new IllegalArgumentException(String.format("Invalid instrumentation specified. Instrumentation '%s' does not exist or is not an instrumentation for 'com.oracle.truffle.sl.bytecode.SLBytecodeRootNode'. Instrumentations can be specified using the @Instrumentation annotation.", c.getName()));
        }

        protected long encodeTag(Class<?> c) throws IllegalArgumentException {
            return (long)CLASS_TO_TAG_MASK.get(c).intValue() << 32;
        }

        private static long decode(BytecodeConfig config) {
            return BytecodeConfigEncoderImpl.decode(BytecodeConfigEncoderImpl.getEncoder((BytecodeConfig)config), BytecodeConfigEncoderImpl.getEncoding((BytecodeConfig)config));
        }

        private static long decode(BytecodeConfigEncoder encoder, long encoding) {
            if (encoder != null && encoder != INSTANCE) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException("Encoded config is not compatible with this bytecode node.");
            }
            return encoding & 0xFF00000001L;
        }
    }

    public static final class Builder
    extends BytecodeBuilder {
        private static final byte UNINITIALIZED = -1;
        private static final String[] OPERATION_NAMES = new String[]{null, "Block", "Root", "IfThen", "IfThenElse", "Conditional", "While", "TryCatch", "TryFinally", "TryCatchOtherwise", "FinallyHandler", "Label", "Branch", "LoadConstant", "LoadNull", "LoadArgument", "LoadException", "LoadLocal", "StoreLocal", "Return", "Source", "SourceSection", "Tag", "SLAlwaysHalt", "SLLoadArgument", "Builtin", "SLInvoke", "SLAdd", "SLDiv", "SLEqual", "SLLessOrEqual", "SLLessThan", "SLLogicalNot", "SLMul", "SLReadProperty", "SLSub", "SLWriteProperty", "SLUnbox", "SLFunctionLiteral", "SLToBoolean", "SLAnd", "SLOr"};
        private static final Class<?>[] TAGS_ROOT_TAG = new Class[]{StandardTags.RootTag.class};
        private static final Class<?>[] TAGS_ALWAYS_HALT = new Class[]{DebuggerTags.AlwaysHalt.class};
        private int operationSequenceNumber;
        private OperationStackEntry[] operationStack;
        private int operationSp;
        private int rootOperationSp;
        private int numLocals;
        private int numLabels;
        private int numNodes;
        private int numHandlers;
        private int numConditionalBranches;
        private byte[] bc;
        private int bci;
        private int currentStackHeight;
        private int maxStackHeight;
        private int[] sourceInfo;
        private int sourceInfoIndex;
        private int[] handlerTable;
        private int handlerTableSize;
        private int[] locals;
        private int localsTableIndex;
        private HashMap<BytecodeLabel, ArrayList<Integer>> unresolvedLabels;
        private ConstantPool constantPool;
        private boolean reachable = true;
        private int maxLocals;
        private List<TagNode> tagRoots;
        private List<TagNode> tagNodes;
        private SavedState savedState;
        private final SLLanguage language;
        private final BytecodeRootNodesImpl nodes;
        private final CharSequence reparseReason;
        private final boolean parseBytecodes;
        private final int tags;
        private final int instrumentations;
        private final boolean parseSources;
        private final ArrayList<SLBytecodeRootNodeGen> builtNodes;
        private int numRoots;
        private final ArrayList<Source> sources;
        private SerializationState serialization;

        private Builder(SLLanguage language, BytecodeRootNodesImpl nodes, BytecodeConfig config) {
            super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
            this.language = language;
            this.nodes = nodes;
            this.reparseReason = null;
            long encoding = BytecodeConfigEncoderImpl.decode(config);
            this.tags = (int)(encoding >> 32 & 0xFFFFFFFFFFFFFFFFL);
            this.instrumentations = (int)(encoding >> 1 & Integer.MAX_VALUE);
            this.parseSources = (encoding & 1L) != 0L;
            this.parseBytecodes = true;
            this.sources = this.parseSources ? new ArrayList(4) : null;
            this.builtNodes = new ArrayList();
            this.operationStack = new OperationStackEntry[8];
            this.rootOperationSp = -1;
        }

        private Builder(BytecodeRootNodesImpl nodes, boolean parseBytecodes, int tags, int instrumentations, boolean parseSources, CharSequence reparseReason) {
            super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
            this.language = nodes.getLanguage();
            this.nodes = nodes;
            this.reparseReason = reparseReason;
            this.parseBytecodes = parseBytecodes;
            this.tags = tags;
            this.instrumentations = instrumentations;
            this.parseSources = parseSources;
            this.sources = parseSources ? new ArrayList(4) : null;
            this.builtNodes = new ArrayList();
            this.operationStack = new OperationStackEntry[8];
            this.rootOperationSp = -1;
        }

        public BytecodeLocal createLocal() {
            return this.createLocal(null, null);
        }

        public BytecodeLocal createLocal(Object name, Object info) {
            if (this.serialization != null) {
                try {
                    int nameId = name != null ? this.serialization.serializeObject(name) : -1;
                    int infoId = info != null ? this.serialization.serializeObject(info) : -1;
                    this.serialization.buffer.writeShort(-3);
                    this.serialization.buffer.writeInt(nameId);
                    this.serialization.buffer.writeInt(infoId);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return new SerializationLocal(this.serialization.depth, this.serialization.localCount++);
            }
            ScopeData scope = this.getCurrentScope();
            short localIndex = this.allocateBytecodeLocal();
            short frameIndex = Builder.safeCastShort(1 + scope.frameOffset + scope.numLocals);
            int tableIndex = this.doEmitLocal((int)localIndex, (int)frameIndex, name, info);
            scope.registerLocal(tableIndex);
            BytecodeLocalImpl local = new BytecodeLocalImpl(frameIndex, localIndex, ((RootData)this.operationStack[this.rootOperationSp].data).index, scope);
            return local;
        }

        public BytecodeLabel createLabel() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(-2);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return new SerializationLabel(this.serialization.depth, this.serialization.labelCount++);
            }
            if (this.operationSp == 0 || this.operationStack[this.operationSp - 1].operation != 1 && this.operationStack[this.operationSp - 1].operation != 2) {
                throw this.failState("Labels must be created inside either Block or Root operations.");
            }
            BytecodeLabelImpl result = new BytecodeLabelImpl(this.numLabels++, -1, this.operationStack[this.operationSp - 1].sequenceNumber);
            this.operationStack[this.operationSp - 1].addDeclaredLabel(result);
            return result;
        }

        public void beginSourceSectionUnavailable() {
            this.beginSourceSection(-1, -1);
        }

        public void endSourceSectionUnavailable() {
            this.endSourceSection();
        }

        private void registerUnresolvedLabel(BytecodeLabel label, int immediateBci) {
            ArrayList locations = this.unresolvedLabels.computeIfAbsent(label, k -> new ArrayList());
            locations.add(immediateBci);
        }

        private void resolveUnresolvedLabel(BytecodeLabel label, int stackHeight) {
            BytecodeLabelImpl impl = (BytecodeLabelImpl)label;
            assert (!impl.isDefined());
            impl.bci = this.bci;
            List sites = this.unresolvedLabels.remove((Object)impl);
            if (sites != null) {
                for (Integer site : sites) {
                    BYTES.putInt(this.bc, site.intValue(), impl.bci);
                }
            }
        }

        public void beginBlock() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(2);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            ScopeData parentScope = this.getCurrentScope();
            this.beforeChild();
            BlockData operationData = new BlockData(this.currentStackHeight);
            this.beginOperation(1, operationData);
            operationData.frameOffset = parentScope.frameOffset + parentScope.numLocals;
        }

        public void endBlock() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(3);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(1);
            Object object = operation.data;
            if (!(object instanceof BlockData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class BlockData expected, but was " + String.valueOf(operation.data));
            }
            BlockData operationData = (BlockData)object;
            if (operationData.numLocals > 0) {
                this.maxLocals = Math.max(this.maxLocals, operationData.frameOffset + operationData.numLocals);
                for (int index = 0; index < operationData.numLocals; ++index) {
                    this.locals[operationData.locals[index] + 1] = this.bci;
                    this.doEmitInstructionS((short)13, 0, Builder.safeCastShort(this.locals[operationData.locals[index] + 3]));
                }
            }
            operationData.valid = false;
            this.afterChild(operationData.producedValue, operationData.childBci);
        }

        public void beginRoot() {
            if (this.serialization != null) {
                try {
                    short s = this.serialization.rootCount;
                    this.serialization.rootCount = (short)(s + 1);
                    SerializationRootNode node = new SerializationRootNode(FrameDescriptor.newBuilder(), this.serialization.depth, Builder.checkOverflowShort(s, "Root node count"));
                    this.serialization.rootStack.push(node);
                    this.serialization.builtNodes.add(node);
                    this.serialization.buffer.writeShort(4);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            if (this.bc != null) {
                this.savedState = new SavedState(this.operationSequenceNumber, this.operationStack, this.operationSp, this.rootOperationSp, this.numLocals, this.numLabels, this.numNodes, this.numHandlers, this.numConditionalBranches, this.bc, this.bci, this.currentStackHeight, this.maxStackHeight, this.sourceInfo, this.sourceInfoIndex, this.handlerTable, this.handlerTableSize, this.locals, this.localsTableIndex, this.unresolvedLabels, this.constantPool, this.reachable, this.maxLocals, this.tagRoots, this.tagNodes, this.savedState);
            }
            this.operationSequenceNumber = 0;
            this.rootOperationSp = this.operationSp;
            this.reachable = true;
            this.tagRoots = null;
            this.tagNodes = null;
            this.maxLocals = this.numLocals = 0;
            this.numLabels = 0;
            this.numNodes = 0;
            this.numHandlers = 0;
            this.numConditionalBranches = 0;
            this.constantPool = new ConstantPool();
            this.bc = new byte[32];
            this.bci = 0;
            this.currentStackHeight = 0;
            this.maxStackHeight = 0;
            this.handlerTable = new int[10];
            this.handlerTableSize = 0;
            this.locals = null;
            this.localsTableIndex = 0;
            this.unresolvedLabels = new HashMap();
            if (this.parseSources) {
                this.sourceInfo = new int[15];
                this.sourceInfoIndex = 0;
            }
            RootData operationData = new RootData(Builder.safeCastShort(this.numRoots++));
            if (this.reparseReason == null) {
                this.builtNodes.add(null);
                if (this.builtNodes.size() > Short.MAX_VALUE) {
                    throw BytecodeEncodingException.create((String)"Root node count exceeded maximum value.");
                }
            }
            operationData.frameOffset = this.numLocals;
            this.beginOperation(2, operationData);
            this.beginTag(TAGS_ROOT_TAG);
            this.beginBlock();
        }

        public SLBytecodeRootNode endRoot() {
            SLBytecodeRootNodeGen result;
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(5);
                    SerializationRootNode result2 = this.serialization.rootStack.pop();
                    this.serialization.buffer.writeInt(result2.contextDepth);
                    this.serialization.buffer.writeInt(result2.rootIndex);
                    return result2;
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
            }
            Object object = this.operationStack[this.operationSp - 1].data;
            if (!(object instanceof BlockData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class BlockData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
            }
            BlockData blockOperation = (BlockData)object;
            if (!blockOperation.producedValue) {
                this.emitLoadNull();
            }
            this.endBlock();
            Object object2 = this.operationStack[this.rootOperationSp].data;
            if (!(object2 instanceof RootData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class RootData expected, but was " + String.valueOf(this.operationStack[this.rootOperationSp].data));
            }
            RootData operationData = (RootData)object2;
            this.endTag(TAGS_ROOT_TAG);
            this.doEmitInstruction((short)42, -1);
            this.endOperation(2);
            if (operationData.numLocals > 0) {
                this.maxLocals = Math.max(this.maxLocals, operationData.frameOffset + operationData.numLocals);
                for (int index = 0; index < operationData.numLocals; ++index) {
                    this.locals[operationData.locals[index] + 1] = this.bci;
                }
            }
            operationData.valid = false;
            byte[] bytecodes_ = null;
            Object[] constants_ = null;
            int[] handlers_ = null;
            int[] locals_ = null;
            int[] sourceInfo_ = null;
            ArrayList<Source> sources_ = null;
            int numNodes_ = 0;
            TagRootNode tagRoot_ = null;
            this.doEmitRoot();
            if (this.parseSources) {
                sourceInfo_ = Arrays.copyOf(this.sourceInfo, this.sourceInfoIndex);
                sources_ = this.sources;
            }
            if (this.parseBytecodes) {
                bytecodes_ = Arrays.copyOf(this.bc, this.bci);
                constants_ = this.constantPool.toArray();
                handlers_ = Arrays.copyOf(this.handlerTable, this.handlerTableSize);
                sources_ = this.sources;
                numNodes_ = this.numNodes;
                int[] nArray = locals_ = this.locals == null ? EMPTY_INT_ARRAY : Arrays.copyOf(this.locals, this.localsTableIndex);
            }
            if (this.tags != 0 && this.tagNodes != null) {
                TagNode tagTree_;
                TagNode[] tagNodes_ = (TagNode[])this.tagNodes.toArray(TagNode[]::new);
                assert (!this.tagRoots.isEmpty());
                if (this.tagRoots.size() == 1) {
                    tagTree_ = this.tagRoots.get(0);
                } else {
                    tagTree_ = new TagNode(0, -1);
                    tagTree_.children = (TagNode[])tagTree_.insert((Node[])((TagNode[])this.tagRoots.toArray(TagNode[]::new)));
                }
                tagRoot_ = new TagRootNode(tagTree_, tagNodes_);
            }
            if (this.reparseReason != null) {
                result = this.builtNodes.get(operationData.index);
                if (this.parseBytecodes) {
                    AbstractBytecodeNode oldBytecodeNode = result.bytecode;
                    assert (result.maxLocals == this.maxLocals + 1);
                    assert (result.nodes == this.nodes);
                    assert (constants_.length == oldBytecodeNode.constants.length);
                    assert (result.getFrameDescriptor().getNumberOfSlots() == this.maxStackHeight + this.maxLocals + 1);
                }
                result.updateBytecode(bytecodes_, constants_, handlers_, locals_, sourceInfo_, sources_, numNodes_, tagRoot_, this.reparseReason);
                assert (result.buildIndex == operationData.index);
            } else {
                FrameDescriptor.Builder frameDescriptorBuilder = FrameDescriptor.newBuilder();
                frameDescriptorBuilder.defaultValueIllegal();
                frameDescriptorBuilder.useSlotKinds(false);
                frameDescriptorBuilder.addSlots(this.maxStackHeight + this.maxLocals + 1);
                result = new SLBytecodeRootNodeGen(this.language, frameDescriptorBuilder, this.nodes, this.maxLocals + 1, this.numLocals, operationData.index, bytecodes_, constants_, handlers_, locals_, sourceInfo_, sources_, numNodes_, tagRoot_);
                assert (operationData.index <= this.numRoots);
                this.builtNodes.set(operationData.index, result);
            }
            this.rootOperationSp = -1;
            if (this.savedState == null) {
                this.bc = null;
            } else {
                this.operationSequenceNumber = this.savedState.operationSequenceNumber;
                this.operationStack = this.savedState.operationStack;
                this.operationSp = this.savedState.operationSp;
                this.rootOperationSp = this.savedState.rootOperationSp;
                this.numLocals = this.savedState.numLocals;
                this.numLabels = this.savedState.numLabels;
                this.numNodes = this.savedState.numNodes;
                this.numHandlers = this.savedState.numHandlers;
                this.numConditionalBranches = this.savedState.numConditionalBranches;
                this.bc = this.savedState.bc;
                this.bci = this.savedState.bci;
                this.currentStackHeight = this.savedState.currentStackHeight;
                this.maxStackHeight = this.savedState.maxStackHeight;
                this.sourceInfo = this.savedState.sourceInfo;
                this.sourceInfoIndex = this.savedState.sourceInfoIndex;
                this.handlerTable = this.savedState.handlerTable;
                this.handlerTableSize = this.savedState.handlerTableSize;
                this.locals = this.savedState.locals;
                this.localsTableIndex = this.savedState.localsTableIndex;
                this.unresolvedLabels = this.savedState.unresolvedLabels;
                this.constantPool = this.savedState.constantPool;
                this.reachable = this.savedState.reachable;
                this.maxLocals = this.savedState.maxLocals;
                this.tagRoots = this.savedState.tagRoots;
                this.tagNodes = this.savedState.tagNodes;
                this.savedState = this.savedState.savedState;
            }
            return result;
        }

        public void beginIfThen() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(6);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            IfThenData operationData = new IfThenData(this.reachable);
            this.beginOperation(3, operationData);
        }

        public void endIfThen() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(7);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(3);
            if (operation.childCount != 2) {
                throw this.failState("Operation IfThen expected exactly 2 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            this.updateReachable();
            this.afterChild(false, -1);
        }

        public void beginIfThenElse() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(8);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            IfThenElseData operationData = new IfThenElseData(this.reachable, this.reachable);
            this.beginOperation(4, operationData);
        }

        public void endIfThenElse() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(9);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(4);
            if (operation.childCount != 3) {
                throw this.failState("Operation IfThenElse expected exactly 3 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof IfThenElseData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class IfThenElseData expected, but was " + String.valueOf(operation.data));
            }
            IfThenElseData operationData = (IfThenElseData)object;
            this.markReachable(operationData.thenReachable || operationData.elseReachable);
            this.afterChild(false, -1);
        }

        public void beginConditional() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(10);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            ConditionalData operationData = new ConditionalData(this.reachable, this.reachable);
            this.beginOperation(5, operationData);
        }

        public void endConditional() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(11);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(5);
            if (operation.childCount != 3) {
                throw this.failState("Operation Conditional expected exactly 3 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof ConditionalData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class ConditionalData expected, but was " + String.valueOf(operation.data));
            }
            ConditionalData operationData = (ConditionalData)object;
            this.markReachable(operationData.thenReachable || operationData.elseReachable);
            this.doEmitInstructionII((short)103, -1, operationData.thenReachable ? operationData.child0Bci : -1, operationData.elseReachable ? operationData.child1Bci : -1);
            this.afterChild(true, this.bci - 10);
        }

        public void beginWhile() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(12);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            WhileData operationData = new WhileData(this.bci, this.reachable);
            this.beginOperation(6, operationData);
        }

        public void endWhile() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(13);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(6);
            if (operation.childCount != 2) {
                throw this.failState("Operation While expected exactly 2 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            this.updateReachable();
            this.afterChild(false, -1);
        }

        public void beginTryCatch() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(14);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            TryCatchData operationData = new TryCatchData(++this.numHandlers, Builder.safeCastShort(this.currentStackHeight), this.bci, this.reachable, this.reachable, this.reachable);
            this.beginOperation(7, operationData);
        }

        public void endTryCatch() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(15);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(7);
            if (operation.childCount != 2) {
                throw this.failState("Operation TryCatch expected exactly 2 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof TryCatchData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class TryCatchData expected, but was " + String.valueOf(operation.data));
            }
            TryCatchData operationData = (TryCatchData)object;
            this.markReachable(operationData.tryReachable || operationData.catchReachable);
            this.afterChild(false, -1);
        }

        public void beginTryFinally(Runnable finallyGenerator) {
            if (this.serialization != null) {
                try {
                    short finallyGeneratorIndex = this.serializeFinallyGenerator(finallyGenerator);
                    this.serialization.buffer.writeShort(16);
                    this.serialization.buffer.writeShort(this.serialization.depth);
                    this.serialization.buffer.writeShort(finallyGeneratorIndex);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            TryFinallyData operationData = new TryFinallyData(++this.numHandlers, Builder.safeCastShort(this.currentStackHeight), finallyGenerator, this.bci, this.reachable, this.reachable, false);
            this.beginOperation(8, operationData);
        }

        public void endTryFinally() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(17);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(8);
            if (operation.childCount != 1) {
                throw this.failState("Operation TryFinally expected exactly 1 child, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof TryFinallyData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(operation.data));
            }
            TryFinallyData operationData = (TryFinallyData)object;
            int handlerSp = this.currentStackHeight + 1;
            this.updateMaxStackHeight(handlerSp);
            int exHandlerIndex = -1;
            if (operationData.operationReachable) {
                exHandlerIndex = this.doCreateExceptionHandler(operationData.tryStartBci, this.bci, 0, -operationData.handlerId, handlerSp);
            }
            this.doEmitFinallyHandler(operationData, this.operationSp);
            boolean bl = operationData.tryReachable = operationData.tryReachable && this.reachable;
            if (this.reachable) {
                operationData.endBranchFixupBci = this.bci + 2;
                this.doEmitInstructionI((short)20, 0, -1);
            }
            if (operationData.operationReachable) {
                this.reachable = true;
                this.patchHandlerTable(operationData.extraTableEntriesStart, operationData.extraTableEntriesEnd, operationData.handlerId, this.bci, handlerSp);
                if (exHandlerIndex != -1) {
                    this.handlerTable[exHandlerIndex + 3] = this.bci;
                }
            }
            this.currentStackHeight = handlerSp;
            this.doEmitFinallyHandler(operationData, this.operationSp);
            this.doEmitInstruction((short)43, -1);
            if (operationData.endBranchFixupBci != -1) {
                BYTES.putInt(this.bc, operationData.endBranchFixupBci, this.bci);
            }
            this.markReachable(operationData.tryReachable);
            this.afterChild(false, -1);
        }

        public void beginTryCatchOtherwise(Runnable otherwiseGenerator) {
            if (this.serialization != null) {
                try {
                    short finallyGeneratorIndex = this.serializeFinallyGenerator(otherwiseGenerator);
                    this.serialization.buffer.writeShort(18);
                    this.serialization.buffer.writeShort(this.serialization.depth);
                    this.serialization.buffer.writeShort(finallyGeneratorIndex);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            TryFinallyData operationData = new TryFinallyData(++this.numHandlers, Builder.safeCastShort(this.currentStackHeight), otherwiseGenerator, this.bci, this.reachable, this.reachable, this.reachable);
            this.beginOperation(9, operationData);
        }

        public void endTryCatchOtherwise() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(19);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(9);
            if (operation.childCount != 2) {
                throw this.failState("Operation TryCatchOtherwise expected exactly 2 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof TryFinallyData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(operation.data));
            }
            TryFinallyData operationData = (TryFinallyData)object;
            this.markReachable(operationData.tryReachable || operationData.catchReachable);
            this.afterChild(false, -1);
        }

        private void beginFinallyHandler(short finallyOperationSp) {
            this.validateRootOperationBegin();
            FinallyHandlerData operationData = new FinallyHandlerData(finallyOperationSp);
            this.beginOperation(10, operationData);
        }

        private void endFinallyHandler() {
            this.endOperation(10);
        }

        public void emitLabel(BytecodeLabel label) {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(22);
                    this.serialization.buffer.writeShort(Builder.safeCastShort(((SerializationLabel)label).contextDepth));
                    this.serialization.buffer.writeShort(Builder.safeCastShort(((SerializationLabel)label).labelIndex));
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            BytecodeLabelImpl labelImpl = (BytecodeLabelImpl)label;
            if (labelImpl.isDefined()) {
                throw this.failState("BytecodeLabel already emitted. Each label must be emitted exactly once.");
            }
            if (labelImpl.declaringOp != this.operationStack[this.operationSp - 1].sequenceNumber) {
                throw this.failState("BytecodeLabel must be emitted inside the same operation it was created in.");
            }
            Object object = this.operationStack[this.operationSp - 1].data;
            if (object instanceof BlockData) {
                BlockData blockData = (BlockData)object;
                assert (this.currentStackHeight == blockData.startStackHeight);
            } else {
                assert (this.operationStack[this.operationSp - 1].data instanceof RootData);
                assert (this.currentStackHeight == 0);
            }
            this.resolveUnresolvedLabel(labelImpl, this.currentStackHeight);
            this.markReachable(true);
            this.afterChild(false, -1);
        }

        public void emitBranch(BytecodeLabel label) {
            int targetStackHeight;
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(24);
                    this.serialization.buffer.writeShort(Builder.safeCastShort(((SerializationLabel)label).contextDepth));
                    this.serialization.buffer.writeShort(Builder.safeCastShort(((SerializationLabel)label).labelIndex));
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            BytecodeLabelImpl labelImpl = (BytecodeLabelImpl)label;
            int declaringOperationSp = -1;
            for (int i = this.operationSp - 1; i >= this.rootOperationSp; --i) {
                if (this.operationStack[i].operation == 10) {
                    i = ((FinallyHandlerData)this.operationStack[i].data).finallyOperationSp;
                    continue;
                }
                if (this.operationStack[i].sequenceNumber != labelImpl.declaringOp) continue;
                declaringOperationSp = i;
                break;
            }
            if (declaringOperationSp == -1) {
                throw this.failState("Branch must be targeting a label that is declared in an enclosing operation of the current root. Jumps into other operations are not permitted.");
            }
            if (labelImpl.isDefined()) {
                throw this.failState("Backward branches are unsupported. Use a While operation to model backward control flow.");
            }
            Object object = this.operationStack[declaringOperationSp].data;
            if (object instanceof BlockData) {
                BlockData blockData = (BlockData)object;
                targetStackHeight = blockData.startStackHeight;
            } else {
                assert (this.operationStack[declaringOperationSp].data instanceof RootData);
                targetStackHeight = 0;
            }
            this.beforeEmitBranch(declaringOperationSp);
            int stackHeightBeforeBranch = this.currentStackHeight;
            while (targetStackHeight != this.currentStackHeight) {
                this.doEmitInstructionI((short)25, -1, -1);
            }
            this.currentStackHeight = stackHeightBeforeBranch;
            if (this.reachable) {
                this.registerUnresolvedLabel(labelImpl, this.bci + 2);
            }
            this.doEmitInstructionI((short)20, 0, -1);
            this.markReachable(false);
            this.afterChild(false, this.bci - 6);
        }

        public void emitLoadConstant(Object constant) {
            if (this.serialization != null) {
                try {
                    int constant_index = this.serialization.serializeObject(constant);
                    this.serialization.buffer.writeShort(26);
                    this.serialization.buffer.writeInt(constant_index);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            if (constant == null) {
                throw this.failArgument("The constant parameter must not be null. Use emitLoadNull() instead for null values.");
            }
            if (constant instanceof Node && !(constant instanceof RootNode)) {
                throw this.failArgument("Nodes cannot be used as constants.");
            }
            this.beforeChild();
            this.doEmitInstructionI((short)4, 1, this.constantPool.addConstant(constant));
            this.afterChild(true, this.bci - 6);
        }

        public void emitLoadNull() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(28);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            this.doEmitInstruction((short)41, 1);
            this.afterChild(true, this.bci - 2);
        }

        public void emitLoadArgument(int index) {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(30);
                    this.serialization.buffer.writeInt(index);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            this.doEmitInstructionS((short)1, 1, Builder.safeCastShort(index));
            this.afterChild(true, this.bci - 4);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void emitLoadException() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(32);
                    return;
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            short exceptionStackHeight = -1;
            block6: for (int i = this.operationSp - 1; i >= this.rootOperationSp; --i) {
                if (this.operationStack[i].operation == 10) {
                    i = ((FinallyHandlerData)this.operationStack[i].data).finallyOperationSp;
                    continue;
                }
                switch (this.operationStack[i].operation) {
                    case 7: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof TryCatchData)) throw SLBytecodeRootNodeGen.assertionFailed("Data class TryCatchData expected, but was " + String.valueOf(this.operationStack[i].data));
                        Object operationData = (TryCatchData)object;
                        if (this.operationStack[i].childCount != 1) break;
                        exceptionStackHeight = ((TryCatchData)operationData).stackHeight;
                        break block6;
                    }
                    case 9: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof TryFinallyData)) throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(this.operationStack[i].data));
                        Object operationData = (TryFinallyData)object;
                        if (this.operationStack[i].childCount != 1) break;
                        exceptionStackHeight = ((TryFinallyData)operationData).stackHeight;
                        break block6;
                    }
                }
            }
            if (exceptionStackHeight == -1) {
                throw this.failState("LoadException can only be used in the catch operation of a TryCatch/TryCatchOtherwise operation in the current root.");
            }
            this.doEmitInstructionS((short)44, 1, exceptionStackHeight);
            this.afterChild(true, this.bci - 4);
        }

        private void validateLocalScope(BytecodeLocal local) {
            BytecodeLocalImpl localImpl = (BytecodeLocalImpl)local;
            if (!localImpl.scope.valid) {
                throw this.failArgument("Local variable scope of this local is no longer valid.");
            }
            RootData rootOperationData = this.getCurrentRootOperationData();
            if (rootOperationData.index != localImpl.rootIndex) {
                throw this.failArgument("Local variable must belong to the current root node. Consider using materialized local accesses (i.e., LoadLocalMaterialized/StoreLocalMaterialized or MaterializedLocalAccessor) to access locals from an outer root node. Materialized local accesses are currently disabled and can be enabled using the enableMaterializedLocalAccesses field of @GenerateBytecode.");
            }
        }

        public void emitLoadLocal(BytecodeLocal local) {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(34);
                    this.serialization.buffer.writeShort(Builder.safeCastShort(((SerializationLocal)local).contextDepth));
                    this.serialization.buffer.writeShort(Builder.safeCastShort(((SerializationLocal)local).localIndex));
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            this.validateLocalScope(local);
            this.doEmitInstructionSS((short)7, 1, ((BytecodeLocalImpl)local).frameIndex, ((BytecodeLocalImpl)local).localIndex);
            this.afterChild(true, this.bci - 6);
        }

        public void beginStoreLocal(BytecodeLocal local) {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(36);
                    this.serialization.buffer.writeShort(Builder.safeCastShort(((SerializationLocal)local).contextDepth));
                    this.serialization.buffer.writeShort(Builder.safeCastShort(((SerializationLocal)local).localIndex));
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.validateLocalScope(local);
            this.beforeChild();
            StoreLocalData operationData = new StoreLocalData((BytecodeLocalImpl)local);
            this.beginOperation(18, operationData);
        }

        public void endStoreLocal() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(37);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(18);
            if (operation.childCount != 1) {
                throw this.failState("Operation StoreLocal expected exactly 1 child, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof StoreLocalData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class StoreLocalData expected, but was " + String.valueOf(operation.data));
            }
            StoreLocalData operationData = (StoreLocalData)object;
            this.doEmitInstructionSSI((short)14, -1, operationData.local.frameIndex, operationData.local.localIndex, operationData.childBci);
            this.afterChild(false, this.bci - 10);
        }

        public void beginReturn() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(38);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            ReturnOperationData operationData = new ReturnOperationData();
            this.beginOperation(19, operationData);
        }

        public void endReturn() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(39);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(19);
            if (operation.childCount != 1) {
                throw this.failState("Operation Return expected exactly 1 child, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof ReturnOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class ReturnOperationData expected, but was " + String.valueOf(operation.data));
            }
            ReturnOperationData operationData = (ReturnOperationData)object;
            this.beforeEmitReturn(operationData.childBci);
            this.doEmitInstruction((short)42, -1);
            this.markReachable(false);
            this.afterChild(false, this.bci - 2);
        }

        public void beginSource(Source source) {
            if (!this.parseSources) {
                return;
            }
            if (this.serialization != null) {
                try {
                    int source_index = this.serialization.serializeObject(source);
                    this.serialization.buffer.writeShort(40);
                    this.serialization.buffer.writeInt(source_index);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.beforeChild();
            if (source.hasBytes()) {
                throw this.failArgument("Byte-based sources are not supported.");
            }
            int index = this.sources.indexOf(source);
            if (index == -1) {
                index = this.sources.size();
                this.sources.add(source);
            }
            SourceData operationData = new SourceData(index);
            this.beginOperation(20, operationData);
        }

        public void endSource() {
            if (!this.parseSources) {
                return;
            }
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(41);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(20);
            Object object = operation.data;
            if (!(object instanceof SourceData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class SourceData expected, but was " + String.valueOf(operation.data));
            }
            SourceData operationData = (SourceData)object;
            this.afterChild(operationData.producedValue, operationData.childBci);
        }

        public void beginSourceSection(int index, int length) {
            if (!this.parseSources) {
                return;
            }
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(42);
                    this.serialization.buffer.writeInt(index);
                    this.serialization.buffer.writeInt(length);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.beforeChild();
            int foundSourceIndex = -1;
            block5: for (int i = this.operationSp - 1; i >= 0; --i) {
                if (this.operationStack[i].operation == 10) {
                    i = ((FinallyHandlerData)this.operationStack[i].data).finallyOperationSp;
                    continue;
                }
                switch (this.operationStack[i].operation) {
                    case 20: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof SourceData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class SourceData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        SourceData sourceData = (SourceData)object;
                        foundSourceIndex = sourceData.sourceIndex;
                        break block5;
                    }
                    default: {
                        continue block5;
                    }
                }
            }
            if (foundSourceIndex == -1) {
                throw this.failState("No enclosing Source operation found - each SourceSection must be enclosed in a Source operation.");
            }
            assert (index == -1 && length == -1 || index >= 0 && length >= 0);
            int startBci = this.rootOperationSp == -1 ? 0 : this.bci;
            SourceSectionData operationData = new SourceSectionData(foundSourceIndex, startBci, index, length);
            this.beginOperation(21, operationData);
        }

        public void endSourceSection() {
            if (!this.parseSources) {
                return;
            }
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(43);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(21);
            Object object = operation.data;
            if (!(object instanceof SourceSectionData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class SourceSectionData expected, but was " + String.valueOf(operation.data));
            }
            SourceSectionData operationData = (SourceSectionData)object;
            this.doEmitSourceInfo(operationData.sourceIndex, operationData.startBci, this.bci, operationData.start, operationData.length);
            this.afterChild(operationData.producedValue, operationData.childBci);
        }

        public void beginTag(Class<?> ... newTags) {
            if (newTags.length == 0) {
                throw this.failArgument("The tags parameter for beginTag must not be empty. Please specify at least one tag.");
            }
            int encodedTags = SLBytecodeRootNodeGen.encodeTags(newTags);
            if ((encodedTags & this.tags) == 0) {
                return;
            }
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(44);
                    this.serialization.buffer.writeInt(encodedTags);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            TagNode node = new TagNode(encodedTags & this.tags, this.bci);
            if (this.tagNodes == null) {
                this.tagNodes = new ArrayList<TagNode>();
            }
            int nodeId = this.tagNodes.size();
            this.tagNodes.add(node);
            this.beforeChild();
            TagOperationData operationData = new TagOperationData(nodeId, this.reachable, this.currentStackHeight, node);
            this.beginOperation(22, operationData);
            this.doEmitInstructionI((short)45, 0, nodeId);
        }

        public void endTag(Class<?> ... newTags) {
            TagNode[] children;
            List<TagNode> operationChildren;
            if (newTags.length == 0) {
                throw this.failArgument("The tags parameter for beginTag must not be empty. Please specify at least one tag.");
            }
            int encodedTags = SLBytecodeRootNodeGen.encodeTags(newTags);
            if ((encodedTags & this.tags) == 0) {
                return;
            }
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(45);
                    this.serialization.buffer.writeInt(encodedTags);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(22);
            if (operation.childCount != 1) {
                throw this.failState("Operation Tag expected exactly 1 child, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof TagOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class TagOperationData expected, but was " + String.valueOf(operation.data));
            }
            TagOperationData operationData = (TagOperationData)object;
            TagNode tagNode = operationData.node;
            if ((encodedTags & this.tags) != tagNode.tags) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException("The tags provided to endTag do not match the tags provided to the corresponding beginTag call.");
            }
            boolean outerTagFound = false;
            for (int i = this.operationSp - 1; i >= this.rootOperationSp; --i) {
                if (this.operationStack[i].operation == 10) {
                    i = ((FinallyHandlerData)this.operationStack[i].data).finallyOperationSp;
                    continue;
                }
                Object object2 = this.operationStack[i].data;
                if (!(object2 instanceof TagOperationData)) continue;
                TagOperationData t = (TagOperationData)object2;
                if (t.children == null) {
                    t.children = new ArrayList<TagNode>(3);
                }
                t.children.add(tagNode);
                outerTagFound = true;
                break;
            }
            if (!outerTagFound) {
                if (this.tagRoots == null) {
                    this.tagRoots = new ArrayList<TagNode>(3);
                }
                this.tagRoots.add(tagNode);
            }
            if ((operationChildren = operationData.children) == null) {
                children = TagNode.EMPTY_ARRAY;
            } else {
                children = new TagNode[operationChildren.size()];
                for (int i = 0; i < children.length; ++i) {
                    children[i] = (TagNode)tagNode.insert((Node)operationChildren.get(i));
                }
            }
            tagNode.children = children;
            tagNode.returnBci = this.bci;
            if (operationData.producedValue) {
                if (operationData.operationReachable) {
                    this.markReachable(true);
                    this.doEmitInstructionII((short)46, 0, operationData.nodeId, operationData.childBci);
                    this.doCreateExceptionHandler(operationData.handlerStartBci, this.bci, 1, operationData.nodeId, operationData.startStackHeight);
                } else {
                    this.doEmitInstructionII((short)46, 0, operationData.nodeId, operationData.childBci);
                }
                this.afterChild(true, this.bci - 10);
            } else {
                if (operationData.operationReachable) {
                    this.markReachable(true);
                    this.doEmitInstructionI((short)52, 0, operationData.nodeId);
                    this.doCreateExceptionHandler(operationData.handlerStartBci, this.bci, 1, operationData.nodeId, operationData.startStackHeight);
                } else {
                    this.doEmitInstructionI((short)52, 0, operationData.nodeId);
                }
                this.afterChild(false, -1);
            }
        }

        public void emitSLAlwaysHalt() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(46);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beginTag(TAGS_ALWAYS_HALT);
            this.beforeChild();
            this.doEmitInstruction((short)53, 0);
            this.afterChild(false, this.bci - 2);
            this.endTag(TAGS_ALWAYS_HALT);
        }

        public void emitSLLoadArgument(int indexValue) {
            if (this.serialization != null) {
                try {
                    int indexValue_index = this.serialization.serializeObject(indexValue);
                    this.serialization.buffer.writeShort(48);
                    this.serialization.buffer.writeInt(indexValue_index);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            int indexIndex = this.constantPool.addConstant(indexValue);
            this.beforeChild();
            this.doEmitInstructionII((short)54, 1, indexIndex, this.allocateNode());
            this.afterChild(true, this.bci - 10);
        }

        public void emitBuiltin(NodeFactory<?> factoryValue, int argumentCountValue) {
            if (this.serialization != null) {
                try {
                    int factoryValue_index = this.serialization.serializeObject(factoryValue);
                    int argumentCountValue_index = this.serialization.serializeObject(argumentCountValue);
                    this.serialization.buffer.writeShort(50);
                    this.serialization.buffer.writeInt(factoryValue_index);
                    this.serialization.buffer.writeInt(argumentCountValue_index);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            if (factoryValue == null) {
                throw this.failArgument("The factoryValue parameter must not be null. Constant operands do not permit null values.");
            }
            int factoryIndex = this.constantPool.addConstant(factoryValue);
            int argumentCountIndex = this.constantPool.addConstant(argumentCountValue);
            this.beforeChild();
            this.doEmitInstructionIII((short)56, 1, factoryIndex, argumentCountIndex, this.allocateNode());
            this.afterChild(true, this.bci - 14);
        }

        public void beginSLInvoke() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(52);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomOperationData operationData = new CustomOperationData(EMPTY_INT_ARRAY, EMPTY_INT_ARRAY, new Object[0]);
            this.beginOperation(26, operationData);
        }

        public void endSLInvoke() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(53);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(26);
            if (operation.childCount < 1) {
                throw this.failState("Operation SLInvoke expected at least 1 child, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            this.doEmitVariadic(operation.childCount - 1);
            Object object = operation.data;
            if (!(object instanceof CustomOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomOperationData operationData = (CustomOperationData)object;
            this.doEmitInstructionI((short)57, -1, this.allocateNode());
            this.afterChild(true, this.bci - 6);
        }

        public void beginSLAdd() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(54);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomOperationData operationData = new CustomOperationData(new int[]{-1, -1}, EMPTY_INT_ARRAY, new Object[0]);
            this.beginOperation(27, operationData);
        }

        public void endSLAdd() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(55);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(27);
            if (operation.childCount != 2) {
                throw this.failState("Operation SLAdd expected exactly 2 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomOperationData operationData = (CustomOperationData)object;
            int childBci0 = operationData.childBcis[0];
            int childBci1 = operationData.childBcis[1];
            this.doEmitInstructionIII((short)58, -1, this.allocateNode(), childBci0, childBci1);
            this.afterChild(true, this.bci - 14);
        }

        public void beginSLDiv() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(56);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomOperationData operationData = new CustomOperationData(new int[]{-1, -1}, EMPTY_INT_ARRAY, new Object[0]);
            this.beginOperation(28, operationData);
        }

        public void endSLDiv() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(57);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(28);
            if (operation.childCount != 2) {
                throw this.failState("Operation SLDiv expected exactly 2 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomOperationData operationData = (CustomOperationData)object;
            int childBci0 = operationData.childBcis[0];
            int childBci1 = operationData.childBcis[1];
            this.doEmitInstructionIII((short)61, -1, this.allocateNode(), childBci0, childBci1);
            this.afterChild(true, this.bci - 14);
        }

        public void beginSLEqual() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(58);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomOperationData operationData = new CustomOperationData(new int[]{-1, -1}, EMPTY_INT_ARRAY, new Object[0]);
            this.beginOperation(29, operationData);
        }

        public void endSLEqual() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(59);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(29);
            if (operation.childCount != 2) {
                throw this.failState("Operation SLEqual expected exactly 2 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomOperationData operationData = (CustomOperationData)object;
            int childBci0 = operationData.childBcis[0];
            int childBci1 = operationData.childBcis[1];
            this.doEmitInstructionIII((short)64, -1, this.allocateNode(), childBci0, childBci1);
            this.afterChild(true, this.bci - 14);
        }

        public void beginSLLessOrEqual() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(60);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomOperationData operationData = new CustomOperationData(new int[]{-1, -1}, EMPTY_INT_ARRAY, new Object[0]);
            this.beginOperation(30, operationData);
        }

        public void endSLLessOrEqual() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(61);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(30);
            if (operation.childCount != 2) {
                throw this.failState("Operation SLLessOrEqual expected exactly 2 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomOperationData operationData = (CustomOperationData)object;
            int childBci0 = operationData.childBcis[0];
            int childBci1 = operationData.childBcis[1];
            this.doEmitInstructionIII((short)70, -1, this.allocateNode(), childBci0, childBci1);
            this.afterChild(true, this.bci - 14);
        }

        public void beginSLLessThan() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(62);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomOperationData operationData = new CustomOperationData(new int[]{-1, -1}, EMPTY_INT_ARRAY, new Object[0]);
            this.beginOperation(31, operationData);
        }

        public void endSLLessThan() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(63);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(31);
            if (operation.childCount != 2) {
                throw this.failState("Operation SLLessThan expected exactly 2 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomOperationData operationData = (CustomOperationData)object;
            int childBci0 = operationData.childBcis[0];
            int childBci1 = operationData.childBcis[1];
            this.doEmitInstructionIII((short)75, -1, this.allocateNode(), childBci0, childBci1);
            this.afterChild(true, this.bci - 14);
        }

        public void beginSLLogicalNot() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(64);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomOperationData operationData = new CustomOperationData(new int[]{-1}, EMPTY_INT_ARRAY, new Object[0]);
            this.beginOperation(32, operationData);
        }

        public void endSLLogicalNot() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(65);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(32);
            if (operation.childCount != 1) {
                throw this.failState("Operation SLLogicalNot expected exactly 1 child, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomOperationData operationData = (CustomOperationData)object;
            int childBci0 = operationData.childBcis[0];
            this.doEmitInstructionII((short)79, 0, this.allocateNode(), childBci0);
            this.afterChild(true, this.bci - 10);
        }

        public void beginSLMul() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(66);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomOperationData operationData = new CustomOperationData(new int[]{-1, -1}, EMPTY_INT_ARRAY, new Object[0]);
            this.beginOperation(33, operationData);
        }

        public void endSLMul() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(67);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(33);
            if (operation.childCount != 2) {
                throw this.failState("Operation SLMul expected exactly 2 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomOperationData operationData = (CustomOperationData)object;
            int childBci0 = operationData.childBcis[0];
            int childBci1 = operationData.childBcis[1];
            this.doEmitInstructionIII((short)83, -1, this.allocateNode(), childBci0, childBci1);
            this.afterChild(true, this.bci - 14);
        }

        public void beginSLReadProperty() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(68);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomOperationData operationData = new CustomOperationData(EMPTY_INT_ARRAY, EMPTY_INT_ARRAY, new Object[0]);
            this.beginOperation(34, operationData);
        }

        public void endSLReadProperty() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(69);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(34);
            if (operation.childCount != 2) {
                throw this.failState("Operation SLReadProperty expected exactly 2 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomOperationData operationData = (CustomOperationData)object;
            this.doEmitInstructionI((short)86, -1, this.allocateNode());
            this.afterChild(true, this.bci - 6);
        }

        public void beginSLSub() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(70);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomOperationData operationData = new CustomOperationData(new int[]{-1, -1}, EMPTY_INT_ARRAY, new Object[0]);
            this.beginOperation(35, operationData);
        }

        public void endSLSub() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(71);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(35);
            if (operation.childCount != 2) {
                throw this.failState("Operation SLSub expected exactly 2 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomOperationData operationData = (CustomOperationData)object;
            int childBci0 = operationData.childBcis[0];
            int childBci1 = operationData.childBcis[1];
            this.doEmitInstructionIII((short)87, -1, this.allocateNode(), childBci0, childBci1);
            this.afterChild(true, this.bci - 14);
        }

        public void beginSLWriteProperty() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(72);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomOperationData operationData = new CustomOperationData(EMPTY_INT_ARRAY, EMPTY_INT_ARRAY, new Object[0]);
            this.beginOperation(36, operationData);
        }

        public void endSLWriteProperty() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(73);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(36);
            if (operation.childCount != 3) {
                throw this.failState("Operation SLWriteProperty expected exactly 3 children, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomOperationData operationData = (CustomOperationData)object;
            this.doEmitInstructionI((short)90, -2, this.allocateNode());
            this.afterChild(true, this.bci - 6);
        }

        public void beginSLUnbox() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(74);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomOperationData operationData = new CustomOperationData(new int[]{-1}, EMPTY_INT_ARRAY, new Object[0]);
            this.beginOperation(37, operationData);
        }

        public void endSLUnbox() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(75);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(37);
            if (operation.childCount != 1) {
                throw this.failState("Operation SLUnbox expected exactly 1 child, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomOperationData operationData = (CustomOperationData)object;
            int childBci0 = operationData.childBcis[0];
            this.doEmitInstructionII((short)91, 0, this.allocateNode(), childBci0);
            this.afterChild(true, this.bci - 10);
        }

        public void beginSLFunctionLiteral() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(76);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomOperationData operationData = new CustomOperationData(EMPTY_INT_ARRAY, EMPTY_INT_ARRAY, new Object[0]);
            this.beginOperation(38, operationData);
        }

        public void endSLFunctionLiteral() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(77);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(38);
            if (operation.childCount != 1) {
                throw this.failState("Operation SLFunctionLiteral expected exactly 1 child, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomOperationData operationData = (CustomOperationData)object;
            this.doEmitInstructionI((short)96, 0, this.allocateNode());
            this.afterChild(true, this.bci - 6);
        }

        public void beginSLToBoolean() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(78);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomOperationData operationData = new CustomOperationData(new int[]{-1}, EMPTY_INT_ARRAY, new Object[0]);
            this.beginOperation(39, operationData);
        }

        public void endSLToBoolean() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(79);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(39);
            if (operation.childCount != 1) {
                throw this.failState("Operation SLToBoolean expected exactly 1 child, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomOperationData operationData = (CustomOperationData)object;
            int childBci0 = operationData.childBcis[0];
            this.doEmitInstructionII((short)97, 0, this.allocateNode(), childBci0);
            this.afterChild(true, this.bci - 10);
        }

        public void beginSLAnd() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(80);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomShortCircuitOperationData operationData = new CustomShortCircuitOperationData();
            this.beginOperation(40, operationData);
        }

        public void endSLAnd() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(81);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(40);
            if (operation.childCount == 0) {
                throw this.failState("Operation SLAnd expected at least 1 child, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomShortCircuitOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomShortCircuitOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomShortCircuitOperationData operationData = (CustomShortCircuitOperationData)object;
            int childBci = operationData.childBci;
            assert (childBci != -1);
            this.doEmitInstructionII((short)97, 0, this.allocateNode(), childBci);
            for (int site : operationData.branchFixupBcis) {
                BYTES.putInt(this.bc, site, this.bci);
            }
            this.afterChild(true, this.bci - 10);
        }

        public void beginSLOr() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(82);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            this.validateRootOperationBegin();
            this.beforeChild();
            CustomShortCircuitOperationData operationData = new CustomShortCircuitOperationData();
            this.beginOperation(41, operationData);
        }

        public void endSLOr() {
            if (this.serialization != null) {
                try {
                    this.serialization.buffer.writeShort(83);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                return;
            }
            OperationStackEntry operation = this.endOperation(41);
            if (operation.childCount == 0) {
                throw this.failState("Operation SLOr expected at least 1 child, but " + operation.childCount + " provided. This is probably a bug in the parser.");
            }
            Object object = operation.data;
            if (!(object instanceof CustomShortCircuitOperationData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomShortCircuitOperationData expected, but was " + String.valueOf(operation.data));
            }
            CustomShortCircuitOperationData operationData = (CustomShortCircuitOperationData)object;
            int childBci = operationData.childBci;
            assert (childBci != -1);
            this.doEmitInstructionII((short)97, 0, this.allocateNode(), childBci);
            for (int site : operationData.branchFixupBcis) {
                BYTES.putInt(this.bc, site, this.bci);
            }
            this.afterChild(true, this.bci - 10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markReachable(boolean newReachable) {
            this.reachable = newReachable;
            try {
                block21: for (int i = this.operationSp - 1; i >= this.rootOperationSp; --i) {
                    if (this.operationStack[i].operation == 10) {
                        i = ((FinallyHandlerData)this.operationStack[i].data).finallyOperationSp;
                        continue;
                    }
                    OperationStackEntry operation = this.operationStack[i];
                    switch (operation.operation) {
                        case 2: {
                            Object object = this.operationStack[i].data;
                            if (!(object instanceof RootData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class RootData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            Object operationData = (RootData)object;
                            ((RootData)operationData).reachable = newReachable;
                            return;
                        }
                        case 3: {
                            Object object = this.operationStack[i].data;
                            if (!(object instanceof IfThenData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class IfThenData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            Object operationData = (IfThenData)object;
                            if (operation.childCount == 0) {
                                ((IfThenData)operationData).thenReachable = newReachable;
                                continue block21;
                            }
                            if (operation.childCount == 1) {
                                ((IfThenData)operationData).thenReachable = newReachable;
                            }
                            return;
                        }
                        case 4: {
                            Object object = this.operationStack[i].data;
                            if (!(object instanceof IfThenElseData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class IfThenElseData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            Object operationData = (IfThenElseData)object;
                            if (operation.childCount == 0) {
                                ((IfThenElseData)operationData).thenReachable = newReachable;
                                ((IfThenElseData)operationData).elseReachable = newReachable;
                                continue block21;
                            }
                            if (operation.childCount == 1) {
                                ((IfThenElseData)operationData).thenReachable = newReachable;
                            } else if (operation.childCount == 2) {
                                ((IfThenElseData)operationData).elseReachable = newReachable;
                            }
                            return;
                        }
                        case 5: {
                            Object object = this.operationStack[i].data;
                            if (!(object instanceof ConditionalData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class ConditionalData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            Object operationData = (ConditionalData)object;
                            if (operation.childCount == 0) {
                                ((ConditionalData)operationData).thenReachable = newReachable;
                                ((ConditionalData)operationData).elseReachable = newReachable;
                                continue block21;
                            }
                            if (operation.childCount == 1) {
                                ((ConditionalData)operationData).thenReachable = newReachable;
                            } else if (operation.childCount == 2) {
                                ((ConditionalData)operationData).elseReachable = newReachable;
                            }
                            return;
                        }
                        case 6: {
                            Object object = this.operationStack[i].data;
                            if (!(object instanceof WhileData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class WhileData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            Object operationData = (WhileData)object;
                            if (operation.childCount == 0) {
                                ((WhileData)operationData).bodyReachable = newReachable;
                                continue block21;
                            }
                            if (operation.childCount == 1) {
                                ((WhileData)operationData).bodyReachable = newReachable;
                            }
                            return;
                        }
                        case 7: {
                            Object object = this.operationStack[i].data;
                            if (!(object instanceof TryCatchData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class TryCatchData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            Object operationData = (TryCatchData)object;
                            if (operation.childCount == 0) {
                                ((TryCatchData)operationData).tryReachable = newReachable;
                            } else if (operation.childCount == 1) {
                                ((TryCatchData)operationData).catchReachable = newReachable;
                            }
                            return;
                        }
                        case 8: {
                            Object object = this.operationStack[i].data;
                            if (!(object instanceof TryFinallyData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            Object operationData = (TryFinallyData)object;
                            if (operation.childCount == 0) {
                                ((TryFinallyData)operationData).tryReachable = newReachable;
                            }
                            return;
                        }
                        case 9: {
                            Object object = this.operationStack[i].data;
                            if (!(object instanceof TryFinallyData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            Object operationData = (TryFinallyData)object;
                            if (operation.childCount == 0) {
                                ((TryFinallyData)operationData).tryReachable = newReachable;
                            } else if (operation.childCount == 1) {
                                ((TryFinallyData)operationData).catchReachable = newReachable;
                            }
                            return;
                        }
                    }
                }
            }
            finally {
                assert (this.updateReachable() == this.reachable) : "Inconsistent reachability detected.";
            }
        }

        private boolean updateReachable() {
            boolean oldReachable = this.reachable;
            block10: for (int i = this.operationSp - 1; i >= this.rootOperationSp; --i) {
                if (this.operationStack[i].operation == 10) {
                    i = ((FinallyHandlerData)this.operationStack[i].data).finallyOperationSp;
                    continue;
                }
                OperationStackEntry operation = this.operationStack[i];
                switch (operation.operation) {
                    case 2: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof RootData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class RootData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (RootData)object;
                        this.reachable = ((RootData)operationData).reachable;
                        return oldReachable;
                    }
                    case 3: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof IfThenData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class IfThenData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (IfThenData)object;
                        if (operation.childCount == 0) continue block10;
                        if (operation.childCount == 1) {
                            this.reachable = ((IfThenData)operationData).thenReachable;
                        }
                        return oldReachable;
                    }
                    case 4: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof IfThenElseData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class IfThenElseData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (IfThenElseData)object;
                        if (operation.childCount == 0) continue block10;
                        if (operation.childCount == 1) {
                            this.reachable = ((IfThenElseData)operationData).thenReachable;
                        } else if (operation.childCount == 2) {
                            this.reachable = ((IfThenElseData)operationData).elseReachable;
                        }
                        return oldReachable;
                    }
                    case 5: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof ConditionalData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class ConditionalData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (ConditionalData)object;
                        if (operation.childCount == 0) continue block10;
                        if (operation.childCount == 1) {
                            this.reachable = ((ConditionalData)operationData).thenReachable;
                        } else if (operation.childCount == 2) {
                            this.reachable = ((ConditionalData)operationData).elseReachable;
                        }
                        return oldReachable;
                    }
                    case 6: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof WhileData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class WhileData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (WhileData)object;
                        if (operation.childCount == 0) continue block10;
                        if (operation.childCount == 1) {
                            this.reachable = ((WhileData)operationData).bodyReachable;
                        }
                        return oldReachable;
                    }
                    case 7: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof TryCatchData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class TryCatchData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (TryCatchData)object;
                        if (operation.childCount == 0) {
                            this.reachable = ((TryCatchData)operationData).tryReachable;
                        } else if (operation.childCount == 1) {
                            this.reachable = ((TryCatchData)operationData).catchReachable;
                        }
                        return oldReachable;
                    }
                    case 8: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof TryFinallyData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (TryFinallyData)object;
                        if (operation.childCount == 0) {
                            this.reachable = ((TryFinallyData)operationData).tryReachable;
                        }
                        return oldReachable;
                    }
                    case 9: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof TryFinallyData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (TryFinallyData)object;
                        if (operation.childCount == 0) {
                            this.reachable = ((TryFinallyData)operationData).tryReachable;
                        } else if (operation.childCount == 2) {
                            this.reachable = ((TryFinallyData)operationData).catchReachable;
                        }
                        return oldReachable;
                    }
                }
            }
            return oldReachable;
        }

        private void beginOperation(int id, Object data) {
            if (this.operationSp == this.operationStack.length) {
                this.operationStack = Arrays.copyOf(this.operationStack, this.operationStack.length * 2);
            }
            this.operationStack[this.operationSp++] = new OperationStackEntry(id, data, this.operationSequenceNumber++);
        }

        private OperationStackEntry endOperation(int id) {
            if (this.operationSp == 0) {
                throw this.failState("Unexpected operation end - there are no operations on the stack. Did you forget a beginRoot()?");
            }
            OperationStackEntry entry = this.operationStack[this.operationSp - 1];
            if (entry.operation != id) {
                throw this.failState("Unexpected operation end, expected end" + OPERATION_NAMES[entry.operation] + ", but got end" + OPERATION_NAMES[id]);
            }
            if (entry.declaredLabels != null) {
                for (BytecodeLabel label : entry.declaredLabels) {
                    BytecodeLabelImpl impl = (BytecodeLabelImpl)label;
                    if (impl.isDefined()) continue;
                    throw this.failState("Operation " + OPERATION_NAMES[id] + " ended without emitting one or more declared labels.");
                }
            }
            this.operationStack[this.operationSp - 1] = null;
            --this.operationSp;
            return entry;
        }

        private void validateRootOperationBegin() {
            if (this.rootOperationSp == -1) {
                throw this.failState("Unexpected operation emit - no root operation present. Did you forget a beginRoot()?");
            }
        }

        private RootData getCurrentRootOperationData() {
            this.validateRootOperationBegin();
            Object object = this.operationStack[this.rootOperationSp].data;
            if (!(object instanceof RootData)) {
                throw SLBytecodeRootNodeGen.assertionFailed("Data class RootData expected, but was " + String.valueOf(this.operationStack[this.rootOperationSp].data));
            }
            RootData rootOperationData = (RootData)object;
            return rootOperationData;
        }

        private void beforeChild() {
            if (this.operationSp == 0) {
                return;
            }
            int childIndex = this.operationStack[this.operationSp - 1].childCount;
            switch (this.operationStack[this.operationSp - 1].operation) {
                case 1: {
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof BlockData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class BlockData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    BlockData operationData = (BlockData)object;
                    if (!operationData.producedValue) break;
                    this.doEmitInstructionI((short)25, -1, operationData.childBci);
                    break;
                }
                case 2: {
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof RootData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class RootData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    RootData operationData = (RootData)object;
                    if (!operationData.producedValue) break;
                    this.doEmitInstructionI((short)25, -1, operationData.childBci);
                    break;
                }
                case 20: {
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof SourceData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class SourceData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    SourceData operationData = (SourceData)object;
                    if (!operationData.producedValue) break;
                    this.doEmitInstructionI((short)25, -1, operationData.childBci);
                    break;
                }
                case 21: {
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof SourceSectionData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class SourceSectionData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    SourceSectionData operationData = (SourceSectionData)object;
                    if (!operationData.producedValue) break;
                    this.doEmitInstructionI((short)25, -1, operationData.childBci);
                    break;
                }
                case 40: {
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof CustomShortCircuitOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomShortCircuitOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    CustomShortCircuitOperationData operationData = (CustomShortCircuitOperationData)object;
                    if (childIndex == 0) break;
                    int childBci = operationData.childBci;
                    assert (childBci != -1);
                    this.doEmitInstructionII((short)97, 0, this.allocateNode(), childBci);
                    if (this.reachable) {
                        operationData.branchFixupBcis.add(this.bci + 2);
                    }
                    this.doEmitInstructionII((short)101, -1, -1, this.allocateBranchProfile());
                    break;
                }
                case 41: {
                    Object childBci = this.operationStack[this.operationSp - 1].data;
                    if (!(childBci instanceof CustomShortCircuitOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomShortCircuitOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    CustomShortCircuitOperationData operationData = (CustomShortCircuitOperationData)childBci;
                    if (childIndex == 0) break;
                    int childBci2 = operationData.childBci;
                    assert (childBci2 != -1);
                    this.doEmitInstructionII((short)97, 0, this.allocateNode(), childBci2);
                    if (this.reachable) {
                        operationData.branchFixupBcis.add(this.bci + 2);
                    }
                    this.doEmitInstructionII((short)102, -1, -1, this.allocateBranchProfile());
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    if (childIndex < 1) break;
                    this.updateReachable();
                    break;
                }
                case 7: {
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof TryCatchData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class TryCatchData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    TryCatchData operationData = (TryCatchData)object;
                    if (childIndex != 1) break;
                    this.updateReachable();
                    ++this.currentStackHeight;
                    this.updateMaxStackHeight(this.currentStackHeight);
                    break;
                }
                case 9: {
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof TryFinallyData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    TryFinallyData operationData = (TryFinallyData)object;
                    if (childIndex != 1) break;
                    this.updateReachable();
                    ++this.currentStackHeight;
                    this.updateMaxStackHeight(this.currentStackHeight);
                    break;
                }
                case 6: 
                case 10: 
                case 18: 
                case 19: 
                case 22: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    break;
                }
                default: {
                    throw SLBytecodeRootNodeGen.assertionFailed("beforeChild should not be called on an operation with no children.");
                }
            }
        }

        private void afterChild(boolean producedValue, int childBci) {
            if (this.operationSp == 0) {
                return;
            }
            int childIndex = this.operationStack[this.operationSp - 1].childCount;
            switch (this.operationStack[this.operationSp - 1].operation) {
                case 1: {
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof BlockData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class BlockData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    BlockData operationData = (BlockData)object;
                    operationData.producedValue = producedValue;
                    operationData.childBci = childBci;
                    break;
                }
                case 2: {
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof RootData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class RootData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    RootData operationData = (RootData)object;
                    operationData.producedValue = producedValue;
                    operationData.childBci = childBci;
                    break;
                }
                case 20: {
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof SourceData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class SourceData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    SourceData operationData = (SourceData)object;
                    operationData.producedValue = producedValue;
                    operationData.childBci = childBci;
                    break;
                }
                case 21: {
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof SourceSectionData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class SourceSectionData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    SourceSectionData operationData = (SourceSectionData)object;
                    operationData.producedValue = producedValue;
                    operationData.childBci = childBci;
                    break;
                }
                case 22: {
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof TagOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class TagOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    TagOperationData operationData = (TagOperationData)object;
                    operationData.producedValue = producedValue;
                    operationData.childBci = childBci;
                    break;
                }
                case 3: {
                    Object object;
                    if (childIndex == 0 && !producedValue) {
                        throw this.failState("Operation IfThen expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    if (childIndex == 1 && producedValue) {
                        this.doEmitInstructionI((short)25, -1, childBci);
                    }
                    if (!((object = this.operationStack[this.operationSp - 1].data) instanceof IfThenData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class IfThenData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    IfThenData operationData = (IfThenData)object;
                    if (childIndex == 0) {
                        if (this.reachable) {
                            operationData.falseBranchFixupBci = this.bci + 2;
                        }
                        this.doEmitInstructionIII((short)22, -1, -1, this.allocateBranchProfile(), childBci);
                        break;
                    }
                    int toUpdate = operationData.falseBranchFixupBci;
                    if (toUpdate == -1) break;
                    BYTES.putInt(this.bc, toUpdate, this.bci);
                    break;
                }
                case 4: {
                    Object toUpdate;
                    if (childIndex == 0 && !producedValue) {
                        throw this.failState("Operation IfThenElse expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    if ((childIndex == 1 || childIndex == 2) && producedValue) {
                        this.doEmitInstructionI((short)25, -1, childBci);
                    }
                    if (!((toUpdate = this.operationStack[this.operationSp - 1].data) instanceof IfThenElseData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class IfThenElseData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    IfThenElseData operationData = (IfThenElseData)toUpdate;
                    if (childIndex == 0) {
                        if (this.reachable) {
                            operationData.falseBranchFixupBci = this.bci + 2;
                        }
                        this.doEmitInstructionIII((short)22, -1, -1, this.allocateBranchProfile(), childBci);
                        break;
                    }
                    if (childIndex == 1) {
                        if (this.reachable) {
                            operationData.endBranchFixupBci = this.bci + 2;
                        }
                        this.doEmitInstructionI((short)20, 0, -1);
                        int toUpdate2 = operationData.falseBranchFixupBci;
                        if (toUpdate2 == -1) break;
                        BYTES.putInt(this.bc, toUpdate2, this.bci);
                        break;
                    }
                    int toUpdate3 = operationData.endBranchFixupBci;
                    if (toUpdate3 == -1) break;
                    BYTES.putInt(this.bc, toUpdate3, this.bci);
                    break;
                }
                case 5: {
                    if (!producedValue) {
                        throw this.failState("Operation Conditional expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object toUpdate3 = this.operationStack[this.operationSp - 1].data;
                    if (!(toUpdate3 instanceof ConditionalData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class ConditionalData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    ConditionalData operationData = (ConditionalData)toUpdate3;
                    if (childIndex == 0) {
                        this.doEmitInstruction((short)29, 1);
                        if (this.reachable) {
                            operationData.falseBranchFixupBci = this.bci + 2;
                        }
                        this.doEmitInstructionIII((short)22, -1, -1, this.allocateBranchProfile(), childBci);
                        break;
                    }
                    if (childIndex == 1) {
                        operationData.child0Bci = childBci;
                        if (this.reachable) {
                            operationData.endBranchFixupBci = this.bci + 2;
                            this.doEmitInstructionI((short)20, 0, -1);
                        }
                        --this.currentStackHeight;
                        int toUpdate = operationData.falseBranchFixupBci;
                        if (toUpdate == -1) break;
                        BYTES.putInt(this.bc, toUpdate, this.bci);
                        break;
                    }
                    operationData.child1Bci = childBci;
                    int toUpdate = operationData.endBranchFixupBci;
                    if (toUpdate == -1) break;
                    BYTES.putInt(this.bc, toUpdate, this.bci);
                    break;
                }
                case 6: {
                    Object toUpdate;
                    if (childIndex == 0 && !producedValue) {
                        throw this.failState("Operation While expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    if (childIndex == 1 && producedValue) {
                        this.doEmitInstructionI((short)25, -1, childBci);
                    }
                    if (!((toUpdate = this.operationStack[this.operationSp - 1].data) instanceof WhileData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class WhileData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    WhileData operationData = (WhileData)toUpdate;
                    if (childIndex == 0) {
                        if (this.reachable) {
                            operationData.endBranchFixupBci = this.bci + 2;
                        }
                        this.doEmitInstructionIII((short)22, -1, -1, this.allocateBranchProfile(), childBci);
                        break;
                    }
                    int toUpdate2 = operationData.endBranchFixupBci;
                    if (toUpdate2 == -1) break;
                    this.doEmitInstructionII((short)21, 0, operationData.whileStartBci, BYTES.getInt(this.bc, toUpdate2 + 4));
                    BYTES.putInt(this.bc, toUpdate2, this.bci);
                    break;
                }
                case 7: {
                    Object toUpdate2;
                    if (producedValue) {
                        this.doEmitInstructionI((short)25, -1, childBci);
                    }
                    if (!((toUpdate2 = this.operationStack[this.operationSp - 1].data) instanceof TryCatchData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class TryCatchData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    TryCatchData operationData = (TryCatchData)toUpdate2;
                    if (childIndex == 0) {
                        if (!operationData.operationReachable) break;
                        int tryEndBci = this.bci;
                        if (operationData.tryReachable) {
                            operationData.endBranchFixupBci = this.bci + 2;
                            this.doEmitInstructionI((short)20, 0, -1);
                        }
                        int handlerSp = this.currentStackHeight + 1;
                        this.patchHandlerTable(operationData.extraTableEntriesStart, operationData.extraTableEntriesEnd, operationData.handlerId, this.bci, handlerSp);
                        this.doCreateExceptionHandler(operationData.tryStartBci, tryEndBci, 0, this.bci, handlerSp);
                        break;
                    }
                    if (childIndex != 1) break;
                    this.doEmitInstructionI((short)25, -1, -1);
                    if (operationData.endBranchFixupBci == -1) break;
                    BYTES.putInt(this.bc, operationData.endBranchFixupBci, this.bci);
                    break;
                }
                case 8: {
                    if (!producedValue) break;
                    this.doEmitInstructionI((short)25, -1, childBci);
                    break;
                }
                case 9: {
                    Object tryEndBci;
                    if (producedValue) {
                        this.doEmitInstructionI((short)25, -1, childBci);
                    }
                    if (!((tryEndBci = this.operationStack[this.operationSp - 1].data) instanceof TryFinallyData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    TryFinallyData operationData = (TryFinallyData)tryEndBci;
                    if (childIndex == 0) {
                        int handlerSp = this.currentStackHeight + 1;
                        this.updateMaxStackHeight(handlerSp);
                        int exHandlerIndex = -1;
                        if (operationData.operationReachable) {
                            exHandlerIndex = this.doCreateExceptionHandler(operationData.tryStartBci, this.bci, 0, -operationData.handlerId, handlerSp);
                        }
                        this.doEmitFinallyHandler(operationData, this.operationSp - 1);
                        boolean bl = operationData.tryReachable = operationData.tryReachable && this.reachable;
                        if (this.reachable) {
                            operationData.endBranchFixupBci = this.bci + 2;
                            this.doEmitInstructionI((short)20, 0, -1);
                        }
                        if (!operationData.operationReachable) break;
                        this.reachable = true;
                        this.patchHandlerTable(operationData.extraTableEntriesStart, operationData.extraTableEntriesEnd, operationData.handlerId, this.bci, handlerSp);
                        if (exHandlerIndex == -1) break;
                        this.handlerTable[exHandlerIndex + 3] = this.bci;
                        break;
                    }
                    this.doEmitInstructionI((short)25, -1, -1);
                    if (operationData.endBranchFixupBci == -1) break;
                    BYTES.putInt(this.bc, operationData.endBranchFixupBci, this.bci);
                    break;
                }
                case 10: {
                    if (!producedValue) break;
                    this.doEmitInstructionI((short)25, -1, childBci);
                    break;
                }
                case 18: {
                    if (!producedValue) {
                        throw this.failState("Operation StoreLocal expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof StoreLocalData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class StoreLocalData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    StoreLocalData operationData = (StoreLocalData)object;
                    operationData.childBci = childBci;
                    break;
                }
                case 19: {
                    if (!producedValue) {
                        throw this.failState("Operation Return expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof ReturnOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class ReturnOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    ReturnOperationData operationData = (ReturnOperationData)object;
                    operationData.producedValue = producedValue;
                    operationData.childBci = childBci;
                    break;
                }
                case 26: {
                    if (producedValue) break;
                    throw this.failState("Operation SLInvoke expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                }
                case 27: {
                    if (!producedValue) {
                        throw this.failState("Operation SLAdd expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof CustomOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    CustomOperationData operationData = (CustomOperationData)object;
                    if (childIndex == 0) {
                        operationData.childBcis[0] = childBci;
                        break;
                    }
                    if (childIndex != 1) break;
                    operationData.childBcis[1] = childBci;
                    break;
                }
                case 28: {
                    if (!producedValue) {
                        throw this.failState("Operation SLDiv expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof CustomOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    CustomOperationData operationData = (CustomOperationData)object;
                    if (childIndex == 0) {
                        operationData.childBcis[0] = childBci;
                        break;
                    }
                    if (childIndex != 1) break;
                    operationData.childBcis[1] = childBci;
                    break;
                }
                case 29: {
                    if (!producedValue) {
                        throw this.failState("Operation SLEqual expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof CustomOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    CustomOperationData operationData = (CustomOperationData)object;
                    if (childIndex == 0) {
                        operationData.childBcis[0] = childBci;
                        break;
                    }
                    if (childIndex != 1) break;
                    operationData.childBcis[1] = childBci;
                    break;
                }
                case 30: {
                    if (!producedValue) {
                        throw this.failState("Operation SLLessOrEqual expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof CustomOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    CustomOperationData operationData = (CustomOperationData)object;
                    if (childIndex == 0) {
                        operationData.childBcis[0] = childBci;
                        break;
                    }
                    if (childIndex != 1) break;
                    operationData.childBcis[1] = childBci;
                    break;
                }
                case 31: {
                    if (!producedValue) {
                        throw this.failState("Operation SLLessThan expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof CustomOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    CustomOperationData operationData = (CustomOperationData)object;
                    if (childIndex == 0) {
                        operationData.childBcis[0] = childBci;
                        break;
                    }
                    if (childIndex != 1) break;
                    operationData.childBcis[1] = childBci;
                    break;
                }
                case 32: {
                    if (!producedValue) {
                        throw this.failState("Operation SLLogicalNot expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof CustomOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    CustomOperationData operationData = (CustomOperationData)object;
                    if (childIndex != 0) break;
                    operationData.childBcis[0] = childBci;
                    break;
                }
                case 33: {
                    if (!producedValue) {
                        throw this.failState("Operation SLMul expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof CustomOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    CustomOperationData operationData = (CustomOperationData)object;
                    if (childIndex == 0) {
                        operationData.childBcis[0] = childBci;
                        break;
                    }
                    if (childIndex != 1) break;
                    operationData.childBcis[1] = childBci;
                    break;
                }
                case 34: {
                    if (producedValue) break;
                    throw this.failState("Operation SLReadProperty expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                }
                case 35: {
                    if (!producedValue) {
                        throw this.failState("Operation SLSub expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof CustomOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    CustomOperationData operationData = (CustomOperationData)object;
                    if (childIndex == 0) {
                        operationData.childBcis[0] = childBci;
                        break;
                    }
                    if (childIndex != 1) break;
                    operationData.childBcis[1] = childBci;
                    break;
                }
                case 36: {
                    if (producedValue) break;
                    throw this.failState("Operation SLWriteProperty expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                }
                case 37: {
                    if (!producedValue) {
                        throw this.failState("Operation SLUnbox expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof CustomOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    CustomOperationData operationData = (CustomOperationData)object;
                    if (childIndex != 0) break;
                    operationData.childBcis[0] = childBci;
                    break;
                }
                case 38: {
                    if (producedValue) break;
                    throw this.failState("Operation SLFunctionLiteral expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                }
                case 39: {
                    if (!producedValue) {
                        throw this.failState("Operation SLToBoolean expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof CustomOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    CustomOperationData operationData = (CustomOperationData)object;
                    if (childIndex != 0) break;
                    operationData.childBcis[0] = childBci;
                    break;
                }
                case 40: {
                    if (!producedValue) {
                        throw this.failState("Operation SLAnd expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof CustomShortCircuitOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomShortCircuitOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    CustomShortCircuitOperationData operationData = (CustomShortCircuitOperationData)object;
                    operationData.childBci = childBci;
                    break;
                }
                case 41: {
                    if (!producedValue) {
                        throw this.failState("Operation SLOr expected a value-producing child at position " + childIndex + ", but a void one was provided.");
                    }
                    Object object = this.operationStack[this.operationSp - 1].data;
                    if (!(object instanceof CustomShortCircuitOperationData)) {
                        throw SLBytecodeRootNodeGen.assertionFailed("Data class CustomShortCircuitOperationData expected, but was " + String.valueOf(this.operationStack[this.operationSp - 1].data));
                    }
                    CustomShortCircuitOperationData operationData = (CustomShortCircuitOperationData)object;
                    operationData.childBci = childBci;
                    break;
                }
            }
            this.operationStack[this.operationSp - 1].childCount = childIndex + 1;
        }

        private void updateMaxStackHeight(int stackHeight) {
            this.maxStackHeight = Math.max(this.maxStackHeight, stackHeight);
            if (this.maxStackHeight > Short.MAX_VALUE) {
                throw BytecodeEncodingException.create((String)"Maximum stack height exceeded.");
            }
        }

        private void ensureBytecodeCapacity(int size) {
            if (size > this.bc.length) {
                this.bc = Arrays.copyOf(this.bc, Math.max(size, this.bc.length * 2));
            }
        }

        private void doEmitVariadic(int count) {
            this.currentStackHeight -= count - 1;
            if (!this.reachable) {
                return;
            }
            if (count <= 8) {
                this.doEmitInstruction(Builder.safeCastShort(30 + count), 0);
            } else {
                int elementCount;
                this.updateMaxStackHeight(this.currentStackHeight + count);
                this.doEmitInstruction((short)40, 0);
                for (elementCount = count + 1; elementCount > 8; elementCount -= 7) {
                    this.doEmitInstruction((short)38, 0);
                }
                if (elementCount > 0) {
                    this.doEmitInstruction(Builder.safeCastShort(30 + elementCount), 0);
                }
                this.doEmitInstruction((short)39, 0);
            }
            if (count == 0) {
                this.updateMaxStackHeight(this.currentStackHeight);
            }
        }

        private void doEmitFinallyHandler(TryFinallyData TryFinallyData2, int finallyOperationSp) {
            assert (TryFinallyData2.finallyHandlerSp == -1);
            try {
                TryFinallyData2.finallyHandlerSp = this.operationSp;
                this.beginFinallyHandler(Builder.safeCastShort(finallyOperationSp));
                TryFinallyData2.finallyGenerator.run();
                this.endFinallyHandler();
            }
            finally {
                TryFinallyData2.finallyHandlerSp = -1;
            }
        }

        private int doCreateExceptionHandler(int startBci, int endBci, int handlerKind, int handlerBci, int handlerSp) {
            assert (startBci <= endBci);
            if (startBci == endBci) {
                return -1;
            }
            if (this.handlerTableSize > 0) {
                int previousEntry = this.handlerTableSize - 5;
                int previousEndBci = this.handlerTable[previousEntry + 1];
                int previousKind = this.handlerTable[previousEntry + 2];
                int previousHandlerBci = this.handlerTable[previousEntry + 3];
                if (previousEndBci == startBci && previousKind == handlerKind && previousHandlerBci == handlerBci) {
                    this.handlerTable[previousEntry + 1] = endBci;
                    return -1;
                }
            }
            if (this.handlerTable.length <= this.handlerTableSize + 5) {
                this.handlerTable = Arrays.copyOf(this.handlerTable, this.handlerTable.length * 2);
            }
            int result = this.handlerTableSize;
            this.handlerTable[this.handlerTableSize + 0] = startBci;
            this.handlerTable[this.handlerTableSize + 1] = endBci;
            this.handlerTable[this.handlerTableSize + 2] = handlerKind;
            this.handlerTable[this.handlerTableSize + 3] = handlerBci;
            this.handlerTable[this.handlerTableSize + 4] = handlerSp;
            this.handlerTableSize += 5;
            return result;
        }

        private void doEmitSourceInfo(int sourceIndex, int startBci, int endBci, int start, int length) {
            assert (this.parseSources);
            if (this.rootOperationSp == -1) {
                return;
            }
            int index = this.sourceInfoIndex;
            int prevIndex = index - 5;
            if (prevIndex >= 0 && this.sourceInfo[prevIndex + 2] == sourceIndex && this.sourceInfo[prevIndex + 3] == start && this.sourceInfo[prevIndex + 4] == length) {
                if (this.sourceInfo[prevIndex + 0] == startBci && this.sourceInfo[prevIndex + 1] == endBci) {
                    return;
                }
                if (this.sourceInfo[prevIndex + 1] == startBci) {
                    this.sourceInfo[prevIndex + 1] = endBci;
                    return;
                }
            }
            if (index >= this.sourceInfo.length) {
                this.sourceInfo = Arrays.copyOf(this.sourceInfo, this.sourceInfo.length * 2);
            }
            this.sourceInfo[index + 0] = startBci;
            this.sourceInfo[index + 1] = endBci;
            this.sourceInfo[index + 2] = sourceIndex;
            this.sourceInfo[index + 3] = start;
            this.sourceInfo[index + 4] = length;
            this.sourceInfoIndex = index + 5;
        }

        private void finish() {
            if (this.operationSp != 0) {
                throw this.failState("Unexpected parser end - there are still operations on the stack. Did you forget to end them?");
            }
            if (this.reparseReason == null) {
                this.nodes.setNodes(this.builtNodes.toArray(new SLBytecodeRootNodeGen[0]));
            }
            assert (this.nodes.validate());
        }

        private void beforeEmitBranch(int declaringOperationSp) {
            int i;
            boolean needsRewind = false;
            block15: for (i = this.operationSp - 1; i >= declaringOperationSp + 1; --i) {
                if (this.operationStack[i].operation == 10) {
                    i = ((FinallyHandlerData)this.operationStack[i].data).finallyOperationSp;
                    continue;
                }
                switch (this.operationStack[i].operation) {
                    case 22: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof TagOperationData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class TagOperationData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (TagOperationData)object;
                        if (!this.reachable) continue block15;
                        this.doEmitInstructionI((short)52, 0, ((TagOperationData)operationData).nodeId);
                        this.doCreateExceptionHandler(((TagOperationData)operationData).handlerStartBci, this.bci, 1, ((TagOperationData)operationData).nodeId, ((TagOperationData)operationData).startStackHeight);
                        needsRewind = true;
                        continue block15;
                    }
                    case 8: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof TryFinallyData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (TryFinallyData)object;
                        if (this.operationStack[i].childCount != 0) continue block15;
                        if (this.reachable) {
                            int handlerTableIndex = this.doCreateExceptionHandler(((TryFinallyData)operationData).tryStartBci, this.bci, 0, -((TryFinallyData)operationData).handlerId, -1);
                            if (handlerTableIndex != -1) {
                                if (((TryFinallyData)operationData).extraTableEntriesStart == -1) {
                                    ((TryFinallyData)operationData).extraTableEntriesStart = handlerTableIndex;
                                }
                                ((TryFinallyData)operationData).extraTableEntriesEnd = handlerTableIndex + 5;
                            }
                            needsRewind = true;
                        }
                        this.doEmitFinallyHandler((TryFinallyData)operationData, i);
                        continue block15;
                    }
                    case 9: {
                        Object handlerTableIndex = this.operationStack[i].data;
                        if (!(handlerTableIndex instanceof TryFinallyData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (TryFinallyData)handlerTableIndex;
                        if (this.operationStack[i].childCount != 0) continue block15;
                        if (this.reachable) {
                            int handlerTableIndex2 = this.doCreateExceptionHandler(((TryFinallyData)operationData).tryStartBci, this.bci, 0, -((TryFinallyData)operationData).handlerId, -1);
                            if (handlerTableIndex2 != -1) {
                                if (((TryFinallyData)operationData).extraTableEntriesStart == -1) {
                                    ((TryFinallyData)operationData).extraTableEntriesStart = handlerTableIndex2;
                                }
                                ((TryFinallyData)operationData).extraTableEntriesEnd = handlerTableIndex2 + 5;
                            }
                            needsRewind = true;
                        }
                        this.doEmitFinallyHandler((TryFinallyData)operationData, i);
                        continue block15;
                    }
                    case 7: {
                        Object handlerTableIndex2 = this.operationStack[i].data;
                        if (!(handlerTableIndex2 instanceof TryCatchData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class TryCatchData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (TryCatchData)handlerTableIndex2;
                        if (this.operationStack[i].childCount != 0 || !this.reachable) continue block15;
                        int handlerTableIndex22 = this.doCreateExceptionHandler(((TryCatchData)operationData).tryStartBci, this.bci, 0, -((TryCatchData)operationData).handlerId, -1);
                        if (handlerTableIndex22 != -1) {
                            if (((TryCatchData)operationData).extraTableEntriesStart == -1) {
                                ((TryCatchData)operationData).extraTableEntriesStart = handlerTableIndex22;
                            }
                            ((TryCatchData)operationData).extraTableEntriesEnd = handlerTableIndex22 + 5;
                        }
                        needsRewind = true;
                        continue block15;
                    }
                    case 21: {
                        Object handlerTableIndex22 = this.operationStack[i].data;
                        if (!(handlerTableIndex22 instanceof SourceSectionData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class SourceSectionData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (SourceSectionData)handlerTableIndex22;
                        this.doEmitSourceInfo(((SourceSectionData)operationData).sourceIndex, ((SourceSectionData)operationData).startBci, this.bci, ((SourceSectionData)operationData).start, ((SourceSectionData)operationData).length);
                        needsRewind = true;
                        continue block15;
                    }
                    case 1: {
                        Object handlerTableIndex22 = this.operationStack[i].data;
                        if (!(handlerTableIndex22 instanceof BlockData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class BlockData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (BlockData)handlerTableIndex22;
                        for (int j = 0; j < ((BlockData)operationData).numLocals; ++j) {
                            this.locals[((BlockData)operationData).locals[j] + 1] = this.bci;
                            this.doEmitInstructionS((short)13, 0, Builder.safeCastShort(this.locals[((BlockData)operationData).locals[j] + 3]));
                            needsRewind = true;
                        }
                        continue block15;
                    }
                }
            }
            if (needsRewind) {
                block17: for (i = declaringOperationSp + 1; i < this.operationSp; ++i) {
                    int finallyHandlerSp;
                    if ((this.operationStack[i].operation == 8 || this.operationStack[i].operation == 9) && (finallyHandlerSp = ((TryFinallyData)this.operationStack[i].data).finallyHandlerSp) != -1) {
                        i = finallyHandlerSp - 1;
                        continue;
                    }
                    switch (this.operationStack[i].operation) {
                        case 22: {
                            Object j = this.operationStack[i].data;
                            if (!(j instanceof TagOperationData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class TagOperationData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            TagOperationData operationData = (TagOperationData)j;
                            operationData.handlerStartBci = this.bci;
                            continue block17;
                        }
                        case 8: 
                        case 9: {
                            if (this.operationStack[i].childCount != 0) continue block17;
                            Object j = this.operationStack[i].data;
                            if (!(j instanceof TryFinallyData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            TryFinallyData operationData = (TryFinallyData)j;
                            operationData.tryStartBci = this.bci;
                            continue block17;
                        }
                        case 7: {
                            if (this.operationStack[i].childCount != 0) continue block17;
                            Object j = this.operationStack[i].data;
                            if (!(j instanceof TryCatchData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class TryCatchData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            TryCatchData operationData = (TryCatchData)j;
                            operationData.tryStartBci = this.bci;
                            continue block17;
                        }
                        case 21: {
                            Object j = this.operationStack[i].data;
                            if (!(j instanceof SourceSectionData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class SourceSectionData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            SourceSectionData operationData = (SourceSectionData)j;
                            operationData.startBci = this.bci;
                            continue block17;
                        }
                        case 1: {
                            Object j = this.operationStack[i].data;
                            if (!(j instanceof BlockData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class BlockData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            BlockData operationData = (BlockData)j;
                            for (int j2 = 0; j2 < operationData.numLocals; ++j2) {
                                int prevTableIndex = operationData.locals[j2];
                                int localIndex = this.locals[prevTableIndex + 2];
                                int frameIndex = this.locals[prevTableIndex + 3];
                                int nameIndex = this.locals[prevTableIndex + 4];
                                int infoIndex = this.locals[prevTableIndex + 5];
                                operationData.locals[j2] = this.doEmitLocal(localIndex, frameIndex, nameIndex, infoIndex);
                            }
                            continue block17;
                        }
                    }
                }
            }
        }

        private void beforeEmitReturn(int parentBci) {
            int i;
            int childBci = parentBci;
            boolean needsRewind = false;
            block15: for (i = this.operationSp - 1; i >= this.rootOperationSp + 1; --i) {
                if (this.operationStack[i].operation == 10) {
                    i = ((FinallyHandlerData)this.operationStack[i].data).finallyOperationSp;
                    continue;
                }
                switch (this.operationStack[i].operation) {
                    case 22: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof TagOperationData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class TagOperationData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (TagOperationData)object;
                        if (!this.reachable) continue block15;
                        this.doEmitInstructionII((short)46, 0, ((TagOperationData)operationData).nodeId, childBci);
                        childBci = this.bci - 10;
                        this.doCreateExceptionHandler(((TagOperationData)operationData).handlerStartBci, this.bci, 1, ((TagOperationData)operationData).nodeId, ((TagOperationData)operationData).startStackHeight);
                        needsRewind = true;
                        continue block15;
                    }
                    case 8: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof TryFinallyData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (TryFinallyData)object;
                        if (this.operationStack[i].childCount != 0) continue block15;
                        if (this.reachable) {
                            int handlerTableIndex = this.doCreateExceptionHandler(((TryFinallyData)operationData).tryStartBci, this.bci, 0, -((TryFinallyData)operationData).handlerId, -1);
                            if (handlerTableIndex != -1) {
                                if (((TryFinallyData)operationData).extraTableEntriesStart == -1) {
                                    ((TryFinallyData)operationData).extraTableEntriesStart = handlerTableIndex;
                                }
                                ((TryFinallyData)operationData).extraTableEntriesEnd = handlerTableIndex + 5;
                            }
                            needsRewind = true;
                        }
                        this.doEmitFinallyHandler((TryFinallyData)operationData, i);
                        continue block15;
                    }
                    case 9: {
                        Object handlerTableIndex = this.operationStack[i].data;
                        if (!(handlerTableIndex instanceof TryFinallyData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (TryFinallyData)handlerTableIndex;
                        if (this.operationStack[i].childCount != 0) continue block15;
                        if (this.reachable) {
                            int handlerTableIndex2 = this.doCreateExceptionHandler(((TryFinallyData)operationData).tryStartBci, this.bci, 0, -((TryFinallyData)operationData).handlerId, -1);
                            if (handlerTableIndex2 != -1) {
                                if (((TryFinallyData)operationData).extraTableEntriesStart == -1) {
                                    ((TryFinallyData)operationData).extraTableEntriesStart = handlerTableIndex2;
                                }
                                ((TryFinallyData)operationData).extraTableEntriesEnd = handlerTableIndex2 + 5;
                            }
                            needsRewind = true;
                        }
                        this.doEmitFinallyHandler((TryFinallyData)operationData, i);
                        continue block15;
                    }
                    case 7: {
                        Object handlerTableIndex2 = this.operationStack[i].data;
                        if (!(handlerTableIndex2 instanceof TryCatchData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class TryCatchData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (TryCatchData)handlerTableIndex2;
                        if (this.operationStack[i].childCount != 0 || !this.reachable) continue block15;
                        int handlerTableIndex22 = this.doCreateExceptionHandler(((TryCatchData)operationData).tryStartBci, this.bci, 0, -((TryCatchData)operationData).handlerId, -1);
                        if (handlerTableIndex22 != -1) {
                            if (((TryCatchData)operationData).extraTableEntriesStart == -1) {
                                ((TryCatchData)operationData).extraTableEntriesStart = handlerTableIndex22;
                            }
                            ((TryCatchData)operationData).extraTableEntriesEnd = handlerTableIndex22 + 5;
                        }
                        needsRewind = true;
                        continue block15;
                    }
                    case 21: {
                        Object handlerTableIndex22 = this.operationStack[i].data;
                        if (!(handlerTableIndex22 instanceof SourceSectionData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class SourceSectionData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (SourceSectionData)handlerTableIndex22;
                        this.doEmitSourceInfo(((SourceSectionData)operationData).sourceIndex, ((SourceSectionData)operationData).startBci, this.bci, ((SourceSectionData)operationData).start, ((SourceSectionData)operationData).length);
                        needsRewind = true;
                        continue block15;
                    }
                    case 1: {
                        Object handlerTableIndex22 = this.operationStack[i].data;
                        if (!(handlerTableIndex22 instanceof BlockData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class BlockData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        Object operationData = (BlockData)handlerTableIndex22;
                        for (int j = 0; j < ((BlockData)operationData).numLocals; ++j) {
                            this.locals[((BlockData)operationData).locals[j] + 1] = this.bci;
                            needsRewind = true;
                        }
                        continue block15;
                    }
                }
            }
            if (needsRewind) {
                block17: for (i = this.rootOperationSp + 1; i < this.operationSp; ++i) {
                    int finallyHandlerSp;
                    if ((this.operationStack[i].operation == 8 || this.operationStack[i].operation == 9) && (finallyHandlerSp = ((TryFinallyData)this.operationStack[i].data).finallyHandlerSp) != -1) {
                        i = finallyHandlerSp - 1;
                        continue;
                    }
                    switch (this.operationStack[i].operation) {
                        case 22: {
                            Object j = this.operationStack[i].data;
                            if (!(j instanceof TagOperationData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class TagOperationData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            TagOperationData operationData = (TagOperationData)j;
                            operationData.handlerStartBci = this.bci;
                            continue block17;
                        }
                        case 8: 
                        case 9: {
                            if (this.operationStack[i].childCount != 0) continue block17;
                            Object j = this.operationStack[i].data;
                            if (!(j instanceof TryFinallyData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class TryFinallyData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            TryFinallyData operationData = (TryFinallyData)j;
                            operationData.tryStartBci = this.bci;
                            continue block17;
                        }
                        case 7: {
                            if (this.operationStack[i].childCount != 0) continue block17;
                            Object j = this.operationStack[i].data;
                            if (!(j instanceof TryCatchData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class TryCatchData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            TryCatchData operationData = (TryCatchData)j;
                            operationData.tryStartBci = this.bci;
                            continue block17;
                        }
                        case 21: {
                            Object j = this.operationStack[i].data;
                            if (!(j instanceof SourceSectionData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class SourceSectionData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            SourceSectionData operationData = (SourceSectionData)j;
                            operationData.startBci = this.bci;
                            continue block17;
                        }
                        case 1: {
                            Object j = this.operationStack[i].data;
                            if (!(j instanceof BlockData)) {
                                throw SLBytecodeRootNodeGen.assertionFailed("Data class BlockData expected, but was " + String.valueOf(this.operationStack[i].data));
                            }
                            BlockData operationData = (BlockData)j;
                            for (int j2 = 0; j2 < operationData.numLocals; ++j2) {
                                int prevTableIndex = operationData.locals[j2];
                                int endBci = this.locals[prevTableIndex + 1];
                                if (endBci == this.bci) {
                                    this.locals[prevTableIndex + 1] = -1;
                                    continue;
                                }
                                int localIndex = this.locals[prevTableIndex + 2];
                                int frameIndex = this.locals[prevTableIndex + 3];
                                int nameIndex = this.locals[prevTableIndex + 4];
                                int infoIndex = this.locals[prevTableIndex + 5];
                                operationData.locals[j2] = this.doEmitLocal(localIndex, frameIndex, nameIndex, infoIndex);
                            }
                            continue block17;
                        }
                    }
                }
            }
        }

        private void patchHandlerTable(int tableStart, int tableEnd, int handlerId, int handlerBci, int handlerSp) {
            for (int i = tableStart; i < tableEnd; i += 5) {
                if (this.handlerTable[i + 2] != 0 || this.handlerTable[i + 3] != -handlerId) continue;
                this.handlerTable[i + 3] = handlerBci;
                this.handlerTable[i + 4] = handlerSp;
            }
        }

        private void doEmitRoot() {
            if (!this.parseSources) {
                return;
            }
            for (int i = this.operationSp - 1; i >= 0; --i) {
                if (this.operationStack[i].operation == 10) {
                    i = ((FinallyHandlerData)this.operationStack[i].data).finallyOperationSp;
                    continue;
                }
                switch (this.operationStack[i].operation) {
                    case 21: {
                        Object object = this.operationStack[i].data;
                        if (!(object instanceof SourceSectionData)) {
                            throw SLBytecodeRootNodeGen.assertionFailed("Data class SourceSectionData expected, but was " + String.valueOf(this.operationStack[i].data));
                        }
                        SourceSectionData operationData = (SourceSectionData)object;
                        this.doEmitSourceInfo(operationData.sourceIndex, 0, this.bci, operationData.start, operationData.length);
                    }
                }
            }
        }

        private int allocateNode() {
            if (!this.reachable) {
                return -1;
            }
            return Builder.checkOverflowInt(this.numNodes++, "Node counter");
        }

        private short allocateBytecodeLocal() {
            return Builder.checkOverflowShort((short)this.numLocals++, "Number of locals");
        }

        private int allocateBranchProfile() {
            if (!this.reachable) {
                return -1;
            }
            return Builder.checkOverflowInt(this.numConditionalBranches++, "Number of branch profiles");
        }

        private ScopeData getCurrentScope() {
            for (int i = this.operationSp - 1; i >= this.rootOperationSp; --i) {
                if (this.operationStack[i].operation == 10) {
                    i = ((FinallyHandlerData)this.operationStack[i].data).finallyOperationSp;
                    continue;
                }
                Object object = this.operationStack[i].data;
                if (!(object instanceof ScopeData)) continue;
                ScopeData e = (ScopeData)object;
                return e;
            }
            throw this.failState("Invalid scope for local variable.");
        }

        private int doEmitLocal(int localIndex, int frameIndex, Object name, Object info) {
            int nameIndex = -1;
            if (name != null) {
                nameIndex = this.constantPool.addConstant(name);
            }
            int infoIndex = -1;
            if (info != null) {
                infoIndex = this.constantPool.addConstant(info);
            }
            return this.doEmitLocal(localIndex, frameIndex, nameIndex, infoIndex);
        }

        private int doEmitLocal(int localIndex, int frameIndex, int nameIndex, int infoIndex) {
            int tableIndex = this.allocateLocalsTableEntry();
            assert (frameIndex - 1 >= 0);
            this.locals[tableIndex + 0] = this.bci;
            this.locals[tableIndex + 1] = -1;
            this.locals[tableIndex + 2] = localIndex;
            this.locals[tableIndex + 3] = frameIndex;
            this.locals[tableIndex + 4] = nameIndex;
            this.locals[tableIndex + 5] = infoIndex;
            return tableIndex;
        }

        private int allocateLocalsTableEntry() {
            int result = this.localsTableIndex;
            if (this.locals == null) {
                assert (result == 0);
                this.locals = new int[48];
            } else if (result + 6 > this.locals.length) {
                this.locals = Arrays.copyOf(this.locals, Math.max(result + 6, this.locals.length * 2));
            }
            this.localsTableIndex += 6;
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void serialize(DataOutput buffer, BytecodeSerializer callback, List<SLBytecodeRootNode> existingNodes) throws IOException {
            this.serialization = new SerializationState(buffer, callback);
            try {
                int i;
                this.nodes.getParserImpl().parse((BytecodeBuilder)this);
                List<SLBytecodeRootNode> nodesToSerialize = existingNodes != null ? existingNodes : this.serialization.builtNodes;
                int[][] nodeFields = new int[nodesToSerialize.size()][];
                for (i = 0; i < nodeFields.length; ++i) {
                    SLBytecodeRootNode node = nodesToSerialize.get(i);
                    nodeFields[i] = new int[2];
                    int[] fields = nodeFields[i];
                    fields[0] = this.serialization.serializeObject(node.tsName);
                    fields[1] = this.serialization.serializeObject(node.parameterCount);
                }
                this.serialization.buffer.writeShort(-8);
                for (i = 0; i < nodeFields.length; ++i) {
                    int[] fields = nodeFields[i];
                    this.serialization.buffer.writeInt(fields[0]);
                    this.serialization.buffer.writeInt(fields[1]);
                }
            }
            finally {
                this.serialization = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private short serializeFinallyGenerator(Runnable finallyGenerator) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SerializationState outerSerialization = this.serialization;
            try {
                this.serialization = new SerializationState((DataOutput)new DataOutputStream(baos), this.serialization);
                finallyGenerator.run();
                this.serialization.buffer.writeShort(-7);
            }
            finally {
                this.serialization = outerSerialization;
            }
            byte[] bytes = baos.toByteArray();
            this.serialization.buffer.writeShort(-6);
            this.serialization.buffer.writeInt(bytes.length);
            this.serialization.buffer.write(bytes);
            return Builder.safeCastShort(this.serialization.finallyGeneratorCount++);
        }

        private void deserialize(Supplier<DataInput> bufferSupplier, BytecodeDeserializer callback, DeserializationState outerContext) {
            try {
                short code;
                DeserializationState context = new DeserializationState(outerContext);
                DataInput buffer = bufferSupplier.get();
                block81: while (true) {
                    code = buffer.readShort();
                    switch (code) {
                        case -2: {
                            context.labels.add(this.createLabel());
                            continue block81;
                        }
                        case -3: {
                            int nameId = buffer.readInt();
                            Object name = null;
                            if (nameId != -1) {
                                name = context.consts.get(nameId);
                            }
                            int infoId = buffer.readInt();
                            Object info = null;
                            if (infoId != -1) {
                                info = context.consts.get(infoId);
                            }
                            context.locals.add(this.createLocal(name, info));
                            continue block81;
                        }
                        case -5: {
                            context.consts.add(null);
                            continue block81;
                        }
                        case -4: {
                            context.consts.add(Objects.requireNonNull(callback.deserialize((BytecodeDeserializer.DeserializerContext)context, buffer)));
                            continue block81;
                        }
                        case -6: {
                            byte[] finallyGeneratorBytes = new byte[buffer.readInt()];
                            buffer.readFully(finallyGeneratorBytes);
                            context.finallyGenerators.add(() -> this.deserialize(() -> SerializationUtils.createDataInput((ByteBuffer)ByteBuffer.wrap(finallyGeneratorBytes)), callback, context));
                            continue block81;
                        }
                        case -7: {
                            return;
                        }
                        case -8: {
                            for (int i = 0; i < this.builtNodes.size(); ++i) {
                                SLBytecodeRootNodeGen node = this.builtNodes.get(i);
                                node.tsName = (TruffleString)context.consts.get(buffer.readInt());
                                node.parameterCount = (Integer)context.consts.get(buffer.readInt());
                            }
                            return;
                        }
                        case 2: {
                            this.beginBlock();
                            continue block81;
                        }
                        case 3: {
                            this.endBlock();
                            continue block81;
                        }
                        case 4: {
                            context.builtNodes.add(null);
                            this.beginRoot();
                            continue block81;
                        }
                        case 5: {
                            SLBytecodeRootNodeGen node = (SLBytecodeRootNodeGen)this.endRoot();
                            int serializedContextDepth = buffer.readInt();
                            if (context.depth != serializedContextDepth) {
                                throw new AssertionError((Object)("Invalid context depth. Expected " + context.depth + " but got " + serializedContextDepth));
                            }
                            context.builtNodes.set(buffer.readInt(), node);
                            continue block81;
                        }
                        case 6: {
                            this.beginIfThen();
                            continue block81;
                        }
                        case 7: {
                            this.endIfThen();
                            continue block81;
                        }
                        case 8: {
                            this.beginIfThenElse();
                            continue block81;
                        }
                        case 9: {
                            this.endIfThenElse();
                            continue block81;
                        }
                        case 10: {
                            this.beginConditional();
                            continue block81;
                        }
                        case 11: {
                            this.endConditional();
                            continue block81;
                        }
                        case 12: {
                            this.beginWhile();
                            continue block81;
                        }
                        case 13: {
                            this.endWhile();
                            continue block81;
                        }
                        case 14: {
                            this.beginTryCatch();
                            continue block81;
                        }
                        case 15: {
                            this.endTryCatch();
                            continue block81;
                        }
                        case 16: {
                            Runnable finallyGenerator = context.getContext((int)buffer.readShort()).finallyGenerators.get(buffer.readShort());
                            this.beginTryFinally(finallyGenerator);
                            continue block81;
                        }
                        case 17: {
                            this.endTryFinally();
                            continue block81;
                        }
                        case 18: {
                            Runnable otherwiseGenerator = context.getContext((int)buffer.readShort()).finallyGenerators.get(buffer.readShort());
                            this.beginTryCatchOtherwise(otherwiseGenerator);
                            continue block81;
                        }
                        case 19: {
                            this.endTryCatchOtherwise();
                            continue block81;
                        }
                        case 22: {
                            BytecodeLabel label = context.getContext((int)buffer.readShort()).labels.get(buffer.readShort());
                            this.emitLabel(label);
                            continue block81;
                        }
                        case 24: {
                            BytecodeLabel label = context.getContext((int)buffer.readShort()).labels.get(buffer.readShort());
                            this.emitBranch(label);
                            continue block81;
                        }
                        case 26: {
                            Object constant = context.consts.get(buffer.readInt());
                            this.emitLoadConstant(constant);
                            continue block81;
                        }
                        case 28: {
                            this.emitLoadNull();
                            continue block81;
                        }
                        case 30: {
                            int index = buffer.readInt();
                            this.emitLoadArgument(index);
                            continue block81;
                        }
                        case 32: {
                            this.emitLoadException();
                            continue block81;
                        }
                        case 34: {
                            BytecodeLocal local = context.getContext((int)buffer.readShort()).locals.get(buffer.readShort());
                            this.emitLoadLocal(local);
                            continue block81;
                        }
                        case 36: {
                            BytecodeLocal local = context.getContext((int)buffer.readShort()).locals.get(buffer.readShort());
                            this.beginStoreLocal(local);
                            continue block81;
                        }
                        case 37: {
                            this.endStoreLocal();
                            continue block81;
                        }
                        case 38: {
                            this.beginReturn();
                            continue block81;
                        }
                        case 39: {
                            this.endReturn();
                            continue block81;
                        }
                        case 40: {
                            Source source = (Source)context.consts.get(buffer.readInt());
                            this.beginSource(source);
                            continue block81;
                        }
                        case 41: {
                            this.endSource();
                            continue block81;
                        }
                        case 42: {
                            int index = buffer.readInt();
                            int length = buffer.readInt();
                            this.beginSourceSection(index, length);
                            continue block81;
                        }
                        case 43: {
                            this.endSourceSection();
                            continue block81;
                        }
                        case 44: {
                            Class[] newTags = TAG_MASK_TO_TAGS.computeIfAbsent(buffer.readInt(), v -> SLBytecodeRootNodeGen.mapTagMaskToTagsArray(v));
                            this.beginTag(newTags);
                            continue block81;
                        }
                        case 45: {
                            Class[] newTags = TAG_MASK_TO_TAGS.computeIfAbsent(buffer.readInt(), v -> SLBytecodeRootNodeGen.mapTagMaskToTagsArray(v));
                            this.endTag(newTags);
                            continue block81;
                        }
                        case 46: {
                            this.emitSLAlwaysHalt();
                            continue block81;
                        }
                        case 48: {
                            int indexValue = (Integer)context.consts.get(buffer.readInt());
                            this.emitSLLoadArgument(indexValue);
                            continue block81;
                        }
                        case 50: {
                            NodeFactory factoryValue = (NodeFactory)context.consts.get(buffer.readInt());
                            int argumentCountValue = (Integer)context.consts.get(buffer.readInt());
                            this.emitBuiltin(factoryValue, argumentCountValue);
                            continue block81;
                        }
                        case 52: {
                            this.beginSLInvoke();
                            continue block81;
                        }
                        case 53: {
                            this.endSLInvoke();
                            continue block81;
                        }
                        case 54: {
                            this.beginSLAdd();
                            continue block81;
                        }
                        case 55: {
                            this.endSLAdd();
                            continue block81;
                        }
                        case 56: {
                            this.beginSLDiv();
                            continue block81;
                        }
                        case 57: {
                            this.endSLDiv();
                            continue block81;
                        }
                        case 58: {
                            this.beginSLEqual();
                            continue block81;
                        }
                        case 59: {
                            this.endSLEqual();
                            continue block81;
                        }
                        case 60: {
                            this.beginSLLessOrEqual();
                            continue block81;
                        }
                        case 61: {
                            this.endSLLessOrEqual();
                            continue block81;
                        }
                        case 62: {
                            this.beginSLLessThan();
                            continue block81;
                        }
                        case 63: {
                            this.endSLLessThan();
                            continue block81;
                        }
                        case 64: {
                            this.beginSLLogicalNot();
                            continue block81;
                        }
                        case 65: {
                            this.endSLLogicalNot();
                            continue block81;
                        }
                        case 66: {
                            this.beginSLMul();
                            continue block81;
                        }
                        case 67: {
                            this.endSLMul();
                            continue block81;
                        }
                        case 68: {
                            this.beginSLReadProperty();
                            continue block81;
                        }
                        case 69: {
                            this.endSLReadProperty();
                            continue block81;
                        }
                        case 70: {
                            this.beginSLSub();
                            continue block81;
                        }
                        case 71: {
                            this.endSLSub();
                            continue block81;
                        }
                        case 72: {
                            this.beginSLWriteProperty();
                            continue block81;
                        }
                        case 73: {
                            this.endSLWriteProperty();
                            continue block81;
                        }
                        case 74: {
                            this.beginSLUnbox();
                            continue block81;
                        }
                        case 75: {
                            this.endSLUnbox();
                            continue block81;
                        }
                        case 76: {
                            this.beginSLFunctionLiteral();
                            continue block81;
                        }
                        case 77: {
                            this.endSLFunctionLiteral();
                            continue block81;
                        }
                        case 78: {
                            this.beginSLToBoolean();
                            continue block81;
                        }
                        case 79: {
                            this.endSLToBoolean();
                            continue block81;
                        }
                        case 80: {
                            this.beginSLAnd();
                            continue block81;
                        }
                        case 81: {
                            this.endSLAnd();
                            continue block81;
                        }
                        case 82: {
                            this.beginSLOr();
                            continue block81;
                        }
                        case 83: {
                            this.endSLOr();
                            continue block81;
                        }
                    }
                    break;
                }
                throw new AssertionError((Object)("Unknown operation code " + code));
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }

        public String toString() {
            int i;
            StringBuilder b = new StringBuilder();
            b.append(SLBytecodeRootNodeGen.class.getSimpleName());
            b.append('.');
            b.append(Builder.class.getSimpleName());
            b.append("[");
            b.append("at=");
            for (i = 0; i < this.operationSp; ++i) {
                b.append("(");
                b.append(this.operationStack[i].toString(this));
            }
            for (i = 0; i < this.operationSp; ++i) {
                b.append(")");
            }
            b.append(", mode=");
            if (this.serialization != null) {
                b.append("serializing");
            } else if (this.reparseReason != null) {
                b.append("reparsing");
            } else {
                b.append("default");
            }
            b.append(", bytecodeIndex=").append(this.bci);
            b.append(", stackPointer=").append(this.currentStackHeight);
            b.append(", bytecodes=").append(this.parseBytecodes);
            b.append(", sources=").append(this.parseSources);
            b.append(", tags=");
            String sepTag = "";
            if ((this.tags & CLASS_TO_TAG_MASK.get(StandardTags.CallTag.class)) != 0) {
                b.append(sepTag);
                b.append(Tag.getIdentifier(StandardTags.CallTag.class));
                sepTag = ",";
            }
            if ((this.tags & CLASS_TO_TAG_MASK.get(StandardTags.StatementTag.class)) != 0) {
                b.append(sepTag);
                b.append(Tag.getIdentifier(StandardTags.StatementTag.class));
                sepTag = ",";
            }
            if ((this.tags & CLASS_TO_TAG_MASK.get(StandardTags.RootTag.class)) != 0) {
                b.append(sepTag);
                b.append(Tag.getIdentifier(StandardTags.RootTag.class));
                sepTag = ",";
            }
            if ((this.tags & CLASS_TO_TAG_MASK.get(StandardTags.RootBodyTag.class)) != 0) {
                b.append(sepTag);
                b.append(Tag.getIdentifier(StandardTags.RootBodyTag.class));
                sepTag = ",";
            }
            if ((this.tags & CLASS_TO_TAG_MASK.get(StandardTags.ExpressionTag.class)) != 0) {
                b.append(sepTag);
                b.append(Tag.getIdentifier(StandardTags.ExpressionTag.class));
                sepTag = ",";
            }
            if ((this.tags & CLASS_TO_TAG_MASK.get(DebuggerTags.AlwaysHalt.class)) != 0) {
                b.append(sepTag);
                b.append(Tag.getIdentifier(DebuggerTags.AlwaysHalt.class));
                sepTag = ",";
            }
            if ((this.tags & CLASS_TO_TAG_MASK.get(StandardTags.ReadVariableTag.class)) != 0) {
                b.append(sepTag);
                b.append(Tag.getIdentifier(StandardTags.ReadVariableTag.class));
                sepTag = ",";
            }
            if ((this.tags & CLASS_TO_TAG_MASK.get(StandardTags.WriteVariableTag.class)) != 0) {
                b.append(sepTag);
                b.append(Tag.getIdentifier(StandardTags.WriteVariableTag.class));
                sepTag = ",";
            }
            b.append("]");
            return b.toString();
        }

        private RuntimeException failState(String message) {
            throw new IllegalStateException("Invalid builder usage: " + message + " Operation stack: " + this.dumpAt());
        }

        private RuntimeException failArgument(String message) {
            throw new IllegalArgumentException("Invalid builder operation argument: " + message + " Operation stack: " + this.dumpAt());
        }

        private String dumpAt() {
            try {
                int i;
                StringBuilder b = new StringBuilder();
                for (i = 0; i < this.operationSp; ++i) {
                    b.append("(");
                    b.append(this.operationStack[i].toString(this));
                }
                for (i = 0; i < this.operationSp; ++i) {
                    b.append(")");
                }
                return b.toString();
            }
            catch (Exception e) {
                return "<invalid-location>";
            }
        }

        private boolean doEmitInstruction(short instruction, int stackEffect) {
            if (stackEffect != 0) {
                this.currentStackHeight += stackEffect;
                assert (this.currentStackHeight >= 0);
            }
            if (stackEffect > 0) {
                this.updateMaxStackHeight(this.currentStackHeight);
            }
            if (!this.reachable) {
                return false;
            }
            int newBci = Builder.checkBci(this.bci + 2);
            if (newBci > this.bc.length) {
                this.ensureBytecodeCapacity(newBci);
            }
            BYTES.putShort(this.bc, this.bci + 0, instruction);
            this.bci = newBci;
            return true;
        }

        private boolean doEmitInstructionS(short instruction, int stackEffect, short data0) {
            if (stackEffect != 0) {
                this.currentStackHeight += stackEffect;
                assert (this.currentStackHeight >= 0);
            }
            if (stackEffect > 0) {
                this.updateMaxStackHeight(this.currentStackHeight);
            }
            if (!this.reachable) {
                return false;
            }
            int newBci = Builder.checkBci(this.bci + 4);
            if (newBci > this.bc.length) {
                this.ensureBytecodeCapacity(newBci);
            }
            BYTES.putShort(this.bc, this.bci + 0, instruction);
            BYTES.putShort(this.bc, this.bci + 2, data0);
            this.bci = newBci;
            return true;
        }

        private boolean doEmitInstructionI(short instruction, int stackEffect, int data0) {
            if (stackEffect != 0) {
                this.currentStackHeight += stackEffect;
                assert (this.currentStackHeight >= 0);
            }
            if (stackEffect > 0) {
                this.updateMaxStackHeight(this.currentStackHeight);
            }
            if (!this.reachable) {
                return false;
            }
            int newBci = Builder.checkBci(this.bci + 6);
            if (newBci > this.bc.length) {
                this.ensureBytecodeCapacity(newBci);
            }
            BYTES.putShort(this.bc, this.bci + 0, instruction);
            BYTES.putInt(this.bc, this.bci + 2, data0);
            this.bci = newBci;
            return true;
        }

        private boolean doEmitInstructionSS(short instruction, int stackEffect, short data0, short data1) {
            if (stackEffect != 0) {
                this.currentStackHeight += stackEffect;
                assert (this.currentStackHeight >= 0);
            }
            if (stackEffect > 0) {
                this.updateMaxStackHeight(this.currentStackHeight);
            }
            if (!this.reachable) {
                return false;
            }
            int newBci = Builder.checkBci(this.bci + 6);
            if (newBci > this.bc.length) {
                this.ensureBytecodeCapacity(newBci);
            }
            BYTES.putShort(this.bc, this.bci + 0, instruction);
            BYTES.putShort(this.bc, this.bci + 2, data0);
            BYTES.putShort(this.bc, this.bci + 4, data1);
            this.bci = newBci;
            return true;
        }

        private boolean doEmitInstructionII(short instruction, int stackEffect, int data0, int data1) {
            if (stackEffect != 0) {
                this.currentStackHeight += stackEffect;
                assert (this.currentStackHeight >= 0);
            }
            if (stackEffect > 0) {
                this.updateMaxStackHeight(this.currentStackHeight);
            }
            if (!this.reachable) {
                return false;
            }
            int newBci = Builder.checkBci(this.bci + 10);
            if (newBci > this.bc.length) {
                this.ensureBytecodeCapacity(newBci);
            }
            BYTES.putShort(this.bc, this.bci + 0, instruction);
            BYTES.putInt(this.bc, this.bci + 2, data0);
            BYTES.putInt(this.bc, this.bci + 6, data1);
            this.bci = newBci;
            return true;
        }

        private boolean doEmitInstructionSSI(short instruction, int stackEffect, short data0, short data1, int data2) {
            if (stackEffect != 0) {
                this.currentStackHeight += stackEffect;
                assert (this.currentStackHeight >= 0);
            }
            if (stackEffect > 0) {
                this.updateMaxStackHeight(this.currentStackHeight);
            }
            if (!this.reachable) {
                return false;
            }
            int newBci = Builder.checkBci(this.bci + 10);
            if (newBci > this.bc.length) {
                this.ensureBytecodeCapacity(newBci);
            }
            BYTES.putShort(this.bc, this.bci + 0, instruction);
            BYTES.putShort(this.bc, this.bci + 2, data0);
            BYTES.putShort(this.bc, this.bci + 4, data1);
            BYTES.putInt(this.bc, this.bci + 6, data2);
            this.bci = newBci;
            return true;
        }

        private boolean doEmitInstructionIII(short instruction, int stackEffect, int data0, int data1, int data2) {
            if (stackEffect != 0) {
                this.currentStackHeight += stackEffect;
                assert (this.currentStackHeight >= 0);
            }
            if (stackEffect > 0) {
                this.updateMaxStackHeight(this.currentStackHeight);
            }
            if (!this.reachable) {
                return false;
            }
            int newBci = Builder.checkBci(this.bci + 14);
            if (newBci > this.bc.length) {
                this.ensureBytecodeCapacity(newBci);
            }
            BYTES.putShort(this.bc, this.bci + 0, instruction);
            BYTES.putInt(this.bc, this.bci + 2, data0);
            BYTES.putInt(this.bc, this.bci + 6, data1);
            BYTES.putInt(this.bc, this.bci + 10, data2);
            this.bci = newBci;
            return true;
        }

        private static short safeCastShort(int num) {
            if (Short.MIN_VALUE <= num && num <= Short.MAX_VALUE) {
                return (short)num;
            }
            throw BytecodeEncodingException.create((String)("Value " + num + " cannot be encoded as a short."));
        }

        private static short checkOverflowShort(short num, String valueName) {
            if (num < 0) {
                throw BytecodeEncodingException.create((String)(valueName + " overflowed."));
            }
            return num;
        }

        private static int checkOverflowInt(int num, String valueName) {
            if (num < 0) {
                throw BytecodeEncodingException.create((String)(valueName + " overflowed."));
            }
            return num;
        }

        private static int checkBci(int newBci) {
            return Builder.checkOverflowInt(newBci, "Bytecode index");
        }

        private static class OperationStackEntry {
            private final int operation;
            private final Object data;
            private final int sequenceNumber;
            private int childCount = 0;
            private ArrayList<BytecodeLabel> declaredLabels = null;

            OperationStackEntry(int operation, Object data, int sequenceNumber) {
                this.operation = operation;
                this.data = data;
                this.sequenceNumber = sequenceNumber;
            }

            public void addDeclaredLabel(BytecodeLabel label) {
                if (this.declaredLabels == null) {
                    this.declaredLabels = new ArrayList(8);
                }
                this.declaredLabels.add(label);
            }

            public String toString() {
                return "(" + this.toString(null) + ")";
            }

            private String toString(Builder builder) {
                StringBuilder b = new StringBuilder();
                b.append(OPERATION_NAMES[this.operation]);
                switch (this.operation) {
                    case 1: {
                        BlockData operationData = (BlockData)this.data;
                        if (operationData.numLocals <= 0) break;
                        b.append(" locals=");
                        b.append(operationData.numLocals);
                        break;
                    }
                    case 2: {
                        RootData operationData = (RootData)this.data;
                        if (operationData.numLocals <= 0) break;
                        b.append(" locals=");
                        b.append(operationData.numLocals);
                        break;
                    }
                    case 18: {
                        b.append(" ");
                        StoreLocalData operationData = (StoreLocalData)this.data;
                        b.append(operationData.local.frameIndex);
                        break;
                    }
                    case 20: {
                        b.append(" ");
                        SourceData operationData = (SourceData)this.data;
                        b.append(operationData.sourceIndex);
                        if (builder == null) break;
                        b.append(":");
                        b.append(builder.sources.get(operationData.sourceIndex).getName());
                        break;
                    }
                    case 21: {
                        b.append(" ");
                        SourceSectionData operationData = (SourceSectionData)this.data;
                        b.append(operationData.start);
                        b.append(":");
                        b.append(operationData.length);
                        break;
                    }
                    case 22: {
                        b.append(" ");
                        TagOperationData operationData = (TagOperationData)this.data;
                        b.append((Object)operationData.node);
                    }
                }
                return b.toString();
            }
        }

        private static class SerializationState
        implements BytecodeSerializer.SerializerContext {
            private static final short CODE_$CREATE_LABEL = -2;
            private static final short CODE_$CREATE_LOCAL = -3;
            private static final short CODE_$CREATE_OBJECT = -4;
            private static final short CODE_$CREATE_NULL = -5;
            private static final short CODE_$CREATE_FINALLY_GENERATOR = -6;
            private static final short CODE_$END_FINALLY_GENERATOR = -7;
            private static final short CODE_$END = -8;
            private static final short CODE_BEGIN_BLOCK = 2;
            private static final short CODE_END_BLOCK = 3;
            private static final short CODE_BEGIN_ROOT = 4;
            private static final short CODE_END_ROOT = 5;
            private static final short CODE_BEGIN_IF_THEN = 6;
            private static final short CODE_END_IF_THEN = 7;
            private static final short CODE_BEGIN_IF_THEN_ELSE = 8;
            private static final short CODE_END_IF_THEN_ELSE = 9;
            private static final short CODE_BEGIN_CONDITIONAL = 10;
            private static final short CODE_END_CONDITIONAL = 11;
            private static final short CODE_BEGIN_WHILE = 12;
            private static final short CODE_END_WHILE = 13;
            private static final short CODE_BEGIN_TRY_CATCH = 14;
            private static final short CODE_END_TRY_CATCH = 15;
            private static final short CODE_BEGIN_TRY_FINALLY = 16;
            private static final short CODE_END_TRY_FINALLY = 17;
            private static final short CODE_BEGIN_TRY_CATCH_OTHERWISE = 18;
            private static final short CODE_END_TRY_CATCH_OTHERWISE = 19;
            private static final short CODE_EMIT_LABEL = 22;
            private static final short CODE_EMIT_BRANCH = 24;
            private static final short CODE_EMIT_LOAD_CONSTANT = 26;
            private static final short CODE_EMIT_LOAD_NULL = 28;
            private static final short CODE_EMIT_LOAD_ARGUMENT = 30;
            private static final short CODE_EMIT_LOAD_EXCEPTION = 32;
            private static final short CODE_EMIT_LOAD_LOCAL = 34;
            private static final short CODE_BEGIN_STORE_LOCAL = 36;
            private static final short CODE_END_STORE_LOCAL = 37;
            private static final short CODE_BEGIN_RETURN = 38;
            private static final short CODE_END_RETURN = 39;
            private static final short CODE_BEGIN_SOURCE = 40;
            private static final short CODE_END_SOURCE = 41;
            private static final short CODE_BEGIN_SOURCE_SECTION = 42;
            private static final short CODE_END_SOURCE_SECTION = 43;
            private static final short CODE_BEGIN_TAG = 44;
            private static final short CODE_END_TAG = 45;
            private static final short CODE_EMIT_SL_ALWAYS_HALT = 46;
            private static final short CODE_EMIT_SL_LOAD_ARGUMENT = 48;
            private static final short CODE_EMIT_BUILTIN = 50;
            private static final short CODE_BEGIN_SL_INVOKE = 52;
            private static final short CODE_END_SL_INVOKE = 53;
            private static final short CODE_BEGIN_SL_ADD = 54;
            private static final short CODE_END_SL_ADD = 55;
            private static final short CODE_BEGIN_SL_DIV = 56;
            private static final short CODE_END_SL_DIV = 57;
            private static final short CODE_BEGIN_SL_EQUAL = 58;
            private static final short CODE_END_SL_EQUAL = 59;
            private static final short CODE_BEGIN_SL_LESS_OR_EQUAL = 60;
            private static final short CODE_END_SL_LESS_OR_EQUAL = 61;
            private static final short CODE_BEGIN_SL_LESS_THAN = 62;
            private static final short CODE_END_SL_LESS_THAN = 63;
            private static final short CODE_BEGIN_SL_LOGICAL_NOT = 64;
            private static final short CODE_END_SL_LOGICAL_NOT = 65;
            private static final short CODE_BEGIN_SL_MUL = 66;
            private static final short CODE_END_SL_MUL = 67;
            private static final short CODE_BEGIN_SL_READ_PROPERTY = 68;
            private static final short CODE_END_SL_READ_PROPERTY = 69;
            private static final short CODE_BEGIN_SL_SUB = 70;
            private static final short CODE_END_SL_SUB = 71;
            private static final short CODE_BEGIN_SL_WRITE_PROPERTY = 72;
            private static final short CODE_END_SL_WRITE_PROPERTY = 73;
            private static final short CODE_BEGIN_SL_UNBOX = 74;
            private static final short CODE_END_SL_UNBOX = 75;
            private static final short CODE_BEGIN_SL_FUNCTION_LITERAL = 76;
            private static final short CODE_END_SL_FUNCTION_LITERAL = 77;
            private static final short CODE_BEGIN_SL_TO_BOOLEAN = 78;
            private static final short CODE_END_SL_TO_BOOLEAN = 79;
            private static final short CODE_BEGIN_SL_AND = 80;
            private static final short CODE_END_SL_AND = 81;
            private static final short CODE_BEGIN_SL_OR = 82;
            private static final short CODE_END_SL_OR = 83;
            private final DataOutput buffer;
            private final BytecodeSerializer callback;
            private final SerializationState outer;
            private final int depth;
            private final HashMap<Object, Integer> objects = new HashMap();
            private final ArrayList<SLBytecodeRootNode> builtNodes = new ArrayList();
            private final ArrayDeque<SerializationRootNode> rootStack = new ArrayDeque();
            private int labelCount;
            private int localCount;
            private short rootCount;
            private int finallyGeneratorCount;

            private SerializationState(DataOutput buffer, BytecodeSerializer callback) {
                this.buffer = buffer;
                this.callback = callback;
                this.outer = null;
                this.depth = 0;
            }

            private SerializationState(DataOutput buffer, SerializationState outer) {
                this.buffer = buffer;
                this.callback = outer.callback;
                this.outer = outer;
                this.depth = Builder.safeCastShort(outer.depth + 1);
            }

            private int serializeObject(Object object) throws IOException {
                Integer index = this.objects.get(object);
                if (index == null) {
                    index = this.objects.size();
                    this.objects.put(object, index);
                    if (object == null) {
                        this.buffer.writeShort(-5);
                    } else {
                        this.buffer.writeShort(-4);
                        this.callback.serialize((BytecodeSerializer.SerializerContext)this, this.buffer, object);
                    }
                }
                return index;
            }

            public void writeBytecodeNode(DataOutput buffer, BytecodeRootNode node) throws IOException {
                SerializationRootNode serializationRoot = (SerializationRootNode)node;
                buffer.writeInt(serializationRoot.contextDepth);
                buffer.writeInt(serializationRoot.rootIndex);
            }
        }

        private static final class SerializationLocal
        extends BytecodeLocal {
            private final int contextDepth;
            private final int localIndex;

            SerializationLocal(int contextDepth, int localIndex) {
                super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
                this.contextDepth = contextDepth;
                this.localIndex = localIndex;
            }

            @CompilerDirectives.TruffleBoundary
            public int getLocalOffset() {
                throw new IllegalStateException();
            }

            @CompilerDirectives.TruffleBoundary
            public int getLocalIndex() {
                throw new IllegalStateException();
            }
        }

        private static abstract class ScopeData {
            int frameOffset;
            int[] locals = null;
            int numLocals = 0;
            boolean valid = true;

            private ScopeData() {
            }

            public void registerLocal(int tableIndex) {
                int localTableIndex = this.numLocals++;
                if (this.locals == null) {
                    this.locals = new int[8];
                } else if (localTableIndex >= this.locals.length) {
                    this.locals = Arrays.copyOf(this.locals, this.locals.length * 2);
                }
                this.locals[localTableIndex] = tableIndex;
            }
        }

        private static final class BytecodeLocalImpl
        extends BytecodeLocal {
            private final short frameIndex;
            private final short localIndex;
            private final short rootIndex;
            private final ScopeData scope;

            BytecodeLocalImpl(short frameIndex, short localIndex, short rootIndex, ScopeData scope) {
                super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
                this.frameIndex = frameIndex;
                this.localIndex = localIndex;
                this.rootIndex = rootIndex;
                this.scope = scope;
            }

            public int getLocalOffset() {
                return this.frameIndex - 1;
            }

            public int getLocalIndex() {
                return this.localIndex;
            }
        }

        private static final class RootData
        extends ScopeData {
            final short index;
            boolean producedValue;
            int childBci;
            boolean reachable;

            RootData(short index) {
                this.index = index;
                this.producedValue = false;
                this.childBci = -1;
                this.reachable = true;
            }
        }

        private static final class SerializationLabel
        extends BytecodeLabel {
            private final int contextDepth;
            private final int labelIndex;

            SerializationLabel(int contextDepth, int labelIndex) {
                super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
                this.contextDepth = contextDepth;
                this.labelIndex = labelIndex;
            }
        }

        private static final class BytecodeLabelImpl
        extends BytecodeLabel {
            private final int id;
            int bci;
            private final int declaringOp;

            BytecodeLabelImpl(int id, int bci, int declaringOp) {
                super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
                this.id = id;
                this.bci = bci;
                this.declaringOp = declaringOp;
            }

            public boolean isDefined() {
                return this.bci != -1;
            }

            public boolean equals(Object other) {
                if (!(other instanceof BytecodeLabelImpl)) {
                    return false;
                }
                return this.id == ((BytecodeLabelImpl)((Object)other)).id;
            }

            public int hashCode() {
                return this.id;
            }
        }

        private static final class BlockData
        extends ScopeData {
            final int startStackHeight;
            boolean producedValue;
            int childBci;

            BlockData(int startStackHeight) {
                this.startStackHeight = startStackHeight;
                this.producedValue = false;
                this.childBci = -1;
            }
        }

        private static final class SerializationRootNode
        extends SLBytecodeRootNode {
            private final int contextDepth;
            private final int rootIndex;

            private SerializationRootNode(FrameDescriptor.Builder builder, int contextDepth, int rootIndex) {
                super(null, builder.build());
                this.contextDepth = contextDepth;
                this.rootIndex = rootIndex;
            }

            public Object execute(VirtualFrame frame) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("method should not be called");
            }

            @CompilerDirectives.TruffleBoundary
            protected boolean isInstrumentable() {
                throw new IllegalStateException("method should not be called");
            }

            @CompilerDirectives.TruffleBoundary
            protected void prepareForInstrumentation(Set<Class<?>> materializedTags) {
                throw new IllegalStateException("method should not be called");
            }

            @CompilerDirectives.TruffleBoundary
            protected boolean prepareForCompilation(boolean rootCompilation, int compilationTier, boolean lastTier) {
                throw new IllegalStateException("method should not be called");
            }

            @CompilerDirectives.TruffleBoundary
            protected boolean isCloneUninitializedSupported() {
                throw new IllegalStateException("method should not be called");
            }

            @CompilerDirectives.TruffleBoundary
            protected RootNode cloneUninitialized() {
                throw new IllegalStateException("method should not be called");
            }

            protected int findBytecodeIndex(Node node, Frame frame) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("method should not be called");
            }

            @CompilerDirectives.TruffleBoundary
            protected boolean isCaptureFramesForTrace(boolean compiled) {
                throw new IllegalStateException("method should not be called");
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public SourceSection getSourceSection() {
                throw new IllegalStateException("method should not be called");
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected Object translateStackTraceElement(TruffleStackTraceElement stackTraceElement) {
                throw new IllegalStateException("method should not be called");
            }

            @CompilerDirectives.TruffleBoundary
            protected int computeSize() {
                throw new IllegalStateException("method should not be called");
            }
        }

        private static class SavedState {
            private int operationSequenceNumber;
            private OperationStackEntry[] operationStack;
            private int operationSp;
            private int rootOperationSp;
            private int numLocals;
            private int numLabels;
            private int numNodes;
            private int numHandlers;
            private int numConditionalBranches;
            private byte[] bc;
            private int bci;
            private int currentStackHeight;
            private int maxStackHeight;
            private int[] sourceInfo;
            private int sourceInfoIndex;
            private int[] handlerTable;
            private int handlerTableSize;
            private int[] locals;
            private int localsTableIndex;
            private HashMap<BytecodeLabel, ArrayList<Integer>> unresolvedLabels;
            private ConstantPool constantPool;
            private boolean reachable = true;
            private int maxLocals;
            private List<TagNode> tagRoots;
            private List<TagNode> tagNodes;
            private SavedState savedState;

            SavedState(int operationSequenceNumber, OperationStackEntry[] operationStack, int operationSp, int rootOperationSp, int numLocals, int numLabels, int numNodes, int numHandlers, int numConditionalBranches, byte[] bc, int bci, int currentStackHeight, int maxStackHeight, int[] sourceInfo, int sourceInfoIndex, int[] handlerTable, int handlerTableSize, int[] locals, int localsTableIndex, HashMap<BytecodeLabel, ArrayList<Integer>> unresolvedLabels, ConstantPool constantPool, boolean reachable, int maxLocals, List<TagNode> tagRoots, List<TagNode> tagNodes, SavedState savedState) {
                this.operationSequenceNumber = operationSequenceNumber;
                this.operationStack = operationStack;
                this.operationSp = operationSp;
                this.rootOperationSp = rootOperationSp;
                this.numLocals = numLocals;
                this.numLabels = numLabels;
                this.numNodes = numNodes;
                this.numHandlers = numHandlers;
                this.numConditionalBranches = numConditionalBranches;
                this.bc = bc;
                this.bci = bci;
                this.currentStackHeight = currentStackHeight;
                this.maxStackHeight = maxStackHeight;
                this.sourceInfo = sourceInfo;
                this.sourceInfoIndex = sourceInfoIndex;
                this.handlerTable = handlerTable;
                this.handlerTableSize = handlerTableSize;
                this.locals = locals;
                this.localsTableIndex = localsTableIndex;
                this.unresolvedLabels = unresolvedLabels;
                this.constantPool = constantPool;
                this.reachable = reachable;
                this.maxLocals = maxLocals;
                this.tagRoots = tagRoots;
                this.tagNodes = tagNodes;
                this.savedState = savedState;
            }
        }

        private static class ConstantPool {
            private final ArrayList<Object> constants = new ArrayList();
            private final HashMap<Object, Integer> map = new HashMap();

            ConstantPool() {
            }

            private int addConstant(Object constant) {
                if (this.map.containsKey(constant)) {
                    return this.map.get(constant);
                }
                int index = this.constants.size();
                this.constants.add(constant);
                this.map.put(constant, index);
                return index;
            }

            private short allocateSlot() {
                short index = Builder.safeCastShort(this.constants.size());
                this.constants.add(null);
                return index;
            }

            private Object[] toArray() {
                return this.constants.toArray();
            }
        }

        private static final class IfThenData {
            boolean thenReachable;
            int falseBranchFixupBci;

            IfThenData(boolean thenReachable) {
                this.thenReachable = thenReachable;
                this.falseBranchFixupBci = -1;
            }
        }

        private static final class IfThenElseData {
            boolean thenReachable;
            boolean elseReachable;
            int falseBranchFixupBci;
            int endBranchFixupBci;

            IfThenElseData(boolean thenReachable, boolean elseReachable) {
                this.thenReachable = thenReachable;
                this.elseReachable = elseReachable;
                this.falseBranchFixupBci = -1;
                this.endBranchFixupBci = -1;
            }
        }

        private static final class ConditionalData {
            boolean thenReachable;
            boolean elseReachable;
            int falseBranchFixupBci;
            int endBranchFixupBci;
            int child0Bci;
            int child1Bci;

            ConditionalData(boolean thenReachable, boolean elseReachable) {
                this.thenReachable = thenReachable;
                this.elseReachable = elseReachable;
                this.falseBranchFixupBci = -1;
                this.endBranchFixupBci = -1;
                this.child0Bci = -1;
                this.child1Bci = -1;
            }
        }

        private static final class WhileData {
            final int whileStartBci;
            boolean bodyReachable;
            int endBranchFixupBci;

            WhileData(int whileStartBci, boolean bodyReachable) {
                this.whileStartBci = whileStartBci;
                this.bodyReachable = bodyReachable;
                this.endBranchFixupBci = -1;
            }
        }

        private static final class TryCatchData {
            final int handlerId;
            final short stackHeight;
            int tryStartBci;
            final boolean operationReachable;
            boolean tryReachable;
            boolean catchReachable;
            int endBranchFixupBci;
            int extraTableEntriesStart;
            int extraTableEntriesEnd;

            TryCatchData(int handlerId, short stackHeight, int tryStartBci, boolean operationReachable, boolean tryReachable, boolean catchReachable) {
                this.handlerId = handlerId;
                this.stackHeight = stackHeight;
                this.tryStartBci = tryStartBci;
                this.operationReachable = operationReachable;
                this.tryReachable = tryReachable;
                this.catchReachable = catchReachable;
                this.endBranchFixupBci = -1;
                this.extraTableEntriesStart = -1;
                this.extraTableEntriesEnd = -1;
            }
        }

        private static final class TryFinallyData {
            final int handlerId;
            final short stackHeight;
            final Runnable finallyGenerator;
            int tryStartBci;
            final boolean operationReachable;
            boolean tryReachable;
            boolean catchReachable;
            int endBranchFixupBci;
            int extraTableEntriesStart;
            int extraTableEntriesEnd;
            int finallyHandlerSp;

            TryFinallyData(int handlerId, short stackHeight, Runnable finallyGenerator, int tryStartBci, boolean operationReachable, boolean tryReachable, boolean catchReachable) {
                this.handlerId = handlerId;
                this.stackHeight = stackHeight;
                this.finallyGenerator = finallyGenerator;
                this.tryStartBci = tryStartBci;
                this.operationReachable = operationReachable;
                this.tryReachable = tryReachable;
                this.catchReachable = catchReachable;
                this.endBranchFixupBci = -1;
                this.extraTableEntriesStart = -1;
                this.extraTableEntriesEnd = -1;
                this.finallyHandlerSp = -1;
            }
        }

        private static final class FinallyHandlerData {
            final int finallyOperationSp;

            FinallyHandlerData(int finallyOperationSp) {
                this.finallyOperationSp = finallyOperationSp;
            }
        }

        private static final class StoreLocalData {
            BytecodeLocalImpl local;
            int childBci;

            StoreLocalData(BytecodeLocalImpl local) {
                this.local = local;
                this.childBci = -1;
            }
        }

        private static final class ReturnOperationData {
            boolean producedValue = false;
            int childBci = -1;

            ReturnOperationData() {
            }
        }

        private static final class SourceData {
            final int sourceIndex;
            boolean producedValue;
            int childBci;

            SourceData(int sourceIndex) {
                this.sourceIndex = sourceIndex;
                this.producedValue = false;
                this.childBci = -1;
            }
        }

        private static final class SourceSectionData {
            final int sourceIndex;
            int startBci;
            final int start;
            final int length;
            boolean producedValue;
            int childBci;

            SourceSectionData(int sourceIndex, int startBci, int start, int length) {
                this.sourceIndex = sourceIndex;
                this.startBci = startBci;
                this.start = start;
                this.length = length;
                this.producedValue = false;
                this.childBci = -1;
            }
        }

        private static final class TagOperationData {
            final int nodeId;
            final boolean operationReachable;
            final int startStackHeight;
            final TagNode node;
            int handlerStartBci;
            boolean producedValue;
            int childBci;
            List<TagNode> children;

            TagOperationData(int nodeId, boolean operationReachable, int startStackHeight, TagNode node) {
                this.nodeId = nodeId;
                this.operationReachable = operationReachable;
                this.startStackHeight = startStackHeight;
                this.node = node;
                this.handlerStartBci = node.enterBci;
                this.producedValue = false;
                this.childBci = -1;
                this.children = null;
            }
        }

        private static final class CustomOperationData {
            final int[] childBcis;
            final int[] constants;
            final Object[] locals;

            CustomOperationData(int[] childBcis, int[] constants, Object ... locals) {
                this.childBcis = childBcis;
                this.constants = constants;
                this.locals = locals;
            }
        }

        private static final class CustomShortCircuitOperationData {
            int childBci = -1;
            List<Integer> branchFixupBcis = new ArrayList<Integer>(4);

            CustomShortCircuitOperationData() {
            }
        }

        private static final class DeserializationState
        implements BytecodeDeserializer.DeserializerContext {
            private final DeserializationState outer;
            private final int depth;
            private final ArrayList<Object> consts = new ArrayList();
            private final ArrayList<SLBytecodeRootNodeGen> builtNodes = new ArrayList();
            private final ArrayList<BytecodeLabel> labels = new ArrayList();
            private final ArrayList<BytecodeLocal> locals = new ArrayList();
            private final ArrayList<Runnable> finallyGenerators = new ArrayList();

            private DeserializationState(DeserializationState outer) {
                this.outer = outer;
                this.depth = outer == null ? 0 : outer.depth + 1;
            }

            public BytecodeRootNode readBytecodeNode(DataInput buffer) throws IOException {
                return this.getContext((int)buffer.readInt()).builtNodes.get(buffer.readInt());
            }

            private DeserializationState getContext(int targetDepth) {
                assert (targetDepth >= 0);
                DeserializationState ctx = this;
                while (ctx.depth != targetDepth) {
                    ctx = ctx.outer;
                }
                return ctx;
            }
        }
    }

    private static final class Instructions {
        private static final short LOAD_ARGUMENT = 1;
        private static final short LOAD_ARGUMENT$LONG = 2;
        private static final short LOAD_ARGUMENT$BOOLEAN = 3;
        private static final short LOAD_CONSTANT = 4;
        private static final short LOAD_CONSTANT$LONG = 5;
        private static final short LOAD_CONSTANT$BOOLEAN = 6;
        private static final short LOAD_LOCAL = 7;
        private static final short LOAD_LOCAL$LONG = 8;
        private static final short LOAD_LOCAL$LONG$UNBOXED = 9;
        private static final short LOAD_LOCAL$BOOLEAN = 10;
        private static final short LOAD_LOCAL$BOOLEAN$UNBOXED = 11;
        private static final short LOAD_LOCAL$GENERIC = 12;
        private static final short CLEAR_LOCAL = 13;
        private static final short STORE_LOCAL = 14;
        private static final short STORE_LOCAL$LONG = 15;
        private static final short STORE_LOCAL$LONG$LONG = 16;
        private static final short STORE_LOCAL$BOOLEAN = 17;
        private static final short STORE_LOCAL$BOOLEAN$BOOLEAN = 18;
        private static final short STORE_LOCAL$GENERIC = 19;
        private static final short BRANCH = 20;
        private static final short BRANCH_BACKWARD = 21;
        private static final short BRANCH_FALSE = 22;
        private static final short BRANCH_FALSE$GENERIC = 23;
        private static final short BRANCH_FALSE$BOOLEAN = 24;
        private static final short POP = 25;
        private static final short POP$LONG = 26;
        private static final short POP$BOOLEAN = 27;
        private static final short POP$GENERIC = 28;
        private static final short DUP = 29;
        private static final short LOAD_VARIADIC_0 = 30;
        private static final short LOAD_VARIADIC_1 = 31;
        private static final short LOAD_VARIADIC_2 = 32;
        private static final short LOAD_VARIADIC_3 = 33;
        private static final short LOAD_VARIADIC_4 = 34;
        private static final short LOAD_VARIADIC_5 = 35;
        private static final short LOAD_VARIADIC_6 = 36;
        private static final short LOAD_VARIADIC_7 = 37;
        private static final short LOAD_VARIADIC_8 = 38;
        private static final short MERGE_VARIADIC = 39;
        private static final short CONSTANT_NULL = 40;
        private static final short LOAD_NULL = 41;
        private static final short RETURN = 42;
        private static final short THROW = 43;
        private static final short LOAD_EXCEPTION = 44;
        private static final short TAG_ENTER = 45;
        private static final short TAG_LEAVE = 46;
        private static final short TAG_LEAVE$LONG = 47;
        private static final short TAG_LEAVE$LONG$UNBOXED = 48;
        private static final short TAG_LEAVE$BOOLEAN = 49;
        private static final short TAG_LEAVE$BOOLEAN$UNBOXED = 50;
        private static final short TAG_LEAVE$GENERIC = 51;
        private static final short TAG_LEAVE_VOID = 52;
        private static final short SL_ALWAYS_HALT_ = 53;
        private static final short SL_LOAD_ARGUMENT_ = 54;
        private static final short SL_LOAD_ARGUMENT$LOAD_IN_BOUNDS_ = 55;
        private static final short BUILTIN_ = 56;
        private static final short SL_INVOKE_ = 57;
        private static final short SL_ADD_ = 58;
        private static final short SL_ADD$LONG_ = 59;
        private static final short SL_ADD$LONG$UNBOXED_ = 60;
        private static final short SL_DIV_ = 61;
        private static final short SL_DIV$LONG_ = 62;
        private static final short SL_DIV$LONG$UNBOXED_ = 63;
        private static final short SL_EQUAL_ = 64;
        private static final short SL_EQUAL$LONG_ = 65;
        private static final short SL_EQUAL$LONG$UNBOXED_ = 66;
        private static final short SL_EQUAL$BOOLEAN_ = 67;
        private static final short SL_EQUAL$BOOLEAN$UNBOXED_ = 68;
        private static final short SL_EQUAL$UNBOXED_ = 69;
        private static final short SL_LESS_OR_EQUAL_ = 70;
        private static final short SL_LESS_OR_EQUAL$LONG_ = 71;
        private static final short SL_LESS_OR_EQUAL$LONG$UNBOXED_ = 72;
        private static final short SL_LESS_OR_EQUAL$SL_BIG_INTEGER$INTEROP_BIG_INTEGER0$INTEROP_BIG_INTEGER1_ = 73;
        private static final short SL_LESS_OR_EQUAL$SL_BIG_INTEGER$INTEROP_BIG_INTEGER0$INTEROP_BIG_INTEGER1$UNBOXED_ = 74;
        private static final short SL_LESS_THAN_ = 75;
        private static final short SL_LESS_THAN$LONG_ = 76;
        private static final short SL_LESS_THAN$LONG$UNBOXED_ = 77;
        private static final short SL_LESS_THAN$UNBOXED_ = 78;
        private static final short SL_LOGICAL_NOT_ = 79;
        private static final short SL_LOGICAL_NOT$BOOLEAN_ = 80;
        private static final short SL_LOGICAL_NOT$BOOLEAN$UNBOXED_ = 81;
        private static final short SL_LOGICAL_NOT$UNBOXED_ = 82;
        private static final short SL_MUL_ = 83;
        private static final short SL_MUL$LONG_ = 84;
        private static final short SL_MUL$LONG$UNBOXED_ = 85;
        private static final short SL_READ_PROPERTY_ = 86;
        private static final short SL_SUB_ = 87;
        private static final short SL_SUB$LONG_ = 88;
        private static final short SL_SUB$LONG$UNBOXED_ = 89;
        private static final short SL_WRITE_PROPERTY_ = 90;
        private static final short SL_UNBOX_ = 91;
        private static final short SL_UNBOX$FROM_BOOLEAN_ = 92;
        private static final short SL_UNBOX$FROM_BOOLEAN$UNBOXED_ = 93;
        private static final short SL_UNBOX$FROM_LONG_ = 94;
        private static final short SL_UNBOX$FROM_LONG$UNBOXED_ = 95;
        private static final short SL_FUNCTION_LITERAL_ = 96;
        private static final short SL_TO_BOOLEAN_ = 97;
        private static final short SL_TO_BOOLEAN$BOOLEAN_ = 98;
        private static final short SL_TO_BOOLEAN$BOOLEAN$UNBOXED_ = 99;
        private static final short SL_TO_BOOLEAN$UNBOXED_ = 100;
        private static final short SL_AND_ = 101;
        private static final short SL_OR_ = 102;
        private static final short MERGE_CONDITIONAL = 103;
        private static final short MERGE_CONDITIONAL$LONG = 104;
        private static final short MERGE_CONDITIONAL$LONG$UNBOXED = 105;
        private static final short MERGE_CONDITIONAL$BOOLEAN = 106;
        private static final short MERGE_CONDITIONAL$BOOLEAN$UNBOXED = 107;
        private static final short MERGE_CONDITIONAL$GENERIC = 108;
        private static final short INVALIDATE0 = 109;
        private static final short INVALIDATE1 = 110;
        private static final short INVALIDATE2 = 111;
        private static final short INVALIDATE3 = 112;
        private static final short INVALIDATE4 = 113;
        private static final short INVALIDATE5 = 114;
        private static final short INVALIDATE6 = 115;

        private Instructions() {
        }
    }

    private static final class SLToBoolean_Node
    extends Node {
        static final InlineSupport.ReferenceField<Interop0Data> INTEROP0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"interop0_cache", Interop0Data.class);
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private Interop0Data interop0_cache;

        private SLToBoolean_Node() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        private boolean execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && child0Value_ instanceof Boolean) {
                    boolean child0Value__ = (Boolean)child0Value_;
                    return SLToBooleanNode.doBoolean(child0Value__);
                }
                if ((state_0 & 0xE) != 0) {
                    if ((state_0 & 2) != 0) {
                        Interop0Data s1_ = this.interop0_cache;
                        while (s1_ != null) {
                            if (s1_.lib_.accepts(child0Value_) && s1_.lib_.isBoolean(child0Value_)) {
                                Interop0Data node__ = s1_;
                                return SLToBooleanNode.doInterop(child0Value_, node__, s1_.lib_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary lib__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (lib__.isBoolean(child0Value_)) {
                                boolean bl = this.interop1Boundary1(state_0, child0Value_, $bytecode, $bc, $bci, $sp);
                                return bl;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        SLToBoolean_Node node__1 = this;
                        if (this.fallbackGuard_(state_0, child0Value_, $bytecode, $bc, $bci, $sp)) {
                            return SLToBooleanNode.doFallback(child0Value_, node__1);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, $bytecode, $bc, $bci, $sp);
        }

        private boolean executeBoolean(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            boolean child0Value_;
            try {
                child0Value_ = FRAMES.expectBoolean((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            return SLToBooleanNode.doBoolean(child0Value_);
        }

        private boolean executeBoolean$unboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            boolean child0Value_;
            try {
                child0Value_ = FRAMES.expectBoolean((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            return SLToBooleanNode.doBoolean(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        private boolean executeunboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && child0Value_ instanceof Boolean) {
                    boolean child0Value__ = (Boolean)child0Value_;
                    return SLToBooleanNode.doBoolean(child0Value__);
                }
                if ((state_0 & 0xE) != 0) {
                    if ((state_0 & 2) != 0) {
                        Interop0Data s1_ = this.interop0_cache;
                        while (s1_ != null) {
                            if (s1_.lib_.accepts(child0Value_) && s1_.lib_.isBoolean(child0Value_)) {
                                Interop0Data node__ = s1_;
                                return SLToBooleanNode.doInterop(child0Value_, node__, s1_.lib_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary lib__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (lib__.isBoolean(child0Value_)) {
                                boolean bl = this.interop1Boundary2(state_0, child0Value_, $bytecode, $bc, $bci, $sp);
                                return bl;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        SLToBoolean_Node node__1 = this;
                        if (this.fallbackGuard_(state_0, child0Value_, $bytecode, $bc, $bci, $sp)) {
                            return SLToBooleanNode.doFallback(child0Value_, node__1);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, $bytecode, $bc, $bci, $sp);
        }

        private boolean fallbackGuard_(int state_0, Object child0Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            if ((state_0 & 1) == 0 && child0Value instanceof Boolean) {
                return false;
            }
            return (state_0 & 4) != 0 || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isBoolean(child0Value);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean interop1Boundary(int state_0, Object child0Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            SLToBoolean_Node node__ = this;
            InteropLibrary lib__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLToBooleanNode.doInterop(child0Value, node__, lib__);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean interop1Boundary0(int state_0, Object child0Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            SLToBoolean_Node node__ = this;
            InteropLibrary lib__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLToBooleanNode.doInterop(child0Value_, node__, lib__);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object child0Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int state_0 = this.state_0_;
            if (child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                this.state_0_ = state_0 |= 1;
                SLToBoolean_Node.quicken(state_0, $bc, $bci);
                return SLToBooleanNode.doBoolean(child0Value_);
            }
            Interop0Data node__ = null;
            if ((state_0 & 4) == 0) {
                Interop0Data s1_;
                block10: {
                    Interop0Data s1_original;
                    do {
                        InteropLibrary lib__;
                        int count1_ = 0;
                        s1_original = s1_ = (Interop0Data)((Object)INTEROP0_CACHE_UPDATER.getVolatile((Node)this));
                        while (s1_ != null) {
                            if (s1_.lib_.accepts(child0Value) && s1_.lib_.isBoolean(child0Value)) {
                                node__ = s1_;
                                break;
                            }
                            ++count1_;
                            s1_ = s1_.next_;
                        }
                        if (s1_ != null || !(lib__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child0Value)))).isBoolean(child0Value) || count1_ >= 3) break block10;
                        node__ = s1_ = (Interop0Data)this.insert(new Interop0Data(s1_original));
                        Objects.requireNonNull((InteropLibrary)s1_.insert((Node)lib__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s1_.lib_ = lib__;
                    } while (!INTEROP0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s1_original, (Object)s1_));
                    this.state_0_ = state_0 |= 2;
                    SLToBoolean_Node.quicken(state_0, $bc, $bci);
                }
                if (s1_ != null) {
                    return SLToBooleanNode.doInterop(child0Value, node__, s1_.lib_);
                }
            }
            InteropLibrary lib__ = null;
            SLToBoolean_Node node__2 = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                lib__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                if (lib__.isBoolean(child0Value)) {
                    node__2 = this;
                    this.interop0_cache = null;
                    state_0 &= 0xFFFFFFFD;
                    this.state_0_ = state_0 |= 4;
                    SLToBoolean_Node.quicken(state_0, $bc, $bci);
                    boolean bl = SLToBooleanNode.doInterop(child0Value, node__2, lib__);
                    return bl;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            SLToBoolean_Node node__1 = null;
            node__1 = this;
            this.state_0_ = state_0 |= 8;
            SLToBoolean_Node.quicken(state_0, $bc, $bci);
            return SLToBooleanNode.doFallback(child0Value, node__1);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean interop1Boundary1(int state_0, Object child0Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            SLToBoolean_Node node__ = this;
            InteropLibrary lib__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLToBooleanNode.doInterop(child0Value_, node__, lib__);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean interop1Boundary2(int state_0, Object child0Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            SLToBoolean_Node node__ = this;
            InteropLibrary lib__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLToBooleanNode.doInterop(child0Value_, node__, lib__);
        }

        private static void quicken(int state_0, byte[] $bc, int $bci) {
            short newInstruction;
            short newOperand0;
            int oldOperandIndex0 = BYTES.getIntUnaligned($bc, $bci + 6);
            short oldOperand0 = oldOperandIndex0 != -1 ? (short)BYTES.getShort($bc, oldOperandIndex0) : (short)-1;
            if ((state_0 & 0xE) == 0 && state_0 != 0 && (newOperand0 = SLBytecodeRootNodeGen.applyQuickeningBoolean(oldOperand0)) != -1) {
                newInstruction = SLBytecodeRootNodeGen.isQuickeningBoolean(BYTES.getShort($bc, $bci)) ? (short)99 : 98;
            } else {
                newOperand0 = SLBytecodeRootNodeGen.undoQuickening(oldOperand0);
                newInstruction = SLBytecodeRootNodeGen.isQuickeningBoolean(BYTES.getShort($bc, $bci)) ? (short)100 : 97;
            }
            if (newOperand0 != -1) {
                BYTES.putShort($bc, oldOperandIndex0, newOperand0);
            }
            BYTES.putShort($bc, $bci, newInstruction);
        }

        @DenyReplace
        private static final class Interop0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            Interop0Data next_;
            @Node.Child
            InteropLibrary lib_;

            Interop0Data(Interop0Data next_) {
                this.next_ = next_;
            }
        }

        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public boolean executeUncached(VirtualFrame frameValue, Object child0Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                if (child0Value instanceof Boolean) {
                    boolean child0Value_ = (Boolean)child0Value;
                    return SLToBooleanNode.doBoolean(child0Value_);
                }
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value)).isBoolean(child0Value)) {
                    return SLToBooleanNode.doInterop(child0Value, (Node)$bytecode, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value));
                }
                return SLToBooleanNode.doFallback(child0Value, (Node)$bytecode);
            }
        }
    }

    private static final class SLFunctionLiteral_Node
    extends Node {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private PerformData perform_cache;

        private SLFunctionLiteral_Node() {
        }

        private SLFunction execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int state_0 = this.state_0_;
            Object child0Value_ = FRAMES.uncheckedGetObject((Frame)frameValue, $sp - 1);
            if (state_0 != 0 && child0Value_ instanceof TruffleString) {
                TruffleString child0Value__ = (TruffleString)child0Value_;
                PerformData s0_ = this.perform_cache;
                if (s0_ != null) {
                    SLFunctionLiteral_Node node__ = this;
                    return SLFunctionLiteralNode.perform(child0Value__, node__, s0_.result_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, $bytecode, $bc, $bci, $sp);
        }

        private SLFunction executeAndSpecialize(Object child0Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int state_0 = this.state_0_;
            SLFunctionLiteral_Node node__ = null;
            if (child0Value instanceof TruffleString) {
                TruffleString child0Value_ = (TruffleString)child0Value;
                PerformData s0_ = new PerformData();
                node__ = this;
                s0_.result_ = SLFunctionLiteralNode.lookupFunctionCached(child0Value_, node__);
                VarHandle.storeStoreFence();
                this.perform_cache = s0_;
                this.state_0_ = state_0 |= 1;
                return SLFunctionLiteralNode.perform(child0Value_, node__, s0_.result_);
            }
            throw new UnsupportedSpecializationException((Node)this, null, new Object[]{child0Value});
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException1(Node thisNode_, Object child0Value) {
            return new UnsupportedSpecializationException(thisNode_, null, new Object[]{child0Value});
        }

        @DenyReplace
        private static final class PerformData
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            SLFunction result_;

            PerformData() {
            }
        }

        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public SLFunction executeUncached(VirtualFrame frameValue, Object child0Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                if (child0Value instanceof TruffleString) {
                    TruffleString child0Value_ = (TruffleString)child0Value;
                    return SLFunctionLiteralNode.perform(child0Value_, (Node)$bytecode, SLFunctionLiteralNode.lookupFunction(child0Value_, (Node)$bytecode));
                }
                throw SLFunctionLiteral_Node.newUnsupportedSpecializationException1(this, child0Value);
            }
        }
    }

    private static final class SLUnbox_Node
    extends Node {
        static final InlineSupport.ReferenceField<FromForeign0Data> FROM_FOREIGN0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"fromForeign0_cache", FromForeign0Data.class);
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private TruffleString.FromJavaStringNode fromString_fromJavaStringNode_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private FromForeign0Data fromForeign0_cache;

        private SLUnbox_Node() {
        }

        @ExplodeLoop
        private Object execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            if ((state_0 & 0x1FF) != 0) {
                Object child0Value__;
                if ((state_0 & 1) != 0 && child0Value_ instanceof String) {
                    child0Value__ = (String)child0Value_;
                    TruffleString.FromJavaStringNode fromJavaStringNode__ = this.fromString_fromJavaStringNode_;
                    if (fromJavaStringNode__ != null) {
                        return SLUnboxNode.fromString((String)child0Value__, fromJavaStringNode__);
                    }
                }
                if ((state_0 & 2) != 0 && child0Value_ instanceof TruffleString) {
                    child0Value__ = (TruffleString)child0Value_;
                    return SLUnboxNode.fromTruffleString((TruffleString)child0Value__);
                }
                if ((state_0 & 4) != 0 && child0Value_ instanceof Boolean) {
                    boolean child0Value__2 = (Boolean)child0Value_;
                    return SLUnboxNode.fromBoolean(child0Value__2);
                }
                if ((state_0 & 8) != 0 && child0Value_ instanceof Long) {
                    long child0Value__3 = (Long)child0Value_;
                    return SLUnboxNode.fromLong(child0Value__3);
                }
                if ((state_0 & 0x10) != 0 && SLTypesGen.isImplicitSLBigInteger((state_0 & 0x600) >>> 9, child0Value_)) {
                    child0Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x600) >>> 9, child0Value_);
                    return SLUnboxNode.fromBigNumber((SLBigInteger)child0Value__);
                }
                if ((state_0 & 0x20) != 0 && child0Value_ instanceof SLFunction) {
                    child0Value__ = (SLFunction)child0Value_;
                    return SLUnboxNode.fromFunction((SLFunction)child0Value__);
                }
                if ((state_0 & 0x40) != 0 && SLTypes.isSLNull(child0Value_)) {
                    child0Value__ = SLTypes.asSLNull(child0Value_);
                    return SLUnboxNode.fromFunction((SLNull)child0Value__);
                }
                if ((state_0 & 0x180) != 0) {
                    if ((state_0 & 0x80) != 0) {
                        FromForeign0Data s7_ = this.fromForeign0_cache;
                        while (s7_ != null) {
                            if (s7_.interop_.accepts(child0Value_)) {
                                return SLUnboxNode.fromForeign(child0Value_, s7_.interop_);
                            }
                            s7_ = s7_.next_;
                        }
                    }
                    if ((state_0 & 0x100) != 0) {
                        return this.fromForeign1Boundary1(state_0, child0Value_, $bytecode, $bc, $bci, $sp);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, $bytecode, $bc, $bci, $sp);
        }

        private boolean executeFromBoolean(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            boolean child0Value_;
            try {
                child0Value_ = FRAMES.expectBoolean((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectBoolean(this.executeAndSpecialize(ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            return SLUnboxNode.fromBoolean(child0Value_);
        }

        private boolean executeFromBoolean$unboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            boolean child0Value_;
            try {
                child0Value_ = FRAMES.expectBoolean((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectBoolean(this.executeAndSpecialize(ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            return SLUnboxNode.fromBoolean(child0Value_);
        }

        private long executeFromLong(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            return SLUnboxNode.fromLong(child0Value_);
        }

        private long executeFromLong$unboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            return SLUnboxNode.fromLong(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object fromForeign1Boundary(int state_0, Object child0Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value);
                Object object = SLUnboxNode.fromForeign(child0Value, interop__);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object fromForeign1Boundary0(int state_0, Object child0Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_);
                Object object = SLUnboxNode.fromForeign(child0Value_, interop__);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object child0Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int state_0 = this.state_0_;
            if (child0Value instanceof String) {
                String child0Value_ = (String)child0Value;
                TruffleString.FromJavaStringNode fromJavaStringNode__ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fromString_fromJavaStringNode_ = fromJavaStringNode__;
                this.state_0_ = state_0 |= 1;
                SLUnbox_Node.quicken(state_0, $bc, $bci);
                return SLUnboxNode.fromString(child0Value_, fromJavaStringNode__);
            }
            if (child0Value instanceof TruffleString) {
                TruffleString child0Value_ = (TruffleString)child0Value;
                this.state_0_ = state_0 |= 2;
                SLUnbox_Node.quicken(state_0, $bc, $bci);
                return SLUnboxNode.fromTruffleString(child0Value_);
            }
            if (child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                this.state_0_ = state_0 |= 4;
                SLUnbox_Node.quicken(state_0, $bc, $bci);
                return SLUnboxNode.fromBoolean(child0Value_);
            }
            if (child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                this.state_0_ = state_0 |= 8;
                SLUnbox_Node.quicken(state_0, $bc, $bci);
                return SLUnboxNode.fromLong(child0Value_);
            }
            int sLBigIntegerCast0 = SLTypesGen.specializeImplicitSLBigInteger(child0Value);
            if (sLBigIntegerCast0 != 0) {
                SLBigInteger child0Value_ = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast0, child0Value);
                state_0 |= sLBigIntegerCast0 << 9;
                this.state_0_ = state_0 |= 0x10;
                SLUnbox_Node.quicken(state_0, $bc, $bci);
                return SLUnboxNode.fromBigNumber(child0Value_);
            }
            if (child0Value instanceof SLFunction) {
                SLFunction child0Value_ = (SLFunction)child0Value;
                this.state_0_ = state_0 |= 0x20;
                SLUnbox_Node.quicken(state_0, $bc, $bci);
                return SLUnboxNode.fromFunction(child0Value_);
            }
            if (SLTypes.isSLNull(child0Value)) {
                SLNull child0Value_ = SLTypes.asSLNull(child0Value);
                this.state_0_ = state_0 |= 0x40;
                SLUnbox_Node.quicken(state_0, $bc, $bci);
                return SLUnboxNode.fromFunction(child0Value_);
            }
            if ((state_0 & 0x100) == 0) {
                FromForeign0Data s7_;
                block14: {
                    FromForeign0Data s7_original;
                    do {
                        int count7_ = 0;
                        s7_original = s7_ = (FromForeign0Data)((Object)FROM_FOREIGN0_CACHE_UPDATER.getVolatile((Node)this));
                        while (s7_ != null && !s7_.interop_.accepts(child0Value)) {
                            ++count7_;
                            s7_ = s7_.next_;
                        }
                        if (s7_ != null || count7_ >= 5) break block14;
                        s7_ = (FromForeign0Data)this.insert(new FromForeign0Data(s7_original));
                        InteropLibrary interop__ = (InteropLibrary)s7_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child0Value)));
                        Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s7_.interop_ = interop__;
                    } while (!FROM_FOREIGN0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s7_original, (Object)s7_));
                    this.state_0_ = state_0 |= 0x80;
                    SLUnbox_Node.quicken(state_0, $bc, $bci);
                }
                if (s7_ != null) {
                    return SLUnboxNode.fromForeign(child0Value, s7_.interop_);
                }
            }
            InteropLibrary interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value);
                this.fromForeign0_cache = null;
                state_0 &= 0xFFFFFF7F;
                this.state_0_ = state_0 |= 0x100;
                SLUnbox_Node.quicken(state_0, $bc, $bci);
                Object object = SLUnboxNode.fromForeign(child0Value, interop__);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object fromForeign1Boundary1(int state_0, Object child0Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_);
                Object object = SLUnboxNode.fromForeign(child0Value_, interop__);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        private static void quicken(int state_0, byte[] $bc, int $bci) {
            int newInstruction;
            short newOperand0;
            int oldOperandIndex0 = BYTES.getIntUnaligned($bc, $bci + 6);
            short oldOperand0 = BYTES.getShort($bc, oldOperandIndex0);
            if ((state_0 & 0x1FB) == 0 && (state_0 & 0x1FF) != 0 && (newOperand0 = SLBytecodeRootNodeGen.applyQuickeningBoolean(oldOperand0)) != -1) {
                newInstruction = SLBytecodeRootNodeGen.isQuickeningBoolean(BYTES.getShort($bc, $bci)) ? 93 : 92;
            } else if ((state_0 & 0x1F7) == 0 && (state_0 & 0x1FF) != 0 && (newOperand0 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand0)) != -1) {
                newInstruction = SLBytecodeRootNodeGen.isQuickeningLong(BYTES.getShort($bc, $bci)) ? 95 : 94;
            } else {
                newOperand0 = SLBytecodeRootNodeGen.undoQuickening(oldOperand0);
                newInstruction = 91;
            }
            BYTES.putShort($bc, oldOperandIndex0, newOperand0);
            BYTES.putShort($bc, $bci, (short)newInstruction);
        }

        @DenyReplace
        private static final class FromForeign0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            FromForeign0Data next_;
            @Node.Child
            InteropLibrary interop_;

            FromForeign0Data(FromForeign0Data next_) {
                this.next_ = next_;
            }
        }

        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public Object executeUncached(VirtualFrame frameValue, Object child0Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                if (child0Value instanceof String) {
                    String child0Value_ = (String)child0Value;
                    return SLUnboxNode.fromString(child0Value_, TruffleString.FromJavaStringNode.getUncached());
                }
                if (child0Value instanceof TruffleString) {
                    TruffleString child0Value_ = (TruffleString)child0Value;
                    return SLUnboxNode.fromTruffleString(child0Value_);
                }
                if (child0Value instanceof Boolean) {
                    boolean child0Value_ = (Boolean)child0Value;
                    return SLUnboxNode.fromBoolean(child0Value_);
                }
                if (child0Value instanceof Long) {
                    long child0Value_ = (Long)child0Value;
                    return SLUnboxNode.fromLong(child0Value_);
                }
                if (SLTypesGen.isImplicitSLBigInteger(child0Value)) {
                    SLBigInteger child0Value_ = SLTypesGen.asImplicitSLBigInteger(child0Value);
                    return SLUnboxNode.fromBigNumber(child0Value_);
                }
                if (child0Value instanceof SLFunction) {
                    SLFunction child0Value_ = (SLFunction)child0Value;
                    return SLUnboxNode.fromFunction(child0Value_);
                }
                if (SLTypes.isSLNull(child0Value)) {
                    SLNull child0Value_ = SLTypes.asSLNull(child0Value);
                    return SLUnboxNode.fromFunction(child0Value_);
                }
                return SLUnboxNode.fromForeign(child0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value));
            }
        }
    }

    private static final class SLWriteProperty_Node
    extends Node {
        private static final InlineSupport.StateField WRITE_SL_OBJECT0_SL_WRITE_PROPERTY_NODE_WRITE_SL_OBJECT0_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)WriteSLObject0Data.lookup_(), (String)"writeSLObject0_state_0_");
        private static final InlineSupport.StateField WRITE_SL_OBJECT1_SL_WRITE_PROPERTY_NODE_WRITE_SL_OBJECT1_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)WriteSLObject1Data.lookup_(), (String)"writeSLObject1_state_0_");
        private static final InlineSupport.StateField WRITE_OBJECT0_SL_WRITE_PROPERTY_NODE_WRITE_OBJECT0_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)WriteObject0Data.lookup_(), (String)"writeObject0_state_0_");
        private static final InlineSupport.StateField WRITE_OBJECT1_SL_WRITE_PROPERTY_NODE_WRITE_OBJECT1_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)WriteObject1Data.lookup_(), (String)"writeObject1_state_0_");
        static final InlineSupport.ReferenceField<WriteArray0Data> WRITE_ARRAY0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"writeArray0_cache", WriteArray0Data.class);
        static final InlineSupport.ReferenceField<WriteSLObject0Data> WRITE_SL_OBJECT0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"writeSLObject0_cache", WriteSLObject0Data.class);
        static final InlineSupport.ReferenceField<WriteObject0Data> WRITE_OBJECT0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"writeObject0_cache", WriteObject0Data.class);
        private static final SLToTruffleStringNode INLINED_WRITE_SL_OBJECT0_TO_TRUFFLE_STRING_NODE_ = SLToTruffleStringNodeGen.inline(InlineSupport.InlineTarget.create(SLToTruffleStringNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{WRITE_SL_OBJECT0_SL_WRITE_PROPERTY_NODE_WRITE_SL_OBJECT0_STATE_0_UPDATER.subUpdater(0, 11), InlineSupport.ReferenceField.create((MethodHandles.Lookup)WriteSLObject0Data.lookup_(), (String)"writeSLObject0_toTruffleStringNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)WriteSLObject0Data.lookup_(), (String)"writeSLObject0_toTruffleStringNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)WriteSLObject0Data.lookup_(), (String)"writeSLObject0_toTruffleStringNode__field3_", Node.class)}));
        private static final SLToTruffleStringNode INLINED_WRITE_SL_OBJECT1_TO_TRUFFLE_STRING_NODE_ = SLToTruffleStringNodeGen.inline(InlineSupport.InlineTarget.create(SLToTruffleStringNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{WRITE_SL_OBJECT1_SL_WRITE_PROPERTY_NODE_WRITE_SL_OBJECT1_STATE_0_UPDATER.subUpdater(0, 11), InlineSupport.ReferenceField.create((MethodHandles.Lookup)WriteSLObject1Data.lookup_(), (String)"writeSLObject1_toTruffleStringNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)WriteSLObject1Data.lookup_(), (String)"writeSLObject1_toTruffleStringNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)WriteSLObject1Data.lookup_(), (String)"writeSLObject1_toTruffleStringNode__field3_", Node.class)}));
        private static final SLToMemberNode INLINED_WRITE_OBJECT0_AS_MEMBER_ = SLToMemberNodeGen.inline(InlineSupport.InlineTarget.create(SLToMemberNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{WRITE_OBJECT0_SL_WRITE_PROPERTY_NODE_WRITE_OBJECT0_STATE_0_UPDATER.subUpdater(0, 9), InlineSupport.ReferenceField.create((MethodHandles.Lookup)WriteObject0Data.lookup_(), (String)"writeObject0_asMember__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)WriteObject0Data.lookup_(), (String)"writeObject0_asMember__field2_", Node.class)}));
        private static final SLToMemberNode INLINED_WRITE_OBJECT1_AS_MEMBER_ = SLToMemberNodeGen.inline(InlineSupport.InlineTarget.create(SLToMemberNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{WRITE_OBJECT1_SL_WRITE_PROPERTY_NODE_WRITE_OBJECT1_STATE_0_UPDATER.subUpdater(0, 9), InlineSupport.ReferenceField.create((MethodHandles.Lookup)WriteObject1Data.lookup_(), (String)"writeObject1_asMember__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)WriteObject1Data.lookup_(), (String)"writeObject1_asMember__field2_", Node.class)}));
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private WriteArray0Data writeArray0_cache;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private WriteSLObject0Data writeSLObject0_cache;
        @Node.Child
        private WriteSLObject1Data writeSLObject1_cache;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private WriteObject0Data writeObject0_cache;
        @Node.Child
        private WriteObject1Data writeObject1_cache;

        private SLWriteProperty_Node() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        private Object execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int state_0 = this.state_0_;
            Object child0Value_ = FRAMES.uncheckedGetObject((Frame)frameValue, $sp - 3);
            Object child1Value_ = FRAMES.uncheckedGetObject((Frame)frameValue, $sp - 2);
            Object child2Value_ = FRAMES.uncheckedGetObject((Frame)frameValue, $sp - 1);
            if (state_0 != 0) {
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0) {
                        WriteArray0Data s0_ = this.writeArray0_cache;
                        while (s0_ != null) {
                            if (s0_.arrays_.accepts(child0Value_) && s0_.numbers_.accepts(child1Value_) && s0_.arrays_.hasArrayElements(child0Value_)) {
                                WriteArray0Data node__ = s0_;
                                return SLWritePropertyNode.writeArray(child0Value_, child1Value_, child2Value_, node__, s0_.arrays_, s0_.numbers_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (arrays__.hasArrayElements(child0Value_)) {
                                Object object = this.writeArray1Boundary3(state_0, child0Value_, child1Value_, child2Value_, $bytecode, $bc, $bci, $sp);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if ((state_0 & 0xC) != 0 && child0Value_ instanceof SLObject) {
                    WriteSLObject1Data s3_;
                    SLObject child0Value__ = (SLObject)((Object)child0Value_);
                    if ((state_0 & 4) != 0) {
                        WriteSLObject0Data s2_ = this.writeSLObject0_cache;
                        while (s2_ != null) {
                            if (s2_.objectLibrary_.accepts((Object)child0Value__)) {
                                WriteSLObject0Data node__1 = s2_;
                                return SLWritePropertyNode.writeSLObject(child0Value__, child1Value_, child2Value_, node__1, s2_.objectLibrary_, INLINED_WRITE_SL_OBJECT0_TO_TRUFFLE_STRING_NODE_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.writeSLObject1_cache) != null) {
                        return this.writeSLObject1Boundary4(state_0, s3_, child0Value__, child1Value_, child2Value_, $bytecode, $bc, $bci, $sp);
                    }
                }
                if ((state_0 & 0x30) != 0) {
                    WriteObject1Data s5_;
                    if ((state_0 & 0x10) != 0) {
                        WriteObject0Data s4_ = this.writeObject0_cache;
                        while (s4_ != null) {
                            if (s4_.objectLibrary_.accepts(child0Value_) && !SLWritePropertyNode.isSLObject(child0Value_)) {
                                WriteObject0Data node__2 = s4_;
                                return SLWritePropertyNode.writeObject(child0Value_, child1Value_, child2Value_, node__2, s4_.objectLibrary_, INLINED_WRITE_OBJECT0_AS_MEMBER_);
                            }
                            s4_ = s4_.next_;
                        }
                    }
                    if ((state_0 & 0x20) != 0 && (s5_ = this.writeObject1_cache) != null && !SLWritePropertyNode.isSLObject(child0Value_)) {
                        return this.writeObject1Boundary5(state_0, s5_, child0Value_, child1Value_, child2Value_, $bytecode, $bc, $bci, $sp);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, child2Value_, $bytecode, $bc, $bci, $sp);
        }

        @CompilerDirectives.TruffleBoundary
        private Object writeArray1Boundary(int state_0, Object child0Value, Object child1Value, Object child2Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            SLWriteProperty_Node node__ = this;
            InteropLibrary arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary numbers__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLWritePropertyNode.writeArray(child0Value, child1Value, child2Value, node__, arrays__, numbers__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object writeSLObject1Boundary(int state_0, WriteSLObject1Data s3_, SLObject child0Value_, Object child1Value, Object child2Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            WriteSLObject1Data node__1 = s3_;
            DynamicObjectLibrary objectLibrary__ = (DynamicObjectLibrary)DYNAMIC_OBJECT_LIBRARY_.getUncached((Object)child0Value_);
            return SLWritePropertyNode.writeSLObject(child0Value_, child1Value, child2Value, node__1, objectLibrary__, INLINED_WRITE_SL_OBJECT1_TO_TRUFFLE_STRING_NODE_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object writeObject1Boundary(int state_0, WriteObject1Data s5_, Object child0Value, Object child1Value, Object child2Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                WriteObject1Data node__2 = s5_;
                InteropLibrary objectLibrary__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value);
                Object object = SLWritePropertyNode.writeObject(child0Value, child1Value, child2Value, node__2, objectLibrary__1, INLINED_WRITE_OBJECT1_AS_MEMBER_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private Object writeArray1Boundary0(int state_0, Object child0Value_, Object child1Value_, Object child2Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            SLWriteProperty_Node node__ = this;
            InteropLibrary arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary numbers__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLWritePropertyNode.writeArray(child0Value_, child1Value_, child2Value_, node__, arrays__, numbers__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object writeSLObject1Boundary1(int state_0, WriteSLObject1Data s3_, SLObject child0Value__, Object child1Value_, Object child2Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            WriteSLObject1Data node__1 = s3_;
            DynamicObjectLibrary objectLibrary__ = (DynamicObjectLibrary)DYNAMIC_OBJECT_LIBRARY_.getUncached((Object)child0Value__);
            return SLWritePropertyNode.writeSLObject(child0Value__, child1Value_, child2Value_, node__1, objectLibrary__, INLINED_WRITE_SL_OBJECT1_TO_TRUFFLE_STRING_NODE_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object writeObject1Boundary2(int state_0, WriteObject1Data s5_, Object child0Value_, Object child1Value_, Object child2Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                WriteObject1Data node__2 = s5_;
                InteropLibrary objectLibrary__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_);
                Object object = SLWritePropertyNode.writeObject(child0Value_, child1Value_, child2Value_, node__2, objectLibrary__1, INLINED_WRITE_OBJECT1_AS_MEMBER_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object child0Value, Object child1Value, Object child2Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object numbers__;
            int state_0 = this.state_0_;
            WriteArray0Data node__ = null;
            if ((state_0 & 2) == 0) {
                WriteArray0Data s0_;
                block24: {
                    WriteArray0Data s0_original;
                    do {
                        InteropLibrary arrays__;
                        int count0_ = 0;
                        s0_original = s0_ = (WriteArray0Data)((Object)WRITE_ARRAY0_CACHE_UPDATER.getVolatile((Node)this));
                        while (s0_ != null) {
                            if (s0_.arrays_.accepts(child0Value) && s0_.numbers_.accepts(child1Value) && s0_.arrays_.hasArrayElements(child0Value)) {
                                node__ = s0_;
                                break;
                            }
                            ++count0_;
                            s0_ = s0_.next_;
                        }
                        if (s0_ != null || !(arrays__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child0Value)))).hasArrayElements(child0Value) || count0_ >= 3) break block24;
                        node__ = s0_ = (WriteArray0Data)this.insert(new WriteArray0Data(s0_original));
                        Objects.requireNonNull((InteropLibrary)s0_.insert((Node)arrays__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.arrays_ = arrays__;
                        numbers__ = (InteropLibrary)s0_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child1Value)));
                        Objects.requireNonNull(numbers__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.numbers_ = numbers__;
                    } while (!WRITE_ARRAY0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                    this.state_0_ = state_0 |= 1;
                }
                if (s0_ != null) {
                    return SLWritePropertyNode.writeArray(child0Value, child1Value, child2Value, node__, s0_.arrays_, s0_.numbers_);
                }
            }
            InteropLibrary numbers__2 = null;
            InteropLibrary arrays__ = null;
            SLWriteProperty_Node node__2 = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                if (arrays__.hasArrayElements(child0Value)) {
                    node__2 = this;
                    numbers__2 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    this.writeArray0_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    numbers__ = SLWritePropertyNode.writeArray(child0Value, child1Value, child2Value, node__2, arrays__, numbers__2);
                    return numbers__;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            if (child0Value instanceof SLObject) {
                WriteSLObject1Data s3_;
                SLObject child0Value_ = (SLObject)((Object)child0Value);
                WriteSLObject0Data node__1 = null;
                if ((state_0 & 8) == 0) {
                    WriteSLObject0Data s2_;
                    block26: {
                        WriteSLObject0Data s2_original;
                        do {
                            int count2_ = 0;
                            s2_original = s2_ = (WriteSLObject0Data)((Object)WRITE_SL_OBJECT0_CACHE_UPDATER.getVolatile((Node)this));
                            while (s2_ != null) {
                                if (s2_.objectLibrary_.accepts((Object)child0Value_)) {
                                    node__1 = s2_;
                                    break;
                                }
                                ++count2_;
                                s2_ = s2_.next_;
                            }
                            if (s2_ != null || count2_ >= 3) break block26;
                            node__1 = s2_ = (WriteSLObject0Data)this.insert(new WriteSLObject0Data(s2_original));
                            DynamicObjectLibrary objectLibrary__ = (DynamicObjectLibrary)s2_.insert((Node)((DynamicObjectLibrary)DYNAMIC_OBJECT_LIBRARY_.create((Object)child0Value_)));
                            Objects.requireNonNull(objectLibrary__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.objectLibrary_ = objectLibrary__;
                        } while (!WRITE_SL_OBJECT0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s2_ != null) {
                        return SLWritePropertyNode.writeSLObject(child0Value_, child1Value, child2Value, node__1, s2_.objectLibrary_, INLINED_WRITE_SL_OBJECT0_TO_TRUFFLE_STRING_NODE_);
                    }
                }
                DynamicObjectLibrary objectLibrary__ = null;
                WriteSLObject1Data node__12 = null;
                node__12 = s3_ = (WriteSLObject1Data)this.insert(new WriteSLObject1Data());
                objectLibrary__ = (DynamicObjectLibrary)DYNAMIC_OBJECT_LIBRARY_.getUncached((Object)child0Value_);
                VarHandle.storeStoreFence();
                this.writeSLObject1_cache = s3_;
                this.writeSLObject0_cache = null;
                state_0 &= 0xFFFFFFFB;
                this.state_0_ = state_0 |= 8;
                return SLWritePropertyNode.writeSLObject(child0Value_, child1Value, child2Value, node__12, objectLibrary__, INLINED_WRITE_SL_OBJECT1_TO_TRUFFLE_STRING_NODE_);
            }
            WriteObject0Data node__22 = null;
            if ((state_0 & 0x20) == 0) {
                WriteObject0Data s4_;
                block27: {
                    WriteObject0Data s4_original;
                    do {
                        int count4_ = 0;
                        s4_original = s4_ = (WriteObject0Data)((Object)WRITE_OBJECT0_CACHE_UPDATER.getVolatile((Node)this));
                        while (s4_ != null) {
                            if (s4_.objectLibrary_.accepts(child0Value) && !SLWritePropertyNode.isSLObject(child0Value)) {
                                node__22 = s4_;
                                break;
                            }
                            ++count4_;
                            s4_ = s4_.next_;
                        }
                        if (s4_ != null || SLWritePropertyNode.isSLObject(child0Value) || count4_ >= 3) break block27;
                        node__22 = s4_ = (WriteObject0Data)this.insert(new WriteObject0Data(s4_original));
                        InteropLibrary objectLibrary__1 = (InteropLibrary)s4_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child0Value)));
                        Objects.requireNonNull(objectLibrary__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s4_.objectLibrary_ = objectLibrary__1;
                    } while (!WRITE_OBJECT0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s4_original, (Object)s4_));
                    this.state_0_ = state_0 |= 0x10;
                }
                if (s4_ != null) {
                    return SLWritePropertyNode.writeObject(child0Value, child1Value, child2Value, node__22, s4_.objectLibrary_, INLINED_WRITE_OBJECT0_AS_MEMBER_);
                }
            }
            InteropLibrary objectLibrary__1 = null;
            WriteObject1Data node__23 = null;
            EncapsulatingNodeReference encapsulating_2 = EncapsulatingNodeReference.getCurrent();
            Node prev_2 = encapsulating_2.set((Node)this);
            try {
                if (!SLWritePropertyNode.isSLObject(child0Value)) {
                    WriteObject1Data s5_;
                    node__23 = s5_ = (WriteObject1Data)this.insert(new WriteObject1Data());
                    objectLibrary__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value);
                    VarHandle.storeStoreFence();
                    this.writeObject1_cache = s5_;
                    this.writeObject0_cache = null;
                    state_0 &= 0xFFFFFFEF;
                    this.state_0_ = state_0 |= 0x20;
                    Object object = SLWritePropertyNode.writeObject(child0Value, child1Value, child2Value, node__23, objectLibrary__1, INLINED_WRITE_OBJECT1_AS_MEMBER_);
                    return object;
                }
            }
            finally {
                encapsulating_2.set(prev_2);
            }
            throw new UnsupportedSpecializationException((Node)this, null, new Object[]{child0Value, child1Value, child2Value});
        }

        @CompilerDirectives.TruffleBoundary
        private Object writeArray1Boundary3(int state_0, Object child0Value_, Object child1Value_, Object child2Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            SLWriteProperty_Node node__ = this;
            InteropLibrary arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary numbers__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLWritePropertyNode.writeArray(child0Value_, child1Value_, child2Value_, node__, arrays__, numbers__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object writeSLObject1Boundary4(int state_0, WriteSLObject1Data s3_, SLObject child0Value__, Object child1Value_, Object child2Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            WriteSLObject1Data node__1 = s3_;
            DynamicObjectLibrary objectLibrary__ = (DynamicObjectLibrary)DYNAMIC_OBJECT_LIBRARY_.getUncached((Object)child0Value__);
            return SLWritePropertyNode.writeSLObject(child0Value__, child1Value_, child2Value_, node__1, objectLibrary__, INLINED_WRITE_SL_OBJECT1_TO_TRUFFLE_STRING_NODE_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object writeObject1Boundary5(int state_0, WriteObject1Data s5_, Object child0Value_, Object child1Value_, Object child2Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                WriteObject1Data node__2 = s5_;
                InteropLibrary objectLibrary__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_);
                Object object = SLWritePropertyNode.writeObject(child0Value_, child1Value_, child2Value_, node__2, objectLibrary__1, INLINED_WRITE_OBJECT1_AS_MEMBER_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException3(Node thisNode_, Object child0Value, Object child1Value, Object child2Value) {
            return new UnsupportedSpecializationException(thisNode_, null, new Object[]{child0Value, child1Value, child2Value});
        }

        @DenyReplace
        private static final class WriteArray0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            WriteArray0Data next_;
            @Node.Child
            InteropLibrary arrays_;
            @Node.Child
            InteropLibrary numbers_;

            WriteArray0Data(WriteArray0Data next_) {
                this.next_ = next_;
            }
        }

        @DenyReplace
        private static final class WriteSLObject0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            WriteSLObject0Data next_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int writeSLObject0_state_0_;
            @Node.Child
            DynamicObjectLibrary objectLibrary_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node writeSLObject0_toTruffleStringNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node writeSLObject0_toTruffleStringNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node writeSLObject0_toTruffleStringNode__field3_;

            WriteSLObject0Data(WriteSLObject0Data next_) {
                this.next_ = next_;
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @DenyReplace
        private static final class WriteSLObject1Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int writeSLObject1_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node writeSLObject1_toTruffleStringNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node writeSLObject1_toTruffleStringNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node writeSLObject1_toTruffleStringNode__field3_;

            WriteSLObject1Data() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @DenyReplace
        private static final class WriteObject0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            WriteObject0Data next_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int writeObject0_state_0_;
            @Node.Child
            InteropLibrary objectLibrary_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node writeObject0_asMember__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node writeObject0_asMember__field2_;

            WriteObject0Data(WriteObject0Data next_) {
                this.next_ = next_;
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @DenyReplace
        private static final class WriteObject1Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int writeObject1_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node writeObject1_asMember__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node writeObject1_asMember__field2_;

            WriteObject1Data() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public Object executeUncached(VirtualFrame frameValue, Object child0Value, Object child1Value, Object child2Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value)).hasArrayElements(child0Value)) {
                    return SLWritePropertyNode.writeArray(child0Value, child1Value, child2Value, (Node)$bytecode, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), (InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value));
                }
                if (child0Value instanceof SLObject) {
                    SLObject child0Value_ = (SLObject)((Object)child0Value);
                    return SLWritePropertyNode.writeSLObject(child0Value_, child1Value, child2Value, (Node)$bytecode, (DynamicObjectLibrary)DYNAMIC_OBJECT_LIBRARY_.getUncached((Object)child0Value_), SLToTruffleStringNodeGen.getUncached());
                }
                if (!SLWritePropertyNode.isSLObject(child0Value)) {
                    return SLWritePropertyNode.writeObject(child0Value, child1Value, child2Value, (Node)$bytecode, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), SLToMemberNodeGen.getUncached());
                }
                throw SLWriteProperty_Node.newUnsupportedSpecializationException3(this, child0Value, child1Value, child2Value);
            }
        }
    }

    private static final class SLSub_Node
    extends Node {
        static final InlineSupport.ReferenceField<InteropBigInteger0Data> INTEROP_BIG_INTEGER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"interopBigInteger0_cache", InteropBigInteger0Data.class);
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private InteropBigInteger0Data interopBigInteger0_cache;

        private SLSub_Node() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        private Object execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child1Value_;
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            if ((state_0 & 0x3D) != 0) {
                if ((state_0 & 1) != 0 && child0Value_ instanceof Long) {
                    long child0Value__ = (Long)child0Value_;
                    if (child1Value_ instanceof Long) {
                        long child1Value__ = (Long)child1Value_;
                        try {
                            return SLSubNode.doLong(child0Value__, child1Value__);
                        }
                        catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFE;
                            this.state_0_ = state_0 |= 2;
                            SLSub_Node.quicken(state_0, $bc, $bci);
                            return this.executeAndSpecialize(child0Value__, child1Value__, $bytecode, $bc, $bci, $sp);
                        }
                    }
                }
                if ((state_0 & 4) != 0 && SLTypesGen.isImplicitSLBigInteger((state_0 & 0xC0) >>> 6, child0Value_)) {
                    SLBigInteger child0Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0xC0) >>> 6, child0Value_);
                    if (SLTypesGen.isImplicitSLBigInteger((state_0 & 0x300) >>> 8, child1Value_)) {
                        SLBigInteger child1Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x300) >>> 8, child1Value_);
                        return SLSubNode.doSLBigInteger(child0Value__, child1Value__);
                    }
                }
                if ((state_0 & 0x38) != 0) {
                    if ((state_0 & 8) != 0) {
                        InteropBigInteger0Data s2_ = this.interopBigInteger0_cache;
                        while (s2_ != null) {
                            if (s2_.leftLibrary_.accepts(child0Value_) && s2_.rightLibrary_.accepts(child1Value_) && s2_.leftLibrary_.fitsInBigInteger(child0Value_) && s2_.rightLibrary_.fitsInBigInteger(child1Value_)) {
                                return SLSubNode.doInteropBigInteger(child0Value_, child1Value_, s2_.leftLibrary_, s2_.rightLibrary_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0x10) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary rightLibrary__;
                            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (leftLibrary__.fitsInBigInteger(child0Value_) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value_)) {
                                Object object = this.interopBigInteger1Boundary1(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0x20) != 0) {
                        SLSub_Node node__ = this;
                        if (this.fallbackGuard_(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp)) {
                            return SLSubNode.typeError(child0Value_, child1Value_, node__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
        }

        private long executeLong(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return SLTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp));
            }
            try {
                child1Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            try {
                return SLSubNode.doLong(child0Value_, child1Value_);
            }
            catch (ArithmeticException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int state_0 = this.state_0_;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                SLSub_Node.quicken(state_0, $bc, $bci);
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp));
            }
        }

        private long executeLong$unboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return SLTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp));
            }
            try {
                child1Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            try {
                return SLSubNode.doLong(child0Value_, child1Value_);
            }
            catch (ArithmeticException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int state_0 = this.state_0_;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                SLSub_Node.quicken(state_0, $bc, $bci);
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp));
            }
        }

        private boolean fallbackGuard_(int state_0, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            return (state_0 & 0x10) != 0 || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child0Value) || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary(int state_0, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLSubNode.doInteropBigInteger(child0Value, child1Value, leftLibrary__, rightLibrary__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary0(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLSubNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int sLBigIntegerCast0;
            int state_0 = this.state_0_;
            if ((state_0 & 0x1C) == 0 && (state_0 & 2) == 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    this.state_0_ = state_0 |= 1;
                    SLSub_Node.quicken(state_0, $bc, $bci);
                    try {
                        return SLSubNode.doLong(child0Value_, child1Value_);
                    }
                    catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        SLSub_Node.quicken(state_0, $bc, $bci);
                        return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                    }
                }
            }
            if ((state_0 & 0x18) == 0 && (sLBigIntegerCast0 = SLTypesGen.specializeImplicitSLBigInteger(child0Value)) != 0) {
                SLBigInteger child0Value_ = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast0, child0Value);
                int sLBigIntegerCast1 = SLTypesGen.specializeImplicitSLBigInteger(child1Value);
                if (sLBigIntegerCast1 != 0) {
                    SLBigInteger child1Value_ = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast1, child1Value);
                    state_0 &= 0xFFFFFFFE;
                    state_0 |= sLBigIntegerCast0 << 6;
                    state_0 |= sLBigIntegerCast1 << 8;
                    this.state_0_ = state_0 |= 4;
                    SLSub_Node.quicken(state_0, $bc, $bci);
                    return SLSubNode.doSLBigInteger(child0Value_, child1Value_);
                }
            }
            if ((state_0 & 0x10) == 0) {
                InteropBigInteger0Data s2_;
                block14: {
                    InteropBigInteger0Data s2_original;
                    do {
                        InteropLibrary rightLibrary__;
                        InteropLibrary leftLibrary__;
                        int count2_ = 0;
                        s2_original = s2_ = (InteropBigInteger0Data)((Object)INTEROP_BIG_INTEGER0_CACHE_UPDATER.getVolatile((Node)this));
                        while (!(s2_ == null || s2_.leftLibrary_.accepts(child0Value) && s2_.rightLibrary_.accepts(child1Value) && s2_.leftLibrary_.fitsInBigInteger(child0Value) && s2_.rightLibrary_.fitsInBigInteger(child1Value))) {
                            ++count2_;
                            s2_ = s2_.next_;
                        }
                        if (s2_ != null || !(leftLibrary__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child0Value)))).fitsInBigInteger(child0Value) || !(rightLibrary__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child1Value)))).fitsInBigInteger(child1Value) || count2_ >= 3) break block14;
                        s2_ = (InteropBigInteger0Data)this.insert(new InteropBigInteger0Data(s2_original));
                        Objects.requireNonNull((InteropLibrary)s2_.insert((Node)leftLibrary__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.leftLibrary_ = leftLibrary__;
                        Objects.requireNonNull((InteropLibrary)s2_.insert((Node)rightLibrary__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.rightLibrary_ = rightLibrary__;
                    } while (!INTEROP_BIG_INTEGER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                    state_0 &= 0xFFFFFFFA;
                    this.state_0_ = state_0 |= 8;
                    SLSub_Node.quicken(state_0, $bc, $bci);
                }
                if (s2_ != null) {
                    return SLSubNode.doInteropBigInteger(child0Value, child1Value, s2_.leftLibrary_, s2_.rightLibrary_);
                }
            }
            InteropLibrary rightLibrary__ = null;
            InteropLibrary leftLibrary__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                if (leftLibrary__.fitsInBigInteger(child0Value) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value)) {
                    this.interopBigInteger0_cache = null;
                    state_0 &= 0xFFFFFFF2;
                    this.state_0_ = state_0 |= 0x10;
                    SLSub_Node.quicken(state_0, $bc, $bci);
                    SLBigInteger sLBigInteger = SLSubNode.doInteropBigInteger(child0Value, child1Value, leftLibrary__, rightLibrary__);
                    return sLBigInteger;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            SLSub_Node node__ = null;
            node__ = this;
            this.state_0_ = state_0 |= 0x20;
            SLSub_Node.quicken(state_0, $bc, $bci);
            return SLSubNode.typeError(child0Value, child1Value, node__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary1(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLSubNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        private static void quicken(int state_0, byte[] $bc, int $bci) {
            int newInstruction;
            short newOperand1;
            short newOperand0;
            int oldOperandIndex0 = BYTES.getIntUnaligned($bc, $bci + 6);
            short oldOperand0 = BYTES.getShort($bc, oldOperandIndex0);
            int oldOperandIndex1 = BYTES.getIntUnaligned($bc, $bci + 10);
            short oldOperand1 = BYTES.getShort($bc, oldOperandIndex1);
            if ((state_0 & 0x3C) == 0 && (state_0 & 0x3D) != 0 && (newOperand0 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand0)) != -1 && (newOperand1 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand1)) != -1) {
                newInstruction = SLBytecodeRootNodeGen.isQuickeningLong(BYTES.getShort($bc, $bci)) ? 89 : 88;
            } else {
                newOperand0 = SLBytecodeRootNodeGen.undoQuickening(oldOperand0);
                newOperand1 = SLBytecodeRootNodeGen.undoQuickening(oldOperand1);
                newInstruction = 87;
            }
            BYTES.putShort($bc, oldOperandIndex0, newOperand0);
            BYTES.putShort($bc, oldOperandIndex1, newOperand1);
            BYTES.putShort($bc, $bci, (short)newInstruction);
        }

        @DenyReplace
        private static final class InteropBigInteger0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            InteropBigInteger0Data next_;
            @Node.Child
            InteropLibrary leftLibrary_;
            @Node.Child
            InteropLibrary rightLibrary_;

            InteropBigInteger0Data(InteropBigInteger0Data next_) {
                this.next_ = next_;
            }
        }

        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public Object executeUncached(VirtualFrame frameValue, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value)).fitsInBigInteger(child0Value) && ((InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value)).fitsInBigInteger(child1Value)) {
                    return SLSubNode.doInteropBigInteger(child0Value, child1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), (InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value));
                }
                return SLSubNode.typeError(child0Value, child1Value, (Node)$bytecode);
            }
        }
    }

    private static final class SLReadProperty_Node
    extends Node {
        private static final InlineSupport.StateField READ_SL_OBJECT0_SL_READ_PROPERTY_NODE_READ_SL_OBJECT0_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)ReadSLObject0Data.lookup_(), (String)"readSLObject0_state_0_");
        private static final InlineSupport.StateField READ_SL_OBJECT1_SL_READ_PROPERTY_NODE_READ_SL_OBJECT1_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)ReadSLObject1Data.lookup_(), (String)"readSLObject1_state_0_");
        private static final InlineSupport.StateField READ_OBJECT0_SL_READ_PROPERTY_NODE_READ_OBJECT0_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)ReadObject0Data.lookup_(), (String)"readObject0_state_0_");
        private static final InlineSupport.StateField READ_OBJECT1_SL_READ_PROPERTY_NODE_READ_OBJECT1_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)ReadObject1Data.lookup_(), (String)"readObject1_state_0_");
        static final InlineSupport.ReferenceField<ReadArray0Data> READ_ARRAY0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"readArray0_cache", ReadArray0Data.class);
        static final InlineSupport.ReferenceField<ReadSLObject0Data> READ_SL_OBJECT0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"readSLObject0_cache", ReadSLObject0Data.class);
        static final InlineSupport.ReferenceField<ReadObject0Data> READ_OBJECT0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"readObject0_cache", ReadObject0Data.class);
        private static final SLToTruffleStringNode INLINED_READ_SL_OBJECT0_TO_TRUFFLE_STRING_NODE_ = SLToTruffleStringNodeGen.inline(InlineSupport.InlineTarget.create(SLToTruffleStringNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{READ_SL_OBJECT0_SL_READ_PROPERTY_NODE_READ_SL_OBJECT0_STATE_0_UPDATER.subUpdater(0, 11), InlineSupport.ReferenceField.create((MethodHandles.Lookup)ReadSLObject0Data.lookup_(), (String)"readSLObject0_toTruffleStringNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)ReadSLObject0Data.lookup_(), (String)"readSLObject0_toTruffleStringNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)ReadSLObject0Data.lookup_(), (String)"readSLObject0_toTruffleStringNode__field3_", Node.class)}));
        private static final SLToTruffleStringNode INLINED_READ_SL_OBJECT1_TO_TRUFFLE_STRING_NODE_ = SLToTruffleStringNodeGen.inline(InlineSupport.InlineTarget.create(SLToTruffleStringNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{READ_SL_OBJECT1_SL_READ_PROPERTY_NODE_READ_SL_OBJECT1_STATE_0_UPDATER.subUpdater(0, 11), InlineSupport.ReferenceField.create((MethodHandles.Lookup)ReadSLObject1Data.lookup_(), (String)"readSLObject1_toTruffleStringNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)ReadSLObject1Data.lookup_(), (String)"readSLObject1_toTruffleStringNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)ReadSLObject1Data.lookup_(), (String)"readSLObject1_toTruffleStringNode__field3_", Node.class)}));
        private static final SLToMemberNode INLINED_READ_OBJECT0_AS_MEMBER_ = SLToMemberNodeGen.inline(InlineSupport.InlineTarget.create(SLToMemberNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{READ_OBJECT0_SL_READ_PROPERTY_NODE_READ_OBJECT0_STATE_0_UPDATER.subUpdater(0, 9), InlineSupport.ReferenceField.create((MethodHandles.Lookup)ReadObject0Data.lookup_(), (String)"readObject0_asMember__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)ReadObject0Data.lookup_(), (String)"readObject0_asMember__field2_", Node.class)}));
        private static final SLToMemberNode INLINED_READ_OBJECT1_AS_MEMBER_ = SLToMemberNodeGen.inline(InlineSupport.InlineTarget.create(SLToMemberNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{READ_OBJECT1_SL_READ_PROPERTY_NODE_READ_OBJECT1_STATE_0_UPDATER.subUpdater(0, 9), InlineSupport.ReferenceField.create((MethodHandles.Lookup)ReadObject1Data.lookup_(), (String)"readObject1_asMember__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)ReadObject1Data.lookup_(), (String)"readObject1_asMember__field2_", Node.class)}));
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private ReadArray0Data readArray0_cache;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private ReadSLObject0Data readSLObject0_cache;
        @Node.Child
        private ReadSLObject1Data readSLObject1_cache;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private ReadObject0Data readObject0_cache;
        @Node.Child
        private ReadObject1Data readObject1_cache;

        private SLReadProperty_Node() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        private Object execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int state_0 = this.state_0_;
            Object child0Value_ = FRAMES.uncheckedGetObject((Frame)frameValue, $sp - 2);
            Object child1Value_ = FRAMES.uncheckedGetObject((Frame)frameValue, $sp - 1);
            if (state_0 != 0) {
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0) {
                        ReadArray0Data s0_ = this.readArray0_cache;
                        while (s0_ != null) {
                            if (s0_.arrays_.accepts(child0Value_) && s0_.numbers_.accepts(child1Value_) && s0_.arrays_.hasArrayElements(child0Value_)) {
                                ReadArray0Data node__ = s0_;
                                return SLReadPropertyNode.readArray(child0Value_, child1Value_, node__, s0_.arrays_, s0_.numbers_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (arrays__.hasArrayElements(child0Value_)) {
                                Object object = this.readArray1Boundary3(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if ((state_0 & 0xC) != 0 && child0Value_ instanceof SLObject) {
                    ReadSLObject1Data s3_;
                    SLObject child0Value__ = (SLObject)((Object)child0Value_);
                    if ((state_0 & 4) != 0) {
                        ReadSLObject0Data s2_ = this.readSLObject0_cache;
                        while (s2_ != null) {
                            if (s2_.objectLibrary_.accepts((Object)child0Value__)) {
                                ReadSLObject0Data node__1 = s2_;
                                return SLReadPropertyNode.readSLObject(child0Value__, child1Value_, node__1, s2_.objectLibrary_, INLINED_READ_SL_OBJECT0_TO_TRUFFLE_STRING_NODE_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.readSLObject1_cache) != null) {
                        return this.readSLObject1Boundary4(state_0, s3_, child0Value__, child1Value_, $bytecode, $bc, $bci, $sp);
                    }
                }
                if ((state_0 & 0x30) != 0) {
                    ReadObject1Data s5_;
                    if ((state_0 & 0x10) != 0) {
                        ReadObject0Data s4_ = this.readObject0_cache;
                        while (s4_ != null) {
                            if (s4_.objects_.accepts(child0Value_) && !SLReadPropertyNode.isSLObject(child0Value_) && s4_.objects_.hasMembers(child0Value_)) {
                                ReadObject0Data node__2 = s4_;
                                return SLReadPropertyNode.readObject(child0Value_, child1Value_, node__2, s4_.objects_, INLINED_READ_OBJECT0_AS_MEMBER_);
                            }
                            s4_ = s4_.next_;
                        }
                    }
                    if ((state_0 & 0x20) != 0 && (s5_ = this.readObject1_cache) != null) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary objects__;
                            if (!SLReadPropertyNode.isSLObject(child0Value_) && (objects__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).hasMembers(child0Value_)) {
                                Object object = this.readObject1Boundary5(state_0, s5_, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
        }

        @CompilerDirectives.TruffleBoundary
        private Object readArray1Boundary(int state_0, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            SLReadProperty_Node node__ = this;
            InteropLibrary arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary numbers__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLReadPropertyNode.readArray(child0Value, child1Value, node__, arrays__, numbers__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object readSLObject1Boundary(int state_0, ReadSLObject1Data s3_, SLObject child0Value_, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            ReadSLObject1Data node__1 = s3_;
            DynamicObjectLibrary objectLibrary__ = (DynamicObjectLibrary)DYNAMIC_OBJECT_LIBRARY_.getUncached((Object)child0Value_);
            return SLReadPropertyNode.readSLObject(child0Value_, child1Value, node__1, objectLibrary__, INLINED_READ_SL_OBJECT1_TO_TRUFFLE_STRING_NODE_);
        }

        @CompilerDirectives.TruffleBoundary
        private Object readObject1Boundary(int state_0, ReadObject1Data s5_, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            ReadObject1Data node__2 = s5_;
            InteropLibrary objects__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLReadPropertyNode.readObject(child0Value, child1Value, node__2, objects__, INLINED_READ_OBJECT1_AS_MEMBER_);
        }

        @CompilerDirectives.TruffleBoundary
        private Object readArray1Boundary0(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            SLReadProperty_Node node__ = this;
            InteropLibrary arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary numbers__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLReadPropertyNode.readArray(child0Value_, child1Value_, node__, arrays__, numbers__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object readSLObject1Boundary1(int state_0, ReadSLObject1Data s3_, SLObject child0Value__, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            ReadSLObject1Data node__1 = s3_;
            DynamicObjectLibrary objectLibrary__ = (DynamicObjectLibrary)DYNAMIC_OBJECT_LIBRARY_.getUncached((Object)child0Value__);
            return SLReadPropertyNode.readSLObject(child0Value__, child1Value_, node__1, objectLibrary__, INLINED_READ_SL_OBJECT1_TO_TRUFFLE_STRING_NODE_);
        }

        @CompilerDirectives.TruffleBoundary
        private Object readObject1Boundary2(int state_0, ReadObject1Data s5_, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            ReadObject1Data node__2 = s5_;
            InteropLibrary objects__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLReadPropertyNode.readObject(child0Value_, child1Value_, node__2, objects__, INLINED_READ_OBJECT1_AS_MEMBER_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object numbers__;
            int state_0 = this.state_0_;
            ReadArray0Data node__ = null;
            if ((state_0 & 2) == 0) {
                ReadArray0Data s0_;
                block24: {
                    ReadArray0Data s0_original;
                    do {
                        InteropLibrary arrays__;
                        int count0_ = 0;
                        s0_original = s0_ = (ReadArray0Data)((Object)READ_ARRAY0_CACHE_UPDATER.getVolatile((Node)this));
                        while (s0_ != null) {
                            if (s0_.arrays_.accepts(child0Value) && s0_.numbers_.accepts(child1Value) && s0_.arrays_.hasArrayElements(child0Value)) {
                                node__ = s0_;
                                break;
                            }
                            ++count0_;
                            s0_ = s0_.next_;
                        }
                        if (s0_ != null || !(arrays__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child0Value)))).hasArrayElements(child0Value) || count0_ >= 3) break block24;
                        node__ = s0_ = (ReadArray0Data)this.insert(new ReadArray0Data(s0_original));
                        Objects.requireNonNull((InteropLibrary)s0_.insert((Node)arrays__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.arrays_ = arrays__;
                        numbers__ = (InteropLibrary)s0_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child1Value)));
                        Objects.requireNonNull(numbers__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.numbers_ = numbers__;
                    } while (!READ_ARRAY0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                    this.state_0_ = state_0 |= 1;
                }
                if (s0_ != null) {
                    return SLReadPropertyNode.readArray(child0Value, child1Value, node__, s0_.arrays_, s0_.numbers_);
                }
            }
            InteropLibrary numbers__2 = null;
            InteropLibrary arrays__ = null;
            SLReadProperty_Node node__2 = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                if (arrays__.hasArrayElements(child0Value)) {
                    node__2 = this;
                    numbers__2 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    this.readArray0_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    numbers__ = SLReadPropertyNode.readArray(child0Value, child1Value, node__2, arrays__, numbers__2);
                    return numbers__;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            if (child0Value instanceof SLObject) {
                ReadSLObject1Data s3_;
                SLObject child0Value_ = (SLObject)((Object)child0Value);
                ReadSLObject0Data node__1 = null;
                if ((state_0 & 8) == 0) {
                    ReadSLObject0Data s2_;
                    block26: {
                        ReadSLObject0Data s2_original;
                        do {
                            int count2_ = 0;
                            s2_original = s2_ = (ReadSLObject0Data)((Object)READ_SL_OBJECT0_CACHE_UPDATER.getVolatile((Node)this));
                            while (s2_ != null) {
                                if (s2_.objectLibrary_.accepts((Object)child0Value_)) {
                                    node__1 = s2_;
                                    break;
                                }
                                ++count2_;
                                s2_ = s2_.next_;
                            }
                            if (s2_ != null || count2_ >= 3) break block26;
                            node__1 = s2_ = (ReadSLObject0Data)this.insert(new ReadSLObject0Data(s2_original));
                            DynamicObjectLibrary objectLibrary__ = (DynamicObjectLibrary)s2_.insert((Node)((DynamicObjectLibrary)DYNAMIC_OBJECT_LIBRARY_.create((Object)child0Value_)));
                            Objects.requireNonNull(objectLibrary__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.objectLibrary_ = objectLibrary__;
                        } while (!READ_SL_OBJECT0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s2_ != null) {
                        return SLReadPropertyNode.readSLObject(child0Value_, child1Value, node__1, s2_.objectLibrary_, INLINED_READ_SL_OBJECT0_TO_TRUFFLE_STRING_NODE_);
                    }
                }
                DynamicObjectLibrary objectLibrary__ = null;
                ReadSLObject1Data node__12 = null;
                node__12 = s3_ = (ReadSLObject1Data)this.insert(new ReadSLObject1Data());
                objectLibrary__ = (DynamicObjectLibrary)DYNAMIC_OBJECT_LIBRARY_.getUncached((Object)child0Value_);
                VarHandle.storeStoreFence();
                this.readSLObject1_cache = s3_;
                this.readSLObject0_cache = null;
                state_0 &= 0xFFFFFFFB;
                this.state_0_ = state_0 |= 8;
                return SLReadPropertyNode.readSLObject(child0Value_, child1Value, node__12, objectLibrary__, INLINED_READ_SL_OBJECT1_TO_TRUFFLE_STRING_NODE_);
            }
            ReadObject0Data node__22 = null;
            if ((state_0 & 0x20) == 0) {
                ReadObject0Data s4_;
                block27: {
                    ReadObject0Data s4_original;
                    do {
                        InteropLibrary objects__;
                        int count4_ = 0;
                        s4_original = s4_ = (ReadObject0Data)((Object)READ_OBJECT0_CACHE_UPDATER.getVolatile((Node)this));
                        while (s4_ != null) {
                            if (s4_.objects_.accepts(child0Value) && !SLReadPropertyNode.isSLObject(child0Value) && s4_.objects_.hasMembers(child0Value)) {
                                node__22 = s4_;
                                break;
                            }
                            ++count4_;
                            s4_ = s4_.next_;
                        }
                        if (s4_ != null || SLReadPropertyNode.isSLObject(child0Value) || !(objects__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child0Value)))).hasMembers(child0Value) || count4_ >= 3) break block27;
                        node__22 = s4_ = (ReadObject0Data)this.insert(new ReadObject0Data(s4_original));
                        Objects.requireNonNull((InteropLibrary)s4_.insert((Node)objects__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s4_.objects_ = objects__;
                    } while (!READ_OBJECT0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s4_original, (Object)s4_));
                    this.state_0_ = state_0 |= 0x10;
                }
                if (s4_ != null) {
                    return SLReadPropertyNode.readObject(child0Value, child1Value, node__22, s4_.objects_, INLINED_READ_OBJECT0_AS_MEMBER_);
                }
            }
            InteropLibrary objects__ = null;
            ReadObject1Data node__23 = null;
            EncapsulatingNodeReference encapsulating_2 = EncapsulatingNodeReference.getCurrent();
            Node prev_2 = encapsulating_2.set((Node)this);
            try {
                if (!SLReadPropertyNode.isSLObject(child0Value) && (objects__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).hasMembers(child0Value)) {
                    ReadObject1Data s5_;
                    node__23 = s5_ = (ReadObject1Data)this.insert(new ReadObject1Data());
                    VarHandle.storeStoreFence();
                    this.readObject1_cache = s5_;
                    this.readObject0_cache = null;
                    state_0 &= 0xFFFFFFEF;
                    this.state_0_ = state_0 |= 0x20;
                    Object object = SLReadPropertyNode.readObject(child0Value, child1Value, node__23, objects__, INLINED_READ_OBJECT1_AS_MEMBER_);
                    return object;
                }
            }
            finally {
                encapsulating_2.set(prev_2);
            }
            throw new UnsupportedSpecializationException((Node)this, null, new Object[]{child0Value, child1Value});
        }

        @CompilerDirectives.TruffleBoundary
        private Object readArray1Boundary3(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            SLReadProperty_Node node__ = this;
            InteropLibrary arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary numbers__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLReadPropertyNode.readArray(child0Value_, child1Value_, node__, arrays__, numbers__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object readSLObject1Boundary4(int state_0, ReadSLObject1Data s3_, SLObject child0Value__, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            ReadSLObject1Data node__1 = s3_;
            DynamicObjectLibrary objectLibrary__ = (DynamicObjectLibrary)DYNAMIC_OBJECT_LIBRARY_.getUncached((Object)child0Value__);
            return SLReadPropertyNode.readSLObject(child0Value__, child1Value_, node__1, objectLibrary__, INLINED_READ_SL_OBJECT1_TO_TRUFFLE_STRING_NODE_);
        }

        @CompilerDirectives.TruffleBoundary
        private Object readObject1Boundary5(int state_0, ReadObject1Data s5_, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            ReadObject1Data node__2 = s5_;
            InteropLibrary objects__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLReadPropertyNode.readObject(child0Value_, child1Value_, node__2, objects__, INLINED_READ_OBJECT1_AS_MEMBER_);
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object child0Value, Object child1Value) {
            return new UnsupportedSpecializationException(thisNode_, null, new Object[]{child0Value, child1Value});
        }

        @DenyReplace
        private static final class ReadArray0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            ReadArray0Data next_;
            @Node.Child
            InteropLibrary arrays_;
            @Node.Child
            InteropLibrary numbers_;

            ReadArray0Data(ReadArray0Data next_) {
                this.next_ = next_;
            }
        }

        @DenyReplace
        private static final class ReadSLObject0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            ReadSLObject0Data next_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int readSLObject0_state_0_;
            @Node.Child
            DynamicObjectLibrary objectLibrary_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node readSLObject0_toTruffleStringNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node readSLObject0_toTruffleStringNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node readSLObject0_toTruffleStringNode__field3_;

            ReadSLObject0Data(ReadSLObject0Data next_) {
                this.next_ = next_;
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @DenyReplace
        private static final class ReadSLObject1Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int readSLObject1_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node readSLObject1_toTruffleStringNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node readSLObject1_toTruffleStringNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node readSLObject1_toTruffleStringNode__field3_;

            ReadSLObject1Data() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @DenyReplace
        private static final class ReadObject0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            ReadObject0Data next_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int readObject0_state_0_;
            @Node.Child
            InteropLibrary objects_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node readObject0_asMember__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node readObject0_asMember__field2_;

            ReadObject0Data(ReadObject0Data next_) {
                this.next_ = next_;
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @DenyReplace
        private static final class ReadObject1Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int readObject1_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node readObject1_asMember__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node readObject1_asMember__field2_;

            ReadObject1Data() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public Object executeUncached(VirtualFrame frameValue, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value)).hasArrayElements(child0Value)) {
                    return SLReadPropertyNode.readArray(child0Value, child1Value, (Node)$bytecode, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), (InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value));
                }
                if (child0Value instanceof SLObject) {
                    SLObject child0Value_ = (SLObject)((Object)child0Value);
                    return SLReadPropertyNode.readSLObject(child0Value_, child1Value, (Node)$bytecode, (DynamicObjectLibrary)DYNAMIC_OBJECT_LIBRARY_.getUncached((Object)child0Value_), SLToTruffleStringNodeGen.getUncached());
                }
                if (!SLReadPropertyNode.isSLObject(child0Value) && ((InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value)).hasMembers(child0Value)) {
                    return SLReadPropertyNode.readObject(child0Value, child1Value, (Node)$bytecode, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), SLToMemberNodeGen.getUncached());
                }
                throw SLReadProperty_Node.newUnsupportedSpecializationException2(this, child0Value, child1Value);
            }
        }
    }

    private static final class SLMul_Node
    extends Node {
        static final InlineSupport.ReferenceField<InteropBigInteger0Data> INTEROP_BIG_INTEGER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"interopBigInteger0_cache", InteropBigInteger0Data.class);
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private InteropBigInteger0Data interopBigInteger0_cache;

        private SLMul_Node() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        private Object execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child1Value_;
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            if ((state_0 & 0x3D) != 0) {
                if ((state_0 & 1) != 0 && child0Value_ instanceof Long) {
                    long child0Value__ = (Long)child0Value_;
                    if (child1Value_ instanceof Long) {
                        long child1Value__ = (Long)child1Value_;
                        try {
                            return SLMulNode.doLong(child0Value__, child1Value__);
                        }
                        catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFE;
                            this.state_0_ = state_0 |= 2;
                            SLMul_Node.quicken(state_0, $bc, $bci);
                            return this.executeAndSpecialize(child0Value__, child1Value__, $bytecode, $bc, $bci, $sp);
                        }
                    }
                }
                if ((state_0 & 4) != 0 && SLTypesGen.isImplicitSLBigInteger((state_0 & 0xC0) >>> 6, child0Value_)) {
                    SLBigInteger child0Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0xC0) >>> 6, child0Value_);
                    if (SLTypesGen.isImplicitSLBigInteger((state_0 & 0x300) >>> 8, child1Value_)) {
                        SLBigInteger child1Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x300) >>> 8, child1Value_);
                        return SLMulNode.doSLBigInteger(child0Value__, child1Value__);
                    }
                }
                if ((state_0 & 0x38) != 0) {
                    if ((state_0 & 8) != 0) {
                        InteropBigInteger0Data s2_ = this.interopBigInteger0_cache;
                        while (s2_ != null) {
                            if (s2_.leftLibrary_.accepts(child0Value_) && s2_.rightLibrary_.accepts(child1Value_) && s2_.leftLibrary_.fitsInBigInteger(child0Value_) && s2_.rightLibrary_.fitsInBigInteger(child1Value_)) {
                                return SLMulNode.doInteropBigInteger(child0Value_, child1Value_, s2_.leftLibrary_, s2_.rightLibrary_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0x10) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary rightLibrary__;
                            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (leftLibrary__.fitsInBigInteger(child0Value_) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value_)) {
                                Object object = this.interopBigInteger1Boundary1(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0x20) != 0) {
                        SLMul_Node node__ = this;
                        if (this.fallbackGuard_(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp)) {
                            return SLMulNode.typeError(child0Value_, child1Value_, node__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
        }

        private long executeLong(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return SLTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp));
            }
            try {
                child1Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            try {
                return SLMulNode.doLong(child0Value_, child1Value_);
            }
            catch (ArithmeticException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int state_0 = this.state_0_;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                SLMul_Node.quicken(state_0, $bc, $bci);
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp));
            }
        }

        private long executeLong$unboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return SLTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp));
            }
            try {
                child1Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            try {
                return SLMulNode.doLong(child0Value_, child1Value_);
            }
            catch (ArithmeticException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int state_0 = this.state_0_;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                SLMul_Node.quicken(state_0, $bc, $bci);
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp));
            }
        }

        private boolean fallbackGuard_(int state_0, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            return (state_0 & 0x10) != 0 || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child0Value) || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary(int state_0, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLMulNode.doInteropBigInteger(child0Value, child1Value, leftLibrary__, rightLibrary__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary0(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLMulNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int sLBigIntegerCast0;
            int state_0 = this.state_0_;
            if ((state_0 & 0x1C) == 0 && (state_0 & 2) == 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    this.state_0_ = state_0 |= 1;
                    SLMul_Node.quicken(state_0, $bc, $bci);
                    try {
                        return SLMulNode.doLong(child0Value_, child1Value_);
                    }
                    catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        SLMul_Node.quicken(state_0, $bc, $bci);
                        return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                    }
                }
            }
            if ((state_0 & 0x18) == 0 && (sLBigIntegerCast0 = SLTypesGen.specializeImplicitSLBigInteger(child0Value)) != 0) {
                SLBigInteger child0Value_ = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast0, child0Value);
                int sLBigIntegerCast1 = SLTypesGen.specializeImplicitSLBigInteger(child1Value);
                if (sLBigIntegerCast1 != 0) {
                    SLBigInteger child1Value_ = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast1, child1Value);
                    state_0 &= 0xFFFFFFFE;
                    state_0 |= sLBigIntegerCast0 << 6;
                    state_0 |= sLBigIntegerCast1 << 8;
                    this.state_0_ = state_0 |= 4;
                    SLMul_Node.quicken(state_0, $bc, $bci);
                    return SLMulNode.doSLBigInteger(child0Value_, child1Value_);
                }
            }
            if ((state_0 & 0x10) == 0) {
                InteropBigInteger0Data s2_;
                block14: {
                    InteropBigInteger0Data s2_original;
                    do {
                        InteropLibrary rightLibrary__;
                        InteropLibrary leftLibrary__;
                        int count2_ = 0;
                        s2_original = s2_ = (InteropBigInteger0Data)((Object)INTEROP_BIG_INTEGER0_CACHE_UPDATER.getVolatile((Node)this));
                        while (!(s2_ == null || s2_.leftLibrary_.accepts(child0Value) && s2_.rightLibrary_.accepts(child1Value) && s2_.leftLibrary_.fitsInBigInteger(child0Value) && s2_.rightLibrary_.fitsInBigInteger(child1Value))) {
                            ++count2_;
                            s2_ = s2_.next_;
                        }
                        if (s2_ != null || !(leftLibrary__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child0Value)))).fitsInBigInteger(child0Value) || !(rightLibrary__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child1Value)))).fitsInBigInteger(child1Value) || count2_ >= 3) break block14;
                        s2_ = (InteropBigInteger0Data)this.insert(new InteropBigInteger0Data(s2_original));
                        Objects.requireNonNull((InteropLibrary)s2_.insert((Node)leftLibrary__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.leftLibrary_ = leftLibrary__;
                        Objects.requireNonNull((InteropLibrary)s2_.insert((Node)rightLibrary__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.rightLibrary_ = rightLibrary__;
                    } while (!INTEROP_BIG_INTEGER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                    state_0 &= 0xFFFFFFFA;
                    this.state_0_ = state_0 |= 8;
                    SLMul_Node.quicken(state_0, $bc, $bci);
                }
                if (s2_ != null) {
                    return SLMulNode.doInteropBigInteger(child0Value, child1Value, s2_.leftLibrary_, s2_.rightLibrary_);
                }
            }
            InteropLibrary rightLibrary__ = null;
            InteropLibrary leftLibrary__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                if (leftLibrary__.fitsInBigInteger(child0Value) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value)) {
                    this.interopBigInteger0_cache = null;
                    state_0 &= 0xFFFFFFF2;
                    this.state_0_ = state_0 |= 0x10;
                    SLMul_Node.quicken(state_0, $bc, $bci);
                    SLBigInteger sLBigInteger = SLMulNode.doInteropBigInteger(child0Value, child1Value, leftLibrary__, rightLibrary__);
                    return sLBigInteger;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            SLMul_Node node__ = null;
            node__ = this;
            this.state_0_ = state_0 |= 0x20;
            SLMul_Node.quicken(state_0, $bc, $bci);
            return SLMulNode.typeError(child0Value, child1Value, node__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary1(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLMulNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        private static void quicken(int state_0, byte[] $bc, int $bci) {
            int newInstruction;
            short newOperand1;
            short newOperand0;
            int oldOperandIndex0 = BYTES.getIntUnaligned($bc, $bci + 6);
            short oldOperand0 = BYTES.getShort($bc, oldOperandIndex0);
            int oldOperandIndex1 = BYTES.getIntUnaligned($bc, $bci + 10);
            short oldOperand1 = BYTES.getShort($bc, oldOperandIndex1);
            if ((state_0 & 0x3C) == 0 && (state_0 & 0x3D) != 0 && (newOperand0 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand0)) != -1 && (newOperand1 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand1)) != -1) {
                newInstruction = SLBytecodeRootNodeGen.isQuickeningLong(BYTES.getShort($bc, $bci)) ? 85 : 84;
            } else {
                newOperand0 = SLBytecodeRootNodeGen.undoQuickening(oldOperand0);
                newOperand1 = SLBytecodeRootNodeGen.undoQuickening(oldOperand1);
                newInstruction = 83;
            }
            BYTES.putShort($bc, oldOperandIndex0, newOperand0);
            BYTES.putShort($bc, oldOperandIndex1, newOperand1);
            BYTES.putShort($bc, $bci, (short)newInstruction);
        }

        @DenyReplace
        private static final class InteropBigInteger0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            InteropBigInteger0Data next_;
            @Node.Child
            InteropLibrary leftLibrary_;
            @Node.Child
            InteropLibrary rightLibrary_;

            InteropBigInteger0Data(InteropBigInteger0Data next_) {
                this.next_ = next_;
            }
        }

        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public Object executeUncached(VirtualFrame frameValue, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value)).fitsInBigInteger(child0Value) && ((InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value)).fitsInBigInteger(child1Value)) {
                    return SLMulNode.doInteropBigInteger(child0Value, child1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), (InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value));
                }
                return SLMulNode.typeError(child0Value, child1Value, (Node)$bytecode);
            }
        }
    }

    private static final class SLLogicalNot_Node
    extends Node {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private SLLogicalNot_Node() {
        }

        private boolean execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && child0Value_ instanceof Boolean) {
                    boolean child0Value__ = (Boolean)child0Value_;
                    return SLLogicalNotNode.doBoolean(child0Value__);
                }
                if ((state_0 & 2) != 0) {
                    SLLogicalNot_Node node__ = this;
                    if (this.fallbackGuard_(state_0, child0Value_, $bytecode, $bc, $bci, $sp)) {
                        return SLLogicalNotNode.typeError(child0Value_, node__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, $bytecode, $bc, $bci, $sp);
        }

        private boolean executeBoolean(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            boolean child0Value_;
            try {
                child0Value_ = FRAMES.expectBoolean((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            return SLLogicalNotNode.doBoolean(child0Value_);
        }

        private boolean executeBoolean$unboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            boolean child0Value_;
            try {
                child0Value_ = FRAMES.expectBoolean((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            return SLLogicalNotNode.doBoolean(child0Value_);
        }

        private boolean executeunboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && child0Value_ instanceof Boolean) {
                    boolean child0Value__ = (Boolean)child0Value_;
                    return SLLogicalNotNode.doBoolean(child0Value__);
                }
                if ((state_0 & 2) != 0) {
                    SLLogicalNot_Node node__ = this;
                    if (this.fallbackGuard_(state_0, child0Value_, $bytecode, $bc, $bci, $sp)) {
                        return SLLogicalNotNode.typeError(child0Value_, node__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, $bytecode, $bc, $bci, $sp);
        }

        private boolean fallbackGuard_(int state_0, Object child0Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            return (state_0 & 1) != 0 || !(child0Value instanceof Boolean);
        }

        private boolean executeAndSpecialize(Object child0Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int state_0 = this.state_0_;
            if (child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                this.state_0_ = state_0 |= 1;
                SLLogicalNot_Node.quicken(state_0, $bc, $bci);
                return SLLogicalNotNode.doBoolean(child0Value_);
            }
            SLLogicalNot_Node node__ = null;
            node__ = this;
            this.state_0_ = state_0 |= 2;
            SLLogicalNot_Node.quicken(state_0, $bc, $bci);
            return SLLogicalNotNode.typeError(child0Value, node__);
        }

        private static void quicken(int state_0, byte[] $bc, int $bci) {
            short newInstruction;
            short newOperand0;
            int oldOperandIndex0 = BYTES.getIntUnaligned($bc, $bci + 6);
            short oldOperand0 = BYTES.getShort($bc, oldOperandIndex0);
            if ((state_0 & 2) == 0 && state_0 != 0 && (newOperand0 = SLBytecodeRootNodeGen.applyQuickeningBoolean(oldOperand0)) != -1) {
                newInstruction = SLBytecodeRootNodeGen.isQuickeningBoolean(BYTES.getShort($bc, $bci)) ? (short)81 : 80;
            } else {
                newOperand0 = SLBytecodeRootNodeGen.undoQuickening(oldOperand0);
                newInstruction = SLBytecodeRootNodeGen.isQuickeningBoolean(BYTES.getShort($bc, $bci)) ? (short)82 : 79;
            }
            BYTES.putShort($bc, oldOperandIndex0, newOperand0);
            BYTES.putShort($bc, $bci, newInstruction);
        }

        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public boolean executeUncached(VirtualFrame frameValue, Object child0Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                if (child0Value instanceof Boolean) {
                    boolean child0Value_ = (Boolean)child0Value;
                    return SLLogicalNotNode.doBoolean(child0Value_);
                }
                return SLLogicalNotNode.typeError(child0Value, (Node)$bytecode);
            }
        }
    }

    private static final class SLLessThan_Node
    extends Node {
        static final InlineSupport.ReferenceField<InteropBigInteger0Data> INTEROP_BIG_INTEGER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"interopBigInteger0_cache", InteropBigInteger0Data.class);
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private InteropBigInteger0Data interopBigInteger0_cache;

        private SLLessThan_Node() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        private boolean execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child1Value_;
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            if ((state_0 & 0x1F) != 0) {
                if ((state_0 & 1) != 0 && child0Value_ instanceof Long) {
                    long child0Value__ = (Long)child0Value_;
                    if (child1Value_ instanceof Long) {
                        long child1Value__ = (Long)child1Value_;
                        return SLLessThanNode.doLong(child0Value__, child1Value__);
                    }
                }
                if ((state_0 & 2) != 0 && SLTypesGen.isImplicitSLBigInteger((state_0 & 0x60) >>> 5, child0Value_)) {
                    SLBigInteger child0Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x60) >>> 5, child0Value_);
                    if (SLTypesGen.isImplicitSLBigInteger((state_0 & 0x180) >>> 7, child1Value_)) {
                        SLBigInteger child1Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x180) >>> 7, child1Value_);
                        return SLLessThanNode.doSLBigInteger(child0Value__, child1Value__);
                    }
                }
                if ((state_0 & 0x1C) != 0) {
                    if ((state_0 & 4) != 0) {
                        InteropBigInteger0Data s2_ = this.interopBigInteger0_cache;
                        while (s2_ != null) {
                            if (s2_.leftLibrary_.accepts(child0Value_) && s2_.rightLibrary_.accepts(child1Value_) && s2_.leftLibrary_.fitsInBigInteger(child0Value_) && s2_.rightLibrary_.fitsInBigInteger(child1Value_)) {
                                return SLLessThanNode.doInteropBigInteger(child0Value_, child1Value_, s2_.leftLibrary_, s2_.rightLibrary_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary rightLibrary__;
                            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (leftLibrary__.fitsInBigInteger(child0Value_) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value_)) {
                                boolean bl = this.interopBigInteger1Boundary1(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                                return bl;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0x10) != 0) {
                        SLLessThan_Node node__ = this;
                        if (this.fallbackGuard_(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp)) {
                            return SLLessThanNode.typeError(child0Value_, child1Value_, node__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
        }

        private boolean executeLong(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            return SLLessThanNode.doLong(child0Value_, child1Value_);
        }

        private boolean executeLong$unboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            return SLLessThanNode.doLong(child0Value_, child1Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        private boolean executeunboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child1Value_;
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            if ((state_0 & 0x1F) != 0) {
                if ((state_0 & 1) != 0 && child0Value_ instanceof Long) {
                    long child0Value__ = (Long)child0Value_;
                    if (child1Value_ instanceof Long) {
                        long child1Value__ = (Long)child1Value_;
                        return SLLessThanNode.doLong(child0Value__, child1Value__);
                    }
                }
                if ((state_0 & 2) != 0 && SLTypesGen.isImplicitSLBigInteger((state_0 & 0x60) >>> 5, child0Value_)) {
                    SLBigInteger child0Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x60) >>> 5, child0Value_);
                    if (SLTypesGen.isImplicitSLBigInteger((state_0 & 0x180) >>> 7, child1Value_)) {
                        SLBigInteger child1Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x180) >>> 7, child1Value_);
                        return SLLessThanNode.doSLBigInteger(child0Value__, child1Value__);
                    }
                }
                if ((state_0 & 0x1C) != 0) {
                    if ((state_0 & 4) != 0) {
                        InteropBigInteger0Data s2_ = this.interopBigInteger0_cache;
                        while (s2_ != null) {
                            if (s2_.leftLibrary_.accepts(child0Value_) && s2_.rightLibrary_.accepts(child1Value_) && s2_.leftLibrary_.fitsInBigInteger(child0Value_) && s2_.rightLibrary_.fitsInBigInteger(child1Value_)) {
                                return SLLessThanNode.doInteropBigInteger(child0Value_, child1Value_, s2_.leftLibrary_, s2_.rightLibrary_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary rightLibrary__;
                            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (leftLibrary__.fitsInBigInteger(child0Value_) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value_)) {
                                boolean bl = this.interopBigInteger1Boundary2(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                                return bl;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0x10) != 0) {
                        SLLessThan_Node node__ = this;
                        if (this.fallbackGuard_(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp)) {
                            return SLLessThanNode.typeError(child0Value_, child1Value_, node__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
        }

        private boolean fallbackGuard_(int state_0, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            if ((state_0 & 1) == 0 && child0Value instanceof Long && child1Value instanceof Long) {
                return false;
            }
            return (state_0 & 8) != 0 || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child0Value) || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean interopBigInteger1Boundary(int state_0, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLLessThanNode.doInteropBigInteger(child0Value, child1Value, leftLibrary__, rightLibrary__);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean interopBigInteger1Boundary0(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLLessThanNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int sLBigIntegerCast0;
            int state_0 = this.state_0_;
            if (child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    this.state_0_ = state_0 |= 1;
                    SLLessThan_Node.quicken(state_0, $bc, $bci);
                    return SLLessThanNode.doLong(child0Value_, child1Value_);
                }
            }
            if ((state_0 & 0xC) == 0 && (sLBigIntegerCast0 = SLTypesGen.specializeImplicitSLBigInteger(child0Value)) != 0) {
                SLBigInteger child0Value_ = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast0, child0Value);
                int sLBigIntegerCast1 = SLTypesGen.specializeImplicitSLBigInteger(child1Value);
                if (sLBigIntegerCast1 != 0) {
                    SLBigInteger child1Value_ = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast1, child1Value);
                    state_0 |= sLBigIntegerCast0 << 5;
                    state_0 |= sLBigIntegerCast1 << 7;
                    this.state_0_ = state_0 |= 2;
                    SLLessThan_Node.quicken(state_0, $bc, $bci);
                    return SLLessThanNode.doSLBigInteger(child0Value_, child1Value_);
                }
            }
            if ((state_0 & 8) == 0) {
                InteropBigInteger0Data s2_;
                block12: {
                    InteropBigInteger0Data s2_original;
                    do {
                        InteropLibrary rightLibrary__;
                        InteropLibrary leftLibrary__;
                        int count2_ = 0;
                        s2_original = s2_ = (InteropBigInteger0Data)((Object)INTEROP_BIG_INTEGER0_CACHE_UPDATER.getVolatile((Node)this));
                        while (!(s2_ == null || s2_.leftLibrary_.accepts(child0Value) && s2_.rightLibrary_.accepts(child1Value) && s2_.leftLibrary_.fitsInBigInteger(child0Value) && s2_.rightLibrary_.fitsInBigInteger(child1Value))) {
                            ++count2_;
                            s2_ = s2_.next_;
                        }
                        if (s2_ != null || !(leftLibrary__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child0Value)))).fitsInBigInteger(child0Value) || !(rightLibrary__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child1Value)))).fitsInBigInteger(child1Value) || count2_ >= 3) break block12;
                        s2_ = (InteropBigInteger0Data)this.insert(new InteropBigInteger0Data(s2_original));
                        Objects.requireNonNull((InteropLibrary)s2_.insert((Node)leftLibrary__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.leftLibrary_ = leftLibrary__;
                        Objects.requireNonNull((InteropLibrary)s2_.insert((Node)rightLibrary__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.rightLibrary_ = rightLibrary__;
                    } while (!INTEROP_BIG_INTEGER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                    state_0 &= 0xFFFFFFFD;
                    this.state_0_ = state_0 |= 4;
                    SLLessThan_Node.quicken(state_0, $bc, $bci);
                }
                if (s2_ != null) {
                    return SLLessThanNode.doInteropBigInteger(child0Value, child1Value, s2_.leftLibrary_, s2_.rightLibrary_);
                }
            }
            InteropLibrary rightLibrary__ = null;
            InteropLibrary leftLibrary__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                if (leftLibrary__.fitsInBigInteger(child0Value) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value)) {
                    this.interopBigInteger0_cache = null;
                    state_0 &= 0xFFFFFFF9;
                    this.state_0_ = state_0 |= 8;
                    SLLessThan_Node.quicken(state_0, $bc, $bci);
                    boolean bl = SLLessThanNode.doInteropBigInteger(child0Value, child1Value, leftLibrary__, rightLibrary__);
                    return bl;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            SLLessThan_Node node__ = null;
            node__ = this;
            this.state_0_ = state_0 |= 0x10;
            SLLessThan_Node.quicken(state_0, $bc, $bci);
            return SLLessThanNode.typeError(child0Value, child1Value, node__);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean interopBigInteger1Boundary1(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLLessThanNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean interopBigInteger1Boundary2(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLLessThanNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        private static void quicken(int state_0, byte[] $bc, int $bci) {
            short newInstruction;
            short newOperand1;
            short newOperand0;
            int oldOperandIndex0 = BYTES.getIntUnaligned($bc, $bci + 6);
            short oldOperand0 = BYTES.getShort($bc, oldOperandIndex0);
            int oldOperandIndex1 = BYTES.getIntUnaligned($bc, $bci + 10);
            short oldOperand1 = BYTES.getShort($bc, oldOperandIndex1);
            if ((state_0 & 0x1E) == 0 && (state_0 & 0x1F) != 0 && (newOperand0 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand0)) != -1 && (newOperand1 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand1)) != -1) {
                newInstruction = SLBytecodeRootNodeGen.isQuickeningBoolean(BYTES.getShort($bc, $bci)) ? (short)77 : 76;
            } else {
                newOperand0 = SLBytecodeRootNodeGen.undoQuickening(oldOperand0);
                newOperand1 = SLBytecodeRootNodeGen.undoQuickening(oldOperand1);
                newInstruction = SLBytecodeRootNodeGen.isQuickeningBoolean(BYTES.getShort($bc, $bci)) ? (short)78 : 75;
            }
            BYTES.putShort($bc, oldOperandIndex0, newOperand0);
            BYTES.putShort($bc, oldOperandIndex1, newOperand1);
            BYTES.putShort($bc, $bci, newInstruction);
        }

        @DenyReplace
        private static final class InteropBigInteger0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            InteropBigInteger0Data next_;
            @Node.Child
            InteropLibrary leftLibrary_;
            @Node.Child
            InteropLibrary rightLibrary_;

            InteropBigInteger0Data(InteropBigInteger0Data next_) {
                this.next_ = next_;
            }
        }

        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public boolean executeUncached(VirtualFrame frameValue, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                if (child0Value instanceof Long) {
                    long child0Value_ = (Long)child0Value;
                    if (child1Value instanceof Long) {
                        long child1Value_ = (Long)child1Value;
                        return SLLessThanNode.doLong(child0Value_, child1Value_);
                    }
                }
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value)).fitsInBigInteger(child0Value) && ((InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value)).fitsInBigInteger(child1Value)) {
                    return SLLessThanNode.doInteropBigInteger(child0Value, child1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), (InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value));
                }
                return SLLessThanNode.typeError(child0Value, child1Value, (Node)$bytecode);
            }
        }
    }

    private static final class SLLessOrEqual_Node
    extends Node {
        static final InlineSupport.ReferenceField<InteropBigInteger0Data> INTEROP_BIG_INTEGER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"interopBigInteger0_cache", InteropBigInteger0Data.class);
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private InteropBigInteger0Data interopBigInteger0_cache;

        private SLLessOrEqual_Node() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        private Object execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child1Value_;
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            if ((state_0 & 0x1F) != 0) {
                if ((state_0 & 1) != 0 && child0Value_ instanceof Long) {
                    long child0Value__ = (Long)child0Value_;
                    if (child1Value_ instanceof Long) {
                        long child1Value__ = (Long)child1Value_;
                        return SLLessOrEqualNode.doLong(child0Value__, child1Value__);
                    }
                }
                if ((state_0 & 2) != 0 && SLTypesGen.isImplicitSLBigInteger((state_0 & 0x60) >>> 5, child0Value_)) {
                    SLBigInteger child0Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x60) >>> 5, child0Value_);
                    if (SLTypesGen.isImplicitSLBigInteger((state_0 & 0x180) >>> 7, child1Value_)) {
                        SLBigInteger child1Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x180) >>> 7, child1Value_);
                        return SLLessOrEqualNode.doSLBigInteger(child0Value__, child1Value__);
                    }
                }
                if ((state_0 & 0x1C) != 0) {
                    if ((state_0 & 4) != 0) {
                        InteropBigInteger0Data s2_ = this.interopBigInteger0_cache;
                        while (s2_ != null) {
                            if (s2_.leftLibrary_.accepts(child0Value_) && s2_.rightLibrary_.accepts(child1Value_) && s2_.leftLibrary_.fitsInBigInteger(child0Value_) && s2_.rightLibrary_.fitsInBigInteger(child1Value_)) {
                                return SLLessOrEqualNode.doInteropBigInteger(child0Value_, child1Value_, s2_.leftLibrary_, s2_.rightLibrary_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary rightLibrary__;
                            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (leftLibrary__.fitsInBigInteger(child0Value_) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value_)) {
                                Object object = this.interopBigInteger1Boundary1(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0x10) != 0) {
                        SLLessOrEqual_Node node__ = this;
                        if (this.fallbackGuard_(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp)) {
                            return SLLessOrEqualNode.typeError(child0Value_, child1Value_, node__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
        }

        private boolean executeLong(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return SLTypesGen.expectBoolean(this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp));
            }
            try {
                child1Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectBoolean(this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            return SLLessOrEqualNode.doLong(child0Value_, child1Value_);
        }

        private boolean executeLong$unboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return SLTypesGen.expectBoolean(this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp));
            }
            try {
                child1Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectBoolean(this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            return SLLessOrEqualNode.doLong(child0Value_, child1Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        private boolean executeSLBigInteger_InteropBigInteger0_InteropBigInteger1(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            Object child1Value_;
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return SLTypesGen.expectBoolean(this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp));
            }
            try {
                child1Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectBoolean(this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            if ((state_0 & 0xE) != 0) {
                if ((state_0 & 2) != 0 && SLTypesGen.isImplicitSLBigInteger((state_0 & 0x60) >>> 5, child0Value_)) {
                    SLBigInteger child0Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x60) >>> 5, child0Value_);
                    if (SLTypesGen.isImplicitSLBigInteger((state_0 & 0x180) >>> 7, child1Value_)) {
                        SLBigInteger child1Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x180) >>> 7, child1Value_);
                        return SLLessOrEqualNode.doSLBigInteger(child0Value__, child1Value__);
                    }
                }
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0) {
                        InteropBigInteger0Data s2_ = this.interopBigInteger0_cache;
                        while (s2_ != null) {
                            if (s2_.leftLibrary_.accepts(child0Value_) && s2_.rightLibrary_.accepts(child1Value_) && s2_.leftLibrary_.fitsInBigInteger(child0Value_) && s2_.rightLibrary_.fitsInBigInteger(child1Value_)) {
                                return SLLessOrEqualNode.doInteropBigInteger(child0Value_, child1Value_, s2_.leftLibrary_, s2_.rightLibrary_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary rightLibrary__;
                            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (leftLibrary__.fitsInBigInteger(child0Value_) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value_)) {
                                boolean bl = this.interopBigInteger1Boundary2(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                                return bl;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return SLTypesGen.expectBoolean(this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        private boolean executeSLBigInteger_InteropBigInteger0_InteropBigInteger1$unboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            Object child1Value_;
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return SLTypesGen.expectBoolean(this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp));
            }
            try {
                child1Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectBoolean(this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            if ((state_0 & 0xE) != 0) {
                if ((state_0 & 2) != 0 && SLTypesGen.isImplicitSLBigInteger((state_0 & 0x60) >>> 5, child0Value_)) {
                    SLBigInteger child0Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x60) >>> 5, child0Value_);
                    if (SLTypesGen.isImplicitSLBigInteger((state_0 & 0x180) >>> 7, child1Value_)) {
                        SLBigInteger child1Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x180) >>> 7, child1Value_);
                        return SLLessOrEqualNode.doSLBigInteger(child0Value__, child1Value__);
                    }
                }
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0) {
                        InteropBigInteger0Data s2_ = this.interopBigInteger0_cache;
                        while (s2_ != null) {
                            if (s2_.leftLibrary_.accepts(child0Value_) && s2_.rightLibrary_.accepts(child1Value_) && s2_.leftLibrary_.fitsInBigInteger(child0Value_) && s2_.rightLibrary_.fitsInBigInteger(child1Value_)) {
                                return SLLessOrEqualNode.doInteropBigInteger(child0Value_, child1Value_, s2_.leftLibrary_, s2_.rightLibrary_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary rightLibrary__;
                            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (leftLibrary__.fitsInBigInteger(child0Value_) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value_)) {
                                boolean bl = this.interopBigInteger1Boundary3(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                                return bl;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return SLTypesGen.expectBoolean(this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp));
        }

        private boolean fallbackGuard_(int state_0, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            if ((state_0 & 1) == 0 && child0Value instanceof Long && child1Value instanceof Long) {
                return false;
            }
            return (state_0 & 8) != 0 || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child0Value) || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary(int state_0, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLLessOrEqualNode.doInteropBigInteger(child0Value, child1Value, leftLibrary__, rightLibrary__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary0(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLLessOrEqualNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int sLBigIntegerCast0;
            int state_0 = this.state_0_;
            if (child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    this.state_0_ = state_0 |= 1;
                    SLLessOrEqual_Node.quicken(state_0, $bc, $bci);
                    return SLLessOrEqualNode.doLong(child0Value_, child1Value_);
                }
            }
            if ((state_0 & 0xC) == 0 && (sLBigIntegerCast0 = SLTypesGen.specializeImplicitSLBigInteger(child0Value)) != 0) {
                SLBigInteger child0Value_ = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast0, child0Value);
                int sLBigIntegerCast1 = SLTypesGen.specializeImplicitSLBigInteger(child1Value);
                if (sLBigIntegerCast1 != 0) {
                    SLBigInteger child1Value_ = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast1, child1Value);
                    state_0 |= sLBigIntegerCast0 << 5;
                    state_0 |= sLBigIntegerCast1 << 7;
                    this.state_0_ = state_0 |= 2;
                    SLLessOrEqual_Node.quicken(state_0, $bc, $bci);
                    return SLLessOrEqualNode.doSLBigInteger(child0Value_, child1Value_);
                }
            }
            if ((state_0 & 8) == 0) {
                InteropBigInteger0Data s2_;
                block12: {
                    InteropBigInteger0Data s2_original;
                    do {
                        InteropLibrary rightLibrary__;
                        InteropLibrary leftLibrary__;
                        int count2_ = 0;
                        s2_original = s2_ = (InteropBigInteger0Data)((Object)INTEROP_BIG_INTEGER0_CACHE_UPDATER.getVolatile((Node)this));
                        while (!(s2_ == null || s2_.leftLibrary_.accepts(child0Value) && s2_.rightLibrary_.accepts(child1Value) && s2_.leftLibrary_.fitsInBigInteger(child0Value) && s2_.rightLibrary_.fitsInBigInteger(child1Value))) {
                            ++count2_;
                            s2_ = s2_.next_;
                        }
                        if (s2_ != null || !(leftLibrary__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child0Value)))).fitsInBigInteger(child0Value) || !(rightLibrary__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child1Value)))).fitsInBigInteger(child1Value) || count2_ >= 3) break block12;
                        s2_ = (InteropBigInteger0Data)this.insert(new InteropBigInteger0Data(s2_original));
                        Objects.requireNonNull((InteropLibrary)s2_.insert((Node)leftLibrary__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.leftLibrary_ = leftLibrary__;
                        Objects.requireNonNull((InteropLibrary)s2_.insert((Node)rightLibrary__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.rightLibrary_ = rightLibrary__;
                    } while (!INTEROP_BIG_INTEGER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                    state_0 &= 0xFFFFFFFD;
                    this.state_0_ = state_0 |= 4;
                    SLLessOrEqual_Node.quicken(state_0, $bc, $bci);
                }
                if (s2_ != null) {
                    return SLLessOrEqualNode.doInteropBigInteger(child0Value, child1Value, s2_.leftLibrary_, s2_.rightLibrary_);
                }
            }
            InteropLibrary rightLibrary__ = null;
            InteropLibrary leftLibrary__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                if (leftLibrary__.fitsInBigInteger(child0Value) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value)) {
                    this.interopBigInteger0_cache = null;
                    state_0 &= 0xFFFFFFF9;
                    this.state_0_ = state_0 |= 8;
                    SLLessOrEqual_Node.quicken(state_0, $bc, $bci);
                    Boolean bl = SLLessOrEqualNode.doInteropBigInteger(child0Value, child1Value, leftLibrary__, rightLibrary__);
                    return bl;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            SLLessOrEqual_Node node__ = null;
            node__ = this;
            this.state_0_ = state_0 |= 0x10;
            SLLessOrEqual_Node.quicken(state_0, $bc, $bci);
            return SLLessOrEqualNode.typeError(child0Value, child1Value, node__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary1(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLLessOrEqualNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean interopBigInteger1Boundary2(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLLessOrEqualNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean interopBigInteger1Boundary3(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLLessOrEqualNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        private static void quicken(int state_0, byte[] $bc, int $bci) {
            int newInstruction;
            short newOperand1;
            short newOperand0;
            int oldOperandIndex0 = BYTES.getIntUnaligned($bc, $bci + 6);
            short oldOperand0 = BYTES.getShort($bc, oldOperandIndex0);
            int oldOperandIndex1 = BYTES.getIntUnaligned($bc, $bci + 10);
            short oldOperand1 = BYTES.getShort($bc, oldOperandIndex1);
            if ((state_0 & 0x1E) == 0 && (state_0 & 0x1F) != 0 && (newOperand0 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand0)) != -1 && (newOperand1 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand1)) != -1) {
                newInstruction = SLBytecodeRootNodeGen.isQuickeningBoolean(BYTES.getShort($bc, $bci)) ? 72 : 71;
            } else if ((state_0 & 0x11) == 0 && (state_0 & 0x1F) != 0 && (state_0 & 0x60) >>> 5 == 2 && (state_0 & 0x180) >>> 7 == 2) {
                newOperand0 = SLBytecodeRootNodeGen.undoQuickening(oldOperand0);
                newOperand1 = SLBytecodeRootNodeGen.undoQuickening(oldOperand1);
                newInstruction = SLBytecodeRootNodeGen.isQuickeningBoolean(BYTES.getShort($bc, $bci)) ? 74 : 73;
            } else {
                newOperand0 = SLBytecodeRootNodeGen.undoQuickening(oldOperand0);
                newOperand1 = SLBytecodeRootNodeGen.undoQuickening(oldOperand1);
                newInstruction = 70;
            }
            BYTES.putShort($bc, oldOperandIndex0, newOperand0);
            BYTES.putShort($bc, oldOperandIndex1, newOperand1);
            BYTES.putShort($bc, $bci, (short)newInstruction);
        }

        @DenyReplace
        private static final class InteropBigInteger0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            InteropBigInteger0Data next_;
            @Node.Child
            InteropLibrary leftLibrary_;
            @Node.Child
            InteropLibrary rightLibrary_;

            InteropBigInteger0Data(InteropBigInteger0Data next_) {
                this.next_ = next_;
            }
        }

        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public Object executeUncached(VirtualFrame frameValue, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                if (child0Value instanceof Long) {
                    long child0Value_ = (Long)child0Value;
                    if (child1Value instanceof Long) {
                        long child1Value_ = (Long)child1Value;
                        return SLLessOrEqualNode.doLong(child0Value_, child1Value_);
                    }
                }
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value)).fitsInBigInteger(child0Value) && ((InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value)).fitsInBigInteger(child1Value)) {
                    return SLLessOrEqualNode.doInteropBigInteger(child0Value, child1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), (InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value));
                }
                return SLLessOrEqualNode.typeError(child0Value, child1Value, (Node)$bytecode);
            }
        }
    }

    private static final class SLEqual_Node
    extends Node {
        static final InlineSupport.ReferenceField<Generic0Data> GENERIC0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"generic0_cache", Generic0Data.class);
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private TruffleString.EqualNode truffleString_equalNode_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private Generic0Data generic0_cache;

        private SLEqual_Node() {
        }

        @ExplodeLoop
        private boolean execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child1Value_;
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            if ((state_0 & 0x1FF) != 0) {
                Object child1Value__;
                if ((state_0 & 1) != 0 && child0Value_ instanceof Long) {
                    long child0Value__ = (Long)child0Value_;
                    if (child1Value_ instanceof Long) {
                        long child1Value__2 = (Long)child1Value_;
                        return SLEqualNode.doLong(child0Value__, child1Value__2);
                    }
                }
                if ((state_0 & 2) != 0 && SLTypesGen.isImplicitSLBigInteger((state_0 & 0x600) >>> 9, child0Value_)) {
                    SLBigInteger child0Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x600) >>> 9, child0Value_);
                    if (SLTypesGen.isImplicitSLBigInteger((state_0 & 0x1800) >>> 11, child1Value_)) {
                        SLBigInteger child1Value__3 = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x1800) >>> 11, child1Value_);
                        return SLEqualNode.doBigNumber(child0Value__, child1Value__3);
                    }
                }
                if ((state_0 & 4) != 0 && child0Value_ instanceof Boolean) {
                    boolean child0Value__ = (Boolean)child0Value_;
                    if (child1Value_ instanceof Boolean) {
                        boolean child1Value__4 = (Boolean)child1Value_;
                        return SLEqualNode.doBoolean(child0Value__, child1Value__4);
                    }
                }
                if ((state_0 & 8) != 0 && child0Value_ instanceof String) {
                    String child0Value__ = (String)child0Value_;
                    if (child1Value_ instanceof String) {
                        String child1Value__5 = (String)child1Value_;
                        return SLEqualNode.doString(child0Value__, child1Value__5);
                    }
                }
                if ((state_0 & 0x10) != 0 && child0Value_ instanceof TruffleString) {
                    TruffleString child0Value__ = (TruffleString)child0Value_;
                    if (child1Value_ instanceof TruffleString) {
                        child1Value__ = (TruffleString)child1Value_;
                        TruffleString.EqualNode equalNode__ = this.truffleString_equalNode_;
                        if (equalNode__ != null) {
                            return SLEqualNode.doTruffleString(child0Value__, child1Value__, equalNode__);
                        }
                    }
                }
                if ((state_0 & 0x20) != 0 && SLTypes.isSLNull(child0Value_)) {
                    SLNull child0Value__ = SLTypes.asSLNull(child0Value_);
                    if (SLTypes.isSLNull(child1Value_)) {
                        child1Value__ = SLTypes.asSLNull(child1Value_);
                        return SLEqualNode.doNull(child0Value__, (SLNull)child1Value__);
                    }
                }
                if ((state_0 & 0x1C0) != 0) {
                    if ((state_0 & 0x40) != 0 && child0Value_ instanceof SLFunction) {
                        SLFunction child0Value__ = (SLFunction)child0Value_;
                        return SLEqualNode.doFunction(child0Value__, child1Value_);
                    }
                    if ((state_0 & 0x180) != 0) {
                        if ((state_0 & 0x80) != 0) {
                            Generic0Data s7_ = this.generic0_cache;
                            while (s7_ != null) {
                                if (s7_.leftInterop_.accepts(child0Value_) && s7_.rightInterop_.accepts(child1Value_)) {
                                    return SLEqualNode.doGeneric(child0Value_, child1Value_, s7_.leftInterop_, s7_.rightInterop_);
                                }
                                s7_ = s7_.next_;
                            }
                        }
                        if ((state_0 & 0x100) != 0) {
                            return this.generic1Boundary1(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
        }

        private boolean executeLong(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            return SLEqualNode.doLong(child0Value_, child1Value_);
        }

        private boolean executeLong$unboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            return SLEqualNode.doLong(child0Value_, child1Value_);
        }

        private boolean executeBoolean(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            boolean child1Value_;
            boolean child0Value_;
            try {
                child0Value_ = FRAMES.expectBoolean((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectBoolean((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            return SLEqualNode.doBoolean(child0Value_, child1Value_);
        }

        private boolean executeBoolean$unboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            boolean child1Value_;
            boolean child0Value_;
            try {
                child0Value_ = FRAMES.expectBoolean((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectBoolean((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            return SLEqualNode.doBoolean(child0Value_, child1Value_);
        }

        @ExplodeLoop
        private boolean executeunboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child1Value_;
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            if ((state_0 & 0x1FF) != 0) {
                Object child1Value__;
                if ((state_0 & 1) != 0 && child0Value_ instanceof Long) {
                    long child0Value__ = (Long)child0Value_;
                    if (child1Value_ instanceof Long) {
                        long child1Value__2 = (Long)child1Value_;
                        return SLEqualNode.doLong(child0Value__, child1Value__2);
                    }
                }
                if ((state_0 & 2) != 0 && SLTypesGen.isImplicitSLBigInteger((state_0 & 0x600) >>> 9, child0Value_)) {
                    SLBigInteger child0Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x600) >>> 9, child0Value_);
                    if (SLTypesGen.isImplicitSLBigInteger((state_0 & 0x1800) >>> 11, child1Value_)) {
                        SLBigInteger child1Value__3 = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x1800) >>> 11, child1Value_);
                        return SLEqualNode.doBigNumber(child0Value__, child1Value__3);
                    }
                }
                if ((state_0 & 4) != 0 && child0Value_ instanceof Boolean) {
                    boolean child0Value__ = (Boolean)child0Value_;
                    if (child1Value_ instanceof Boolean) {
                        boolean child1Value__4 = (Boolean)child1Value_;
                        return SLEqualNode.doBoolean(child0Value__, child1Value__4);
                    }
                }
                if ((state_0 & 8) != 0 && child0Value_ instanceof String) {
                    String child0Value__ = (String)child0Value_;
                    if (child1Value_ instanceof String) {
                        String child1Value__5 = (String)child1Value_;
                        return SLEqualNode.doString(child0Value__, child1Value__5);
                    }
                }
                if ((state_0 & 0x10) != 0 && child0Value_ instanceof TruffleString) {
                    TruffleString child0Value__ = (TruffleString)child0Value_;
                    if (child1Value_ instanceof TruffleString) {
                        child1Value__ = (TruffleString)child1Value_;
                        TruffleString.EqualNode equalNode__ = this.truffleString_equalNode_;
                        if (equalNode__ != null) {
                            return SLEqualNode.doTruffleString(child0Value__, child1Value__, equalNode__);
                        }
                    }
                }
                if ((state_0 & 0x20) != 0 && SLTypes.isSLNull(child0Value_)) {
                    SLNull child0Value__ = SLTypes.asSLNull(child0Value_);
                    if (SLTypes.isSLNull(child1Value_)) {
                        child1Value__ = SLTypes.asSLNull(child1Value_);
                        return SLEqualNode.doNull(child0Value__, (SLNull)child1Value__);
                    }
                }
                if ((state_0 & 0x1C0) != 0) {
                    if ((state_0 & 0x40) != 0 && child0Value_ instanceof SLFunction) {
                        SLFunction child0Value__ = (SLFunction)child0Value_;
                        return SLEqualNode.doFunction(child0Value__, child1Value_);
                    }
                    if ((state_0 & 0x180) != 0) {
                        if ((state_0 & 0x80) != 0) {
                            Generic0Data s7_ = this.generic0_cache;
                            while (s7_ != null) {
                                if (s7_.leftInterop_.accepts(child0Value_) && s7_.rightInterop_.accepts(child1Value_)) {
                                    return SLEqualNode.doGeneric(child0Value_, child1Value_, s7_.leftInterop_, s7_.rightInterop_);
                                }
                                s7_ = s7_.next_;
                            }
                        }
                        if ((state_0 & 0x100) != 0) {
                            return this.generic1Boundary2(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private boolean generic1Boundary(int state_0, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary leftInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value);
                InteropLibrary rightInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value);
                boolean bl = SLEqualNode.doGeneric(child0Value, child1Value, leftInterop__, rightInterop__);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private boolean generic1Boundary0(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary leftInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_);
                InteropLibrary rightInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value_);
                boolean bl = SLEqualNode.doGeneric(child0Value_, child1Value_, leftInterop__, rightInterop__);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child1Value_;
            int sLBigIntegerCast0;
            int state_0 = this.state_0_;
            if (child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                if (child1Value instanceof Long) {
                    long child1Value_2 = (Long)child1Value;
                    this.state_0_ = state_0 |= 1;
                    SLEqual_Node.quicken(state_0, $bc, $bci);
                    return SLEqualNode.doLong(child0Value_, child1Value_2);
                }
            }
            if ((sLBigIntegerCast0 = SLTypesGen.specializeImplicitSLBigInteger(child0Value)) != 0) {
                SLBigInteger child0Value_ = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast0, child0Value);
                int sLBigIntegerCast1 = SLTypesGen.specializeImplicitSLBigInteger(child1Value);
                if (sLBigIntegerCast1 != 0) {
                    SLBigInteger child1Value_3 = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast1, child1Value);
                    state_0 |= sLBigIntegerCast0 << 9;
                    state_0 |= sLBigIntegerCast1 << 11;
                    this.state_0_ = state_0 |= 2;
                    SLEqual_Node.quicken(state_0, $bc, $bci);
                    return SLEqualNode.doBigNumber(child0Value_, child1Value_3);
                }
            }
            if (child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                if (child1Value instanceof Boolean) {
                    boolean child1Value_4 = (Boolean)child1Value;
                    this.state_0_ = state_0 |= 4;
                    SLEqual_Node.quicken(state_0, $bc, $bci);
                    return SLEqualNode.doBoolean(child0Value_, child1Value_4);
                }
            }
            if (child0Value instanceof String) {
                String child0Value_ = (String)child0Value;
                if (child1Value instanceof String) {
                    child1Value_ = (String)child1Value;
                    this.state_0_ = state_0 |= 8;
                    SLEqual_Node.quicken(state_0, $bc, $bci);
                    return SLEqualNode.doString(child0Value_, (String)child1Value_);
                }
            }
            if (child0Value instanceof TruffleString) {
                TruffleString child0Value_ = (TruffleString)child0Value;
                if (child1Value instanceof TruffleString) {
                    child1Value_ = (TruffleString)child1Value;
                    TruffleString.EqualNode equalNode__ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    Objects.requireNonNull(equalNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.truffleString_equalNode_ = equalNode__;
                    this.state_0_ = state_0 |= 0x10;
                    SLEqual_Node.quicken(state_0, $bc, $bci);
                    return SLEqualNode.doTruffleString(child0Value_, (TruffleString)child1Value_, equalNode__);
                }
            }
            if (SLTypes.isSLNull(child0Value)) {
                SLNull child0Value_ = SLTypes.asSLNull(child0Value);
                if (SLTypes.isSLNull(child1Value)) {
                    child1Value_ = SLTypes.asSLNull(child1Value);
                    this.state_0_ = state_0 |= 0x20;
                    SLEqual_Node.quicken(state_0, $bc, $bci);
                    return SLEqualNode.doNull(child0Value_, (SLNull)child1Value_);
                }
            }
            if (child0Value instanceof SLFunction) {
                SLFunction child0Value_ = (SLFunction)child0Value;
                this.state_0_ = state_0 |= 0x40;
                SLEqual_Node.quicken(state_0, $bc, $bci);
                return SLEqualNode.doFunction(child0Value_, child1Value);
            }
            if ((state_0 & 0x100) == 0) {
                Generic0Data s7_;
                block20: {
                    Generic0Data s7_original;
                    do {
                        int count7_ = 0;
                        s7_original = s7_ = (Generic0Data)((Object)GENERIC0_CACHE_UPDATER.getVolatile((Node)this));
                        while (!(s7_ == null || s7_.leftInterop_.accepts(child0Value) && s7_.rightInterop_.accepts(child1Value))) {
                            ++count7_;
                            s7_ = s7_.next_;
                        }
                        if (s7_ != null || count7_ >= 4) break block20;
                        s7_ = (Generic0Data)this.insert(new Generic0Data(s7_original));
                        InteropLibrary leftInterop__ = (InteropLibrary)s7_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child0Value)));
                        Objects.requireNonNull(leftInterop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s7_.leftInterop_ = leftInterop__;
                        InteropLibrary rightInterop__ = (InteropLibrary)s7_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child1Value)));
                        Objects.requireNonNull(rightInterop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s7_.rightInterop_ = rightInterop__;
                    } while (!GENERIC0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s7_original, (Object)s7_));
                    this.state_0_ = state_0 |= 0x80;
                    SLEqual_Node.quicken(state_0, $bc, $bci);
                }
                if (s7_ != null) {
                    return SLEqualNode.doGeneric(child0Value, child1Value, s7_.leftInterop_, s7_.rightInterop_);
                }
            }
            InteropLibrary rightInterop__ = null;
            InteropLibrary leftInterop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                leftInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value);
                rightInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value);
                this.generic0_cache = null;
                state_0 &= 0xFFFFFF7F;
                this.state_0_ = state_0 |= 0x100;
                SLEqual_Node.quicken(state_0, $bc, $bci);
                boolean bl = SLEqualNode.doGeneric(child0Value, child1Value, leftInterop__, rightInterop__);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private boolean generic1Boundary1(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary leftInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_);
                InteropLibrary rightInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value_);
                boolean bl = SLEqualNode.doGeneric(child0Value_, child1Value_, leftInterop__, rightInterop__);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private boolean generic1Boundary2(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary leftInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_);
                InteropLibrary rightInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value_);
                boolean bl = SLEqualNode.doGeneric(child0Value_, child1Value_, leftInterop__, rightInterop__);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        private static void quicken(int state_0, byte[] $bc, int $bci) {
            short newInstruction;
            short newOperand1;
            short newOperand0;
            int oldOperandIndex0 = BYTES.getIntUnaligned($bc, $bci + 6);
            short oldOperand0 = BYTES.getShort($bc, oldOperandIndex0);
            int oldOperandIndex1 = BYTES.getIntUnaligned($bc, $bci + 10);
            short oldOperand1 = BYTES.getShort($bc, oldOperandIndex1);
            if ((state_0 & 0x1FE) == 0 && (state_0 & 0x1FF) != 0 && (newOperand0 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand0)) != -1 && (newOperand1 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand1)) != -1) {
                newInstruction = SLBytecodeRootNodeGen.isQuickeningBoolean(BYTES.getShort($bc, $bci)) ? (short)66 : 65;
            } else if ((state_0 & 0x1FB) == 0 && (state_0 & 0x1FF) != 0 && (newOperand0 = SLBytecodeRootNodeGen.applyQuickeningBoolean(oldOperand0)) != -1 && (newOperand1 = SLBytecodeRootNodeGen.applyQuickeningBoolean(oldOperand1)) != -1) {
                newInstruction = SLBytecodeRootNodeGen.isQuickeningBoolean(BYTES.getShort($bc, $bci)) ? (short)68 : 67;
            } else {
                newOperand0 = SLBytecodeRootNodeGen.undoQuickening(oldOperand0);
                newOperand1 = SLBytecodeRootNodeGen.undoQuickening(oldOperand1);
                newInstruction = SLBytecodeRootNodeGen.isQuickeningBoolean(BYTES.getShort($bc, $bci)) ? (short)69 : 64;
            }
            BYTES.putShort($bc, oldOperandIndex0, newOperand0);
            BYTES.putShort($bc, oldOperandIndex1, newOperand1);
            BYTES.putShort($bc, $bci, newInstruction);
        }

        @DenyReplace
        private static final class Generic0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            Generic0Data next_;
            @Node.Child
            InteropLibrary leftInterop_;
            @Node.Child
            InteropLibrary rightInterop_;

            Generic0Data(Generic0Data next_) {
                this.next_ = next_;
            }
        }

        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public boolean executeUncached(VirtualFrame frameValue, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                if (child0Value instanceof Long) {
                    long child0Value_ = (Long)child0Value;
                    if (child1Value instanceof Long) {
                        long child1Value_ = (Long)child1Value;
                        return SLEqualNode.doLong(child0Value_, child1Value_);
                    }
                }
                if (SLTypesGen.isImplicitSLBigInteger(child0Value)) {
                    SLBigInteger child0Value_ = SLTypesGen.asImplicitSLBigInteger(child0Value);
                    if (SLTypesGen.isImplicitSLBigInteger(child1Value)) {
                        SLBigInteger child1Value_ = SLTypesGen.asImplicitSLBigInteger(child1Value);
                        return SLEqualNode.doBigNumber(child0Value_, child1Value_);
                    }
                }
                if (child0Value instanceof Boolean) {
                    boolean child0Value_ = (Boolean)child0Value;
                    if (child1Value instanceof Boolean) {
                        boolean child1Value_ = (Boolean)child1Value;
                        return SLEqualNode.doBoolean(child0Value_, child1Value_);
                    }
                }
                if (child0Value instanceof String) {
                    String child0Value_ = (String)child0Value;
                    if (child1Value instanceof String) {
                        String child1Value_ = (String)child1Value;
                        return SLEqualNode.doString(child0Value_, child1Value_);
                    }
                }
                if (child0Value instanceof TruffleString) {
                    TruffleString child0Value_ = (TruffleString)child0Value;
                    if (child1Value instanceof TruffleString) {
                        TruffleString child1Value_ = (TruffleString)child1Value;
                        return SLEqualNode.doTruffleString(child0Value_, child1Value_, TruffleString.EqualNode.getUncached());
                    }
                }
                if (SLTypes.isSLNull(child0Value)) {
                    SLNull child0Value_ = SLTypes.asSLNull(child0Value);
                    if (SLTypes.isSLNull(child1Value)) {
                        SLNull child1Value_ = SLTypes.asSLNull(child1Value);
                        return SLEqualNode.doNull(child0Value_, child1Value_);
                    }
                }
                if (child0Value instanceof SLFunction) {
                    SLFunction child0Value_ = (SLFunction)child0Value;
                    return SLEqualNode.doFunction(child0Value_, child1Value);
                }
                return SLEqualNode.doGeneric(child0Value, child1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), (InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value));
            }
        }
    }

    private static final class SLDiv_Node
    extends Node {
        static final InlineSupport.ReferenceField<InteropBigInteger0Data> INTEROP_BIG_INTEGER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"interopBigInteger0_cache", InteropBigInteger0Data.class);
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private InteropBigInteger0Data interopBigInteger0_cache;

        private SLDiv_Node() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        private Object execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child1Value_;
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            if ((state_0 & 0x3D) != 0) {
                if ((state_0 & 1) != 0 && child0Value_ instanceof Long) {
                    long child0Value__ = (Long)child0Value_;
                    if (child1Value_ instanceof Long) {
                        long child1Value__ = (Long)child1Value_;
                        try {
                            return SLDivNode.doLong(child0Value__, child1Value__);
                        }
                        catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFE;
                            this.state_0_ = state_0 |= 2;
                            SLDiv_Node.quicken(state_0, $bc, $bci);
                            return this.executeAndSpecialize(child0Value__, child1Value__, $bytecode, $bc, $bci, $sp);
                        }
                    }
                }
                if ((state_0 & 4) != 0 && SLTypesGen.isImplicitSLBigInteger((state_0 & 0xC0) >>> 6, child0Value_)) {
                    SLBigInteger child0Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0xC0) >>> 6, child0Value_);
                    if (SLTypesGen.isImplicitSLBigInteger((state_0 & 0x300) >>> 8, child1Value_)) {
                        SLBigInteger child1Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x300) >>> 8, child1Value_);
                        return SLDivNode.doSLBigInteger(child0Value__, child1Value__);
                    }
                }
                if ((state_0 & 0x38) != 0) {
                    if ((state_0 & 8) != 0) {
                        InteropBigInteger0Data s2_ = this.interopBigInteger0_cache;
                        while (s2_ != null) {
                            if (s2_.leftLibrary_.accepts(child0Value_) && s2_.rightLibrary_.accepts(child1Value_) && s2_.leftLibrary_.fitsInBigInteger(child0Value_) && s2_.rightLibrary_.fitsInBigInteger(child1Value_)) {
                                return SLDivNode.doInteropBigInteger(child0Value_, child1Value_, s2_.leftLibrary_, s2_.rightLibrary_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0x10) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary rightLibrary__;
                            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (leftLibrary__.fitsInBigInteger(child0Value_) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value_)) {
                                Object object = this.interopBigInteger1Boundary1(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0x20) != 0) {
                        SLDiv_Node node__ = this;
                        if (this.fallbackGuard_(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp)) {
                            return SLDivNode.typeError(child0Value_, child1Value_, node__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
        }

        private long executeLong(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return SLTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp));
            }
            try {
                child1Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            try {
                return SLDivNode.doLong(child0Value_, child1Value_);
            }
            catch (ArithmeticException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int state_0 = this.state_0_;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                SLDiv_Node.quicken(state_0, $bc, $bci);
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp));
            }
        }

        private long executeLong$unboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return SLTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp));
            }
            try {
                child1Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            try {
                return SLDivNode.doLong(child0Value_, child1Value_);
            }
            catch (ArithmeticException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int state_0 = this.state_0_;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                SLDiv_Node.quicken(state_0, $bc, $bci);
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp));
            }
        }

        private boolean fallbackGuard_(int state_0, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            return (state_0 & 0x10) != 0 || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child0Value) || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary(int state_0, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLDivNode.doInteropBigInteger(child0Value, child1Value, leftLibrary__, rightLibrary__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary0(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLDivNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int sLBigIntegerCast0;
            int state_0 = this.state_0_;
            if ((state_0 & 0x1C) == 0 && (state_0 & 2) == 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    this.state_0_ = state_0 |= 1;
                    SLDiv_Node.quicken(state_0, $bc, $bci);
                    try {
                        return SLDivNode.doLong(child0Value_, child1Value_);
                    }
                    catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        SLDiv_Node.quicken(state_0, $bc, $bci);
                        return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                    }
                }
            }
            if ((state_0 & 0x18) == 0 && (sLBigIntegerCast0 = SLTypesGen.specializeImplicitSLBigInteger(child0Value)) != 0) {
                SLBigInteger child0Value_ = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast0, child0Value);
                int sLBigIntegerCast1 = SLTypesGen.specializeImplicitSLBigInteger(child1Value);
                if (sLBigIntegerCast1 != 0) {
                    SLBigInteger child1Value_ = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast1, child1Value);
                    state_0 &= 0xFFFFFFFE;
                    state_0 |= sLBigIntegerCast0 << 6;
                    state_0 |= sLBigIntegerCast1 << 8;
                    this.state_0_ = state_0 |= 4;
                    SLDiv_Node.quicken(state_0, $bc, $bci);
                    return SLDivNode.doSLBigInteger(child0Value_, child1Value_);
                }
            }
            if ((state_0 & 0x10) == 0) {
                InteropBigInteger0Data s2_;
                block14: {
                    InteropBigInteger0Data s2_original;
                    do {
                        InteropLibrary rightLibrary__;
                        InteropLibrary leftLibrary__;
                        int count2_ = 0;
                        s2_original = s2_ = (InteropBigInteger0Data)((Object)INTEROP_BIG_INTEGER0_CACHE_UPDATER.getVolatile((Node)this));
                        while (!(s2_ == null || s2_.leftLibrary_.accepts(child0Value) && s2_.rightLibrary_.accepts(child1Value) && s2_.leftLibrary_.fitsInBigInteger(child0Value) && s2_.rightLibrary_.fitsInBigInteger(child1Value))) {
                            ++count2_;
                            s2_ = s2_.next_;
                        }
                        if (s2_ != null || !(leftLibrary__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child0Value)))).fitsInBigInteger(child0Value) || !(rightLibrary__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child1Value)))).fitsInBigInteger(child1Value) || count2_ >= 3) break block14;
                        s2_ = (InteropBigInteger0Data)this.insert(new InteropBigInteger0Data(s2_original));
                        Objects.requireNonNull((InteropLibrary)s2_.insert((Node)leftLibrary__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.leftLibrary_ = leftLibrary__;
                        Objects.requireNonNull((InteropLibrary)s2_.insert((Node)rightLibrary__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.rightLibrary_ = rightLibrary__;
                    } while (!INTEROP_BIG_INTEGER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                    state_0 &= 0xFFFFFFFA;
                    this.state_0_ = state_0 |= 8;
                    SLDiv_Node.quicken(state_0, $bc, $bci);
                }
                if (s2_ != null) {
                    return SLDivNode.doInteropBigInteger(child0Value, child1Value, s2_.leftLibrary_, s2_.rightLibrary_);
                }
            }
            InteropLibrary rightLibrary__ = null;
            InteropLibrary leftLibrary__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                if (leftLibrary__.fitsInBigInteger(child0Value) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value)) {
                    this.interopBigInteger0_cache = null;
                    state_0 &= 0xFFFFFFF2;
                    this.state_0_ = state_0 |= 0x10;
                    SLDiv_Node.quicken(state_0, $bc, $bci);
                    SLBigInteger sLBigInteger = SLDivNode.doInteropBigInteger(child0Value, child1Value, leftLibrary__, rightLibrary__);
                    return sLBigInteger;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            SLDiv_Node node__ = null;
            node__ = this;
            this.state_0_ = state_0 |= 0x20;
            SLDiv_Node.quicken(state_0, $bc, $bci);
            return SLDivNode.typeError(child0Value, child1Value, node__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary1(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLDivNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        private static void quicken(int state_0, byte[] $bc, int $bci) {
            int newInstruction;
            short newOperand1;
            short newOperand0;
            int oldOperandIndex0 = BYTES.getIntUnaligned($bc, $bci + 6);
            short oldOperand0 = BYTES.getShort($bc, oldOperandIndex0);
            int oldOperandIndex1 = BYTES.getIntUnaligned($bc, $bci + 10);
            short oldOperand1 = BYTES.getShort($bc, oldOperandIndex1);
            if ((state_0 & 0x3C) == 0 && (state_0 & 0x3D) != 0 && (newOperand0 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand0)) != -1 && (newOperand1 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand1)) != -1) {
                newInstruction = SLBytecodeRootNodeGen.isQuickeningLong(BYTES.getShort($bc, $bci)) ? 63 : 62;
            } else {
                newOperand0 = SLBytecodeRootNodeGen.undoQuickening(oldOperand0);
                newOperand1 = SLBytecodeRootNodeGen.undoQuickening(oldOperand1);
                newInstruction = 61;
            }
            BYTES.putShort($bc, oldOperandIndex0, newOperand0);
            BYTES.putShort($bc, oldOperandIndex1, newOperand1);
            BYTES.putShort($bc, $bci, (short)newInstruction);
        }

        @DenyReplace
        private static final class InteropBigInteger0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            InteropBigInteger0Data next_;
            @Node.Child
            InteropLibrary leftLibrary_;
            @Node.Child
            InteropLibrary rightLibrary_;

            InteropBigInteger0Data(InteropBigInteger0Data next_) {
                this.next_ = next_;
            }
        }

        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public Object executeUncached(VirtualFrame frameValue, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value)).fitsInBigInteger(child0Value) && ((InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value)).fitsInBigInteger(child1Value)) {
                    return SLDivNode.doInteropBigInteger(child0Value, child1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), (InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value));
                }
                return SLDivNode.typeError(child0Value, child1Value, (Node)$bytecode);
            }
        }
    }

    private static final class SLAdd_Node
    extends Node {
        private static final InlineSupport.StateField STRING_SL_ADD_NODE_STRING_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)StringData.lookup_(), (String)"string_state_0_");
        static final InlineSupport.ReferenceField<InteropBigInteger0Data> INTEROP_BIG_INTEGER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"interopBigInteger0_cache", InteropBigInteger0Data.class);
        private static final SLToTruffleStringNode INLINED_STRING_TO_TRUFFLE_STRING_NODE_LEFT_ = SLToTruffleStringNodeGen.inline(InlineSupport.InlineTarget.create(SLToTruffleStringNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STRING_SL_ADD_NODE_STRING_STATE_0_UPDATER.subUpdater(0, 11), InlineSupport.ReferenceField.create((MethodHandles.Lookup)StringData.lookup_(), (String)"string_toTruffleStringNodeLeft__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)StringData.lookup_(), (String)"string_toTruffleStringNodeLeft__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)StringData.lookup_(), (String)"string_toTruffleStringNodeLeft__field3_", Node.class)}));
        private static final SLToTruffleStringNode INLINED_STRING_TO_TRUFFLE_STRING_NODE_RIGHT_ = SLToTruffleStringNodeGen.inline(InlineSupport.InlineTarget.create(SLToTruffleStringNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STRING_SL_ADD_NODE_STRING_STATE_0_UPDATER.subUpdater(11, 11), InlineSupport.ReferenceField.create((MethodHandles.Lookup)StringData.lookup_(), (String)"string_toTruffleStringNodeRight__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)StringData.lookup_(), (String)"string_toTruffleStringNodeRight__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)StringData.lookup_(), (String)"string_toTruffleStringNodeRight__field3_", Node.class)}));
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private InteropBigInteger0Data interopBigInteger0_cache;
        @Node.Child
        private StringData string_cache;

        private SLAdd_Node() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        private Object execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            Object child1Value_;
            Object child0Value_;
            int state_0 = this.state_0_;
            try {
                child0Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp);
            }
            try {
                child1Value_ = FRAMES.expectObject((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp);
            }
            if ((state_0 & 0x7D) != 0) {
                if ((state_0 & 1) != 0 && child0Value_ instanceof Long) {
                    long child0Value__ = (Long)child0Value_;
                    if (child1Value_ instanceof Long) {
                        long child1Value__ = (Long)child1Value_;
                        try {
                            return SLAddNode.doLong(child0Value__, child1Value__);
                        }
                        catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFE;
                            this.state_0_ = state_0 |= 2;
                            SLAdd_Node.quicken(state_0, $bc, $bci);
                            return this.executeAndSpecialize(child0Value__, child1Value__, $bytecode, $bc, $bci, $sp);
                        }
                    }
                }
                if ((state_0 & 4) != 0 && SLTypesGen.isImplicitSLBigInteger((state_0 & 0x180) >>> 7, child0Value_)) {
                    SLBigInteger child0Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x180) >>> 7, child0Value_);
                    if (SLTypesGen.isImplicitSLBigInteger((state_0 & 0x600) >>> 9, child1Value_)) {
                        SLBigInteger child1Value__ = SLTypesGen.asImplicitSLBigInteger((state_0 & 0x600) >>> 9, child1Value_);
                        return SLAddNode.doSLBigInteger(child0Value__, child1Value__);
                    }
                }
                if ((state_0 & 0x78) != 0) {
                    StringData s4_;
                    if ((state_0 & 8) != 0) {
                        InteropBigInteger0Data s2_ = this.interopBigInteger0_cache;
                        while (s2_ != null) {
                            if (s2_.leftLibrary_.accepts(child0Value_) && s2_.rightLibrary_.accepts(child1Value_) && s2_.leftLibrary_.fitsInBigInteger(child0Value_) && s2_.rightLibrary_.fitsInBigInteger(child1Value_)) {
                                return SLAddNode.doInteropBigInteger(child0Value_, child1Value_, s2_.leftLibrary_, s2_.rightLibrary_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0x10) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary rightLibrary__;
                            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (leftLibrary__.fitsInBigInteger(child0Value_) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value_)) {
                                Object object = this.interopBigInteger1Boundary1(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0x20) != 0 && (s4_ = this.string_cache) != null && SLAddNode.isString(child0Value_, child1Value_)) {
                        StringData node__ = s4_;
                        return SLAddNode.doString(child0Value_, child1Value_, node__, INLINED_STRING_TO_TRUFFLE_STRING_NODE_LEFT_, INLINED_STRING_TO_TRUFFLE_STRING_NODE_RIGHT_, s4_.concatNode_);
                    }
                    if ((state_0 & 0x40) != 0) {
                        SLAdd_Node node__1 = this;
                        if (this.fallbackGuard_(state_0, child0Value_, child1Value_, $bytecode, $bc, $bci, $sp)) {
                            return SLAddNode.typeError(child0Value_, child1Value_, node__1);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
        }

        private long executeLong(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return SLTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp));
            }
            try {
                child1Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            try {
                return SLAddNode.doLong(child0Value_, child1Value_);
            }
            catch (ArithmeticException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int state_0 = this.state_0_;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                SLAdd_Node.quicken(state_0, $bc, $bci);
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp));
            }
        }

        private long executeLong$unboxed(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) throws UnexpectedResultException {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 2);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = FRAMES.getValue((Frame)frameValue, $sp - 1);
                return SLTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), child1Value, $bytecode, $bc, $bci, $sp));
            }
            try {
                child1Value_ = FRAMES.expectLong((Frame)frameValue, $sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, ex.getResult(), $bytecode, $bc, $bci, $sp));
            }
            try {
                return SLAddNode.doLong(child0Value_, child1Value_);
            }
            catch (ArithmeticException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int state_0 = this.state_0_;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                SLAdd_Node.quicken(state_0, $bc, $bci);
                return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp));
            }
        }

        private boolean fallbackGuard_(int state_0, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            if ((state_0 & 0x10) == 0 && ((InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child0Value) && ((InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value)) {
                return false;
            }
            return (state_0 & 0x20) != 0 || !SLAddNode.isString(child0Value, child1Value);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary(int state_0, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLAddNode.doInteropBigInteger(child0Value, child1Value, leftLibrary__, rightLibrary__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary0(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLAddNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int sLBigIntegerCast0;
            int state_0 = this.state_0_;
            if ((state_0 & 0x1C) == 0 && (state_0 & 2) == 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    this.state_0_ = state_0 |= 1;
                    SLAdd_Node.quicken(state_0, $bc, $bci);
                    try {
                        return SLAddNode.doLong(child0Value_, child1Value_);
                    }
                    catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        SLAdd_Node.quicken(state_0, $bc, $bci);
                        return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
                    }
                }
            }
            if ((state_0 & 0x18) == 0 && (sLBigIntegerCast0 = SLTypesGen.specializeImplicitSLBigInteger(child0Value)) != 0) {
                SLBigInteger child0Value_ = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast0, child0Value);
                int sLBigIntegerCast1 = SLTypesGen.specializeImplicitSLBigInteger(child1Value);
                if (sLBigIntegerCast1 != 0) {
                    SLBigInteger child1Value_ = SLTypesGen.asImplicitSLBigInteger(sLBigIntegerCast1, child1Value);
                    state_0 &= 0xFFFFFFFE;
                    state_0 |= sLBigIntegerCast0 << 7;
                    state_0 |= sLBigIntegerCast1 << 9;
                    this.state_0_ = state_0 |= 4;
                    SLAdd_Node.quicken(state_0, $bc, $bci);
                    return SLAddNode.doSLBigInteger(child0Value_, child1Value_);
                }
            }
            if ((state_0 & 0x10) == 0) {
                InteropBigInteger0Data s2_;
                block15: {
                    InteropBigInteger0Data s2_original;
                    do {
                        InteropLibrary rightLibrary__;
                        InteropLibrary leftLibrary__;
                        int count2_ = 0;
                        s2_original = s2_ = (InteropBigInteger0Data)((Object)INTEROP_BIG_INTEGER0_CACHE_UPDATER.getVolatile((Node)this));
                        while (!(s2_ == null || s2_.leftLibrary_.accepts(child0Value) && s2_.rightLibrary_.accepts(child1Value) && s2_.leftLibrary_.fitsInBigInteger(child0Value) && s2_.rightLibrary_.fitsInBigInteger(child1Value))) {
                            ++count2_;
                            s2_ = s2_.next_;
                        }
                        if (s2_ != null || !(leftLibrary__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child0Value)))).fitsInBigInteger(child0Value) || !(rightLibrary__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(child1Value)))).fitsInBigInteger(child1Value) || count2_ >= 3) break block15;
                        s2_ = (InteropBigInteger0Data)this.insert(new InteropBigInteger0Data(s2_original));
                        Objects.requireNonNull((InteropLibrary)s2_.insert((Node)leftLibrary__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.leftLibrary_ = leftLibrary__;
                        Objects.requireNonNull((InteropLibrary)s2_.insert((Node)rightLibrary__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.rightLibrary_ = rightLibrary__;
                    } while (!INTEROP_BIG_INTEGER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                    state_0 &= 0xFFFFFFFA;
                    this.state_0_ = state_0 |= 8;
                    SLAdd_Node.quicken(state_0, $bc, $bci);
                }
                if (s2_ != null) {
                    return SLAddNode.doInteropBigInteger(child0Value, child1Value, s2_.leftLibrary_, s2_.rightLibrary_);
                }
            }
            InteropLibrary rightLibrary__ = null;
            InteropLibrary leftLibrary__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                if (leftLibrary__.fitsInBigInteger(child0Value) && (rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached()).fitsInBigInteger(child1Value)) {
                    this.interopBigInteger0_cache = null;
                    state_0 &= 0xFFFFFFF2;
                    this.state_0_ = state_0 |= 0x10;
                    SLAdd_Node.quicken(state_0, $bc, $bci);
                    SLBigInteger sLBigInteger = SLAddNode.doInteropBigInteger(child0Value, child1Value, leftLibrary__, rightLibrary__);
                    return sLBigInteger;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            StringData node__ = null;
            if (SLAddNode.isString(child0Value, child1Value)) {
                StringData s4_;
                node__ = s4_ = (StringData)this.insert(new StringData());
                TruffleString.ConcatNode concatNode__ = (TruffleString.ConcatNode)s4_.insert((Node)TruffleString.ConcatNode.create());
                Objects.requireNonNull(concatNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s4_.concatNode_ = concatNode__;
                VarHandle.storeStoreFence();
                this.string_cache = s4_;
                this.state_0_ = state_0 |= 0x20;
                SLAdd_Node.quicken(state_0, $bc, $bci);
                return SLAddNode.doString(child0Value, child1Value, node__, INLINED_STRING_TO_TRUFFLE_STRING_NODE_LEFT_, INLINED_STRING_TO_TRUFFLE_STRING_NODE_RIGHT_, concatNode__);
            }
            SLAdd_Node node__1 = null;
            node__1 = this;
            this.state_0_ = state_0 |= 0x40;
            SLAdd_Node.quicken(state_0, $bc, $bci);
            return SLAddNode.typeError(child0Value, child1Value, node__1);
        }

        @CompilerDirectives.TruffleBoundary
        private Object interopBigInteger1Boundary1(int state_0, Object child0Value_, Object child1Value_, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            InteropLibrary leftLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            InteropLibrary rightLibrary__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
            return SLAddNode.doInteropBigInteger(child0Value_, child1Value_, leftLibrary__, rightLibrary__);
        }

        private static void quicken(int state_0, byte[] $bc, int $bci) {
            int newInstruction;
            short newOperand1;
            short newOperand0;
            int oldOperandIndex0 = BYTES.getIntUnaligned($bc, $bci + 6);
            short oldOperand0 = BYTES.getShort($bc, oldOperandIndex0);
            int oldOperandIndex1 = BYTES.getIntUnaligned($bc, $bci + 10);
            short oldOperand1 = BYTES.getShort($bc, oldOperandIndex1);
            if ((state_0 & 0x7C) == 0 && (state_0 & 0x7D) != 0 && (newOperand0 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand0)) != -1 && (newOperand1 = SLBytecodeRootNodeGen.applyQuickeningLong(oldOperand1)) != -1) {
                newInstruction = SLBytecodeRootNodeGen.isQuickeningLong(BYTES.getShort($bc, $bci)) ? 60 : 59;
            } else {
                newOperand0 = SLBytecodeRootNodeGen.undoQuickening(oldOperand0);
                newOperand1 = SLBytecodeRootNodeGen.undoQuickening(oldOperand1);
                newInstruction = 58;
            }
            BYTES.putShort($bc, oldOperandIndex0, newOperand0);
            BYTES.putShort($bc, oldOperandIndex1, newOperand1);
            BYTES.putShort($bc, $bci, (short)newInstruction);
        }

        @DenyReplace
        private static final class InteropBigInteger0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            InteropBigInteger0Data next_;
            @Node.Child
            InteropLibrary leftLibrary_;
            @Node.Child
            InteropLibrary rightLibrary_;

            InteropBigInteger0Data(InteropBigInteger0Data next_) {
                this.next_ = next_;
            }
        }

        @DenyReplace
        private static final class StringData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int string_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node string_toTruffleStringNodeLeft__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node string_toTruffleStringNodeLeft__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node string_toTruffleStringNodeLeft__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node string_toTruffleStringNodeRight__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node string_toTruffleStringNodeRight__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node string_toTruffleStringNodeRight__field3_;
            @Node.Child
            TruffleString.ConcatNode concatNode_;

            StringData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public Object executeUncached(VirtualFrame frameValue, Object child0Value, Object child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value)).fitsInBigInteger(child0Value) && ((InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value)).fitsInBigInteger(child1Value)) {
                    return SLAddNode.doInteropBigInteger(child0Value, child1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), (InteropLibrary)INTEROP_LIBRARY_.getUncached(child1Value));
                }
                if (SLAddNode.isString(child0Value, child1Value)) {
                    return SLAddNode.doString(child0Value, child1Value, (Node)$bytecode, SLToTruffleStringNodeGen.getUncached(), SLToTruffleStringNodeGen.getUncached(), TruffleString.ConcatNode.getUncached());
                }
                return SLAddNode.typeError(child0Value, child1Value, (Node)$bytecode);
            }
        }
    }

    private static final class SLInvoke_Node
    extends Node {
        static final InlineSupport.ReferenceField<DirectData> DIRECT_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"direct_cache", DirectData.class);
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private DirectData direct_cache;
        @Node.Child
        private IndirectCallNode indirect_callNode_;
        @Node.Child
        private InteropLibrary interop_library_;

        private SLInvoke_Node() {
        }

        @ExplodeLoop
        private Object execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int state_0 = this.state_0_;
            Object child0Value_ = FRAMES.uncheckedGetObject((Frame)frameValue, $sp - 2);
            Object[] child1Value_ = (Object[])FRAMES.uncheckedGetObject((Frame)frameValue, $sp - 1);
            if (state_0 != 0) {
                InteropLibrary library__;
                if ((state_0 & 3) != 0 && child0Value_ instanceof SLFunction) {
                    IndirectCallNode callNode__;
                    SLFunction child0Value__ = (SLFunction)child0Value_;
                    if ((state_0 & 1) != 0) {
                        DirectData s0_ = this.direct_cache;
                        while (s0_ != null) {
                            if (!Assumption.isValidAssumption((Assumption)s0_.callTargetStable_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                this.removeDirect_(s0_);
                                return this.executeAndSpecialize(child0Value__, child1Value_, $bytecode, $bc, $bci, $sp);
                            }
                            if (child0Value__.getCallTarget() == s0_.cachedTarget_) {
                                return SLBytecodeRootNode.SLInvoke.doDirect(child0Value__, child1Value_, s0_.callTargetStable_, s0_.cachedTarget_, s0_.callNode_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0 && (callNode__ = this.indirect_callNode_) != null) {
                        return SLBytecodeRootNode.SLInvoke.doIndirect(child0Value__, child1Value_, callNode__);
                    }
                }
                if ((state_0 & 4) != 0 && (library__ = this.interop_library_) != null) {
                    SLInvoke_Node location__ = this;
                    return SLBytecodeRootNode.SLInvoke.doInterop(child0Value_, child1Value_, library__, location__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, $bytecode, $bc, $bci, $sp);
        }

        private Object executeAndSpecialize(Object child0Value, Object[] child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            int state_0 = this.state_0_;
            if (child0Value instanceof SLFunction) {
                SLFunction child0Value_ = (SLFunction)child0Value;
                if ((state_0 & 2) == 0) {
                    DirectData s0_;
                    block5: {
                        DirectData s0_original;
                        do {
                            Assumption callTargetStable__;
                            Assumption assumption0;
                            int count0_ = 0;
                            s0_original = s0_ = (DirectData)((Object)DIRECT_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s0_ == null || child0Value_.getCallTarget() == s0_.cachedTarget_ && Assumption.isValidAssumption((Assumption)s0_.callTargetStable_))) {
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null) break block5;
                            RootCallTarget cachedTarget__ = child0Value_.getCallTarget();
                            if (child0Value_.getCallTarget() != cachedTarget__ || !Assumption.isValidAssumption((Assumption)(assumption0 = (callTargetStable__ = child0Value_.getCallTargetStable()))) || count0_ >= 3) break block5;
                            s0_ = (DirectData)this.insert(new DirectData(s0_original));
                            s0_.callTargetStable_ = callTargetStable__;
                            s0_.cachedTarget_ = cachedTarget__;
                            s0_.callNode_ = (DirectCallNode)s0_.insert((Node)DirectCallNode.create((CallTarget)cachedTarget__));
                        } while (!DIRECT_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s0_ != null) {
                        return SLBytecodeRootNode.SLInvoke.doDirect(child0Value_, child1Value, s0_.callTargetStable_, s0_.cachedTarget_, s0_.callNode_);
                    }
                }
                VarHandle.storeStoreFence();
                this.indirect_callNode_ = (IndirectCallNode)this.insert((Node)IndirectCallNode.create());
                this.direct_cache = null;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                return SLBytecodeRootNode.SLInvoke.doIndirect(child0Value_, child1Value, this.indirect_callNode_);
            }
            SLInvoke_Node location__ = null;
            InteropLibrary library__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(library__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.interop_library_ = library__;
            location__ = this;
            this.state_0_ = state_0 |= 4;
            return SLBytecodeRootNode.SLInvoke.doInterop(child0Value, child1Value, library__, location__);
        }

        void removeDirect_(DirectData s0_) {
            DirectData update;
            DirectData original;
            DirectData cur;
            block0: do {
                original = cur = this.direct_cache;
                update = null;
                while (cur != null) {
                    if (cur == s0_) {
                        if (cur == original) {
                            update = cur.next_;
                            continue block0;
                        }
                        update = original.remove(this, s0_);
                        continue block0;
                    }
                    cur = cur.next_;
                }
            } while (cur != null && !DIRECT_CACHE_UPDATER.compareAndSet((Node)this, (Object)original, update));
        }

        @GeneratedBy(value=SLBytecodeRootNode.class)
        @DenyReplace
        private static final class DirectData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            DirectData next_;
            @CompilerDirectives.CompilationFinal
            Assumption callTargetStable_;
            @CompilerDirectives.CompilationFinal
            RootCallTarget cachedTarget_;
            @Node.Child
            DirectCallNode callNode_;

            DirectData(DirectData next_) {
                this.next_ = next_;
            }

            DirectData remove(Node parent, DirectData search) {
                DirectData newNext = this.next_;
                if (newNext != null) {
                    newNext = search == newNext ? newNext.next_ : newNext.remove(this, search);
                }
                DirectData copy = (DirectData)parent.insert((Node)new DirectData(newNext));
                copy.callTargetStable_ = this.callTargetStable_;
                copy.cachedTarget_ = this.cachedTarget_;
                copy.callNode_ = (DirectCallNode)copy.insert((Node)this.callNode_);
                return copy;
            }
        }

        @GeneratedBy(value=SLBytecodeRootNode.class)
        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public Object executeUncached(VirtualFrame frameValue, Object child0Value, Object[] child1Value, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                if (child0Value instanceof SLFunction) {
                    SLFunction child0Value_ = (SLFunction)child0Value;
                    return SLBytecodeRootNode.SLInvoke.doIndirect(child0Value_, child1Value, IndirectCallNode.getUncached());
                }
                return SLBytecodeRootNode.SLInvoke.doInterop(child0Value, child1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(), (Node)$bytecode);
            }
        }
    }

    private static final class Builtin_Node
    extends Node {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private SLBuiltinNode builtin;

        private Builtin_Node() {
        }

        private Object execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp, Object[] consts) {
            int state_0 = this.state_0_;
            NodeFactory factoryValue_ = (NodeFactory)ACCESS.uncheckedCast(ACCESS.readObject(consts, BYTES.getIntUnaligned($bc, $bci + 2)), NodeFactory.class);
            int argumentCountValue_ = (Integer)ACCESS.uncheckedCast(ACCESS.readObject(consts, BYTES.getIntUnaligned($bc, $bci + 6)), Integer.class);
            if (state_0 != 0) {
                SLBuiltinNode builtin_1;
                Object[] arguments__;
                SLBuiltinNode builtin_;
                if ((state_0 & 1) != 0 && (builtin_ = this.builtin) != null && (arguments__ = frameValue.getArguments()).length == argumentCountValue_) {
                    Builtin_Node bytecode__ = this;
                    return SLBytecodeRootNode.Builtin.doInBounds(frameValue, factoryValue_, argumentCountValue_, bytecode__, arguments__, builtin_);
                }
                if ((state_0 & 2) != 0 && (builtin_1 = this.builtin) != null) {
                    Builtin_Node bytecode__1 = this;
                    if (this.fallbackGuard_(state_0, frameValue, factoryValue_, argumentCountValue_, $bytecode, $bc, $bci, $sp, consts)) {
                        return SLBytecodeRootNode.Builtin.doOutOfBounds(frameValue, factoryValue_, argumentCountValue_, bytecode__1, builtin_1);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, factoryValue_, argumentCountValue_, $bytecode, $bc, $bci, $sp, consts);
        }

        private boolean fallbackGuard_(int state_0, VirtualFrame frameValue, NodeFactory<?> factoryValue, int argumentCountValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp, Object[] consts) {
            return (state_0 & 1) != 0 || frameValue.getArguments().length != argumentCountValue;
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, NodeFactory<?> factoryValue, int argumentCountValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp, Object[] consts) {
            SLBuiltinNode builtin_1;
            int state_0 = this.state_0_;
            Object[] arguments__ = null;
            Builtin_Node bytecode__ = null;
            arguments__ = frameValue.getArguments();
            if (arguments__.length == argumentCountValue) {
                SLBuiltinNode builtin_;
                bytecode__ = this;
                SLBuiltinNode builtin__shared = this.builtin;
                if (builtin__shared != null) {
                    builtin_ = builtin__shared;
                } else {
                    builtin_ = (SLBuiltinNode)this.insert(SLBytecodeRootNode.Builtin.createBuiltin(factoryValue));
                    if (builtin_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.builtin == null) {
                    VarHandle.storeStoreFence();
                    this.builtin = builtin_;
                }
                this.state_0_ = state_0 |= 1;
                return SLBytecodeRootNode.Builtin.doInBounds(frameValue, factoryValue, argumentCountValue, bytecode__, arguments__, builtin_);
            }
            Builtin_Node bytecode__1 = null;
            bytecode__1 = this;
            SLBuiltinNode builtin_1_shared = this.builtin;
            if (builtin_1_shared != null) {
                builtin_1 = builtin_1_shared;
            } else {
                builtin_1 = (SLBuiltinNode)this.insert(SLBytecodeRootNode.Builtin.createBuiltin(factoryValue));
                if (builtin_1 == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.builtin == null) {
                VarHandle.storeStoreFence();
                this.builtin = builtin_1;
            }
            this.state_0_ = state_0 |= 2;
            return SLBytecodeRootNode.Builtin.doOutOfBounds(frameValue, factoryValue, argumentCountValue, bytecode__1, builtin_1);
        }

        @GeneratedBy(value=SLBytecodeRootNode.class)
        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public Object executeUncached(VirtualFrame frameValue, NodeFactory<?> factoryValue, int argumentCountValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp, Object[] consts) {
                if (frameValue.getArguments().length == argumentCountValue) {
                    return SLBytecodeRootNode.Builtin.doInBounds(frameValue, factoryValue, argumentCountValue, (Node)$bytecode, frameValue.getArguments(), SLBytecodeRootNode.Builtin.getUncachedBuiltin());
                }
                return SLBytecodeRootNode.Builtin.doOutOfBounds(frameValue, factoryValue, argumentCountValue, (Node)$bytecode, SLBytecodeRootNode.Builtin.getUncachedBuiltin());
            }
        }
    }

    private static final class SLLoadArgument_Node
    extends Node {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private SLLoadArgument_Node() {
        }

        private Object execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp, Object[] consts) {
            int state_0 = this.state_0_;
            int indexValue_ = (Integer)ACCESS.uncheckedCast(ACCESS.readObject(consts, BYTES.getIntUnaligned($bc, $bci + 2)), Integer.class);
            if (state_0 != 0) {
                Object[] arguments__;
                if ((state_0 & 1) != 0 && indexValue_ < (arguments__ = frameValue.getArguments()).length) {
                    return SLBytecodeRootNode.SLLoadArgument.doLoadInBounds(frameValue, indexValue_, arguments__);
                }
                if ((state_0 & 2) != 0 && this.fallbackGuard_(state_0, frameValue, indexValue_, $bytecode, $bc, $bci, $sp, consts)) {
                    return SLBytecodeRootNode.SLLoadArgument.doLoadOutOfBounds(indexValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, indexValue_, $bytecode, $bc, $bci, $sp, consts);
        }

        private Object executeLoadInBounds(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp, Object[] consts) {
            Object[] arguments__;
            int indexValue_ = (Integer)ACCESS.uncheckedCast(ACCESS.readObject(consts, BYTES.getIntUnaligned($bc, $bci + 2)), Integer.class);
            if (indexValue_ < (arguments__ = frameValue.getArguments()).length) {
                return SLBytecodeRootNode.SLLoadArgument.doLoadInBounds(frameValue, indexValue_, arguments__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, indexValue_, $bytecode, $bc, $bci, $sp, consts);
        }

        private boolean fallbackGuard_(int state_0, VirtualFrame frameValue, int indexValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp, Object[] consts) {
            return (state_0 & 1) != 0 || indexValue >= frameValue.getArguments().length;
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, int indexValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp, Object[] consts) {
            int state_0 = this.state_0_;
            Object[] arguments__ = null;
            arguments__ = frameValue.getArguments();
            if (indexValue < arguments__.length) {
                this.state_0_ = state_0 |= 1;
                SLLoadArgument_Node.quicken(state_0, $bc, $bci);
                return SLBytecodeRootNode.SLLoadArgument.doLoadInBounds(frameValue, indexValue, arguments__);
            }
            this.state_0_ = state_0 |= 2;
            SLLoadArgument_Node.quicken(state_0, $bc, $bci);
            return SLBytecodeRootNode.SLLoadArgument.doLoadOutOfBounds(indexValue);
        }

        private static void quicken(int state_0, byte[] $bc, int $bci) {
            short newInstruction = (state_0 & 2) == 0 && state_0 != 0 ? (short)55 : 54;
            BYTES.putShort($bc, $bci, newInstruction);
        }

        @GeneratedBy(value=SLBytecodeRootNode.class)
        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public Object executeUncached(VirtualFrame frameValue, int indexValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp, Object[] consts) {
                if (indexValue < frameValue.getArguments().length) {
                    return SLBytecodeRootNode.SLLoadArgument.doLoadInBounds(frameValue, indexValue, frameValue.getArguments());
                }
                return SLBytecodeRootNode.SLLoadArgument.doLoadOutOfBounds(indexValue);
            }
        }
    }

    @DenyReplace
    private static final class SLAlwaysHalt_Node
    extends Node {
        private static final Uncached UNCACHED = new Uncached();
        private static final SLAlwaysHalt_Node SINGLETON = new SLAlwaysHalt_Node();

        private SLAlwaysHalt_Node() {
        }

        private void execute(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
            SLBytecodeRootNode.SLAlwaysHalt.doDefault();
        }

        public boolean isAdoptable() {
            return false;
        }

        @GeneratedBy(value=SLBytecodeRootNode.class)
        @DenyReplace
        private static final class Uncached
        extends Node
        implements UnadoptableNode {
            private Uncached() {
            }

            public void executeUncached(VirtualFrame frameValue, AbstractBytecodeNode $bytecode, byte[] $bc, int $bci, int $sp) {
                SLBytecodeRootNode.SLAlwaysHalt.doDefault();
            }
        }
    }

    private static class LoopCounter {
        private static final int REPORT_LOOP_STRIDE = 256;
        private int value;

        private LoopCounter() {
        }
    }

    private static final class LocalVariableList
    extends AbstractList<LocalVariable> {
        final AbstractBytecodeNode bytecode;

        LocalVariableList(AbstractBytecodeNode bytecode) {
            this.bytecode = bytecode;
        }

        @Override
        public LocalVariable get(int index) {
            int baseIndex = index * 6;
            if (baseIndex < 0 || baseIndex >= this.bytecode.locals.length) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return new LocalVariableImpl(this.bytecode, baseIndex);
        }

        @Override
        public int size() {
            return this.bytecode.locals.length / 6;
        }
    }

    private static final class LocalVariableImpl
    extends LocalVariable {
        final AbstractBytecodeNode bytecode;
        final int baseIndex;

        LocalVariableImpl(AbstractBytecodeNode bytecode, int baseIndex) {
            super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
            this.bytecode = bytecode;
            this.baseIndex = baseIndex;
        }

        public int getStartIndex() {
            return this.bytecode.locals[this.baseIndex + 0];
        }

        public int getEndIndex() {
            return this.bytecode.locals[this.baseIndex + 1];
        }

        public Object getInfo() {
            int infoId = this.bytecode.locals[this.baseIndex + 5];
            if (infoId == -1) {
                return null;
            }
            return ACCESS.readObject(this.bytecode.constants, infoId);
        }

        public Object getName() {
            int nameId = this.bytecode.locals[this.baseIndex + 4];
            if (nameId == -1) {
                return null;
            }
            return ACCESS.readObject(this.bytecode.constants, nameId);
        }

        public int getLocalIndex() {
            return this.bytecode.locals[this.baseIndex + 2];
        }

        public int getLocalOffset() {
            return this.bytecode.locals[this.baseIndex + 3] - 1;
        }

        public FrameSlotKind getTypeProfile() {
            byte[] localTags = this.bytecode.getLocalTags();
            if (localTags == null) {
                return null;
            }
            return FrameSlotKind.fromTag((byte)localTags[this.getLocalIndex()]);
        }
    }

    private static final class SourceInformationTreeImpl
    extends SourceInformationTree {
        static final int UNAVAILABLE_ROOT = -1;
        final AbstractBytecodeNode bytecode;
        final int baseIndex;
        final List<SourceInformationTree> children;

        SourceInformationTreeImpl(AbstractBytecodeNode bytecode, int baseIndex) {
            super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
            this.bytecode = bytecode;
            this.baseIndex = baseIndex;
            this.children = new LinkedList<SourceInformationTree>();
        }

        public int getStartBytecodeIndex() {
            if (this.baseIndex == -1) {
                return 0;
            }
            return this.bytecode.sourceInfo[this.baseIndex + 0];
        }

        public int getEndBytecodeIndex() {
            if (this.baseIndex == -1) {
                return this.bytecode.bytecodes.length;
            }
            return this.bytecode.sourceInfo[this.baseIndex + 1];
        }

        public SourceSection getSourceSection() {
            if (this.baseIndex == -1) {
                return null;
            }
            return AbstractBytecodeNode.createSourceSection(this.bytecode.sources, this.bytecode.sourceInfo, this.baseIndex);
        }

        public List<SourceInformationTree> getChildren() {
            return this.children;
        }

        private boolean contains(SourceInformationTreeImpl other) {
            if (this.baseIndex == -1) {
                return true;
            }
            return this.getStartBytecodeIndex() <= other.getStartBytecodeIndex() && other.getEndBytecodeIndex() <= this.getEndBytecodeIndex();
        }

        @CompilerDirectives.TruffleBoundary
        private static SourceInformationTree parse(AbstractBytecodeNode bytecode) {
            int[] sourceInfo = bytecode.sourceInfo;
            if (sourceInfo.length == 0) {
                return null;
            }
            SourceInformationTreeImpl root = new SourceInformationTreeImpl(bytecode, -1);
            int baseIndex = sourceInfo.length;
            SourceInformationTreeImpl current = root;
            ArrayDeque<SourceInformationTreeImpl> stack = new ArrayDeque<SourceInformationTreeImpl>();
            do {
                SourceInformationTreeImpl newNode = new SourceInformationTreeImpl(bytecode, baseIndex -= 5);
                while (!current.contains(newNode)) {
                    current = (SourceInformationTreeImpl)((Object)stack.pop());
                }
                current.children.addFirst(newNode);
                stack.push(current);
                current = newNode;
            } while (baseIndex > 0);
            if (root.getChildren().size() == 1) {
                return root.getChildren().getFirst();
            }
            return root;
        }
    }

    private static final class SourceInformationList
    extends AbstractList<SourceInformation> {
        final AbstractBytecodeNode bytecode;

        SourceInformationList(AbstractBytecodeNode bytecode) {
            this.bytecode = bytecode;
        }

        @Override
        public SourceInformation get(int index) {
            int baseIndex = index * 5;
            if (baseIndex < 0 || baseIndex >= this.bytecode.sourceInfo.length) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return new SourceInformationImpl(this.bytecode, baseIndex);
        }

        @Override
        public int size() {
            return this.bytecode.sourceInfo.length / 5;
        }
    }

    private static final class SourceInformationImpl
    extends SourceInformation {
        final AbstractBytecodeNode bytecode;
        final int baseIndex;

        SourceInformationImpl(AbstractBytecodeNode bytecode, int baseIndex) {
            super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
            this.bytecode = bytecode;
            this.baseIndex = baseIndex;
        }

        public int getStartBytecodeIndex() {
            return this.bytecode.sourceInfo[this.baseIndex + 0];
        }

        public int getEndBytecodeIndex() {
            return this.bytecode.sourceInfo[this.baseIndex + 1];
        }

        public SourceSection getSourceSection() {
            return AbstractBytecodeNode.createSourceSection(this.bytecode.sources, this.bytecode.sourceInfo, this.baseIndex);
        }
    }

    private static final class ExceptionHandlerList
    extends AbstractList<ExceptionHandler> {
        final AbstractBytecodeNode bytecode;

        ExceptionHandlerList(AbstractBytecodeNode bytecode) {
            this.bytecode = bytecode;
        }

        @Override
        public ExceptionHandler get(int index) {
            int baseIndex = index * 5;
            if (baseIndex < 0 || baseIndex >= this.bytecode.handlers.length) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return new ExceptionHandlerImpl(this.bytecode, baseIndex);
        }

        @Override
        public int size() {
            return this.bytecode.handlers.length / 5;
        }
    }

    private static final class ExceptionHandlerImpl
    extends ExceptionHandler {
        final AbstractBytecodeNode bytecode;
        final int baseIndex;

        ExceptionHandlerImpl(AbstractBytecodeNode bytecode, int baseIndex) {
            super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
            this.bytecode = bytecode;
            this.baseIndex = baseIndex;
        }

        public ExceptionHandler.HandlerKind getKind() {
            switch (this.bytecode.handlers[this.baseIndex + 2]) {
                case 1: {
                    return ExceptionHandler.HandlerKind.TAG;
                }
            }
            return ExceptionHandler.HandlerKind.CUSTOM;
        }

        public int getStartBytecodeIndex() {
            return this.bytecode.handlers[this.baseIndex + 0];
        }

        public int getEndBytecodeIndex() {
            return this.bytecode.handlers[this.baseIndex + 1];
        }

        public int getHandlerBytecodeIndex() throws UnsupportedOperationException {
            switch (this.getKind()) {
                case TAG: {
                    return super.getHandlerBytecodeIndex();
                }
            }
            return this.bytecode.handlers[this.baseIndex + 3];
        }

        public TagTree getTagTree() throws UnsupportedOperationException {
            if (this.getKind() == ExceptionHandler.HandlerKind.TAG) {
                int nodeId = this.bytecode.handlers[this.baseIndex + 3];
                return this.bytecode.tagRoot.tagNodes[nodeId];
            }
            return super.getTagTree();
        }
    }

    private static final class FrameTags {
        private static final byte OBJECT = 0;
        private static final byte LONG = 1;
        private static final byte BOOLEAN = 5;
        private static final byte ILLEGAL = 7;

        private FrameTags() {
        }
    }

    private static final class Operations {
        private static final int BLOCK = 1;
        private static final int ROOT = 2;
        private static final int IFTHEN = 3;
        private static final int IFTHENELSE = 4;
        private static final int CONDITIONAL = 5;
        private static final int WHILE = 6;
        private static final int TRYCATCH = 7;
        private static final int TRYFINALLY = 8;
        private static final int TRYCATCHOTHERWISE = 9;
        private static final int FINALLYHANDLER = 10;
        private static final int LABEL = 11;
        private static final int BRANCH = 12;
        private static final int LOADCONSTANT = 13;
        private static final int LOADNULL = 14;
        private static final int LOADARGUMENT = 15;
        private static final int LOADEXCEPTION = 16;
        private static final int LOADLOCAL = 17;
        private static final int STORELOCAL = 18;
        private static final int RETURN = 19;
        private static final int SOURCE = 20;
        private static final int SOURCESECTION = 21;
        private static final int TAG = 22;
        private static final int SLALWAYSHALT = 23;
        private static final int SLLOADARGUMENT = 24;
        private static final int BUILTIN = 25;
        private static final int SLINVOKE = 26;
        private static final int SLADD = 27;
        private static final int SLDIV = 28;
        private static final int SLEQUAL = 29;
        private static final int SLLESSOREQUAL = 30;
        private static final int SLLESSTHAN = 31;
        private static final int SLLOGICALNOT = 32;
        private static final int SLMUL = 33;
        private static final int SLREADPROPERTY = 34;
        private static final int SLSUB = 35;
        private static final int SLWRITEPROPERTY = 36;
        private static final int SLUNBOX = 37;
        private static final int SLFUNCTIONLITERAL = 38;
        private static final int SLTOBOOLEAN = 39;
        private static final int SLAND = 40;
        private static final int SLOR = 41;

        private Operations() {
        }
    }

    @DenyReplace
    private static final class CachedBytecodeNode
    extends AbstractBytecodeNode
    implements BytecodeOSRNode {
        private static final boolean[] EMPTY_EXCEPTION_PROFILES = new boolean[0];
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private Node[] cachedNodes_;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final boolean[] exceptionProfiles_;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final byte[] localTags_;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final int[] branchProfiles_;
        @CompilerDirectives.CompilationFinal
        private Object osrMetadata_;

        CachedBytecodeNode(byte[] bytecodes, Object[] constants, int[] handlers, int[] locals, int[] sourceInfo, List<Source> sources, int numNodes, TagRootNode tagRoot, int numLocals) {
            super(bytecodes, constants, handlers, locals, sourceInfo, sources, numNodes, tagRoot);
            CompilerAsserts.neverPartOfCompilation();
            Node[] result = new Node[this.numNodes];
            byte[] bc = bytecodes;
            int bci = 0;
            int numConditionalBranches = 0;
            block28: while (bci < bc.length) {
                switch (BYTES.getShort(bc, bci)) {
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 109: {
                        bci += 2;
                        continue block28;
                    }
                    case 53: {
                        bci += 2;
                        continue block28;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 13: 
                    case 44: 
                    case 110: {
                        bci += 4;
                        continue block28;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 20: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 45: 
                    case 52: 
                    case 111: {
                        bci += 6;
                        continue block28;
                    }
                    case 112: {
                        bci += 8;
                        continue block28;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 21: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 113: {
                        bci += 10;
                        continue block28;
                    }
                    case 114: {
                        bci += 12;
                        continue block28;
                    }
                    case 115: {
                        bci += 14;
                        continue block28;
                    }
                    case 57: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 2))] = this.insert(new SLInvoke_Node());
                        bci += 6;
                        continue block28;
                    }
                    case 86: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 2))] = this.insert(new SLReadProperty_Node());
                        bci += 6;
                        continue block28;
                    }
                    case 90: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 2))] = this.insert(new SLWriteProperty_Node());
                        bci += 6;
                        continue block28;
                    }
                    case 96: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 2))] = this.insert(new SLFunctionLiteral_Node());
                        bci += 6;
                        continue block28;
                    }
                    case 54: 
                    case 55: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 6))] = this.insert(new SLLoadArgument_Node());
                        bci += 10;
                        continue block28;
                    }
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 2))] = this.insert(new SLLogicalNot_Node());
                        bci += 10;
                        continue block28;
                    }
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 2))] = this.insert(new SLUnbox_Node());
                        bci += 10;
                        continue block28;
                    }
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 2))] = this.insert(new SLToBoolean_Node());
                        bci += 10;
                        continue block28;
                    }
                    case 56: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 10))] = this.insert(new Builtin_Node());
                        bci += 14;
                        continue block28;
                    }
                    case 58: 
                    case 59: 
                    case 60: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 2))] = this.insert(new SLAdd_Node());
                        bci += 14;
                        continue block28;
                    }
                    case 61: 
                    case 62: 
                    case 63: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 2))] = this.insert(new SLDiv_Node());
                        bci += 14;
                        continue block28;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 2))] = this.insert(new SLEqual_Node());
                        bci += 14;
                        continue block28;
                    }
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 2))] = this.insert(new SLLessOrEqual_Node());
                        bci += 14;
                        continue block28;
                    }
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 2))] = this.insert(new SLLessThan_Node());
                        bci += 14;
                        continue block28;
                    }
                    case 83: 
                    case 84: 
                    case 85: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 2))] = this.insert(new SLMul_Node());
                        bci += 14;
                        continue block28;
                    }
                    case 87: 
                    case 88: 
                    case 89: {
                        result[SLBytecodeRootNodeGen.BYTES.getIntUnaligned((byte[])bc, (int)(bci + 2))] = this.insert(new SLSub_Node());
                        bci += 14;
                        continue block28;
                    }
                    case 101: 
                    case 102: {
                        ++numConditionalBranches;
                        bci += 10;
                        continue block28;
                    }
                    case 22: 
                    case 23: 
                    case 24: {
                        ++numConditionalBranches;
                        bci += 14;
                        continue block28;
                    }
                }
                throw SLBytecodeRootNodeGen.assertionFailed("Should not reach here");
            }
            assert (bci == bc.length);
            this.cachedNodes_ = result;
            this.branchProfiles_ = CachedBytecodeNode.allocateBranchProfiles(numConditionalBranches);
            this.exceptionProfiles_ = handlers.length == 0 ? EMPTY_EXCEPTION_PROFILES : new boolean[handlers.length / 5];
            byte[] localTags = new byte[numLocals];
            Arrays.fill(localTags, FrameSlotKind.Illegal.tag);
            this.localTags_ = localTags;
        }

        CachedBytecodeNode(byte[] bytecodes, Object[] constants, int[] handlers, int[] locals, int[] sourceInfo, List<Source> sources, int numNodes, TagRootNode tagRoot, Node[] cachedNodes_, boolean[] exceptionProfiles_, byte[] localTags_, int[] branchProfiles_, Object osrMetadata_) {
            super(bytecodes, constants, handlers, locals, sourceInfo, sources, numNodes, tagRoot);
            this.cachedNodes_ = cachedNodes_;
            this.exceptionProfiles_ = exceptionProfiles_;
            this.localTags_ = localTags_;
            this.branchProfiles_ = branchProfiles_;
            this.osrMetadata_ = osrMetadata_;
        }

        @Override
        @HostCompilerDirectives.BytecodeInterpreterSwitch
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
        long continueAt(SLBytecodeRootNodeGen $root, VirtualFrame frame_, long startState) {
            VirtualFrame frame = (VirtualFrame)ACCESS.uncheckedCast((Object)frame_, FRAME_TYPE);
            byte[] bc = this.bytecodes;
            Object[] consts = this.constants;
            Node[] cachedNodes = this.cachedNodes_;
            int[] branchProfiles = this.branchProfiles_;
            byte[] localTags = this.localTags_;
            int bci = (int)startState;
            int sp = (int)(startState >>> 32);
            LoopCounter loopCounter = new LoopCounter();
            FRAMES.setInt((Frame)frame, 0, -1);
            block134: while (true) {
                long temp;
                CompilerAsserts.partialEvaluationConstant((int)bci);
                int op = BYTES.getShort(bc, bci);
                CompilerAsserts.partialEvaluationConstant((int)op);
                try {
                    switch (op) {
                        case 1: {
                            FRAMES.setObject((Frame)frame, sp, frame.getArguments()[BYTES.getShort(bc, bci + 2)]);
                            ++sp;
                            bci += 4;
                            break;
                        }
                        case 2: {
                            this.doLoadArgument$Long(frame, bc, bci, sp);
                            ++sp;
                            bci += 4;
                            break;
                        }
                        case 3: {
                            this.doLoadArgument$Boolean(frame, bc, bci, sp);
                            ++sp;
                            bci += 4;
                            break;
                        }
                        case 4: {
                            if (CompilerDirectives.inCompiledCode()) {
                                CachedBytecodeNode.loadConstantCompiled(frame, bc, bci, sp, consts);
                            } else {
                                FRAMES.setObject((Frame)frame, sp, ACCESS.readObject(consts, BYTES.getIntUnaligned(bc, bci + 2)));
                            }
                            ++sp;
                            bci += 6;
                            break;
                        }
                        case 5: {
                            FRAMES.setLong((Frame)frame, sp, ((Long)ACCESS.uncheckedCast(ACCESS.readObject(consts, BYTES.getIntUnaligned(bc, bci + 2)), Long.class)).longValue());
                            ++sp;
                            bci += 6;
                            break;
                        }
                        case 6: {
                            FRAMES.setBoolean((Frame)frame, sp, ((Boolean)ACCESS.uncheckedCast(ACCESS.readObject(consts, BYTES.getIntUnaligned(bc, bci + 2)), Boolean.class)).booleanValue());
                            ++sp;
                            bci += 6;
                            break;
                        }
                        case 7: {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.doLoadLocal((Frame)frame, bc, bci, sp, localTags);
                            ++sp;
                            bci += 6;
                            break;
                        }
                        case 8: {
                            this.doLoadLocal$Long((Frame)frame, bc, bci, sp, localTags);
                            ++sp;
                            bci += 6;
                            break;
                        }
                        case 9: {
                            this.doLoadLocal$Long$unboxed((Frame)frame, bc, bci, sp, localTags);
                            ++sp;
                            bci += 6;
                            break;
                        }
                        case 10: {
                            this.doLoadLocal$Boolean((Frame)frame, bc, bci, sp, localTags);
                            ++sp;
                            bci += 6;
                            break;
                        }
                        case 11: {
                            this.doLoadLocal$Boolean$unboxed((Frame)frame, bc, bci, sp, localTags);
                            ++sp;
                            bci += 6;
                            break;
                        }
                        case 12: {
                            this.doLoadLocal$generic((Frame)frame, bc, bci, sp, localTags);
                            ++sp;
                            bci += 6;
                            break;
                        }
                        case 13: {
                            FRAMES.clear((Frame)frame, (int)BYTES.getShort(bc, bci + 2));
                            bci += 4;
                            break;
                        }
                        case 14: {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.doStoreLocal((Frame)frame, bc, bci, sp, FRAMES.requireObject((Frame)frame, sp - 1), localTags);
                            FRAMES.clear((Frame)frame, sp - 1);
                            --sp;
                            bci += 10;
                            break;
                        }
                        case 15: {
                            this.doStoreLocal$Long((Frame)frame, bc, bci, sp, localTags);
                            FRAMES.clear((Frame)frame, sp - 1);
                            --sp;
                            bci += 10;
                            break;
                        }
                        case 16: {
                            this.doStoreLocal$Long$Long((Frame)frame, bc, bci, sp, localTags);
                            FRAMES.clear((Frame)frame, sp - 1);
                            --sp;
                            bci += 10;
                            break;
                        }
                        case 17: {
                            this.doStoreLocal$Boolean((Frame)frame, bc, bci, sp, localTags);
                            FRAMES.clear((Frame)frame, sp - 1);
                            --sp;
                            bci += 10;
                            break;
                        }
                        case 18: {
                            this.doStoreLocal$Boolean$Boolean((Frame)frame, bc, bci, sp, localTags);
                            FRAMES.clear((Frame)frame, sp - 1);
                            --sp;
                            bci += 10;
                            break;
                        }
                        case 19: {
                            this.doStoreLocal$generic((Frame)frame, bc, bci, sp, localTags);
                            FRAMES.clear((Frame)frame, sp - 1);
                            --sp;
                            bci += 10;
                            break;
                        }
                        case 20: {
                            bci = BYTES.getIntUnaligned(bc, bci + 2);
                            break;
                        }
                        case 21: {
                            if (CompilerDirectives.hasNextTier() && ++loopCounter.value >= 256) {
                                LoopNode.reportLoopCount((Node)this, (int)loopCounter.value);
                                loopCounter.value = 0;
                            }
                            if ((temp = this.doBranchBackward(frame, bc, bci, sp)) != -1L) {
                                return temp;
                            }
                            bci = BYTES.getIntUnaligned(bc, bci + 2);
                            break;
                        }
                        case 22: {
                            if (CachedBytecodeNode.profileBranch(branchProfiles, BYTES.getIntUnaligned(bc, bci + 6), CachedBytecodeNode.doBranchFalse((Frame)frame, bc, bci, sp))) {
                                --sp;
                                bci += 14;
                                break;
                            }
                            --sp;
                            bci = BYTES.getIntUnaligned(bc, bci + 2);
                            break;
                        }
                        case 23: {
                            if (CachedBytecodeNode.profileBranch(branchProfiles, BYTES.getIntUnaligned(bc, bci + 6), CachedBytecodeNode.doBranchFalse$Generic((Frame)frame, bc, bci, sp))) {
                                --sp;
                                bci += 14;
                                break;
                            }
                            --sp;
                            bci = BYTES.getIntUnaligned(bc, bci + 2);
                            break;
                        }
                        case 24: {
                            if (CachedBytecodeNode.profileBranch(branchProfiles, BYTES.getIntUnaligned(bc, bci + 6), CachedBytecodeNode.doBranchFalse$Boolean((Frame)frame, bc, bci, sp))) {
                                --sp;
                                bci += 14;
                                break;
                            }
                            --sp;
                            bci = BYTES.getIntUnaligned(bc, bci + 2);
                            break;
                        }
                        case 25: {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            CachedBytecodeNode.doPop((Frame)frame, bc, bci, sp);
                            --sp;
                            bci += 6;
                            break;
                        }
                        case 26: {
                            CachedBytecodeNode.doPop$Long((Frame)frame, bc, bci, sp);
                            --sp;
                            bci += 6;
                            break;
                        }
                        case 27: {
                            CachedBytecodeNode.doPop$Boolean((Frame)frame, bc, bci, sp);
                            --sp;
                            bci += 6;
                            break;
                        }
                        case 28: {
                            CachedBytecodeNode.doPop$generic((Frame)frame, bc, bci, sp);
                            --sp;
                            bci += 6;
                            break;
                        }
                        case 29: {
                            FRAMES.copy((Frame)frame, sp - 1, sp);
                            ++sp;
                            bci += 2;
                            break;
                        }
                        case 30: {
                            FRAMES.setObject((Frame)frame, sp, (Object)EMPTY_ARRAY);
                            ++sp;
                            bci += 2;
                            break;
                        }
                        case 31: {
                            FRAMES.setObject((Frame)frame, sp - 1, (Object)SLBytecodeRootNodeGen.readVariadic(frame, sp, 1));
                            bci += 2;
                            break;
                        }
                        case 32: {
                            FRAMES.setObject((Frame)frame, sp - 2, (Object)SLBytecodeRootNodeGen.readVariadic(frame, sp, 2));
                            --sp;
                            bci += 2;
                            break;
                        }
                        case 33: {
                            FRAMES.setObject((Frame)frame, sp - 3, (Object)SLBytecodeRootNodeGen.readVariadic(frame, sp, 3));
                            sp -= 2;
                            bci += 2;
                            break;
                        }
                        case 34: {
                            FRAMES.setObject((Frame)frame, sp - 4, (Object)SLBytecodeRootNodeGen.readVariadic(frame, sp, 4));
                            sp -= 3;
                            bci += 2;
                            break;
                        }
                        case 35: {
                            FRAMES.setObject((Frame)frame, sp - 5, (Object)SLBytecodeRootNodeGen.readVariadic(frame, sp, 5));
                            sp -= 4;
                            bci += 2;
                            break;
                        }
                        case 36: {
                            FRAMES.setObject((Frame)frame, sp - 6, (Object)SLBytecodeRootNodeGen.readVariadic(frame, sp, 6));
                            sp -= 5;
                            bci += 2;
                            break;
                        }
                        case 37: {
                            FRAMES.setObject((Frame)frame, sp - 7, (Object)SLBytecodeRootNodeGen.readVariadic(frame, sp, 7));
                            sp -= 6;
                            bci += 2;
                            break;
                        }
                        case 38: {
                            FRAMES.setObject((Frame)frame, sp - 8, (Object)SLBytecodeRootNodeGen.readVariadic(frame, sp, 8));
                            sp -= 7;
                            bci += 2;
                            break;
                        }
                        case 39: {
                            FRAMES.setObject((Frame)frame, sp - 1, (Object)SLBytecodeRootNodeGen.mergeVariadic((Object[])FRAMES.uncheckedGetObject((Frame)frame, sp - 1)));
                            bci += 2;
                            break;
                        }
                        case 40: {
                            FRAMES.setObject((Frame)frame, sp, null);
                            ++sp;
                            bci += 2;
                            break;
                        }
                        case 41: {
                            FRAMES.setObject((Frame)frame, sp, null);
                            ++sp;
                            bci += 2;
                            break;
                        }
                        case 42: {
                            if (CompilerDirectives.hasNextTier() && loopCounter.value > 0) {
                                LoopNode.reportLoopCount((Node)this, (int)loopCounter.value);
                            }
                            return ((long)(sp - 1) & 0xFFFFL) << 32 | 0xFFFFFFFFL;
                        }
                        case 43: {
                            throw SLBytecodeRootNodeGen.sneakyThrow((Throwable)FRAMES.uncheckedGetObject((Frame)frame, sp - 1));
                        }
                        case 44: {
                            FRAMES.setObject((Frame)frame, sp, FRAMES.getObject((Frame)frame, $root.maxLocals + BYTES.getShort(bc, bci + 2)));
                            ++sp;
                            bci += 4;
                            break;
                        }
                        case 45: {
                            this.doTagEnter(frame, bc, bci, sp);
                            bci += 6;
                            break;
                        }
                        case 46: {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.doTagLeave(frame, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 47: {
                            this.doTagLeave$Long(frame, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 48: {
                            this.doTagLeave$Long$unboxed(frame, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 49: {
                            this.doTagLeave$Boolean(frame, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 50: {
                            this.doTagLeave$Boolean$unboxed(frame, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 51: {
                            this.doTagLeave$generic(frame, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 52: {
                            this.doTagLeaveVoid(frame, bc, bci, sp);
                            bci += 6;
                            break;
                        }
                        case 53: {
                            this.doSLAlwaysHalt_(frame, cachedNodes, bc, bci, sp);
                            bci += 2;
                            break;
                        }
                        case 54: {
                            this.doSLLoadArgument_(frame, cachedNodes, bc, bci, sp, consts);
                            ++sp;
                            bci += 10;
                            break;
                        }
                        case 55: {
                            this.doSLLoadArgument$LoadInBounds_(frame, cachedNodes, bc, bci, sp, consts);
                            ++sp;
                            bci += 10;
                            break;
                        }
                        case 56: {
                            this.doBuiltin_(frame, cachedNodes, bc, bci, sp, consts);
                            ++sp;
                            bci += 14;
                            break;
                        }
                        case 57: {
                            this.doSLInvoke_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 6;
                            break;
                        }
                        case 58: {
                            this.doSLAdd_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 59: {
                            this.doSLAdd$Long_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 60: {
                            this.doSLAdd$Long$unboxed_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 61: {
                            this.doSLDiv_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 62: {
                            this.doSLDiv$Long_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 63: {
                            this.doSLDiv$Long$unboxed_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 64: {
                            this.doSLEqual_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 65: {
                            this.doSLEqual$Long_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 66: {
                            this.doSLEqual$Long$unboxed_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 67: {
                            this.doSLEqual$Boolean_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 68: {
                            this.doSLEqual$Boolean$unboxed_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 69: {
                            this.doSLEqual$unboxed_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 70: {
                            this.doSLLessOrEqual_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 71: {
                            this.doSLLessOrEqual$Long_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 72: {
                            this.doSLLessOrEqual$Long$unboxed_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 73: {
                            this.doSLLessOrEqual$SLBigInteger$InteropBigInteger0$InteropBigInteger1_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 74: {
                            this.doSLLessOrEqual$SLBigInteger$InteropBigInteger0$InteropBigInteger1$unboxed_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 75: {
                            this.doSLLessThan_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 76: {
                            this.doSLLessThan$Long_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 77: {
                            this.doSLLessThan$Long$unboxed_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 78: {
                            this.doSLLessThan$unboxed_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 79: {
                            this.doSLLogicalNot_(frame, cachedNodes, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 80: {
                            this.doSLLogicalNot$Boolean_(frame, cachedNodes, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 81: {
                            this.doSLLogicalNot$Boolean$unboxed_(frame, cachedNodes, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 82: {
                            this.doSLLogicalNot$unboxed_(frame, cachedNodes, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 83: {
                            this.doSLMul_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 84: {
                            this.doSLMul$Long_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 85: {
                            this.doSLMul$Long$unboxed_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 86: {
                            this.doSLReadProperty_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 6;
                            break;
                        }
                        case 87: {
                            this.doSLSub_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 88: {
                            this.doSLSub$Long_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 89: {
                            this.doSLSub$Long$unboxed_(frame, cachedNodes, bc, bci, sp);
                            --sp;
                            bci += 14;
                            break;
                        }
                        case 90: {
                            this.doSLWriteProperty_(frame, cachedNodes, bc, bci, sp);
                            sp -= 2;
                            bci += 6;
                            break;
                        }
                        case 91: {
                            this.doSLUnbox_(frame, cachedNodes, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 92: {
                            this.doSLUnbox$FromBoolean_(frame, cachedNodes, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 93: {
                            this.doSLUnbox$FromBoolean$unboxed_(frame, cachedNodes, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 94: {
                            this.doSLUnbox$FromLong_(frame, cachedNodes, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 95: {
                            this.doSLUnbox$FromLong$unboxed_(frame, cachedNodes, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 96: {
                            this.doSLFunctionLiteral_(frame, cachedNodes, bc, bci, sp);
                            bci += 6;
                            break;
                        }
                        case 97: {
                            this.doSLToBoolean_(frame, cachedNodes, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 98: {
                            this.doSLToBoolean$Boolean_(frame, cachedNodes, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 99: {
                            this.doSLToBoolean$Boolean$unboxed_(frame, cachedNodes, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 100: {
                            this.doSLToBoolean$unboxed_(frame, cachedNodes, bc, bci, sp);
                            bci += 10;
                            break;
                        }
                        case 101: {
                            if (CachedBytecodeNode.profileBranch(branchProfiles, BYTES.getIntUnaligned(bc, bci + 6), (Boolean)FRAMES.uncheckedGetObject((Frame)frame, sp - 1) == false)) {
                                bci = BYTES.getIntUnaligned(bc, bci + 2);
                                break;
                            }
                            FRAMES.clear((Frame)frame, sp - 1);
                            --sp;
                            bci += 10;
                            break;
                        }
                        case 102: {
                            if (CachedBytecodeNode.profileBranch(branchProfiles, BYTES.getIntUnaligned(bc, bci + 6), (Boolean)FRAMES.uncheckedGetObject((Frame)frame, sp - 1))) {
                                bci = BYTES.getIntUnaligned(bc, bci + 2);
                                break;
                            }
                            FRAMES.clear((Frame)frame, sp - 1);
                            --sp;
                            bci += 10;
                            break;
                        }
                        case 103: {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            CachedBytecodeNode.doMergeConditional((Frame)frame, bc, bci, sp, FRAMES.requireObject((Frame)frame, sp - 1));
                            --sp;
                            bci += 10;
                            break;
                        }
                        case 104: {
                            CachedBytecodeNode.doMergeConditional$Long((Frame)frame, bc, bci, sp);
                            --sp;
                            bci += 10;
                            break;
                        }
                        case 105: {
                            CachedBytecodeNode.doMergeConditional$Long$unboxed((Frame)frame, bc, bci, sp);
                            --sp;
                            bci += 10;
                            break;
                        }
                        case 106: {
                            CachedBytecodeNode.doMergeConditional$Boolean((Frame)frame, bc, bci, sp);
                            --sp;
                            bci += 10;
                            break;
                        }
                        case 107: {
                            CachedBytecodeNode.doMergeConditional$Boolean$unboxed((Frame)frame, bc, bci, sp);
                            --sp;
                            bci += 10;
                            break;
                        }
                        case 108: {
                            CachedBytecodeNode.doMergeConditional$generic((Frame)frame, bc, bci, sp);
                            --sp;
                            bci += 10;
                            break;
                        }
                        case 109: {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return ((long)sp & 0xFFFFL) << 32 | (long)bci & 0xFFFFFFFFL;
                        }
                        case 110: {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return ((long)sp & 0xFFFFL) << 32 | (long)bci & 0xFFFFFFFFL;
                        }
                        case 111: {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return ((long)sp & 0xFFFFL) << 32 | (long)bci & 0xFFFFFFFFL;
                        }
                        case 112: {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return ((long)sp & 0xFFFFL) << 32 | (long)bci & 0xFFFFFFFFL;
                        }
                        case 113: {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return ((long)sp & 0xFFFFL) << 32 | (long)bci & 0xFFFFFFFFL;
                        }
                        case 114: {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return ((long)sp & 0xFFFFL) << 32 | (long)bci & 0xFFFFFFFFL;
                        }
                        case 115: {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return ((long)sp & 0xFFFFL) << 32 | (long)bci & 0xFFFFFFFFL;
                        }
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    throwable = this.resolveThrowable($root, frame, bci, throwable);
                    op = -5;
                    block135: while ((op = this.resolveHandler(bci, op + 5, this.handlers)) != -1) {
                        try {
                            block121 : switch (this.handlers[op + 2]) {
                                case 1: {
                                    TagNode node = this.tagRoot.tagNodes[this.handlers[op + 3]];
                                    Object result = this.doTagExceptional(frame, node, this.handlers[op + 3], bc, bci, throwable);
                                    if (result == null) {
                                        throw throwable;
                                    }
                                    temp = this.handlers[op + 4] + $root.maxLocals;
                                    if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                                        bci = node.enterBci;
                                        break;
                                    }
                                    switch (this.readValidBytecode(bc, node.returnBci)) {
                                        case 46: 
                                        case 47: 
                                        case 49: 
                                        case 51: {
                                            FRAMES.setObject((Frame)frame, (int)temp, result);
                                            ++temp;
                                            bci = node.returnBci + 10;
                                            break block121;
                                        }
                                        case 48: {
                                            try {
                                                FRAMES.setLong((Frame)frame, (int)temp, SLBytecodeRootNodeGen.expectLong(result));
                                            }
                                            catch (UnexpectedResultException e) {
                                                FRAMES.setObject((Frame)frame, (int)temp, e.getResult());
                                            }
                                            ++temp;
                                            bci = node.returnBci + 10;
                                            break block121;
                                        }
                                        case 50: {
                                            try {
                                                FRAMES.setBoolean((Frame)frame, (int)temp, SLBytecodeRootNodeGen.expectBoolean(result));
                                            }
                                            catch (UnexpectedResultException e) {
                                                FRAMES.setObject((Frame)frame, (int)temp, e.getResult());
                                            }
                                            ++temp;
                                            bci = node.returnBci + 10;
                                            break block121;
                                        }
                                        case 52: {
                                            bci = node.returnBci + 6;
                                            break block121;
                                        }
                                    }
                                    throw CompilerDirectives.shouldNotReachHere();
                                }
                                default: {
                                    if (throwable instanceof ThreadDeath) continue block135;
                                    assert (throwable instanceof AbstractTruffleException);
                                    bci = this.handlers[op + 3];
                                    temp = this.handlers[op + 4] + $root.maxLocals;
                                    FRAMES.setObject((Frame)frame, (int)temp - 1, (Object)throwable);
                                    break;
                                }
                            }
                        }
                        catch (Throwable t) {
                            if (t == throwable) continue;
                            throwable = this.resolveThrowable($root, frame, bci, t);
                            continue;
                        }
                        assert ((long)sp >= temp - 1L);
                        while ((long)sp > temp) {
                            FRAMES.clear((Frame)frame, --sp);
                        }
                        sp = (int)temp;
                        continue block134;
                    }
                    if (CompilerDirectives.hasNextTier() && loopCounter.value > 0) {
                        LoopNode.reportLoopCount((Node)this, (int)loopCounter.value);
                    }
                    throw SLBytecodeRootNodeGen.sneakyThrow(throwable);
                }
                break;
            }
        }

        private void doLoadArgument$Long(VirtualFrame frame, byte[] bc, int bci, int sp) {
            try {
                FRAMES.setLong((Frame)frame, sp, SLBytecodeRootNodeGen.expectLong(frame.getArguments()[BYTES.getShort(bc, bci + 2)]));
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                BYTES.putShort(bc, bci, (short)1);
                FRAMES.setObject((Frame)frame, sp, e.getResult());
            }
        }

        private void doLoadArgument$Boolean(VirtualFrame frame, byte[] bc, int bci, int sp) {
            try {
                FRAMES.setBoolean((Frame)frame, sp, SLBytecodeRootNodeGen.expectBoolean(frame.getArguments()[BYTES.getShort(bc, bci + 2)]));
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                BYTES.putShort(bc, bci, (short)1);
                FRAMES.setObject((Frame)frame, sp, e.getResult());
            }
        }

        private void doLoadLocal(Frame frame, byte[] bc, int bci, int sp, byte[] localTags) {
            Object value;
            short newInstruction;
            short slot = BYTES.getShort(bc, bci + 2);
            short localIndex = BYTES.getShort(bc, bci + 4);
            byte tag = this.getCachedLocalTagInternal(localTags, localIndex);
            try {
                switch (tag) {
                    case 1: {
                        newInstruction = 8;
                        value = FRAMES.expectLong(frame, (int)slot);
                        break;
                    }
                    case 5: {
                        newInstruction = 10;
                        value = FRAMES.expectBoolean(frame, (int)slot);
                        break;
                    }
                    case 0: 
                    case 7: {
                        newInstruction = 12;
                        value = FRAMES.expectObject(frame, (int)slot);
                        break;
                    }
                    default: {
                        throw CompilerDirectives.shouldNotReachHere((String)"Unexpected frame tag.");
                    }
                }
            }
            catch (UnexpectedResultException ex) {
                newInstruction = 12;
                value = ex.getResult();
            }
            BYTES.putShort(bc, bci, newInstruction);
            FRAMES.setObject(frame, sp, value);
        }

        private void doLoadLocal$Long(Frame frame, byte[] bc, int bci, int sp, byte[] localTags) {
            try {
                FRAMES.setObject(frame, sp, (Object)FRAMES.expectLong(frame, (int)BYTES.getShort(bc, bci + 2)));
            }
            catch (UnexpectedResultException ex) {
                this.doLoadLocal(frame, bc, bci, sp, localTags);
            }
        }

        private void doLoadLocal$Long$unboxed(Frame frame, byte[] bc, int bci, int sp, byte[] localTags) {
            try {
                FRAMES.setLong(frame, sp, FRAMES.expectLong(frame, (int)BYTES.getShort(bc, bci + 2)));
            }
            catch (UnexpectedResultException ex) {
                this.doLoadLocal(frame, bc, bci, sp, localTags);
            }
        }

        private void doLoadLocal$Boolean(Frame frame, byte[] bc, int bci, int sp, byte[] localTags) {
            try {
                FRAMES.setObject(frame, sp, (Object)FRAMES.expectBoolean(frame, (int)BYTES.getShort(bc, bci + 2)));
            }
            catch (UnexpectedResultException ex) {
                this.doLoadLocal(frame, bc, bci, sp, localTags);
            }
        }

        private void doLoadLocal$Boolean$unboxed(Frame frame, byte[] bc, int bci, int sp, byte[] localTags) {
            try {
                FRAMES.setBoolean(frame, sp, FRAMES.expectBoolean(frame, (int)BYTES.getShort(bc, bci + 2)));
            }
            catch (UnexpectedResultException ex) {
                this.doLoadLocal(frame, bc, bci, sp, localTags);
            }
        }

        private void doLoadLocal$generic(Frame frame, byte[] bc, int bci, int sp, byte[] localTags) {
            FRAMES.setObject(frame, sp, FRAMES.requireObject(frame, (int)BYTES.getShort(bc, bci + 2)));
        }

        private void doStoreLocal(Frame frame, byte[] bc, int bci, int sp, Object local, byte[] localTags) {
            byte newTag;
            short newInstruction;
            short newOperand;
            byte oldTag;
            int operandIndex;
            short localIndex;
            block14: {
                short operand;
                short slot;
                block15: {
                    block13: {
                        slot = BYTES.getShort(bc, bci + 2);
                        localIndex = BYTES.getShort(bc, bci + 4);
                        operandIndex = BYTES.getIntUnaligned(bc, bci + 6);
                        operand = BYTES.getShort(bc, operandIndex);
                        oldTag = this.getCachedLocalTagInternal(localTags, localIndex);
                        if (!(local instanceof Long)) break block13;
                        switch (oldTag) {
                            case 1: 
                            case 7: {
                                newOperand = SLBytecodeRootNodeGen.applyQuickeningLong(operand);
                                if (newOperand != -1) {
                                    newInstruction = 16;
                                } else {
                                    newInstruction = 15;
                                    newOperand = operand;
                                }
                                newTag = 1;
                                FRAMES.setLong(frame, (int)slot, ((Long)local).longValue());
                                break block14;
                            }
                            case 0: 
                            case 5: {
                                newInstruction = 19;
                                newOperand = SLBytecodeRootNodeGen.undoQuickening(operand);
                                newTag = 0;
                                FRAMES.setObject(frame, (int)slot, local);
                                break block14;
                            }
                            default: {
                                throw CompilerDirectives.shouldNotReachHere((String)"Unexpected frame tag.");
                            }
                        }
                    }
                    if (!(local instanceof Boolean)) break block15;
                    switch (oldTag) {
                        case 5: 
                        case 7: {
                            newOperand = SLBytecodeRootNodeGen.applyQuickeningBoolean(operand);
                            if (newOperand != -1) {
                                newInstruction = 18;
                            } else {
                                newInstruction = 17;
                                newOperand = operand;
                            }
                            newTag = 5;
                            FRAMES.setBoolean(frame, (int)slot, ((Boolean)local).booleanValue());
                            break block14;
                        }
                        case 0: 
                        case 1: {
                            newInstruction = 19;
                            newOperand = SLBytecodeRootNodeGen.undoQuickening(operand);
                            newTag = 0;
                            FRAMES.setObject(frame, (int)slot, local);
                            break block14;
                        }
                        default: {
                            throw CompilerDirectives.shouldNotReachHere((String)"Unexpected frame tag.");
                        }
                    }
                }
                newInstruction = 19;
                newOperand = SLBytecodeRootNodeGen.undoQuickening(operand);
                newTag = 0;
                FRAMES.setObject(frame, (int)slot, local);
            }
            if (newTag != oldTag) {
                this.setCachedLocalTagInternal(localTags, localIndex, newTag);
            }
            BYTES.putShort(bc, operandIndex, newOperand);
            BYTES.putShort(bc, bci, newInstruction);
            FRAMES.clear(frame, sp - 1);
        }

        private void doStoreLocal$Long(Frame frame, byte[] bc, int bci, int sp, byte[] localTags) {
            Object local;
            try {
                local = FRAMES.expectObject(frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                this.doStoreLocal(frame, bc, bci, sp, ex.getResult(), localTags);
                return;
            }
            short slot = BYTES.getShort(bc, bci + 2);
            short localIndex = BYTES.getShort(bc, bci + 4);
            byte tag = this.getCachedLocalTagInternal(localTags, localIndex);
            if (tag == 1) {
                try {
                    FRAMES.setLong(frame, (int)slot, SLBytecodeRootNodeGen.expectLong(local));
                    if (CompilerDirectives.inCompiledCode()) {
                        FRAMES.clear(frame, sp - 1);
                    }
                    return;
                }
                catch (UnexpectedResultException ex) {
                    local = ex.getResult();
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.doStoreLocal(frame, bc, bci, sp, local, localTags);
        }

        private void doStoreLocal$Long$Long(Frame frame, byte[] bc, int bci, int sp, byte[] localTags) {
            long local;
            try {
                local = FRAMES.expectLong(frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                this.doStoreLocal(frame, bc, bci, sp, ex.getResult(), localTags);
                return;
            }
            short slot = BYTES.getShort(bc, bci + 2);
            short localIndex = BYTES.getShort(bc, bci + 4);
            byte tag = this.getCachedLocalTagInternal(localTags, localIndex);
            if (tag == 1) {
                FRAMES.setLong(frame, (int)slot, local);
                if (CompilerDirectives.inCompiledCode()) {
                    FRAMES.clear(frame, sp - 1);
                }
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.doStoreLocal(frame, bc, bci, sp, local, localTags);
        }

        private void doStoreLocal$Boolean(Frame frame, byte[] bc, int bci, int sp, byte[] localTags) {
            Object local;
            try {
                local = FRAMES.expectObject(frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                this.doStoreLocal(frame, bc, bci, sp, ex.getResult(), localTags);
                return;
            }
            short slot = BYTES.getShort(bc, bci + 2);
            short localIndex = BYTES.getShort(bc, bci + 4);
            byte tag = this.getCachedLocalTagInternal(localTags, localIndex);
            if (tag == 5) {
                try {
                    FRAMES.setBoolean(frame, (int)slot, SLBytecodeRootNodeGen.expectBoolean(local));
                    if (CompilerDirectives.inCompiledCode()) {
                        FRAMES.clear(frame, sp - 1);
                    }
                    return;
                }
                catch (UnexpectedResultException ex) {
                    local = ex.getResult();
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.doStoreLocal(frame, bc, bci, sp, local, localTags);
        }

        private void doStoreLocal$Boolean$Boolean(Frame frame, byte[] bc, int bci, int sp, byte[] localTags) {
            boolean local;
            try {
                local = FRAMES.expectBoolean(frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                this.doStoreLocal(frame, bc, bci, sp, ex.getResult(), localTags);
                return;
            }
            short slot = BYTES.getShort(bc, bci + 2);
            short localIndex = BYTES.getShort(bc, bci + 4);
            byte tag = this.getCachedLocalTagInternal(localTags, localIndex);
            if (tag == 5) {
                FRAMES.setBoolean(frame, (int)slot, local);
                if (CompilerDirectives.inCompiledCode()) {
                    FRAMES.clear(frame, sp - 1);
                }
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.doStoreLocal(frame, bc, bci, sp, local, localTags);
        }

        private void doStoreLocal$generic(Frame frame, byte[] bc, int bci, int sp, byte[] localTags) {
            Object local;
            try {
                local = FRAMES.expectObject(frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                this.doStoreLocal(frame, bc, bci, sp, ex.getResult(), localTags);
                return;
            }
            FRAMES.setObject(frame, (int)BYTES.getShort(bc, bci + 2), local);
            FRAMES.clear(frame, sp - 1);
        }

        private long doBranchBackward(VirtualFrame frame, byte[] bc, int bci, int sp) {
            if (CompilerDirectives.inInterpreter() && BytecodeOSRNode.pollOSRBackEdge((BytecodeOSRNode)this)) {
                int branchProfileIndex = BYTES.getIntUnaligned(bc, bci + 6);
                CachedBytecodeNode.ensureFalseProfile(this.branchProfiles_, branchProfileIndex);
                Object osrResult = BytecodeOSRNode.tryOSR((BytecodeOSRNode)this, (long)(((long)sp & 0xFFFFL) << 32 | (long)BYTES.getIntUnaligned(bc, bci + 2) & 0xFFFFFFFFL), null, null, (VirtualFrame)frame);
                if (osrResult != null) {
                    return (Long)osrResult;
                }
            }
            return -1L;
        }

        @HostCompilerDirectives.InliningCutoff
        private void doTagEnter(VirtualFrame frame, byte[] bc, int bci, int sp) {
            TagNode tagNode = (TagNode)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])this.tagRoot.tagNodes, BYTES.getIntUnaligned(bc, bci + 2)), TagNode.class));
            tagNode.findProbe().onEnter(frame);
        }

        private void doTagLeave(VirtualFrame frame, byte[] bc, int bci, int sp) {
            short newInstruction;
            short newOperand;
            CompilerDirectives.transferToInterpreterAndInvalidate();
            int operandIndex = BYTES.getIntUnaligned(bc, bci + 6);
            short operand = BYTES.getShort(bc, operandIndex);
            Object value = FRAMES.requireObject((Frame)frame, sp - 1);
            if (value instanceof Long && (newOperand = SLBytecodeRootNodeGen.applyQuickeningLong(operand)) != -1) {
                newInstruction = 47;
            } else if (value instanceof Boolean && (newOperand = SLBytecodeRootNodeGen.applyQuickeningBoolean(operand)) != -1) {
                newInstruction = 49;
            } else {
                newOperand = SLBytecodeRootNodeGen.undoQuickening(operand);
                newInstruction = 51;
            }
            BYTES.putShort(bc, operandIndex, newOperand);
            BYTES.putShort(bc, bci, newInstruction);
            TagNode tagNode = (TagNode)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])this.tagRoot.tagNodes, BYTES.getIntUnaligned(bc, bci + 2)), TagNode.class));
            tagNode.findProbe().onReturnValue(frame, value);
        }

        private void doTagLeave$Long(VirtualFrame frame, byte[] bc, int bci, int sp) {
            long returnValue;
            try {
                returnValue = FRAMES.expectLong((Frame)frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                this.doTagLeave(frame, bc, bci, sp);
                return;
            }
            TagNode tagNode = (TagNode)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])this.tagRoot.tagNodes, BYTES.getIntUnaligned(bc, bci + 2)), TagNode.class));
            tagNode.findProbe().onReturnValue(frame, (Object)returnValue);
            FRAMES.setObject((Frame)frame, sp - 1, (Object)returnValue);
        }

        private void doTagLeave$Long$unboxed(VirtualFrame frame, byte[] bc, int bci, int sp) {
            long returnValue;
            try {
                returnValue = FRAMES.expectLong((Frame)frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                this.doTagLeave(frame, bc, bci, sp);
                return;
            }
            TagNode tagNode = (TagNode)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])this.tagRoot.tagNodes, BYTES.getIntUnaligned(bc, bci + 2)), TagNode.class));
            tagNode.findProbe().onReturnValue(frame, (Object)returnValue);
        }

        private void doTagLeave$Boolean(VirtualFrame frame, byte[] bc, int bci, int sp) {
            boolean returnValue;
            try {
                returnValue = FRAMES.expectBoolean((Frame)frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                this.doTagLeave(frame, bc, bci, sp);
                return;
            }
            TagNode tagNode = (TagNode)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])this.tagRoot.tagNodes, BYTES.getIntUnaligned(bc, bci + 2)), TagNode.class));
            tagNode.findProbe().onReturnValue(frame, (Object)returnValue);
            FRAMES.setObject((Frame)frame, sp - 1, (Object)returnValue);
        }

        private void doTagLeave$Boolean$unboxed(VirtualFrame frame, byte[] bc, int bci, int sp) {
            boolean returnValue;
            try {
                returnValue = FRAMES.expectBoolean((Frame)frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                this.doTagLeave(frame, bc, bci, sp);
                return;
            }
            TagNode tagNode = (TagNode)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])this.tagRoot.tagNodes, BYTES.getIntUnaligned(bc, bci + 2)), TagNode.class));
            tagNode.findProbe().onReturnValue(frame, (Object)returnValue);
        }

        private void doTagLeave$generic(VirtualFrame frame, byte[] bc, int bci, int sp) {
            Object returnValue = FRAMES.requireObject((Frame)frame, sp - 1);
            TagNode tagNode = (TagNode)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])this.tagRoot.tagNodes, BYTES.getIntUnaligned(bc, bci + 2)), TagNode.class));
            tagNode.findProbe().onReturnValue(frame, returnValue);
        }

        @HostCompilerDirectives.InliningCutoff
        private void doTagLeaveVoid(VirtualFrame frame, byte[] bc, int bci, int sp) {
            TagNode tagNode = (TagNode)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])this.tagRoot.tagNodes, BYTES.getIntUnaligned(bc, bci + 2)), TagNode.class));
            tagNode.findProbe().onReturnValue(frame, null);
        }

        private void doSLAlwaysHalt_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLAlwaysHalt_Node node = SLAlwaysHalt_Node.SINGLETON;
            node.execute(frame, this, bc, bci, sp);
        }

        private void doSLLoadArgument_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp, Object[] consts) {
            SLLoadArgument_Node node = (SLLoadArgument_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 6)), SLLoadArgument_Node.class));
            Object result = node.execute(frame, this, bc, bci, sp, consts);
            FRAMES.setObject((Frame)frame, sp, result);
        }

        private void doSLLoadArgument$LoadInBounds_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp, Object[] consts) {
            SLLoadArgument_Node node = (SLLoadArgument_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 6)), SLLoadArgument_Node.class));
            Object result = node.executeLoadInBounds(frame, this, bc, bci, sp, consts);
            FRAMES.setObject((Frame)frame, sp, result);
        }

        private void doBuiltin_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp, Object[] consts) {
            Builtin_Node node = (Builtin_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 10)), Builtin_Node.class));
            Object result = node.execute(frame, this, bc, bci, sp, consts);
            FRAMES.setObject((Frame)frame, sp, result);
        }

        private void doSLInvoke_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLInvoke_Node node = (SLInvoke_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLInvoke_Node.class));
            Object result = node.execute(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLAdd_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLAdd_Node node = (SLAdd_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLAdd_Node.class));
            Object result = node.execute(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLAdd$Long_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLAdd_Node node = (SLAdd_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLAdd_Node.class));
            try {
                long result = node.executeLong(frame, this, bc, bci, sp);
                FRAMES.setObject((Frame)frame, sp - 2, (Object)result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 2, ex.getResult());
            }
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLAdd$Long$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLAdd_Node node = (SLAdd_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLAdd_Node.class));
            try {
                long result = node.executeLong$unboxed(frame, this, bc, bci, sp);
                FRAMES.setLong((Frame)frame, sp - 2, result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 2, ex.getResult());
            }
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLDiv_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLDiv_Node node = (SLDiv_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLDiv_Node.class));
            Object result = node.execute(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLDiv$Long_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLDiv_Node node = (SLDiv_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLDiv_Node.class));
            try {
                long result = node.executeLong(frame, this, bc, bci, sp);
                FRAMES.setObject((Frame)frame, sp - 2, (Object)result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 2, ex.getResult());
            }
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLDiv$Long$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLDiv_Node node = (SLDiv_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLDiv_Node.class));
            try {
                long result = node.executeLong$unboxed(frame, this, bc, bci, sp);
                FRAMES.setLong((Frame)frame, sp - 2, result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 2, ex.getResult());
            }
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLEqual_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLEqual_Node node = (SLEqual_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLEqual_Node.class));
            boolean result = node.execute(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, (Object)result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLEqual$Long_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLEqual_Node node = (SLEqual_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLEqual_Node.class));
            boolean result = node.executeLong(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, (Object)result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLEqual$Long$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLEqual_Node node = (SLEqual_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLEqual_Node.class));
            boolean result = node.executeLong$unboxed(frame, this, bc, bci, sp);
            FRAMES.setBoolean((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLEqual$Boolean_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLEqual_Node node = (SLEqual_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLEqual_Node.class));
            boolean result = node.executeBoolean(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, (Object)result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLEqual$Boolean$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLEqual_Node node = (SLEqual_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLEqual_Node.class));
            boolean result = node.executeBoolean$unboxed(frame, this, bc, bci, sp);
            FRAMES.setBoolean((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLEqual$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLEqual_Node node = (SLEqual_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLEqual_Node.class));
            boolean result = node.executeunboxed(frame, this, bc, bci, sp);
            FRAMES.setBoolean((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLLessOrEqual_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLLessOrEqual_Node node = (SLLessOrEqual_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLLessOrEqual_Node.class));
            Object result = node.execute(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLLessOrEqual$Long_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLLessOrEqual_Node node = (SLLessOrEqual_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLLessOrEqual_Node.class));
            try {
                boolean result = node.executeLong(frame, this, bc, bci, sp);
                FRAMES.setObject((Frame)frame, sp - 2, (Object)result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 2, ex.getResult());
            }
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLLessOrEqual$Long$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLLessOrEqual_Node node = (SLLessOrEqual_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLLessOrEqual_Node.class));
            try {
                boolean result = node.executeLong$unboxed(frame, this, bc, bci, sp);
                FRAMES.setBoolean((Frame)frame, sp - 2, result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 2, ex.getResult());
            }
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLLessOrEqual$SLBigInteger$InteropBigInteger0$InteropBigInteger1_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLLessOrEqual_Node node = (SLLessOrEqual_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLLessOrEqual_Node.class));
            try {
                boolean result = node.executeSLBigInteger_InteropBigInteger0_InteropBigInteger1(frame, this, bc, bci, sp);
                FRAMES.setObject((Frame)frame, sp - 2, (Object)result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 2, ex.getResult());
            }
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLLessOrEqual$SLBigInteger$InteropBigInteger0$InteropBigInteger1$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLLessOrEqual_Node node = (SLLessOrEqual_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLLessOrEqual_Node.class));
            try {
                boolean result = node.executeSLBigInteger_InteropBigInteger0_InteropBigInteger1$unboxed(frame, this, bc, bci, sp);
                FRAMES.setBoolean((Frame)frame, sp - 2, result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 2, ex.getResult());
            }
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLLessThan_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLLessThan_Node node = (SLLessThan_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLLessThan_Node.class));
            boolean result = node.execute(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, (Object)result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLLessThan$Long_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLLessThan_Node node = (SLLessThan_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLLessThan_Node.class));
            boolean result = node.executeLong(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, (Object)result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLLessThan$Long$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLLessThan_Node node = (SLLessThan_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLLessThan_Node.class));
            boolean result = node.executeLong$unboxed(frame, this, bc, bci, sp);
            FRAMES.setBoolean((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLLessThan$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLLessThan_Node node = (SLLessThan_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLLessThan_Node.class));
            boolean result = node.executeunboxed(frame, this, bc, bci, sp);
            FRAMES.setBoolean((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLLogicalNot_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLLogicalNot_Node node = (SLLogicalNot_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLLogicalNot_Node.class));
            boolean result = node.execute(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 1, (Object)result);
        }

        private void doSLLogicalNot$Boolean_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLLogicalNot_Node node = (SLLogicalNot_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLLogicalNot_Node.class));
            boolean result = node.executeBoolean(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 1, (Object)result);
        }

        private void doSLLogicalNot$Boolean$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLLogicalNot_Node node = (SLLogicalNot_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLLogicalNot_Node.class));
            boolean result = node.executeBoolean$unboxed(frame, this, bc, bci, sp);
            FRAMES.setBoolean((Frame)frame, sp - 1, result);
        }

        private void doSLLogicalNot$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLLogicalNot_Node node = (SLLogicalNot_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLLogicalNot_Node.class));
            boolean result = node.executeunboxed(frame, this, bc, bci, sp);
            FRAMES.setBoolean((Frame)frame, sp - 1, result);
        }

        private void doSLMul_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLMul_Node node = (SLMul_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLMul_Node.class));
            Object result = node.execute(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLMul$Long_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLMul_Node node = (SLMul_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLMul_Node.class));
            try {
                long result = node.executeLong(frame, this, bc, bci, sp);
                FRAMES.setObject((Frame)frame, sp - 2, (Object)result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 2, ex.getResult());
            }
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLMul$Long$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLMul_Node node = (SLMul_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLMul_Node.class));
            try {
                long result = node.executeLong$unboxed(frame, this, bc, bci, sp);
                FRAMES.setLong((Frame)frame, sp - 2, result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 2, ex.getResult());
            }
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLReadProperty_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLReadProperty_Node node = (SLReadProperty_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLReadProperty_Node.class));
            Object result = node.execute(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLSub_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLSub_Node node = (SLSub_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLSub_Node.class));
            Object result = node.execute(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 2, result);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLSub$Long_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLSub_Node node = (SLSub_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLSub_Node.class));
            try {
                long result = node.executeLong(frame, this, bc, bci, sp);
                FRAMES.setObject((Frame)frame, sp - 2, (Object)result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 2, ex.getResult());
            }
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLSub$Long$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLSub_Node node = (SLSub_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLSub_Node.class));
            try {
                long result = node.executeLong$unboxed(frame, this, bc, bci, sp);
                FRAMES.setLong((Frame)frame, sp - 2, result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 2, ex.getResult());
            }
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLWriteProperty_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLWriteProperty_Node node = (SLWriteProperty_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLWriteProperty_Node.class));
            Object result = node.execute(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 3, result);
            FRAMES.clear((Frame)frame, sp - 2);
            FRAMES.clear((Frame)frame, sp - 1);
        }

        private void doSLUnbox_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLUnbox_Node node = (SLUnbox_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLUnbox_Node.class));
            Object result = node.execute(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 1, result);
        }

        private void doSLUnbox$FromBoolean_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLUnbox_Node node = (SLUnbox_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLUnbox_Node.class));
            try {
                boolean result = node.executeFromBoolean(frame, this, bc, bci, sp);
                FRAMES.setObject((Frame)frame, sp - 1, (Object)result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 1, ex.getResult());
            }
        }

        private void doSLUnbox$FromBoolean$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLUnbox_Node node = (SLUnbox_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLUnbox_Node.class));
            try {
                boolean result = node.executeFromBoolean$unboxed(frame, this, bc, bci, sp);
                FRAMES.setBoolean((Frame)frame, sp - 1, result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 1, ex.getResult());
            }
        }

        private void doSLUnbox$FromLong_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLUnbox_Node node = (SLUnbox_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLUnbox_Node.class));
            try {
                long result = node.executeFromLong(frame, this, bc, bci, sp);
                FRAMES.setObject((Frame)frame, sp - 1, (Object)result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 1, ex.getResult());
            }
        }

        private void doSLUnbox$FromLong$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLUnbox_Node node = (SLUnbox_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLUnbox_Node.class));
            try {
                long result = node.executeFromLong$unboxed(frame, this, bc, bci, sp);
                FRAMES.setLong((Frame)frame, sp - 1, result);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                FRAMES.setObject((Frame)frame, sp - 1, ex.getResult());
            }
        }

        private void doSLFunctionLiteral_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLFunctionLiteral_Node node = (SLFunctionLiteral_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLFunctionLiteral_Node.class));
            SLFunction result = node.execute(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 1, (Object)result);
        }

        private void doSLToBoolean_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLToBoolean_Node node = (SLToBoolean_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLToBoolean_Node.class));
            boolean result = node.execute(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 1, (Object)result);
        }

        private void doSLToBoolean$Boolean_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLToBoolean_Node node = (SLToBoolean_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLToBoolean_Node.class));
            boolean result = node.executeBoolean(frame, this, bc, bci, sp);
            FRAMES.setObject((Frame)frame, sp - 1, (Object)result);
        }

        private void doSLToBoolean$Boolean$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLToBoolean_Node node = (SLToBoolean_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLToBoolean_Node.class));
            boolean result = node.executeBoolean$unboxed(frame, this, bc, bci, sp);
            FRAMES.setBoolean((Frame)frame, sp - 1, result);
        }

        private void doSLToBoolean$unboxed_(VirtualFrame frame, Node[] cachedNodes, byte[] bc, int bci, int sp) {
            SLToBoolean_Node node = (SLToBoolean_Node)((Object)ACCESS.uncheckedCast(ACCESS.readObject((Object[])cachedNodes, BYTES.getIntUnaligned(bc, bci + 2)), SLToBoolean_Node.class));
            boolean result = node.executeunboxed(frame, this, bc, bci, sp);
            FRAMES.setBoolean((Frame)frame, sp - 1, result);
        }

        @Override
        public void adoptNodesAfterUpdate() {
            this.insert(this.cachedNodes_);
        }

        public Object executeOSR(VirtualFrame frame, long target, Object unused) {
            return this.continueAt(this.getRoot(), frame, target);
        }

        public void prepareOSR(long target) {
        }

        public void copyIntoOSRFrame(VirtualFrame osrFrame, VirtualFrame parentFrame, long target, Object targetMetadata) {
            this.transferOSRFrame(osrFrame, parentFrame, target, targetMetadata);
        }

        public Object getOSRMetadata() {
            return this.osrMetadata_;
        }

        public void setOSRMetadata(Object osrMetadata) {
            this.osrMetadata_ = osrMetadata;
        }

        public Object[] storeParentFrameInArguments(VirtualFrame parentFrame) {
            Object[] parentArgs = parentFrame.getArguments();
            Object[] result = Arrays.copyOf(parentArgs, parentArgs.length + 1);
            result[result.length - 1] = parentFrame;
            return result;
        }

        public Frame restoreParentFrameFromArguments(Object[] arguments) {
            return (Frame)arguments[arguments.length - 1];
        }

        public void setUncachedThreshold(int threshold) {
        }

        public BytecodeTier getTier() {
            return BytecodeTier.CACHED;
        }

        @HostCompilerDirectives.InliningCutoff
        private Throwable resolveThrowable(SLBytecodeRootNodeGen $root, VirtualFrame frame, int bci, Throwable throwable) {
            if (throwable instanceof AbstractTruffleException) {
                AbstractTruffleException ate = (AbstractTruffleException)throwable;
                return ate;
            }
            if (throwable instanceof ControlFlowException) {
                ControlFlowException cfe = (ControlFlowException)throwable;
                throw cfe;
            }
            if (throwable instanceof ThreadDeath) {
                ThreadDeath cfe = (ThreadDeath)throwable;
                return cfe;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw SLBytecodeRootNodeGen.sneakyThrow(throwable);
        }

        @ExplodeLoop
        private int resolveHandler(int bci, int handler, int[] localHandlers) {
            int handlerEntryIndex = Math.floorDiv(handler, 5);
            int i = handler;
            while (i < localHandlers.length) {
                if (localHandlers[i + 0] <= bci && localHandlers[i + 1] > bci) {
                    if (!this.exceptionProfiles_[handlerEntryIndex]) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.exceptionProfiles_[handlerEntryIndex] = true;
                    }
                    return i;
                }
                i += 5;
                ++handlerEntryIndex;
            }
            return -1;
        }

        private Object doTagExceptional(VirtualFrame frame, TagNode node, int nodeId, byte[] bc, int bci, Throwable exception) throws Throwable {
            return node.findProbe().onReturnExceptionalOrUnwind(frame, exception, switch (this.readValidBytecode(bc, bci)) {
                case 46, 47, 48, 49, 50, 51 -> BYTES.getIntUnaligned(bc, bci + 2) == nodeId;
                case 52 -> BYTES.getIntUnaligned(bc, bci + 2) == nodeId;
                default -> false;
            });
        }

        @Override
        byte[] getLocalTags() {
            return this.localTags_;
        }

        public Object getLocalValue(int bci, Frame frame, int localOffset) {
            assert (this.validateBytecodeIndex(bci));
            CompilerAsserts.partialEvaluationConstant((int)bci);
            CompilerAsserts.partialEvaluationConstant((int)localOffset);
            assert (localOffset >= 0 && localOffset < this.getLocalCount(bci)) : "Invalid out-of-bounds local offset provided.";
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            int frameIndex = 1 + localOffset;
            try {
                byte tag;
                if (CompilerDirectives.inInterpreter()) {
                    tag = frame.getTag(frameIndex);
                } else {
                    int localIndex = this.localOffsetToLocalIndex(bci, localOffset);
                    tag = this.getCachedLocalTagInternal(this.localTags_, localIndex);
                }
                switch (tag) {
                    case 1: {
                        return frame.expectLong(frameIndex);
                    }
                    case 5: {
                        return frame.expectBoolean(frameIndex);
                    }
                    case 0: {
                        return frame.expectObject(frameIndex);
                    }
                    case 7: {
                        return null;
                    }
                }
                throw CompilerDirectives.shouldNotReachHere((String)"Unexpected tag");
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        public void setLocalValue(int bci, Frame frame, int localOffset, Object value) {
            assert (this.validateBytecodeIndex(bci));
            CompilerAsserts.partialEvaluationConstant((int)bci);
            CompilerAsserts.partialEvaluationConstant((int)localOffset);
            assert (localOffset >= 0 && localOffset < this.getLocalCount(bci)) : "Invalid out-of-bounds local offset provided.";
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            this.setLocalValueImpl(frame, localOffset, value, bci);
        }

        protected Object getLocalValueInternal(Frame frame, int localOffset, int localIndex) {
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            int frameIndex = 1 + localOffset;
            try {
                byte tag = this.getCachedLocalTag(localIndex);
                switch (tag) {
                    case 1: {
                        return frame.expectLong(frameIndex);
                    }
                    case 5: {
                        return frame.expectBoolean(frameIndex);
                    }
                    case 0: {
                        return frame.expectObject(frameIndex);
                    }
                    case 7: {
                        throw new FrameSlotTypeException();
                    }
                }
                throw CompilerDirectives.shouldNotReachHere((String)"unexpected tag");
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        protected void setLocalValueInternal(Frame frame, int localOffset, int localIndex, Object value) {
            byte newTag;
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            int frameIndex = 1 + localOffset;
            byte oldTag = this.getCachedLocalTag(localIndex);
            switch (oldTag) {
                case 1: {
                    if (value instanceof Long) {
                        Long longValue = (Long)value;
                        frame.setLong(frameIndex, longValue.longValue());
                        return;
                    }
                    newTag = 0;
                    break;
                }
                case 5: {
                    if (value instanceof Boolean) {
                        Boolean booleanValue = (Boolean)value;
                        frame.setBoolean(frameIndex, booleanValue.booleanValue());
                        return;
                    }
                    newTag = 0;
                    break;
                }
                case 0: {
                    frame.setObject(frameIndex, value);
                    return;
                }
                default: {
                    newTag = CachedBytecodeNode.specializeSlotTag(value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setCachedLocalTagInternal(this.localTags_, localIndex, newTag);
            this.setLocalValueInternal(frame, localOffset, localIndex, value);
        }

        protected long getLocalValueInternalLong(Frame frame, int localOffset, int localIndex) throws UnexpectedResultException {
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            return frame.expectLong(1 + localOffset);
        }

        protected void setLocalValueInternalLong(Frame frame, int localOffset, int localIndex, long value) {
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            int frameIndex = 1 + localOffset;
            byte oldTag = this.getCachedLocalTag(localIndex);
            switch (oldTag) {
                case 1: {
                    frame.setLong(frameIndex, value);
                    return;
                }
                case 0: {
                    frame.setObject(frameIndex, (Object)value);
                    return;
                }
            }
            byte newTag = CachedBytecodeNode.specializeSlotTag(value);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setCachedLocalTagInternal(this.localTags_, localIndex, newTag);
            this.setLocalValueInternal(frame, localOffset, localIndex, value);
        }

        protected boolean getLocalValueInternalBoolean(Frame frame, int localOffset, int localIndex) throws UnexpectedResultException {
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            return frame.expectBoolean(1 + localOffset);
        }

        protected void setLocalValueInternalBoolean(Frame frame, int localOffset, int localIndex, boolean value) {
            assert (this.getRoot().getFrameDescriptor() == frame.getFrameDescriptor()) : "Invalid frame with invalid descriptor passed.";
            int frameIndex = 1 + localOffset;
            byte oldTag = this.getCachedLocalTag(localIndex);
            switch (oldTag) {
                case 5: {
                    frame.setBoolean(frameIndex, value);
                    return;
                }
                case 0: {
                    frame.setObject(frameIndex, (Object)value);
                    return;
                }
            }
            byte newTag = CachedBytecodeNode.specializeSlotTag(value);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setCachedLocalTagInternal(this.localTags_, localIndex, newTag);
            this.setLocalValueInternal(frame, localOffset, localIndex, value);
        }

        private void setLocalValueImpl(Frame frame, int localOffset, Object value, int bci) {
            byte newTag;
            int frameIndex = localOffset + 1;
            int localIndex = this.localOffsetToLocalIndex(bci, localOffset);
            byte oldTag = this.getCachedLocalTagInternal(this.localTags_, localIndex);
            switch (oldTag) {
                case 1: {
                    if (value instanceof Long) {
                        Long longValue = (Long)value;
                        frame.setLong(frameIndex, longValue.longValue());
                        return;
                    }
                    newTag = 0;
                    break;
                }
                case 5: {
                    if (value instanceof Boolean) {
                        Boolean booleanValue = (Boolean)value;
                        frame.setBoolean(frameIndex, booleanValue.booleanValue());
                        return;
                    }
                    newTag = 0;
                    break;
                }
                case 0: {
                    frame.setObject(frameIndex, value);
                    return;
                }
                default: {
                    newTag = CachedBytecodeNode.specializeSlotTag(value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setCachedLocalTagInternal(this.localTags_, localIndex, newTag);
            this.setLocalValueImpl(frame, localOffset, value, bci);
        }

        byte getCachedLocalTag(int localIndex) {
            byte[] localTags = this.localTags_;
            if (localIndex < 0 || localIndex >= localTags.length) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException("Invalid local offset");
            }
            return this.getCachedLocalTagInternal(localTags, localIndex);
        }

        private void setCachedLocalTag(int localIndex, byte tag) {
            byte[] localTags = this.localTags_;
            if (localIndex < 0 || localIndex >= localTags.length) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException("Invalid local offset");
            }
            this.setCachedLocalTagInternal(localTags, localIndex, tag);
        }

        @Override
        byte getCachedLocalTagInternal(byte[] localTags, int localIndex) {
            return BYTES.getByte(localTags, localIndex);
        }

        @Override
        void setCachedLocalTagInternal(byte[] localTags, int localIndex, byte tag) {
            CompilerAsserts.neverPartOfCompilation();
            BYTES.putByte(localTags, localIndex, tag);
            this.reportReplace((Node)this, (Node)this, "local tags updated");
        }

        @Override
        AbstractBytecodeNode toCached(int numLocals) {
            return this;
        }

        @Override
        AbstractBytecodeNode update(byte[] bytecodes_, Object[] constants_, int[] handlers_, int[] locals_, int[] sourceInfo_, List<Source> sources_, int numNodes_, TagRootNode tagRoot_) {
            List sources__;
            int[] sourceInfo__;
            TagRootNode tagRoot__;
            int[] locals__;
            int numNodes__;
            int[] handlers__;
            Object[] constants__;
            byte[] bytecodes__;
            assert (bytecodes_ != null || sourceInfo_ != null);
            if (bytecodes_ != null) {
                bytecodes__ = bytecodes_;
                constants__ = constants_;
                handlers__ = handlers_;
                numNodes__ = numNodes_;
                locals__ = locals_;
                tagRoot__ = tagRoot_;
            } else {
                bytecodes__ = this.bytecodes;
                constants__ = this.constants;
                handlers__ = this.handlers;
                numNodes__ = this.numNodes;
                locals__ = this.locals;
                tagRoot__ = this.tagRoot;
            }
            if (sourceInfo_ != null) {
                sourceInfo__ = sourceInfo_;
                sources__ = sources_;
            } else {
                sourceInfo__ = this.sourceInfo;
                sources__ = this.sources;
            }
            if (bytecodes_ != null) {
                return new CachedBytecodeNode(bytecodes__, constants__, handlers__, locals__, sourceInfo__, sources__, numNodes__, tagRoot__, this.localTags_.length);
            }
            return new CachedBytecodeNode(bytecodes__, constants__, handlers__, locals__, sourceInfo__, sources__, numNodes__, tagRoot__, this.cachedNodes_, this.exceptionProfiles_, this.localTags_, this.branchProfiles_, this.osrMetadata_);
        }

        @Override
        AbstractBytecodeNode cloneUninitialized() {
            return new CachedBytecodeNode(CachedBytecodeNode.unquickenBytecode(this.bytecodes), this.constants, this.handlers, this.locals, this.sourceInfo, this.sources, this.numNodes, this.tagRoot != null ? (TagRootNode)this.tagRoot.deepCopy() : null, this.localTags_.length);
        }

        @Override
        Node[] getCachedNodes() {
            return this.cachedNodes_;
        }

        @Override
        int[] getBranchProfiles() {
            return this.branchProfiles_;
        }

        @CompilerDirectives.TruffleBoundary
        protected int findBytecodeIndex(FrameInstance frameInstance) {
            Node prev = null;
            for (Node current = frameInstance.getCallNode(); current != null; current = current.getParent()) {
                if (current == this && prev != null) {
                    return this.findBytecodeIndexOfOperationNode(prev);
                }
                prev = current;
            }
            return -1;
        }

        @Override
        protected int findBytecodeIndex(Frame frame, Node node) {
            if (node != null) {
                return this.findBytecodeIndexOfOperationNode(node);
            }
            return -1;
        }

        @CompilerDirectives.TruffleBoundary
        int findBytecodeIndexOfOperationNode(Node operationNode) {
            assert (operationNode.getParent() == this) : "Passed node must be an operation node of the same bytecode node.";
            Node[] localNodes = this.cachedNodes_;
            byte[] bc = this.bytecodes;
            int bci = 0;
            block14: while (bci < bc.length) {
                int nodeIndex;
                int currentBci = bci;
                switch (BYTES.getShort(bc, bci)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 13: 
                    case 44: 
                    case 110: {
                        bci += 4;
                        continue block14;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 20: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 45: 
                    case 52: 
                    case 111: {
                        bci += 6;
                        continue block14;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 21: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 113: {
                        bci += 10;
                        continue block14;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 115: {
                        bci += 14;
                        continue block14;
                    }
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 53: 
                    case 109: {
                        bci += 2;
                        continue block14;
                    }
                    case 112: {
                        bci += 8;
                        continue block14;
                    }
                    case 114: {
                        bci += 12;
                        continue block14;
                    }
                    case 54: 
                    case 55: {
                        nodeIndex = BYTES.getIntUnaligned(bc, bci + 6);
                        bci += 10;
                        break;
                    }
                    case 56: {
                        nodeIndex = BYTES.getIntUnaligned(bc, bci + 10);
                        bci += 14;
                        break;
                    }
                    case 57: 
                    case 86: 
                    case 90: 
                    case 96: {
                        nodeIndex = BYTES.getIntUnaligned(bc, bci + 2);
                        bci += 6;
                        break;
                    }
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: {
                        nodeIndex = BYTES.getIntUnaligned(bc, bci + 2);
                        bci += 14;
                        break;
                    }
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: {
                        nodeIndex = BYTES.getIntUnaligned(bc, bci + 2);
                        bci += 10;
                        break;
                    }
                    default: {
                        throw SLBytecodeRootNodeGen.assertionFailed("Should not reach here");
                    }
                }
                if (localNodes[nodeIndex] != operationNode) continue;
                return currentBci;
            }
            return -1;
        }

        public String toString() {
            return String.format("BytecodeNode [name=%s, sources=%s, tier=cached]", ((RootNode)this.getParent()).getQualifiedName(), this.sourceInfo != null);
        }

        private static boolean doBranchFalse(Frame frame, byte[] bc, int bci, int sp) {
            short newInstruction;
            CompilerDirectives.transferToInterpreterAndInvalidate();
            boolean value = (Boolean)FRAMES.requireObject(frame, sp - 1);
            int operandIndex = BYTES.getIntUnaligned(bc, bci + 10);
            short operand = BYTES.getShort(bc, operandIndex);
            short newOperand = SLBytecodeRootNodeGen.applyQuickeningBoolean(operand);
            if (newOperand != -1) {
                newInstruction = 24;
            } else {
                newInstruction = 23;
                newOperand = operand;
            }
            BYTES.putShort(bc, operandIndex, newOperand);
            BYTES.putShort(bc, bci, newInstruction);
            return value;
        }

        private static boolean doBranchFalse$Generic(Frame frame, byte[] bc, int bci, int sp) {
            try {
                return (Boolean)FRAMES.expectObject(frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                return CachedBytecodeNode.doBranchFalse(frame, bc, bci, sp);
            }
        }

        private static boolean doBranchFalse$Boolean(Frame frame, byte[] bc, int bci, int sp) {
            try {
                return FRAMES.expectBoolean(frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                return CachedBytecodeNode.doBranchFalse(frame, bc, bci, sp);
            }
        }

        private static void doPop(Frame frame, byte[] bc, int bci, int sp) {
            int newInstruction;
            CompilerDirectives.transferToInterpreterAndInvalidate();
            int operandIndex = BYTES.getIntUnaligned(bc, bci + 2);
            if (operandIndex != -1) {
                short newOperand;
                short operand = BYTES.getShort(bc, operandIndex);
                Object value = FRAMES.requireObject(frame, sp - 1);
                if (value instanceof Long && (newOperand = SLBytecodeRootNodeGen.applyQuickeningLong(operand)) != -1) {
                    newInstruction = 26;
                } else if (value instanceof Boolean && (newOperand = SLBytecodeRootNodeGen.applyQuickeningBoolean(operand)) != -1) {
                    newInstruction = 27;
                } else {
                    newOperand = SLBytecodeRootNodeGen.undoQuickening(operand);
                    newInstruction = 28;
                }
                BYTES.putShort(bc, operandIndex, newOperand);
            } else {
                newInstruction = 28;
            }
            BYTES.putShort(bc, bci, (short)newInstruction);
            FRAMES.clear(frame, sp - 1);
        }

        private static void doPop$Long(Frame frame, byte[] bc, int bci, int sp) {
            if (CompilerDirectives.inCompiledCode()) {
                FRAMES.clear(frame, sp - 1);
                return;
            }
            if (frame.getTag(sp - 1) != 1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                CachedBytecodeNode.doPop(frame, bc, bci, sp);
                return;
            }
        }

        private static void doPop$Boolean(Frame frame, byte[] bc, int bci, int sp) {
            if (CompilerDirectives.inCompiledCode()) {
                FRAMES.clear(frame, sp - 1);
                return;
            }
            if (frame.getTag(sp - 1) != 5) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                CachedBytecodeNode.doPop(frame, bc, bci, sp);
                return;
            }
        }

        private static void doPop$generic(Frame frame, byte[] bc, int bci, int sp) {
            FRAMES.clear(frame, sp - 1);
        }

        private static void doMergeConditional(Frame frame, byte[] bc, int bci, int sp, Object local) {
            int newInstruction;
            int otherOperandIndex;
            int operandIndex;
            boolean condition = (Boolean)FRAMES.getValue(frame, sp - 2);
            if (condition) {
                operandIndex = BYTES.getIntUnaligned(bc, bci + 2);
                otherOperandIndex = BYTES.getIntUnaligned(bc, bci + 6);
            } else {
                operandIndex = BYTES.getIntUnaligned(bc, bci + 6);
                otherOperandIndex = BYTES.getIntUnaligned(bc, bci + 2);
            }
            if (operandIndex != -1 && otherOperandIndex != -1) {
                short newOtherOperand;
                short newOperand;
                short operand = BYTES.getShort(bc, operandIndex);
                short otherOperand = BYTES.getShort(bc, otherOperandIndex);
                if (local instanceof Long && (newOperand = SLBytecodeRootNodeGen.applyQuickeningLong(operand)) != -1) {
                    switch (BYTES.getShort(bc, bci)) {
                        case 103: 
                        case 104: {
                            newOtherOperand = otherOperand;
                            newInstruction = 104;
                            break;
                        }
                        case 105: {
                            newOtherOperand = otherOperand;
                            newInstruction = 105;
                            break;
                        }
                        default: {
                            newOtherOperand = SLBytecodeRootNodeGen.undoQuickening(otherOperand);
                            newInstruction = 108;
                            break;
                        }
                    }
                } else if (local instanceof Boolean && (newOperand = SLBytecodeRootNodeGen.applyQuickeningBoolean(operand)) != -1) {
                    switch (BYTES.getShort(bc, bci)) {
                        case 103: 
                        case 106: {
                            newOtherOperand = otherOperand;
                            newInstruction = 106;
                            break;
                        }
                        case 107: {
                            newOtherOperand = otherOperand;
                            newInstruction = 107;
                            break;
                        }
                        default: {
                            newOtherOperand = SLBytecodeRootNodeGen.undoQuickening(otherOperand);
                            newInstruction = 108;
                            break;
                        }
                    }
                } else {
                    newOperand = operand;
                    newOtherOperand = SLBytecodeRootNodeGen.undoQuickening(otherOperand);
                    newInstruction = 108;
                }
                BYTES.putShort(bc, operandIndex, newOperand);
                BYTES.putShort(bc, otherOperandIndex, newOtherOperand);
            } else {
                newInstruction = 108;
            }
            BYTES.putShort(bc, bci, (short)newInstruction);
            FRAMES.setObject(frame, sp - 2, local);
            FRAMES.clear(frame, sp - 1);
        }

        private static void doMergeConditional$Long(Frame frame, byte[] bc, int bci, int sp) {
            long value;
            try {
                value = FRAMES.expectLong(frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CachedBytecodeNode.doMergeConditional(frame, bc, bci, sp, ex.getResult());
                return;
            }
            FRAMES.setObject(frame, sp - 2, (Object)value);
        }

        private static void doMergeConditional$Long$unboxed(Frame frame, byte[] bc, int bci, int sp) {
            long value;
            try {
                value = FRAMES.expectLong(frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CachedBytecodeNode.doMergeConditional(frame, bc, bci, sp, ex.getResult());
                return;
            }
            FRAMES.setLong(frame, sp - 2, value);
        }

        private static void doMergeConditional$Boolean(Frame frame, byte[] bc, int bci, int sp) {
            boolean value;
            try {
                value = FRAMES.expectBoolean(frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CachedBytecodeNode.doMergeConditional(frame, bc, bci, sp, ex.getResult());
                return;
            }
            FRAMES.setObject(frame, sp - 2, (Object)value);
        }

        private static void doMergeConditional$Boolean$unboxed(Frame frame, byte[] bc, int bci, int sp) {
            boolean value;
            try {
                value = FRAMES.expectBoolean(frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CachedBytecodeNode.doMergeConditional(frame, bc, bci, sp, ex.getResult());
                return;
            }
            FRAMES.setBoolean(frame, sp - 2, value);
        }

        private static void doMergeConditional$generic(Frame frame, byte[] bc, int bci, int sp) {
            Object value;
            try {
                value = FRAMES.expectObject(frame, sp - 1);
            }
            catch (UnexpectedResultException ex) {
                CachedBytecodeNode.doMergeConditional(frame, bc, bci, sp, ex.getResult());
                return;
            }
            FRAMES.setObject(frame, sp - 2, value);
            FRAMES.clear(frame, sp - 1);
        }

        private static void loadConstantCompiled(VirtualFrame frame, byte[] bc, int bci, int sp, Object[] consts) {
            Object constant = ACCESS.readObject(consts, BYTES.getIntUnaligned(bc, bci + 2));
            if (constant instanceof Boolean) {
                Boolean b = (Boolean)constant;
                FRAMES.setObject((Frame)frame, sp, (Object)b);
                return;
            }
            if (constant instanceof Byte) {
                Byte b = (Byte)constant;
                FRAMES.setObject((Frame)frame, sp, (Object)b);
                return;
            }
            if (constant instanceof Character) {
                Character c = (Character)constant;
                FRAMES.setObject((Frame)frame, sp, (Object)Character.valueOf(c.charValue()));
                return;
            }
            if (constant instanceof Float) {
                Float f = (Float)constant;
                FRAMES.setObject((Frame)frame, sp, (Object)Float.valueOf(f.floatValue()));
                return;
            }
            if (constant instanceof Integer) {
                Integer i = (Integer)constant;
                FRAMES.setObject((Frame)frame, sp, (Object)i);
                return;
            }
            if (constant instanceof Long) {
                Long l = (Long)constant;
                FRAMES.setObject((Frame)frame, sp, (Object)l);
                return;
            }
            if (constant instanceof Short) {
                Short s = (Short)constant;
                FRAMES.setObject((Frame)frame, sp, (Object)s);
                return;
            }
            if (constant instanceof Double) {
                Double d = (Double)constant;
                FRAMES.setObject((Frame)frame, sp, (Object)d);
                return;
            }
            FRAMES.setObject((Frame)frame, sp, constant);
        }

        private static int[] allocateBranchProfiles(int numProfiles) {
            return new int[numProfiles * 2];
        }

        private static boolean profileBranch(int[] branchProfiles, int profileIndex, boolean condition) {
            if (HostCompilerDirectives.inInterpreterFastPath()) {
                if (condition) {
                    int t = ACCESS.readInt(branchProfiles, profileIndex * 2);
                    if (t == 0) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                    }
                    try {
                        t = Math.addExact(t, 1);
                    }
                    catch (ArithmeticException e) {
                        int f = ACCESS.readInt(branchProfiles, profileIndex * 2 + 1);
                        f = (f & 1) + (f >> 1);
                        ACCESS.writeInt(branchProfiles, profileIndex * 2 + 1, f);
                        t = 0x3FFFFFFF;
                    }
                    ACCESS.writeInt(branchProfiles, profileIndex * 2, t);
                } else {
                    int f = ACCESS.readInt(branchProfiles, profileIndex * 2 + 1);
                    if (f == 0) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                    }
                    try {
                        f = Math.addExact(f, 1);
                    }
                    catch (ArithmeticException e) {
                        int t = ACCESS.readInt(branchProfiles, profileIndex * 2);
                        t = (t & 1) + (t >> 1);
                        ACCESS.writeInt(branchProfiles, profileIndex * 2, t);
                        f = 0x3FFFFFFF;
                    }
                    ACCESS.writeInt(branchProfiles, profileIndex * 2 + 1, f);
                }
                return condition;
            }
            int t = ACCESS.readInt(branchProfiles, profileIndex * 2);
            int f = ACCESS.readInt(branchProfiles, profileIndex * 2 + 1);
            if (condition) {
                if (t == 0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                if (f == 0) {
                    return true;
                }
            } else {
                if (f == 0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                if (t == 0) {
                    return false;
                }
            }
            return CompilerDirectives.injectBranchProbability((double)((double)t / (double)(t + f)), (boolean)condition);
        }

        private static void ensureFalseProfile(int[] branchProfiles, int profileIndex) {
            if (ACCESS.readInt(branchProfiles, profileIndex * 2 + 1) == 0) {
                ACCESS.writeInt(branchProfiles, profileIndex * 2 + 1, 1);
            }
        }

        private static byte specializeSlotTag(Object value) {
            if (value instanceof Long) {
                return 1;
            }
            if (value instanceof Boolean) {
                return 5;
            }
            return 0;
        }

        private static byte[] unquickenBytecode(byte[] original) {
            byte[] copy = Arrays.copyOf(original, original.length);
            int bci = 0;
            while (bci < copy.length) {
                switch (BYTES.getShort(copy, bci)) {
                    case 2: 
                    case 3: {
                        BYTES.putShort(copy, bci, (short)1);
                        bci += 4;
                        break;
                    }
                    case 5: 
                    case 6: {
                        BYTES.putShort(copy, bci, (short)4);
                        bci += 6;
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        BYTES.putShort(copy, bci, (short)7);
                        bci += 6;
                        break;
                    }
                    case 26: 
                    case 27: 
                    case 28: {
                        BYTES.putShort(copy, bci, (short)25);
                        bci += 6;
                        break;
                    }
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: {
                        BYTES.putShort(copy, bci, (short)103);
                        bci += 10;
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        BYTES.putShort(copy, bci, (short)14);
                        bci += 10;
                        break;
                    }
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        BYTES.putShort(copy, bci, (short)46);
                        bci += 10;
                        break;
                    }
                    case 23: 
                    case 24: {
                        BYTES.putShort(copy, bci, (short)22);
                        bci += 14;
                        break;
                    }
                    case 55: {
                        BYTES.putShort(copy, bci, (short)54);
                        bci += 10;
                        break;
                    }
                    case 80: 
                    case 81: 
                    case 82: {
                        BYTES.putShort(copy, bci, (short)79);
                        bci += 10;
                        break;
                    }
                    case 98: 
                    case 99: 
                    case 100: {
                        BYTES.putShort(copy, bci, (short)97);
                        bci += 10;
                        break;
                    }
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        BYTES.putShort(copy, bci, (short)91);
                        bci += 10;
                        break;
                    }
                    case 59: 
                    case 60: {
                        BYTES.putShort(copy, bci, (short)58);
                        bci += 14;
                        break;
                    }
                    case 62: 
                    case 63: {
                        BYTES.putShort(copy, bci, (short)61);
                        bci += 14;
                        break;
                    }
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: {
                        BYTES.putShort(copy, bci, (short)64);
                        bci += 14;
                        break;
                    }
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: {
                        BYTES.putShort(copy, bci, (short)70);
                        bci += 14;
                        break;
                    }
                    case 76: 
                    case 77: 
                    case 78: {
                        BYTES.putShort(copy, bci, (short)75);
                        bci += 14;
                        break;
                    }
                    case 84: 
                    case 85: {
                        BYTES.putShort(copy, bci, (short)83);
                        bci += 14;
                        break;
                    }
                    case 88: 
                    case 89: {
                        BYTES.putShort(copy, bci, (short)87);
                        bci += 14;
                        break;
                    }
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 53: 
                    case 109: {
                        bci += 2;
                        break;
                    }
                    case 1: 
                    case 13: 
                    case 44: 
                    case 110: {
                        bci += 4;
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 20: 
                    case 25: 
                    case 45: 
                    case 52: 
                    case 57: 
                    case 86: 
                    case 90: 
                    case 96: 
                    case 111: {
                        bci += 6;
                        break;
                    }
                    case 112: {
                        bci += 8;
                        break;
                    }
                    case 14: 
                    case 21: 
                    case 46: 
                    case 54: 
                    case 79: 
                    case 91: 
                    case 97: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 113: {
                        bci += 10;
                        break;
                    }
                    case 114: {
                        bci += 12;
                        break;
                    }
                    case 22: 
                    case 56: 
                    case 58: 
                    case 61: 
                    case 64: 
                    case 70: 
                    case 75: 
                    case 83: 
                    case 87: 
                    case 115: {
                        bci += 14;
                    }
                }
            }
            return copy;
        }
    }

    private static final class TagNode
    extends TagTreeNode
    implements InstrumentableNode,
    TagTree {
        static final TagNode[] EMPTY_ARRAY = new TagNode[0];
        final int tags;
        final int enterBci;
        @CompilerDirectives.CompilationFinal
        int returnBci;
        @Node.Children
        TagNode[] children;
        @Node.Child
        private volatile ProbeNode probe;
        @CompilerDirectives.CompilationFinal
        private volatile SourceSection sourceSection;

        TagNode(int tags, int enterBci) {
            super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
            this.tags = tags;
            this.enterBci = enterBci;
        }

        public InstrumentableNode.WrapperNode createWrapper(ProbeNode p) {
            return null;
        }

        public ProbeNode findProbe() {
            ProbeNode p = this.probe;
            if (p == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.probe = p = (ProbeNode)this.insert((Node)this.createProbe(this.getSourceSection()));
            }
            CompilerAsserts.partialEvaluationConstant((Object)p);
            return p;
        }

        public boolean isInstrumentable() {
            return true;
        }

        public boolean hasTag(Class<? extends Tag> tag) {
            if (tag == StandardTags.CallTag.class) {
                return (this.tags & 1) != 0;
            }
            if (tag == StandardTags.StatementTag.class) {
                return (this.tags & 2) != 0;
            }
            if (tag == StandardTags.RootTag.class) {
                return (this.tags & 4) != 0;
            }
            if (tag == StandardTags.RootBodyTag.class) {
                return (this.tags & 8) != 0;
            }
            if (tag == StandardTags.ExpressionTag.class) {
                return (this.tags & 0x10) != 0;
            }
            if (tag == DebuggerTags.AlwaysHalt.class) {
                return (this.tags & 0x20) != 0;
            }
            if (tag == StandardTags.ReadVariableTag.class) {
                return (this.tags & 0x40) != 0;
            }
            if (tag == StandardTags.WriteVariableTag.class) {
                return (this.tags & 0x80) != 0;
            }
            return false;
        }

        public Node copy() {
            TagNode copy = (TagNode)super.copy();
            copy.probe = null;
            return copy;
        }

        public SourceSection getSourceSection() {
            SourceSection section = this.sourceSection;
            if (section == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.sourceSection = section = this.createSourceSection();
            }
            return section;
        }

        public SourceSection[] getSourceSections() {
            return this.findBytecodeNode().getSourceLocations(this.enterBci);
        }

        private SourceSection createSourceSection() {
            if (this.enterBci == -1) {
                return null;
            }
            return this.findBytecodeNode().getSourceLocation(this.enterBci);
        }

        @CompilerDirectives.TruffleBoundary
        private AbstractBytecodeNode findBytecodeNode() {
            TagNode current = this;
            while (true) {
                if (current instanceof AbstractBytecodeNode) break;
                current = current.getParent();
            }
            AbstractBytecodeNode bytecodeNode = (AbstractBytecodeNode)((Object)current);
            if (bytecodeNode == null) {
                throw CompilerDirectives.shouldNotReachHere((String)"Unexpected disconnected node.");
            }
            return bytecodeNode;
        }

        protected Class<?> dispatch() {
            return SLBytecodeScopeExports.class;
        }

        protected Class<SLLanguage> getLanguage() {
            return SLLanguage.class;
        }

        public List<TagTree> getTreeChildren() {
            return List.of(this.children);
        }

        public List<Class<? extends Tag>> getTags() {
            return List.of(SLBytecodeRootNodeGen.mapTagMaskToTagsArray(this.tags));
        }

        public int getEnterBytecodeIndex() {
            return this.enterBci;
        }

        public int getReturnBytecodeIndex() {
            return this.returnBci;
        }
    }

    private static final class InstructionImpl
    extends Instruction {
        final AbstractBytecodeNode bytecode;
        final int bci;
        final int opcode;

        InstructionImpl(AbstractBytecodeNode bytecode, int bci, int opcode) {
            super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
            this.bytecode = bytecode;
            this.bci = bci;
            this.opcode = opcode;
        }

        public int getBytecodeIndex() {
            return this.bci;
        }

        public BytecodeNode getBytecodeNode() {
            return this.bytecode;
        }

        public int getOperationCode() {
            return this.opcode;
        }

        public int getLength() {
            switch (this.opcode) {
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 53: 
                case 109: {
                    return 2;
                }
                case 1: 
                case 2: 
                case 3: 
                case 13: 
                case 44: 
                case 110: {
                    return 4;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 20: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 45: 
                case 52: 
                case 57: 
                case 86: 
                case 90: 
                case 96: 
                case 111: {
                    return 6;
                }
                case 112: {
                    return 8;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 54: 
                case 55: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 113: {
                    return 10;
                }
                case 114: {
                    return 12;
                }
                case 22: 
                case 23: 
                case 24: 
                case 56: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 83: 
                case 84: 
                case 85: 
                case 87: 
                case 88: 
                case 89: 
                case 115: {
                    return 14;
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)"Invalid opcode");
        }

        public List<Instruction.Argument> getArguments() {
            switch (this.opcode) {
                case 1: 
                case 2: 
                case 3: {
                    return List.of(new IntegerArgument(this.bytecode, "index", this.bci + 2, 2));
                }
                case 4: 
                case 5: 
                case 6: {
                    return List.of(new ConstantArgument(this.bytecode, "constant", this.bci + 2));
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    return List.of(new LocalOffsetArgument(this.bytecode, "local_offset", this.bci + 2), new LocalIndexArgument(this.bytecode, "local_index", this.bci + 4));
                }
                case 13: {
                    return List.of(new LocalOffsetArgument(this.bytecode, "local_offset", this.bci + 2));
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    return List.of(new LocalOffsetArgument(this.bytecode, "local_offset", this.bci + 2), new LocalIndexArgument(this.bytecode, "local_index", this.bci + 4), new BytecodeIndexArgument(this.bytecode, "child0", this.bci + 6));
                }
                case 20: {
                    return List.of(new BytecodeIndexArgument(this.bytecode, "branch_target", this.bci + 2));
                }
                case 21: {
                    return List.of(new BytecodeIndexArgument(this.bytecode, "branch_target", this.bci + 2), new BranchProfileArgument(this.bytecode, "loop_header_branch_profile", this.bci + 6));
                }
                case 22: 
                case 23: 
                case 24: {
                    return List.of(new BytecodeIndexArgument(this.bytecode, "branch_target", this.bci + 2), new BranchProfileArgument(this.bytecode, "branch_profile", this.bci + 6), new BytecodeIndexArgument(this.bytecode, "child0", this.bci + 10));
                }
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    return List.of(new BytecodeIndexArgument(this.bytecode, "child0", this.bci + 2));
                }
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 53: 
                case 109: {
                    return List.of();
                }
                case 44: {
                    return List.of(new IntegerArgument(this.bytecode, "exception_sp", this.bci + 2, 2));
                }
                case 45: 
                case 52: {
                    return List.of(new TagNodeArgument(this.bytecode, "tag", this.bci + 2));
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: {
                    return List.of(new TagNodeArgument(this.bytecode, "tag", this.bci + 2), new BytecodeIndexArgument(this.bytecode, "child0", this.bci + 6));
                }
                case 54: 
                case 55: {
                    return List.of(new ConstantArgument(this.bytecode, "index", this.bci + 2), new NodeProfileArgument(this.bytecode, "node", this.bci + 6));
                }
                case 56: {
                    return List.of(new ConstantArgument(this.bytecode, "factory", this.bci + 2), new ConstantArgument(this.bytecode, "argumentCount", this.bci + 6), new NodeProfileArgument(this.bytecode, "node", this.bci + 10));
                }
                case 57: 
                case 86: 
                case 90: 
                case 96: {
                    return List.of(new NodeProfileArgument(this.bytecode, "node", this.bci + 2));
                }
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 83: 
                case 84: 
                case 85: 
                case 87: 
                case 88: 
                case 89: {
                    return List.of(new NodeProfileArgument(this.bytecode, "node", this.bci + 2), new BytecodeIndexArgument(this.bytecode, "child0", this.bci + 6), new BytecodeIndexArgument(this.bytecode, "child1", this.bci + 10));
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: {
                    return List.of(new NodeProfileArgument(this.bytecode, "node", this.bci + 2), new BytecodeIndexArgument(this.bytecode, "child0", this.bci + 6));
                }
                case 101: 
                case 102: {
                    return List.of(new BytecodeIndexArgument(this.bytecode, "branch_target", this.bci + 2), new BranchProfileArgument(this.bytecode, "branch_profile", this.bci + 6));
                }
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: {
                    return List.of(new BytecodeIndexArgument(this.bytecode, "child0", this.bci + 2), new BytecodeIndexArgument(this.bytecode, "child1", this.bci + 6));
                }
                case 110: {
                    return List.of(new IntegerArgument(this.bytecode, "invalidated0", this.bci + 2, 2));
                }
                case 111: {
                    return List.of(new IntegerArgument(this.bytecode, "invalidated0", this.bci + 2, 2), new IntegerArgument(this.bytecode, "invalidated1", this.bci + 4, 2));
                }
                case 112: {
                    return List.of(new IntegerArgument(this.bytecode, "invalidated0", this.bci + 2, 2), new IntegerArgument(this.bytecode, "invalidated1", this.bci + 4, 2), new IntegerArgument(this.bytecode, "invalidated2", this.bci + 6, 2));
                }
                case 113: {
                    return List.of(new IntegerArgument(this.bytecode, "invalidated0", this.bci + 2, 2), new IntegerArgument(this.bytecode, "invalidated1", this.bci + 4, 2), new IntegerArgument(this.bytecode, "invalidated2", this.bci + 6, 2), new IntegerArgument(this.bytecode, "invalidated3", this.bci + 8, 2));
                }
                case 114: {
                    return List.of(new IntegerArgument(this.bytecode, "invalidated0", this.bci + 2, 2), new IntegerArgument(this.bytecode, "invalidated1", this.bci + 4, 2), new IntegerArgument(this.bytecode, "invalidated2", this.bci + 6, 2), new IntegerArgument(this.bytecode, "invalidated3", this.bci + 8, 2), new IntegerArgument(this.bytecode, "invalidated4", this.bci + 10, 2));
                }
                case 115: {
                    return List.of(new IntegerArgument(this.bytecode, "invalidated0", this.bci + 2, 2), new IntegerArgument(this.bytecode, "invalidated1", this.bci + 4, 2), new IntegerArgument(this.bytecode, "invalidated2", this.bci + 6, 2), new IntegerArgument(this.bytecode, "invalidated3", this.bci + 8, 2), new IntegerArgument(this.bytecode, "invalidated4", this.bci + 10, 2), new IntegerArgument(this.bytecode, "invalidated5", this.bci + 12, 2));
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)"Invalid opcode");
        }

        public String getName() {
            switch (this.opcode) {
                case 1: {
                    return "load.argument";
                }
                case 2: {
                    return "load.argument$Long";
                }
                case 3: {
                    return "load.argument$Boolean";
                }
                case 4: {
                    return "load.constant";
                }
                case 5: {
                    return "load.constant$Long";
                }
                case 6: {
                    return "load.constant$Boolean";
                }
                case 7: {
                    return "load.local";
                }
                case 8: {
                    return "load.local$Long";
                }
                case 9: {
                    return "load.local$Long$unboxed";
                }
                case 10: {
                    return "load.local$Boolean";
                }
                case 11: {
                    return "load.local$Boolean$unboxed";
                }
                case 12: {
                    return "load.local$generic";
                }
                case 13: {
                    return "clear.local";
                }
                case 14: {
                    return "store.local";
                }
                case 15: {
                    return "store.local$Long";
                }
                case 16: {
                    return "store.local$Long$Long";
                }
                case 17: {
                    return "store.local$Boolean";
                }
                case 18: {
                    return "store.local$Boolean$Boolean";
                }
                case 19: {
                    return "store.local$generic";
                }
                case 20: {
                    return "branch";
                }
                case 21: {
                    return "branch.backward";
                }
                case 22: {
                    return "branch.false";
                }
                case 23: {
                    return "branch.false$Generic";
                }
                case 24: {
                    return "branch.false$Boolean";
                }
                case 25: {
                    return "pop";
                }
                case 26: {
                    return "pop$Long";
                }
                case 27: {
                    return "pop$Boolean";
                }
                case 28: {
                    return "pop$generic";
                }
                case 29: {
                    return "dup";
                }
                case 30: {
                    return "load.variadic_0";
                }
                case 31: {
                    return "load.variadic_1";
                }
                case 32: {
                    return "load.variadic_2";
                }
                case 33: {
                    return "load.variadic_3";
                }
                case 34: {
                    return "load.variadic_4";
                }
                case 35: {
                    return "load.variadic_5";
                }
                case 36: {
                    return "load.variadic_6";
                }
                case 37: {
                    return "load.variadic_7";
                }
                case 38: {
                    return "load.variadic_8";
                }
                case 39: {
                    return "merge.variadic";
                }
                case 40: {
                    return "constant_null";
                }
                case 41: {
                    return "load.null";
                }
                case 42: {
                    return "return";
                }
                case 43: {
                    return "throw";
                }
                case 44: {
                    return "load.exception";
                }
                case 45: {
                    return "tag.enter";
                }
                case 46: {
                    return "tag.leave";
                }
                case 47: {
                    return "tag.leave$Long";
                }
                case 48: {
                    return "tag.leave$Long$unboxed";
                }
                case 49: {
                    return "tag.leave$Boolean";
                }
                case 50: {
                    return "tag.leave$Boolean$unboxed";
                }
                case 51: {
                    return "tag.leave$generic";
                }
                case 52: {
                    return "tag.leaveVoid";
                }
                case 53: {
                    return "c.SLAlwaysHalt";
                }
                case 54: {
                    return "c.SLLoadArgument";
                }
                case 55: {
                    return "c.SLLoadArgument$LoadInBounds";
                }
                case 56: {
                    return "c.Builtin";
                }
                case 57: {
                    return "c.SLInvoke";
                }
                case 58: {
                    return "c.SLAdd";
                }
                case 59: {
                    return "c.SLAdd$Long";
                }
                case 60: {
                    return "c.SLAdd$Long$unboxed";
                }
                case 61: {
                    return "c.SLDiv";
                }
                case 62: {
                    return "c.SLDiv$Long";
                }
                case 63: {
                    return "c.SLDiv$Long$unboxed";
                }
                case 64: {
                    return "c.SLEqual";
                }
                case 65: {
                    return "c.SLEqual$Long";
                }
                case 66: {
                    return "c.SLEqual$Long$unboxed";
                }
                case 67: {
                    return "c.SLEqual$Boolean";
                }
                case 68: {
                    return "c.SLEqual$Boolean$unboxed";
                }
                case 69: {
                    return "c.SLEqual$unboxed";
                }
                case 70: {
                    return "c.SLLessOrEqual";
                }
                case 71: {
                    return "c.SLLessOrEqual$Long";
                }
                case 72: {
                    return "c.SLLessOrEqual$Long$unboxed";
                }
                case 73: {
                    return "c.SLLessOrEqual$SLBigInteger#InteropBigInteger0#InteropBigInteger1";
                }
                case 74: {
                    return "c.SLLessOrEqual$SLBigInteger#InteropBigInteger0#InteropBigInteger1$unboxed";
                }
                case 75: {
                    return "c.SLLessThan";
                }
                case 76: {
                    return "c.SLLessThan$Long";
                }
                case 77: {
                    return "c.SLLessThan$Long$unboxed";
                }
                case 78: {
                    return "c.SLLessThan$unboxed";
                }
                case 79: {
                    return "c.SLLogicalNot";
                }
                case 80: {
                    return "c.SLLogicalNot$Boolean";
                }
                case 81: {
                    return "c.SLLogicalNot$Boolean$unboxed";
                }
                case 82: {
                    return "c.SLLogicalNot$unboxed";
                }
                case 83: {
                    return "c.SLMul";
                }
                case 84: {
                    return "c.SLMul$Long";
                }
                case 85: {
                    return "c.SLMul$Long$unboxed";
                }
                case 86: {
                    return "c.SLReadProperty";
                }
                case 87: {
                    return "c.SLSub";
                }
                case 88: {
                    return "c.SLSub$Long";
                }
                case 89: {
                    return "c.SLSub$Long$unboxed";
                }
                case 90: {
                    return "c.SLWriteProperty";
                }
                case 91: {
                    return "c.SLUnbox";
                }
                case 92: {
                    return "c.SLUnbox$FromBoolean";
                }
                case 93: {
                    return "c.SLUnbox$FromBoolean$unboxed";
                }
                case 94: {
                    return "c.SLUnbox$FromLong";
                }
                case 95: {
                    return "c.SLUnbox$FromLong$unboxed";
                }
                case 96: {
                    return "c.SLFunctionLiteral";
                }
                case 97: {
                    return "c.SLToBoolean";
                }
                case 98: {
                    return "c.SLToBoolean$Boolean";
                }
                case 99: {
                    return "c.SLToBoolean$Boolean$unboxed";
                }
                case 100: {
                    return "c.SLToBoolean$unboxed";
                }
                case 101: {
                    return "sc.SLAnd";
                }
                case 102: {
                    return "sc.SLOr";
                }
                case 103: {
                    return "merge.conditional";
                }
                case 104: {
                    return "merge.conditional$Long";
                }
                case 105: {
                    return "merge.conditional$Long$unboxed";
                }
                case 106: {
                    return "merge.conditional$Boolean";
                }
                case 107: {
                    return "merge.conditional$Boolean$unboxed";
                }
                case 108: {
                    return "merge.conditional$generic";
                }
                case 109: {
                    return "invalidate0";
                }
                case 110: {
                    return "invalidate1";
                }
                case 111: {
                    return "invalidate2";
                }
                case 112: {
                    return "invalidate3";
                }
                case 113: {
                    return "invalidate4";
                }
                case 114: {
                    return "invalidate5";
                }
                case 115: {
                    return "invalidate6";
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)"Invalid opcode");
        }

        public boolean isInstrumentation() {
            switch (this.opcode) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: {
                    return false;
                }
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: {
                    return true;
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)"Invalid opcode");
        }

        protected Instruction next() {
            int nextBci = this.getNextBytecodeIndex();
            if (nextBci >= this.bytecode.bytecodes.length) {
                return null;
            }
            return new InstructionImpl(this.bytecode, nextBci, this.bytecode.readValidBytecode(this.bytecode.bytecodes, nextBci));
        }

        private static final class IntegerArgument
        extends AbstractArgument {
            private final int width;

            IntegerArgument(AbstractBytecodeNode bytecode, String name, int bci, int width) {
                super(bytecode, name, bci);
                this.width = width;
            }

            public Instruction.Argument.Kind getKind() {
                return Instruction.Argument.Kind.INTEGER;
            }

            public int asInteger() throws UnsupportedOperationException {
                byte[] bc = this.bytecode.bytecodes;
                switch (this.width) {
                    case 1: {
                        return SAFE_BYTES.getByte(bc, this.bci);
                    }
                    case 2: {
                        return SAFE_BYTES.getShort(bc, this.bci);
                    }
                    case 4: {
                        return SAFE_BYTES.getInt(bc, this.bci);
                    }
                }
                throw SLBytecodeRootNodeGen.assertionFailed("Unexpected integer width " + this.width);
            }
        }

        private static final class ConstantArgument
        extends AbstractArgument {
            ConstantArgument(AbstractBytecodeNode bytecode, String name, int bci) {
                super(bytecode, name, bci);
            }

            public Instruction.Argument.Kind getKind() {
                return Instruction.Argument.Kind.CONSTANT;
            }

            public Object asConstant() {
                byte[] bc = this.bytecode.bytecodes;
                Object[] constants = this.bytecode.constants;
                return SAFE_ACCESS.readObject(constants, SAFE_BYTES.getInt(bc, this.bci));
            }
        }

        private static final class LocalOffsetArgument
        extends AbstractArgument {
            LocalOffsetArgument(AbstractBytecodeNode bytecode, String name, int bci) {
                super(bytecode, name, bci);
            }

            public Instruction.Argument.Kind getKind() {
                return Instruction.Argument.Kind.LOCAL_OFFSET;
            }

            public int asLocalOffset() {
                byte[] bc = this.bytecode.bytecodes;
                return SAFE_BYTES.getShort(bc, this.bci) - 1;
            }
        }

        private static final class LocalIndexArgument
        extends AbstractArgument {
            LocalIndexArgument(AbstractBytecodeNode bytecode, String name, int bci) {
                super(bytecode, name, bci);
            }

            public Instruction.Argument.Kind getKind() {
                return Instruction.Argument.Kind.LOCAL_INDEX;
            }

            public int asLocalIndex() {
                byte[] bc = this.bytecode.bytecodes;
                return SAFE_BYTES.getShort(bc, this.bci);
            }
        }

        private static final class BytecodeIndexArgument
        extends AbstractArgument {
            BytecodeIndexArgument(AbstractBytecodeNode bytecode, String name, int bci) {
                super(bytecode, name, bci);
            }

            public Instruction.Argument.Kind getKind() {
                return Instruction.Argument.Kind.BYTECODE_INDEX;
            }

            public int asBytecodeIndex() {
                byte[] bc = this.bytecode.bytecodes;
                return SAFE_BYTES.getInt(bc, this.bci);
            }
        }

        private static final class BranchProfileArgument
        extends AbstractArgument {
            BranchProfileArgument(AbstractBytecodeNode bytecode, String name, int bci) {
                super(bytecode, name, bci);
            }

            public Instruction.Argument.Kind getKind() {
                return Instruction.Argument.Kind.BRANCH_PROFILE;
            }

            public Instruction.Argument.BranchProfile asBranchProfile() {
                byte[] bc = this.bytecode.bytecodes;
                int index = SAFE_BYTES.getInt(bc, this.bci);
                int[] profiles = this.bytecode.getBranchProfiles();
                if (profiles == null) {
                    return new Instruction.Argument.BranchProfile(index, 0, 0);
                }
                return new Instruction.Argument.BranchProfile(index, profiles[index * 2], profiles[index * 2 + 1]);
            }
        }

        private static final class TagNodeArgument
        extends AbstractArgument {
            TagNodeArgument(AbstractBytecodeNode bytecode, String name, int bci) {
                super(bytecode, name, bci);
            }

            public Instruction.Argument.Kind getKind() {
                return Instruction.Argument.Kind.TAG_NODE;
            }

            public TagTreeNode asTagNode() {
                byte[] bc = this.bytecode.bytecodes;
                TagRootNode tagRoot = this.bytecode.tagRoot;
                if (tagRoot == null) {
                    return null;
                }
                return tagRoot.tagNodes[SAFE_BYTES.getInt(bc, this.bci)];
            }
        }

        private static final class NodeProfileArgument
        extends AbstractArgument {
            NodeProfileArgument(AbstractBytecodeNode bytecode, String name, int bci) {
                super(bytecode, name, bci);
            }

            public Instruction.Argument.Kind getKind() {
                return Instruction.Argument.Kind.NODE_PROFILE;
            }

            public Node asCachedNode() {
                Node[] cachedNodes = this.bytecode.getCachedNodes();
                if (cachedNodes == null) {
                    return null;
                }
                byte[] bc = this.bytecode.bytecodes;
                return cachedNodes[SAFE_BYTES.getInt(bc, this.bci)];
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        private static abstract class AbstractArgument
        extends Instruction.Argument {
            protected static final BytecodeDSLAccess SAFE_ACCESS = BytecodeDSLAccess.lookup((Object)BytecodeRootNodesImpl.VISIBLE_TOKEN, (boolean)false);
            protected static final ByteArraySupport SAFE_BYTES = SAFE_ACCESS.getByteArraySupport();
            final AbstractBytecodeNode bytecode;
            final String name;
            final int bci;

            AbstractArgument(AbstractBytecodeNode bytecode, String name, int bci) {
                super(BytecodeRootNodesImpl.VISIBLE_TOKEN);
                this.bytecode = bytecode;
                this.name = name;
                this.bci = bci;
            }

            public final String getName() {
                return this.name;
            }
        }
    }
}

