/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.sl.SLException;
import com.oracle.truffle.sl.nodes.SLBinaryNode;
import com.oracle.truffle.sl.runtime.SLBigInteger;

@NodeInfo(shortName="<=")
public abstract class SLLessOrEqualNode
extends SLBinaryNode {
    @Specialization
    protected boolean doLong(long left, long right) {
        return left <= right;
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected boolean doSLBigInteger(SLBigInteger left, SLBigInteger right) {
        return left.compareTo(right) <= 0;
    }

    @Specialization(replaces={"doSLBigInteger"}, guards={"leftLibrary.fitsInBigInteger(left)", "rightLibrary.fitsInBigInteger(right)"}, limit="3")
    @CompilerDirectives.TruffleBoundary
    protected boolean doInteropBigInteger(Object left, Object right, @CachedLibrary(value="left") InteropLibrary leftLibrary, @CachedLibrary(value="right") InteropLibrary rightLibrary) {
        try {
            return leftLibrary.asBigInteger(left).compareTo(rightLibrary.asBigInteger(right)) <= 0;
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @Fallback
    protected Object typeError(Object left, Object right) {
        throw SLException.typeError(this, left, right);
    }
}

