/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.controlflow;

import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLStatementNode;
import com.oracle.truffle.sl.nodes.controlflow.SLBreakException;
import com.oracle.truffle.sl.nodes.controlflow.SLContinueException;
import com.oracle.truffle.sl.nodes.util.SLUnboxNodeGen;

public final class SLWhileRepeatingNode
extends Node
implements RepeatingNode {
    @Node.Child
    private SLExpressionNode conditionNode;
    @Node.Child
    private SLStatementNode bodyNode;
    private final BranchProfile continueTaken = BranchProfile.create();
    private final BranchProfile breakTaken = BranchProfile.create();

    public SLWhileRepeatingNode(SLExpressionNode conditionNode, SLStatementNode bodyNode) {
        this.conditionNode = SLUnboxNodeGen.create(conditionNode);
        this.bodyNode = bodyNode;
    }

    public boolean executeRepeating(VirtualFrame frame) {
        if (!this.evaluateCondition(frame)) {
            return false;
        }
        try {
            this.bodyNode.executeVoid(frame);
            return true;
        }
        catch (SLContinueException ex) {
            this.continueTaken.enter();
            return true;
        }
        catch (SLBreakException ex) {
            this.breakTaken.enter();
            return false;
        }
    }

    private boolean evaluateCondition(VirtualFrame frame) {
        try {
            return this.conditionNode.executeBoolean(frame);
        }
        catch (UnexpectedResultException ex) {
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode}, new Object[]{ex.getResult()});
        }
    }

    public String toString() {
        return SLStatementNode.formatSourceSection(this);
    }
}

