/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.sl.nodes.SLExpressionNode;

@GeneratedBy(value=SLExpressionNode.class)
final class SLExpressionNodeWrapper
extends SLExpressionNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private SLExpressionNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    SLExpressionNodeWrapper(SLExpressionNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public SLExpressionNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        boolean returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                try {
                    this.probeNode.onEnter(frame);
                    returnValue = this.delegateNode.executeBoolean(frame);
                    wasOnReturnExecuted = true;
                    this.probeNode.onReturnValue(frame, (Object)returnValue);
                }
                catch (UnexpectedResultException e) {
                    wasOnReturnExecuted = true;
                    this.probeNode.onReturnValue(frame, e.getResult());
                    throw e;
                }
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result instanceof Boolean) {
                    returnValue = (Boolean)result;
                    break;
                }
                if (result != null) {
                    throw new UnexpectedResultException(result);
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        Object returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                returnValue = this.delegateNode.executeGeneric(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, returnValue);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) {
                    returnValue = result;
                    break;
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }

    @Override
    public long executeLong(VirtualFrame frame) throws UnexpectedResultException {
        long returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                try {
                    this.probeNode.onEnter(frame);
                    returnValue = this.delegateNode.executeLong(frame);
                    wasOnReturnExecuted = true;
                    this.probeNode.onReturnValue(frame, (Object)returnValue);
                }
                catch (UnexpectedResultException e) {
                    wasOnReturnExecuted = true;
                    this.probeNode.onReturnValue(frame, e.getResult());
                    throw e;
                }
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result instanceof Long) {
                    returnValue = (Long)result;
                    break;
                }
                if (result != null) {
                    throw new UnexpectedResultException(result);
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                Object returnValue = this.delegateNode.executeGeneric(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, returnValue);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) break;
                throw t;
            }
            break;
        }
    }
}

