/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;
import com.oracle.truffle.sl.runtime.SLContext;
import com.oracle.truffle.sl.runtime.SLNull;

@NodeInfo(shortName="addToHostClassPath")
public abstract class SLAddToHostClassPathBuiltin
extends SLBuiltinNode {
    @Specialization
    protected Object doDefault(TruffleString classPath, @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
        this.addToHostClassPath(toJavaStringNode.execute((AbstractTruffleString)classPath));
        return SLNull.SINGLETON;
    }

    @CompilerDirectives.TruffleBoundary
    private void addToHostClassPath(String classPath) {
        TruffleLanguage.Env env = SLContext.get(this).getEnv();
        TruffleFile file = env.getPublicTruffleFile(classPath);
        env.addToHostClassPath(file);
    }
}

