/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.parser;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLRootNode;
import com.oracle.truffle.sl.nodes.SLStatementNode;
import com.oracle.truffle.sl.nodes.controlflow.SLBlockNode;
import com.oracle.truffle.sl.nodes.controlflow.SLBreakNode;
import com.oracle.truffle.sl.nodes.controlflow.SLContinueNode;
import com.oracle.truffle.sl.nodes.controlflow.SLDebuggerNode;
import com.oracle.truffle.sl.nodes.controlflow.SLFunctionBodyNode;
import com.oracle.truffle.sl.nodes.controlflow.SLIfNode;
import com.oracle.truffle.sl.nodes.controlflow.SLReturnNode;
import com.oracle.truffle.sl.nodes.controlflow.SLWhileNode;
import com.oracle.truffle.sl.nodes.expression.SLAddNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLBigIntegerLiteralNode;
import com.oracle.truffle.sl.nodes.expression.SLDivNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLEqualNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLFunctionLiteralNode;
import com.oracle.truffle.sl.nodes.expression.SLInvokeNode;
import com.oracle.truffle.sl.nodes.expression.SLLessOrEqualNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLLessThanNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLLogicalAndNode;
import com.oracle.truffle.sl.nodes.expression.SLLogicalNotNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLLogicalOrNode;
import com.oracle.truffle.sl.nodes.expression.SLLongLiteralNode;
import com.oracle.truffle.sl.nodes.expression.SLMulNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLParenExpressionNode;
import com.oracle.truffle.sl.nodes.expression.SLReadPropertyNode;
import com.oracle.truffle.sl.nodes.expression.SLReadPropertyNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLStringLiteralNode;
import com.oracle.truffle.sl.nodes.expression.SLSubNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLWritePropertyNode;
import com.oracle.truffle.sl.nodes.expression.SLWritePropertyNodeGen;
import com.oracle.truffle.sl.nodes.local.SLReadArgumentNode;
import com.oracle.truffle.sl.nodes.local.SLReadLocalVariableNodeGen;
import com.oracle.truffle.sl.nodes.local.SLWriteLocalVariableNode;
import com.oracle.truffle.sl.nodes.local.SLWriteLocalVariableNodeGen;
import com.oracle.truffle.sl.nodes.util.SLUnboxNode;
import com.oracle.truffle.sl.nodes.util.SLUnboxNodeGen;
import com.oracle.truffle.sl.runtime.SLStrings;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.Token;

public class SLNodeFactory {
    private final Source source;
    private final TruffleString sourceString;
    private final Map<TruffleString, RootCallTarget> allFunctions;
    private int functionStartPos;
    private TruffleString functionName;
    private int functionBodyStartPos;
    private int parameterCount;
    private FrameDescriptor.Builder frameDescriptorBuilder;
    private List<SLStatementNode> methodNodes;
    private LexicalScope lexicalScope;
    private final SLLanguage language;

    public SLNodeFactory(SLLanguage language, Source source) {
        this.language = language;
        this.source = source;
        this.sourceString = SLStrings.fromJavaString(source.getCharacters().toString());
        this.allFunctions = new HashMap<TruffleString, RootCallTarget>();
    }

    public Map<TruffleString, RootCallTarget> getAllFunctions() {
        return this.allFunctions;
    }

    public void startFunction(Token nameToken, Token bodyStartToken) {
        assert (this.functionStartPos == 0);
        assert (this.functionName == null);
        assert (this.functionBodyStartPos == 0);
        assert (this.parameterCount == 0);
        assert (this.frameDescriptorBuilder == null);
        assert (this.lexicalScope == null);
        this.functionStartPos = nameToken.getStartIndex();
        this.functionName = this.asTruffleString(nameToken, false);
        this.functionBodyStartPos = bodyStartToken.getStartIndex();
        this.frameDescriptorBuilder = FrameDescriptor.newBuilder();
        this.methodNodes = new ArrayList<SLStatementNode>();
        this.startBlock();
    }

    public void addFormalParameter(Token nameToken) {
        SLReadArgumentNode readArg = new SLReadArgumentNode(this.parameterCount);
        readArg.setSourceSection(nameToken.getStartIndex(), nameToken.getText().length());
        SLExpressionNode assignment = this.createAssignment(this.createStringLiteral(nameToken, false), readArg, this.parameterCount);
        this.methodNodes.add(assignment);
        ++this.parameterCount;
    }

    public void finishFunction(SLStatementNode bodyNode) {
        if (bodyNode == null) {
            this.lexicalScope = this.lexicalScope.outer;
        } else {
            this.methodNodes.add(bodyNode);
            int bodyEndPos = bodyNode.getSourceEndIndex();
            SourceSection functionSrc = this.source.createSection(this.functionStartPos, bodyEndPos - this.functionStartPos);
            SLStatementNode methodBlock = this.finishBlock(this.methodNodes, this.parameterCount, this.functionBodyStartPos, bodyEndPos - this.functionBodyStartPos);
            assert (this.lexicalScope == null) : "Wrong scoping of blocks in parser";
            SLFunctionBodyNode functionBodyNode = new SLFunctionBodyNode(methodBlock);
            functionBodyNode.setSourceSection(functionSrc.getCharIndex(), functionSrc.getCharLength());
            SLRootNode rootNode = new SLRootNode(this.language, this.frameDescriptorBuilder.build(), functionBodyNode, functionSrc, this.functionName);
            this.allFunctions.put(this.functionName, rootNode.getCallTarget());
        }
        this.functionStartPos = 0;
        this.functionName = null;
        this.functionBodyStartPos = 0;
        this.parameterCount = 0;
        this.frameDescriptorBuilder = null;
        this.lexicalScope = null;
    }

    public void startBlock() {
        this.lexicalScope = new LexicalScope(this.lexicalScope);
    }

    public SLStatementNode finishBlock(List<SLStatementNode> bodyNodes, int startPos, int length) {
        return this.finishBlock(bodyNodes, 0, startPos, length);
    }

    public SLStatementNode finishBlock(List<SLStatementNode> bodyNodes, int skipCount, int startPos, int length) {
        this.lexicalScope = this.lexicalScope.outer;
        if (SLNodeFactory.containsNull(bodyNodes)) {
            return null;
        }
        ArrayList<SLStatementNode> flattenedNodes = new ArrayList<SLStatementNode>(bodyNodes.size());
        this.flattenBlocks(bodyNodes, flattenedNodes);
        int n = flattenedNodes.size();
        for (int i = skipCount; i < n; ++i) {
            SLStatementNode statement = (SLStatementNode)((Object)flattenedNodes.get(i));
            if (!statement.hasSource() || SLNodeFactory.isHaltInCondition(statement)) continue;
            statement.addStatementTag();
        }
        SLBlockNode blockNode = new SLBlockNode(flattenedNodes.toArray(new SLStatementNode[flattenedNodes.size()]));
        blockNode.setSourceSection(startPos, length);
        return blockNode;
    }

    private static boolean isHaltInCondition(SLStatementNode statement) {
        return statement instanceof SLIfNode || statement instanceof SLWhileNode;
    }

    private void flattenBlocks(Iterable<? extends SLStatementNode> bodyNodes, List<SLStatementNode> flattenedNodes) {
        for (SLStatementNode sLStatementNode : bodyNodes) {
            if (sLStatementNode instanceof SLBlockNode) {
                this.flattenBlocks(((SLBlockNode)sLStatementNode).getStatements(), flattenedNodes);
                continue;
            }
            flattenedNodes.add(sLStatementNode);
        }
    }

    SLStatementNode createDebugger(Token debuggerToken) {
        SLDebuggerNode debuggerNode = new SLDebuggerNode();
        SLNodeFactory.srcFromToken(debuggerNode, debuggerToken);
        return debuggerNode;
    }

    public SLStatementNode createBreak(Token breakToken) {
        SLBreakNode breakNode = new SLBreakNode();
        SLNodeFactory.srcFromToken(breakNode, breakToken);
        return breakNode;
    }

    public SLStatementNode createContinue(Token continueToken) {
        SLContinueNode continueNode = new SLContinueNode();
        SLNodeFactory.srcFromToken(continueNode, continueToken);
        return continueNode;
    }

    public SLStatementNode createWhile(Token whileToken, SLExpressionNode conditionNode, SLStatementNode bodyNode) {
        if (conditionNode == null || bodyNode == null) {
            return null;
        }
        conditionNode.addStatementTag();
        int start = whileToken.getStartIndex();
        int end = bodyNode.getSourceEndIndex();
        SLWhileNode whileNode = new SLWhileNode(conditionNode, bodyNode);
        whileNode.setSourceSection(start, end - start);
        return whileNode;
    }

    public SLStatementNode createIf(Token ifToken, SLExpressionNode conditionNode, SLStatementNode thenPartNode, SLStatementNode elsePartNode) {
        if (conditionNode == null || thenPartNode == null) {
            return null;
        }
        conditionNode.addStatementTag();
        int start = ifToken.getStartIndex();
        int end = elsePartNode == null ? thenPartNode.getSourceEndIndex() : elsePartNode.getSourceEndIndex();
        SLIfNode ifNode = new SLIfNode(conditionNode, thenPartNode, elsePartNode);
        ifNode.setSourceSection(start, end - start);
        return ifNode;
    }

    public SLStatementNode createReturn(Token t, SLExpressionNode valueNode) {
        int start = t.getStartIndex();
        int length = valueNode == null ? t.getText().length() : valueNode.getSourceEndIndex() - start;
        SLReturnNode returnNode = new SLReturnNode(valueNode);
        returnNode.setSourceSection(start, length);
        return returnNode;
    }

    public SLExpressionNode createBinary(Token opToken, SLExpressionNode leftNode, SLExpressionNode rightNode) {
        if (leftNode == null || rightNode == null) {
            return null;
        }
        SLUnboxNode leftUnboxed = SLUnboxNodeGen.create(leftNode);
        SLUnboxNode rightUnboxed = SLUnboxNodeGen.create(rightNode);
        SLExpressionNode result = switch (opToken.getText()) {
            case "+" -> SLAddNodeGen.create(leftUnboxed, rightUnboxed);
            case "*" -> SLMulNodeGen.create(leftUnboxed, rightUnboxed);
            case "/" -> SLDivNodeGen.create(leftUnboxed, rightUnboxed);
            case "-" -> SLSubNodeGen.create(leftUnboxed, rightUnboxed);
            case "<" -> SLLessThanNodeGen.create(leftUnboxed, rightUnboxed);
            case "<=" -> SLLessOrEqualNodeGen.create(leftUnboxed, rightUnboxed);
            case ">" -> SLLogicalNotNodeGen.create(SLLessOrEqualNodeGen.create(leftUnboxed, rightUnboxed));
            case ">=" -> SLLogicalNotNodeGen.create(SLLessThanNodeGen.create(leftUnboxed, rightUnboxed));
            case "==" -> SLEqualNodeGen.create(leftUnboxed, rightUnboxed);
            case "!=" -> SLLogicalNotNodeGen.create(SLEqualNodeGen.create(leftUnboxed, rightUnboxed));
            case "&&" -> new SLLogicalAndNode(leftUnboxed, rightUnboxed);
            case "||" -> new SLLogicalOrNode(leftUnboxed, rightUnboxed);
            default -> throw new RuntimeException("unexpected operation: " + opToken.getText());
        };
        int start = leftNode.getSourceCharIndex();
        int length = rightNode.getSourceEndIndex() - start;
        result.setSourceSection(start, length);
        result.addExpressionTag();
        return result;
    }

    public SLExpressionNode createCall(SLExpressionNode functionNode, List<SLExpressionNode> parameterNodes, Token finalToken) {
        if (functionNode == null || SLNodeFactory.containsNull(parameterNodes)) {
            return null;
        }
        SLInvokeNode result = new SLInvokeNode(functionNode, parameterNodes.toArray(new SLExpressionNode[parameterNodes.size()]));
        int startPos = functionNode.getSourceCharIndex();
        int endPos = finalToken.getStartIndex() + finalToken.getText().length();
        result.setSourceSection(startPos, endPos - startPos);
        result.addExpressionTag();
        return result;
    }

    public SLExpressionNode createAssignment(SLExpressionNode nameNode, SLExpressionNode valueNode) {
        return this.createAssignment(nameNode, valueNode, null);
    }

    public SLExpressionNode createAssignment(SLExpressionNode nameNode, SLExpressionNode valueNode, Integer argumentIndex) {
        if (nameNode == null || valueNode == null) {
            return null;
        }
        TruffleString name = ((SLStringLiteralNode)nameNode).executeGeneric(null);
        Integer frameSlot = this.lexicalScope.find(name);
        boolean newVariable = false;
        if (frameSlot == null) {
            frameSlot = this.frameDescriptorBuilder.addSlot(FrameSlotKind.Illegal, (Object)name, (Object)argumentIndex);
            this.lexicalScope.locals.put(name, frameSlot);
            newVariable = true;
        }
        SLWriteLocalVariableNode result = SLWriteLocalVariableNodeGen.create(valueNode, frameSlot, nameNode, newVariable);
        if (valueNode.hasSource()) {
            int start = nameNode.getSourceCharIndex();
            int length = valueNode.getSourceEndIndex() - start;
            result.setSourceSection(start, length);
        }
        if (argumentIndex == null) {
            result.addExpressionTag();
        }
        return result;
    }

    public SLExpressionNode createRead(SLExpressionNode nameNode) {
        if (nameNode == null) {
            return null;
        }
        TruffleString name = ((SLStringLiteralNode)nameNode).executeGeneric(null);
        Integer frameSlot = this.lexicalScope.find(name);
        SLExpressionNode result = frameSlot != null ? SLReadLocalVariableNodeGen.create(frameSlot) : new SLFunctionLiteralNode(name);
        result.setSourceSection(nameNode.getSourceCharIndex(), nameNode.getSourceLength());
        result.addExpressionTag();
        return result;
    }

    public SLExpressionNode createStringLiteral(Token literalToken, boolean removeQuotes) {
        SLStringLiteralNode result = new SLStringLiteralNode(this.asTruffleString(literalToken, removeQuotes));
        SLNodeFactory.srcFromToken(result, literalToken);
        result.addExpressionTag();
        return result;
    }

    private TruffleString asTruffleString(Token literalToken, boolean removeQuotes) {
        int fromIndex = literalToken.getStartIndex();
        int length = literalToken.getStopIndex() - literalToken.getStartIndex() + 1;
        if (removeQuotes) {
            assert (literalToken.getText().length() >= 2 && literalToken.getText().startsWith("\"") && literalToken.getText().endsWith("\""));
            ++fromIndex;
            length -= 2;
        }
        return this.sourceString.substringByteIndexUncached(fromIndex * 2, length * 2, SLLanguage.STRING_ENCODING, true);
    }

    public SLExpressionNode createNumericLiteral(Token literalToken) {
        SLExpressionNode result;
        try {
            result = new SLLongLiteralNode(Long.parseLong(literalToken.getText()));
        }
        catch (NumberFormatException ex) {
            result = new SLBigIntegerLiteralNode(new BigInteger(literalToken.getText()));
        }
        SLNodeFactory.srcFromToken(result, literalToken);
        result.addExpressionTag();
        return result;
    }

    public SLExpressionNode createParenExpression(SLExpressionNode expressionNode, int start, int length) {
        if (expressionNode == null) {
            return null;
        }
        SLParenExpressionNode result = new SLParenExpressionNode(expressionNode);
        result.setSourceSection(start, length);
        return result;
    }

    public SLExpressionNode createReadProperty(SLExpressionNode receiverNode, SLExpressionNode nameNode) {
        if (receiverNode == null || nameNode == null) {
            return null;
        }
        SLReadPropertyNode result = SLReadPropertyNodeGen.create(receiverNode, nameNode);
        int startPos = receiverNode.getSourceCharIndex();
        int endPos = nameNode.getSourceEndIndex();
        result.setSourceSection(startPos, endPos - startPos);
        result.addExpressionTag();
        return result;
    }

    public SLExpressionNode createWriteProperty(SLExpressionNode receiverNode, SLExpressionNode nameNode, SLExpressionNode valueNode) {
        if (receiverNode == null || nameNode == null || valueNode == null) {
            return null;
        }
        SLWritePropertyNode result = SLWritePropertyNodeGen.create(receiverNode, nameNode, valueNode);
        int start = receiverNode.getSourceCharIndex();
        int length = valueNode.getSourceEndIndex() - start;
        result.setSourceSection(start, length);
        result.addExpressionTag();
        return result;
    }

    private static void srcFromToken(SLStatementNode node, Token token) {
        node.setSourceSection(token.getStartIndex(), token.getText().length());
    }

    private static boolean containsNull(List<?> list) {
        for (Object e : list) {
            if (e != null) continue;
            return true;
        }
        return false;
    }

    static class LexicalScope {
        protected final LexicalScope outer;
        protected final Map<TruffleString, Integer> locals;

        LexicalScope(LexicalScope outer) {
            this.outer = outer;
            this.locals = new HashMap<TruffleString, Integer>();
        }

        public Integer find(TruffleString name) {
            Integer result = this.locals.get(name);
            if (result != null) {
                return result;
            }
            if (this.outer != null) {
                return this.outer.find(name);
            }
            return null;
        }
    }
}

