/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLException;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLBinaryNode;
import com.oracle.truffle.sl.nodes.util.SLToTruffleStringNode;
import com.oracle.truffle.sl.runtime.SLBigInteger;

@NodeInfo(shortName="+")
public abstract class SLAddNode
extends SLBinaryNode {
    @Specialization(rewriteOn={ArithmeticException.class})
    protected long doLong(long left, long right) {
        return Math.addExact(left, right);
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected SLBigInteger doSLBigInteger(SLBigInteger left, SLBigInteger right) {
        return new SLBigInteger(left.getValue().add(right.getValue()));
    }

    @Specialization(replaces={"doSLBigInteger"}, guards={"leftLibrary.fitsInBigInteger(left)", "rightLibrary.fitsInBigInteger(right)"}, limit="3")
    @CompilerDirectives.TruffleBoundary
    protected SLBigInteger doInteropBigInteger(Object left, Object right, @CachedLibrary(value="left") InteropLibrary leftLibrary, @CachedLibrary(value="right") InteropLibrary rightLibrary) {
        try {
            return new SLBigInteger(leftLibrary.asBigInteger(left).add(rightLibrary.asBigInteger(right)));
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @Specialization(guards={"isString(left, right)"})
    @CompilerDirectives.TruffleBoundary
    protected static TruffleString doString(Object left, Object right, @Bind(value="this") Node node, @Cached SLToTruffleStringNode toTruffleStringNodeLeft, @Cached SLToTruffleStringNode toTruffleStringNodeRight, @Cached TruffleString.ConcatNode concatNode) {
        return concatNode.execute((AbstractTruffleString)toTruffleStringNodeLeft.execute(node, left), (AbstractTruffleString)toTruffleStringNodeRight.execute(node, right), SLLanguage.STRING_ENCODING, true);
    }

    protected boolean isString(Object a, Object b) {
        return a instanceof TruffleString || b instanceof TruffleString;
    }

    @Fallback
    protected Object typeError(Object left, Object right) {
        throw SLException.typeError(this, left, right);
    }
}

