/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLEvalRootNode;
import com.oracle.truffle.sl.nodes.SLRootNode;

public final class SLStrings {
    public static final TruffleString EMPTY_STRING = SLStrings.constant("");
    public static final TruffleString NULL = SLStrings.constant("NULL");
    public static final TruffleString NULL_LC = SLStrings.constant("null");
    public static final TruffleString MAIN = SLStrings.constant("main");
    public static final TruffleString HELLO = SLStrings.constant("hello");
    public static final TruffleString WORLD = SLStrings.constant("world");

    public static TruffleString constant(String s) {
        return SLStrings.fromJavaString(s);
    }

    public static TruffleString fromJavaString(String s) {
        return TruffleString.fromJavaStringUncached((String)s, (TruffleString.Encoding)SLLanguage.STRING_ENCODING);
    }

    public static TruffleString fromObject(Object o) {
        if (o == null) {
            return NULL_LC;
        }
        if (o instanceof TruffleString) {
            return (TruffleString)o;
        }
        return SLStrings.fromJavaString(o.toString());
    }

    public static TruffleString getSLRootName(RootNode rootNode) {
        if (rootNode instanceof SLRootNode) {
            return ((SLRootNode)rootNode).getTSName();
        }
        if (rootNode instanceof SLEvalRootNode) {
            return SLEvalRootNode.getTSName();
        }
        throw CompilerDirectives.shouldNotReachHere();
    }
}

