/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.runtime.SLType;

@ExportLibrary(value=InteropLibrary.class, delegateTo="delegate")
public final class SLLanguageView
implements TruffleObject {
    final Object delegate;

    SLLanguageView(Object delegate) {
        this.delegate = delegate;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return SLLanguage.class;
    }

    @ExportMessage
    @ExplodeLoop
    boolean hasMetaObject(@CachedLibrary(value="this.delegate") InteropLibrary interop) {
        for (SLType type : SLType.PRECEDENCE) {
            if (!type.isInstance(this.delegate, interop)) continue;
            return true;
        }
        return false;
    }

    @ExportMessage
    @ExplodeLoop
    Object getMetaObject(@CachedLibrary(value="this.delegate") InteropLibrary interop) throws UnsupportedMessageException {
        for (SLType type : SLType.PRECEDENCE) {
            if (!type.isInstance(this.delegate, interop)) continue;
            return type;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @ExplodeLoop
    Object toDisplayString(boolean allowSideEffects, @CachedLibrary(value="this.delegate") InteropLibrary interop) {
        for (SLType type : SLType.PRECEDENCE) {
            if (!type.isInstance(this.delegate, interop)) continue;
            try {
                if (type == SLType.NUMBER) {
                    return SLLanguageView.longToString(interop.asLong(this.delegate));
                }
                if (type == SLType.BOOLEAN) {
                    return Boolean.toString(interop.asBoolean(this.delegate));
                }
                if (type == SLType.STRING) {
                    return interop.asString(this.delegate);
                }
                return type.getName();
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        return "Unsupported";
    }

    @CompilerDirectives.TruffleBoundary
    private static String longToString(long l) {
        return Long.toString(l);
    }

    public static Object create(Object value) {
        assert (SLLanguageView.isPrimitiveOrFromOtherLanguage(value));
        return new SLLanguageView(value);
    }

    private static boolean isPrimitiveOrFromOtherLanguage(Object value) {
        InteropLibrary interop = (InteropLibrary)InteropLibrary.getFactory().getUncached(value);
        try {
            return !interop.hasLanguage(value) || interop.getLanguage(value) != SLLanguage.class;
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static Object forValue(Object value) {
        if (value == null) {
            return null;
        }
        InteropLibrary lib = (InteropLibrary)InteropLibrary.getFactory().getUncached(value);
        try {
            if (lib.hasLanguage(value) && lib.getLanguage(value) == SLLanguage.class) {
                return value;
            }
            return SLLanguageView.create(value);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }
}

