/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.interop;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;

@ExportLibrary(value=InteropLibrary.class)
public final class NodeObjectDescriptorKeys
implements TruffleObject {
    private final TruffleString keyName;

    NodeObjectDescriptorKeys(TruffleString keyName) {
        this.keyName = keyName;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    boolean isArrayElementReadable(long index) {
        return index >= 0L && index < 1L;
    }

    @ExportMessage
    long getArraySize() {
        return 1L;
    }

    @ExportMessage
    Object readArrayElement(long index, @Bind(value="$node") Node node, @Cached InlinedBranchProfile exception) throws InvalidArrayIndexException {
        if (!this.isArrayElementReadable(index)) {
            exception.enter(node);
            throw InvalidArrayIndexException.create((long)index);
        }
        return this.keyName;
    }
}

