/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.runtime.SLUndefinedNameException;

@NodeInfo(shortName="invoke")
public final class SLInvokeNode
extends SLExpressionNode {
    @Node.Child
    private SLExpressionNode functionNode;
    @Node.Children
    private final SLExpressionNode[] argumentNodes;
    @Node.Child
    private InteropLibrary library;

    public SLInvokeNode(SLExpressionNode functionNode, SLExpressionNode[] argumentNodes) {
        this.functionNode = functionNode;
        this.argumentNodes = argumentNodes;
        this.library = (InteropLibrary)InteropLibrary.getFactory().createDispatched(3);
    }

    @Override
    @ExplodeLoop
    public Object executeGeneric(VirtualFrame frame) {
        Object function = this.functionNode.executeGeneric(frame);
        CompilerAsserts.compilationConstant((Object)this.argumentNodes.length);
        Object[] argumentValues = new Object[this.argumentNodes.length];
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            argumentValues[i] = this.argumentNodes[i].executeGeneric(frame);
        }
        try {
            return this.library.execute(function, argumentValues);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw SLUndefinedNameException.undefinedFunction(this, function);
        }
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.CallTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }
}

