/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.controlflow;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.sl.SLException;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLStatementNode;
import com.oracle.truffle.sl.nodes.util.SLUnboxNodeGen;

@NodeInfo(shortName="if", description="The node implementing a condional statement")
public final class SLIfNode
extends SLStatementNode {
    @Node.Child
    private SLExpressionNode conditionNode;
    @Node.Child
    private SLStatementNode thenPartNode;
    @Node.Child
    private SLStatementNode elsePartNode;
    private final CountingConditionProfile condition = CountingConditionProfile.create();

    public SLIfNode(SLExpressionNode conditionNode, SLStatementNode thenPartNode, SLStatementNode elsePartNode) {
        this.conditionNode = SLUnboxNodeGen.create(conditionNode);
        this.thenPartNode = thenPartNode;
        this.elsePartNode = elsePartNode;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        if (this.condition.profile(this.evaluateCondition(frame))) {
            this.thenPartNode.executeVoid(frame);
        } else if (this.elsePartNode != null) {
            this.elsePartNode.executeVoid(frame);
        }
    }

    private boolean evaluateCondition(VirtualFrame frame) {
        try {
            return this.conditionNode.executeBoolean(frame);
        }
        catch (UnexpectedResultException ex) {
            throw SLException.typeError(this, ex.getResult());
        }
    }
}

