/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.sl.nodes.SLStatementNodeWrapper;
import com.oracle.truffle.sl.nodes.local.SLScopedNode;

@NodeInfo(language="SL", description="The abstract base node for all SL statements")
@GenerateWrapper
public abstract class SLStatementNode
extends SLScopedNode
implements InstrumentableNode {
    private static final int NO_SOURCE = -1;
    private static final int UNAVAILABLE_SOURCE = -2;
    private int sourceCharIndex = -1;
    private int sourceLength;
    private boolean hasStatementTag;
    private boolean hasRootTag;

    @CompilerDirectives.TruffleBoundary
    public final SourceSection getSourceSection() {
        if (this.sourceCharIndex == -1) {
            return null;
        }
        RootNode rootNode = this.getRootNode();
        if (rootNode == null) {
            return null;
        }
        SourceSection rootSourceSection = rootNode.getSourceSection();
        if (rootSourceSection == null) {
            return null;
        }
        Source source = rootSourceSection.getSource();
        if (this.sourceCharIndex == -2) {
            if (this.hasRootTag && !rootSourceSection.isAvailable()) {
                return rootSourceSection;
            }
            return source.createUnavailableSection();
        }
        return source.createSection(this.sourceCharIndex, this.sourceLength);
    }

    public final boolean hasSource() {
        return this.sourceCharIndex != -1;
    }

    public final boolean isInstrumentable() {
        return this.hasSource();
    }

    public final int getSourceCharIndex() {
        return this.sourceCharIndex;
    }

    public final int getSourceEndIndex() {
        return this.sourceCharIndex + this.sourceLength;
    }

    public final int getSourceLength() {
        return this.sourceLength;
    }

    public final void setSourceSection(int charIndex, int length) {
        assert (this.sourceCharIndex == -1) : "source must only be set once";
        if (charIndex < 0) {
            throw new IllegalArgumentException("charIndex < 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        this.sourceCharIndex = charIndex;
        this.sourceLength = length;
    }

    public final void setUnavailableSourceSection() {
        assert (this.sourceCharIndex == -1) : "source must only be set once";
        this.sourceCharIndex = -2;
    }

    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.StatementTag.class) {
            return this.hasStatementTag;
        }
        if (tag == StandardTags.RootTag.class || tag == StandardTags.RootBodyTag.class) {
            return this.hasRootTag;
        }
        return false;
    }

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new SLStatementNodeWrapper(this, probe);
    }

    public abstract void executeVoid(VirtualFrame var1);

    public final void addStatementTag() {
        this.hasStatementTag = true;
    }

    public final void addRootTag() {
        this.hasRootTag = true;
    }

    public String toString() {
        return SLStatementNode.formatSourceSection(this);
    }

    public static String formatSourceSection(Node node) {
        if (node == null) {
            return "<unknown>";
        }
        SourceSection section = node.getSourceSection();
        boolean estimated = false;
        if (section == null) {
            section = node.getEncapsulatingSourceSection();
            estimated = true;
        }
        if (section == null || section.getSource() == null) {
            return "<unknown source>";
        }
        String sourceName = section.getSource().getName();
        int startLine = section.getStartLine();
        return String.format("%s:%d%s", sourceName, startLine, estimated ? "~" : "");
    }
}

