/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLStatementNode;
import com.oracle.truffle.sl.nodes.controlflow.SLBlockNode;
import com.oracle.truffle.sl.nodes.controlflow.SLFunctionBodyNode;
import com.oracle.truffle.sl.nodes.local.SLReadArgumentNode;
import com.oracle.truffle.sl.nodes.local.SLWriteLocalVariableNode;
import com.oracle.truffle.sl.runtime.SLContext;
import java.util.ArrayList;

@NodeInfo(language="SL", description="The root of all SL execution trees")
public class SLRootNode
extends RootNode {
    @Node.Child
    private SLExpressionNode bodyNode;
    private final TruffleString name;
    private boolean isCloningAllowed;
    private final SourceSection sourceSection;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private volatile SLWriteLocalVariableNode[] argumentNodesCache;

    public SLRootNode(SLLanguage language, FrameDescriptor frameDescriptor, SLExpressionNode bodyNode, SourceSection sourceSection, TruffleString name) {
        super((TruffleLanguage)language, frameDescriptor);
        this.bodyNode = bodyNode;
        this.name = name;
        this.sourceSection = sourceSection;
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public Object execute(VirtualFrame frame) {
        assert (SLContext.get((Node)this) != null);
        return this.bodyNode.executeGeneric(frame);
    }

    public SLExpressionNode getBodyNode() {
        return this.bodyNode;
    }

    public String getName() {
        return this.name.toJavaStringUncached();
    }

    public TruffleString getTSName() {
        return this.name;
    }

    public void setCloningAllowed(boolean isCloningAllowed) {
        this.isCloningAllowed = isCloningAllowed;
    }

    public boolean isCloningAllowed() {
        return this.isCloningAllowed;
    }

    public String toString() {
        return "root " + this.name;
    }

    public final SLWriteLocalVariableNode[] getDeclaredArguments() {
        SLWriteLocalVariableNode[] argumentNodes = this.argumentNodesCache;
        if (argumentNodes == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            argumentNodes = this.findArgumentNodes();
            this.argumentNodesCache = argumentNodes;
        }
        return argumentNodes;
    }

    private SLWriteLocalVariableNode[] findArgumentNodes() {
        final ArrayList writeArgNodes = new ArrayList(4);
        NodeUtil.forEachChild((Node)this.getBodyNode(), (NodeVisitor)new NodeVisitor(){
            private SLWriteLocalVariableNode wn;

            public boolean visit(Node node) {
                if (node instanceof InstrumentableNode.WrapperNode) {
                    return NodeUtil.forEachChild((Node)node, (NodeVisitor)this);
                }
                if (node instanceof SLWriteLocalVariableNode) {
                    this.wn = (SLWriteLocalVariableNode)node;
                    boolean all = NodeUtil.forEachChild((Node)node, (NodeVisitor)this);
                    this.wn = null;
                    return all;
                }
                if (this.wn != null && node instanceof SLReadArgumentNode) {
                    writeArgNodes.add(this.wn);
                    return true;
                }
                if (this.wn == null && node instanceof SLStatementNode && !(node instanceof SLBlockNode) && !(node instanceof SLFunctionBodyNode)) {
                    return false;
                }
                return NodeUtil.forEachChild((Node)node, (NodeVisitor)this);
            }
        });
        return writeArgNodes.toArray(new SLWriteLocalVariableNode[writeArgNodes.size()]);
    }
}

