/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;

@NodeInfo(shortName="wrapPrimitive")
public abstract class SLWrapPrimitiveBuiltin
extends SLBuiltinNode {
    @CompilerDirectives.TruffleBoundary
    @Specialization
    public Object doDefault(Object value) {
        if (value instanceof PrimitiveValueWrapper) {
            return value;
        }
        return new PrimitiveValueWrapper(value);
    }

    @ExportLibrary(value=ReflectionLibrary.class)
    static final class PrimitiveValueWrapper
    implements TruffleObject {
        final Object delegate;

        PrimitiveValueWrapper(Object delegate) {
            this.delegate = delegate;
        }

        @ExportMessage
        Object send(Message message, Object[] args, @CachedLibrary(value="this.delegate") ReflectionLibrary reflection) throws Exception {
            return reflection.send(this.delegate, message, args);
        }
    }
}

