/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLFileDetector;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;
import com.oracle.truffle.sl.nodes.SLEvalRootNode;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLRootNode;
import com.oracle.truffle.sl.nodes.SLUndefinedFunctionRootNode;
import com.oracle.truffle.sl.nodes.local.SLReadArgumentNode;
import com.oracle.truffle.sl.parser.SimpleLanguageParser;
import com.oracle.truffle.sl.runtime.SLContext;
import com.oracle.truffle.sl.runtime.SLLanguageView;
import com.oracle.truffle.sl.runtime.SLObject;
import com.oracle.truffle.sl.runtime.SLStrings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@TruffleLanguage.Registration(id="sl", name="SL", defaultMimeType="application/x-sl", characterMimeTypes={"application/x-sl"}, contextPolicy=TruffleLanguage.ContextPolicy.SHARED, fileTypeDetectors={SLFileDetector.class}, website="https://www.graalvm.org/graalvm-as-a-platform/implement-language/")
@ProvidedTags(value={StandardTags.CallTag.class, StandardTags.StatementTag.class, StandardTags.RootTag.class, StandardTags.RootBodyTag.class, StandardTags.ExpressionTag.class, DebuggerTags.AlwaysHalt.class, StandardTags.ReadVariableTag.class, StandardTags.WriteVariableTag.class})
public final class SLLanguage
extends TruffleLanguage<SLContext> {
    public static volatile int counter;
    public static final String ID = "sl";
    public static final String MIME_TYPE = "application/x-sl";
    private static final Source BUILTIN_SOURCE;
    public static final TruffleString.Encoding STRING_ENCODING;
    private final Assumption singleContext = Truffle.getRuntime().createAssumption("Single SL context.");
    private final Map<NodeFactory<? extends SLBuiltinNode>, RootCallTarget> builtinTargets = new ConcurrentHashMap<NodeFactory<? extends SLBuiltinNode>, RootCallTarget>();
    private final Map<TruffleString, RootCallTarget> undefinedFunctions = new ConcurrentHashMap<TruffleString, RootCallTarget>();
    private final Shape rootShape;
    private static final TruffleLanguage.LanguageReference<SLLanguage> REFERENCE;
    private static final List<NodeFactory<? extends SLBuiltinNode>> EXTERNAL_BUILTINS;

    public SLLanguage() {
        ++counter;
        this.rootShape = Shape.newBuilder().layout(SLObject.class).build();
    }

    protected SLContext createContext(TruffleLanguage.Env env) {
        return new SLContext(this, env, new ArrayList<NodeFactory<? extends SLBuiltinNode>>(EXTERNAL_BUILTINS));
    }

    protected boolean patchContext(SLContext context, TruffleLanguage.Env newEnv) {
        context.patchContext(newEnv);
        return true;
    }

    public RootCallTarget getOrCreateUndefinedFunction(TruffleString name) {
        RootCallTarget other;
        RootCallTarget target = this.undefinedFunctions.get(name);
        if (target == null && (other = this.undefinedFunctions.putIfAbsent(name, target = new SLUndefinedFunctionRootNode(this, name).getCallTarget())) != null) {
            target = other;
        }
        return target;
    }

    public RootCallTarget lookupBuiltin(NodeFactory<? extends SLBuiltinNode> factory) {
        RootCallTarget target = this.builtinTargets.get(factory);
        if (target != null) {
            return target;
        }
        int argumentCount = factory.getExecutionSignature().size();
        SLExpressionNode[] argumentNodes = new SLExpressionNode[argumentCount];
        for (int i = 0; i < argumentCount; ++i) {
            argumentNodes[i] = new SLReadArgumentNode(i);
        }
        SLBuiltinNode builtinBodyNode = (SLBuiltinNode)((Object)factory.createNode(new Object[]{argumentNodes}));
        builtinBodyNode.addRootTag();
        TruffleString name = SLStrings.fromJavaString(SLLanguage.lookupNodeInfo(((Object)((Object)builtinBodyNode)).getClass()).shortName());
        builtinBodyNode.setUnavailableSourceSection();
        SLRootNode rootNode = new SLRootNode(this, new FrameDescriptor(), builtinBodyNode, BUILTIN_SOURCE.createUnavailableSection(), name);
        RootCallTarget newTarget = rootNode.getCallTarget();
        RootCallTarget oldTarget = this.builtinTargets.putIfAbsent(factory, newTarget);
        if (oldTarget != null) {
            return oldTarget;
        }
        return newTarget;
    }

    public static NodeInfo lookupNodeInfo(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        NodeInfo info = clazz.getAnnotation(NodeInfo.class);
        if (info != null) {
            return info;
        }
        return SLLanguage.lookupNodeInfo(clazz.getSuperclass());
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) throws Exception {
        Map<TruffleString, RootCallTarget> functions;
        Source source = request.getSource();
        if (request.getArgumentNames().isEmpty()) {
            functions = SimpleLanguageParser.parseSL(this, source);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("function main(");
            String sep = "";
            for (String argumentName : request.getArgumentNames()) {
                sb.append(sep);
                sb.append(argumentName);
                sep = ",";
            }
            sb.append(") { return ");
            sb.append(source.getCharacters());
            sb.append(";}");
            String language = source.getLanguage() == null ? ID : source.getLanguage();
            Source decoratedSource = Source.newBuilder((String)language, (CharSequence)sb.toString(), (String)source.getName()).build();
            functions = SimpleLanguageParser.parseSL(this, decoratedSource);
        }
        RootCallTarget main = functions.get(SLStrings.MAIN);
        SLEvalRootNode evalMain = main != null ? new SLEvalRootNode(this, main, functions) : new SLEvalRootNode(this, null, functions);
        return evalMain.getCallTarget();
    }

    protected void initializeMultipleContexts() {
        this.singleContext.invalidate();
    }

    public boolean isSingleContext() {
        return this.singleContext.isValid();
    }

    protected Object getLanguageView(SLContext context, Object value) {
        return SLLanguageView.create(value);
    }

    protected boolean isVisible(SLContext context, Object value) {
        return !((InteropLibrary)InteropLibrary.getFactory().getUncached(value)).isNull(value);
    }

    protected Object getScope(SLContext context) {
        return context.getFunctionRegistry().getFunctionsObject();
    }

    public Shape getRootShape() {
        return this.rootShape;
    }

    public SLObject createObject(AllocationReporter reporter) {
        reporter.onEnter(null, 0L, Long.MIN_VALUE);
        SLObject object = new SLObject(this.rootShape);
        reporter.onReturnValue((Object)object, 0L, Long.MIN_VALUE);
        return object;
    }

    public static SLLanguage get(Node node) {
        return (SLLanguage)REFERENCE.get(node);
    }

    public static void installBuiltin(NodeFactory<? extends SLBuiltinNode> builtin) {
        EXTERNAL_BUILTINS.add(builtin);
    }

    protected void exitContext(SLContext context, TruffleLanguage.ExitMode exitMode, int exitCode) {
        context.runShutdownHooks();
    }

    static {
        BUILTIN_SOURCE = Source.newBuilder((String)ID, (CharSequence)"", (String)"SL builtin").build();
        STRING_ENCODING = TruffleString.Encoding.UTF_16;
        REFERENCE = TruffleLanguage.LanguageReference.create(SLLanguage.class);
        EXTERNAL_BUILTINS = Collections.synchronizedList(new ArrayList());
    }
}

