/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.nodes.SLTypes;
import com.oracle.truffle.sl.runtime.SLBigInteger;

@TypeSystemReference(value=SLTypes.class)
@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class SLToMemberNode
extends Node {
    static final int LIMIT = 5;

    public abstract String execute(Node var1, Object var2) throws UnknownIdentifierException;

    @Specialization
    protected static String fromString(String value) {
        return value;
    }

    @Specialization
    protected static String fromTruffleString(TruffleString value, @Cached(inline=false) TruffleString.ToJavaStringNode toJavaStringNode) {
        return toJavaStringNode.execute((AbstractTruffleString)value);
    }

    @Specialization
    protected static String fromBoolean(boolean value) {
        return String.valueOf(value);
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected static String fromLong(long value) {
        return String.valueOf(value);
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected static String fromBigNumber(SLBigInteger value) {
        return value.toString();
    }

    @Specialization(limit="LIMIT")
    protected static String fromInterop(Object value, @CachedLibrary(value="value") InteropLibrary interop) throws UnknownIdentifierException {
        try {
            if (interop.fitsInLong(value)) {
                return SLToMemberNode.longToString(interop.asLong(value));
            }
            if (interop.isString(value)) {
                return interop.asString(value);
            }
            if (interop.isNumber(value) && value instanceof SLBigInteger) {
                return SLToMemberNode.bigNumberToString((SLBigInteger)value);
            }
            throw SLToMemberNode.error(value);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static UnknownIdentifierException error(Object value) {
        return UnknownIdentifierException.create((String)value.toString());
    }

    @CompilerDirectives.TruffleBoundary
    private static String bigNumberToString(SLBigInteger value) {
        return value.toString();
    }

    @CompilerDirectives.TruffleBoundary
    private static String longToString(long longValue) {
        return String.valueOf(longValue);
    }
}

