/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.runtime.SLType;

@ExportLibrary(value=InteropLibrary.class)
public final class SLObject
extends DynamicObject
implements TruffleObject {
    protected static final int CACHE_LIMIT = 3;

    public SLObject(Shape shape) {
        super(shape);
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return SLLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    int identityHashCode() {
        return System.identityHashCode((Object)this);
    }

    @ExportMessage
    boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    Object getMetaObject() {
        return SLType.OBJECT;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean allowSideEffects) {
        return "Object";
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    void removeMember(String member, @CachedLibrary(value="this") DynamicObjectLibrary objectLibrary) throws UnknownIdentifierException {
        if (!objectLibrary.containsKey((DynamicObject)this, (Object)member)) {
            throw UnknownIdentifierException.create((String)member);
        }
        objectLibrary.removeKey((DynamicObject)this, (Object)member);
    }

    @ExportMessage
    Object getMembers(boolean includeInternal, @CachedLibrary(value="this") DynamicObjectLibrary objectLibrary) {
        return new Keys(objectLibrary.getKeyArray((DynamicObject)this));
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isMemberReadable"), @ExportMessage(name="isMemberModifiable"), @ExportMessage(name="isMemberRemovable")})
    boolean existsMember(String member, @CachedLibrary(value="this") DynamicObjectLibrary objectLibrary) {
        return objectLibrary.containsKey((DynamicObject)this, (Object)member);
    }

    @ExportMessage
    boolean isMemberInsertable(String member, @CachedLibrary(value="this") InteropLibrary receivers) {
        return !receivers.isMemberExisting((Object)this, member);
    }

    @ExportMessage
    Object readMember(String name, @CachedLibrary(value="this") DynamicObjectLibrary objectLibrary) throws UnknownIdentifierException {
        Object result = objectLibrary.getOrDefault((DynamicObject)this, (Object)name, null);
        if (result == null) {
            throw UnknownIdentifierException.create((String)name);
        }
        return result;
    }

    @ExportMessage
    void writeMember(String name, Object value, @CachedLibrary(value="this") DynamicObjectLibrary objectLibrary) {
        objectLibrary.put((DynamicObject)this, (Object)name, value);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class Keys
    implements TruffleObject {
        private final Object[] keys;

        Keys(Object[] keys) {
            this.keys = keys;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                throw InvalidArrayIndexException.create((long)index);
            }
            return this.keys[(int)index];
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.keys.length;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < (long)this.keys.length;
        }
    }

    @ExportMessage
    static final class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doSLObject(SLObject receiver, SLObject other) {
            return TriState.valueOf((receiver == other ? 1 : 0) != 0);
        }

        @Fallback
        static TriState doOther(SLObject receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }
}

