/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.sl.runtime.SLLanguageView;

@GeneratedBy(value=SLLanguageView.class)
final class SLLanguageViewGen {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private SLLanguageViewGen() {
    }

    static {
        LibraryExport.register(SLLanguageView.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=SLLanguageView.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        static final FinalBitSet ENABLED_MESSAGES = InteropLibraryExports.createMessageBitSet((LibraryFactory)SLLanguageViewGen.access$100(), (String[])new String[]{"hasLanguage", "getLanguage", "hasMetaObject", "getMetaObject", "toDisplayString"});
        private static final Uncached UNCACHED = new Uncached();

        private InteropLibraryExports() {
            super(InteropLibrary.class, SLLanguageView.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof SLLanguageView);
            InteropLibrary uncached = (InteropLibrary)InteropLibraryExports.createDelegate((LibraryFactory)INTEROP_LIBRARY_, (Library)UNCACHED);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof SLLanguageView);
            return (InteropLibrary)InteropLibraryExports.createDelegate((LibraryFactory)INTEROP_LIBRARY_, (Library)new Cached(receiver));
        }

        @GeneratedBy(value=SLLanguageView.class)
        private static final class Uncached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            protected Uncached() {
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((SLLanguageView)receiver_).delegate;
            }

            public Library getDelegateExportLibrary(Object delegate_) {
                return INTEROP_LIBRARY_.getUncached(delegate_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof SLLanguageView) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SLLanguageView;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLLanguageView)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLLanguageView)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                SLLanguageView arg0Value = (SLLanguageView)arg0Value_;
                return arg0Value.hasMetaObject((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.delegate));
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                SLLanguageView arg0Value = (SLLanguageView)arg0Value_;
                return arg0Value.getMetaObject((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.delegate));
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object arg0Value_, boolean arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                SLLanguageView arg0Value = (SLLanguageView)arg0Value_;
                return arg0Value.toDisplayString(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.delegate));
            }
        }

        @GeneratedBy(value=SLLanguageView.class)
        private static final class Cached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            @Node.Child
            private InteropLibrary receiverDelegateInteropLibrary_;

            protected Cached(Object receiver) {
                SLLanguageView castReceiver = (SLLanguageView)receiver;
                this.receiverDelegateInteropLibrary_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(castReceiver.delegate));
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((SLLanguageView)receiver_).delegate;
            }

            public Library getDelegateExportLibrary(Object delegate) {
                return this.receiverDelegateInteropLibrary_;
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof SLLanguageView) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof SLLanguageView)) {
                    return false;
                }
                return this.receiverDelegateInteropLibrary_.accepts(((SLLanguageView)receiver).delegate);
            }

            public boolean hasLanguage(Object receiver) {
                assert (receiver instanceof SLLanguageView) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLLanguageView)receiver).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (receiver instanceof SLLanguageView) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLLanguageView)receiver).getLanguage();
            }

            public boolean hasMetaObject(Object arg0Value_) {
                assert (arg0Value_ instanceof SLLanguageView) : "Invalid library usage. Library does not accept given receiver.";
                SLLanguageView arg0Value = (SLLanguageView)arg0Value_;
                InteropLibrary hasMetaObjectNode__hasMetaObject_interop__ = this.receiverDelegateInteropLibrary_;
                return arg0Value.hasMetaObject(hasMetaObjectNode__hasMetaObject_interop__);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            public Object getMetaObject(Object arg0Value_) throws UnsupportedMessageException {
                assert (arg0Value_ instanceof SLLanguageView) : "Invalid library usage. Library does not accept given receiver.";
                SLLanguageView arg0Value = (SLLanguageView)arg0Value_;
                InteropLibrary getMetaObjectNode__getMetaObject_interop__ = this.receiverDelegateInteropLibrary_;
                return arg0Value.getMetaObject(getMetaObjectNode__getMetaObject_interop__);
            }

            public Object toDisplayString(Object arg0Value_, boolean arg1Value) {
                assert (arg0Value_ instanceof SLLanguageView) : "Invalid library usage. Library does not accept given receiver.";
                SLLanguageView arg0Value = (SLLanguageView)arg0Value_;
                InteropLibrary toDisplayStringNode__toDisplayString_interop__ = this.receiverDelegateInteropLibrary_;
                return arg0Value.toDisplayString(arg1Value, toDisplayStringNode__toDisplayString_interop__);
            }
        }
    }
}

