/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.parser.SimpleLanguageParser;
import com.oracle.truffle.sl.runtime.FunctionsObject;
import com.oracle.truffle.sl.runtime.SLFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public final class SLFunctionRegistry {
    private final SLLanguage language;
    private final FunctionsObject functionsObject = new FunctionsObject();
    private final Map<Map<String, RootCallTarget>, Void> registeredFunctions = new IdentityHashMap<Map<String, RootCallTarget>, Void>();

    public SLFunctionRegistry(SLLanguage language) {
        this.language = language;
    }

    @CompilerDirectives.TruffleBoundary
    public SLFunction lookup(String name, boolean createIfNotPresent) {
        SLFunction result = this.functionsObject.functions.get(name);
        if (result == null && createIfNotPresent) {
            result = new SLFunction(this.language, name);
            this.functionsObject.functions.put(name, result);
        }
        return result;
    }

    SLFunction register(String name, RootCallTarget callTarget) {
        SLFunction result = this.functionsObject.functions.get(name);
        if (result == null) {
            result = new SLFunction(callTarget);
            this.functionsObject.functions.put(name, result);
        } else {
            result.setCallTarget(callTarget);
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public void register(Map<String, RootCallTarget> newFunctions) {
        if (this.registeredFunctions.containsKey(newFunctions)) {
            return;
        }
        for (Map.Entry<String, RootCallTarget> entry : newFunctions.entrySet()) {
            this.register(entry.getKey(), entry.getValue());
        }
        this.registeredFunctions.put(newFunctions, null);
    }

    public void register(Source newFunctions) {
        this.register(SimpleLanguageParser.parseSL(this.language, newFunctions));
    }

    public SLFunction getFunction(String name) {
        return this.functionsObject.functions.get(name);
    }

    public List<SLFunction> getFunctions() {
        ArrayList<SLFunction> result = new ArrayList<SLFunction>(this.functionsObject.functions.values());
        Collections.sort(result, new Comparator<SLFunction>(){

            @Override
            public int compare(SLFunction f1, SLFunction f2) {
                return f1.toString().compareTo(f2.toString());
            }
        });
        return result;
    }

    public TruffleObject getFunctionsObject() {
        return this.functionsObject;
    }
}

