/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.runtime.SLType;
import java.util.logging.Level;

@ExportLibrary(value=InteropLibrary.class)
public final class SLFunction
implements TruffleObject {
    public static final int INLINE_CACHE_SIZE = 2;
    private static final TruffleLogger LOG = TruffleLogger.getLogger((String)"sl", SLFunction.class);
    private final String name;
    private RootCallTarget callTarget;
    private final CyclicAssumption callTargetStable;

    protected SLFunction(SLLanguage language, String name) {
        this(language.getOrCreateUndefinedFunction(name));
    }

    protected SLFunction(RootCallTarget callTarget) {
        this.name = callTarget.getRootNode().getName();
        this.callTargetStable = new CyclicAssumption(this.name);
        this.setCallTarget(callTarget);
    }

    public String getName() {
        return this.name;
    }

    protected void setCallTarget(RootCallTarget callTarget) {
        boolean wasNull = this.callTarget == null;
        this.callTarget = callTarget;
        LOG.log(Level.FINE, "Installed call target for: {0}", (Object)this.name);
        if (!wasNull) {
            this.callTargetStable.invalidate();
        }
    }

    public RootCallTarget getCallTarget() {
        return this.callTarget;
    }

    public Assumption getCallTargetStable() {
        return this.callTargetStable.getAssumption();
    }

    public String toString() {
        return this.name;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return SLLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    SourceSection getSourceLocation() {
        return this.getCallTarget().getRootNode().getSourceSection();
    }

    @ExportMessage
    boolean hasSourceLocation() {
        return true;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    Object getMetaObject() {
        return SLType.FUNCTION;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static int identityHashCode(SLFunction receiver) {
        return System.identityHashCode(receiver);
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return this.name;
    }

    @ExportMessage
    @ReportPolymorphism
    static abstract class Execute {
        Execute() {
        }

        @Specialization(limit="INLINE_CACHE_SIZE", guards={"function.getCallTarget() == cachedTarget"}, assumptions={"callTargetStable"})
        protected static Object doDirect(SLFunction function, Object[] arguments, @Cached(value="function.getCallTargetStable()") Assumption callTargetStable, @Cached(value="function.getCallTarget()") RootCallTarget cachedTarget, @Cached(value="create(cachedTarget)") DirectCallNode callNode) {
            Object returnValue = callNode.call(arguments);
            return returnValue;
        }

        @Specialization(replaces={"doDirect"})
        protected static Object doIndirect(SLFunction function, Object[] arguments, @Cached IndirectCallNode callNode) {
            return callNode.call((CallTarget)function.getCallTarget(), arguments);
        }
    }

    @ExportMessage
    static final class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doSLFunction(SLFunction receiver, SLFunction other) {
            return receiver == other ? TriState.TRUE : TriState.FALSE;
        }

        @Fallback
        static TriState doOther(SLFunction receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }
}

