/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;
import com.oracle.truffle.sl.builtins.SLDefineFunctionBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLEvalBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLGetSizeBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLHasSizeBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLHelloEqualsWorldBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLImportBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLIsExecutableBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLIsInstanceBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLIsNullBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLJavaTypeBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLNanoTimeBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLNewObjectBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLPrintlnBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLReadlnBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLStackTraceBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLTypeOfBuiltinFactory;
import com.oracle.truffle.sl.builtins.SLWrapPrimitiveBuiltinFactory;
import com.oracle.truffle.sl.runtime.SLBigNumber;
import com.oracle.truffle.sl.runtime.SLFunctionRegistry;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;

public final class SLContext {
    private final SLLanguage language;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.Env env;
    private final BufferedReader input;
    private final PrintWriter output;
    private final SLFunctionRegistry functionRegistry;
    private final AllocationReporter allocationReporter;
    private static final TruffleLanguage.ContextReference<SLContext> REFERENCE = TruffleLanguage.ContextReference.create(SLLanguage.class);

    public SLContext(SLLanguage language, TruffleLanguage.Env env, List<NodeFactory<? extends SLBuiltinNode>> externalBuiltins) {
        this.env = env;
        this.input = new BufferedReader(new InputStreamReader(env.in()));
        this.output = new PrintWriter(env.out(), true);
        this.language = language;
        this.allocationReporter = (AllocationReporter)env.lookup(AllocationReporter.class);
        this.functionRegistry = new SLFunctionRegistry(language);
        this.installBuiltins();
        for (NodeFactory<? extends SLBuiltinNode> builtin : externalBuiltins) {
            this.installBuiltin(builtin);
        }
    }

    public void patchContext(TruffleLanguage.Env newEnv) {
        this.env = newEnv;
    }

    public TruffleLanguage.Env getEnv() {
        return this.env;
    }

    public BufferedReader getInput() {
        return this.input;
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public SLFunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    private void installBuiltins() {
        this.installBuiltin(SLReadlnBuiltinFactory.getInstance());
        this.installBuiltin(SLPrintlnBuiltinFactory.getInstance());
        this.installBuiltin(SLNanoTimeBuiltinFactory.getInstance());
        this.installBuiltin(SLDefineFunctionBuiltinFactory.getInstance());
        this.installBuiltin(SLStackTraceBuiltinFactory.getInstance());
        this.installBuiltin(SLHelloEqualsWorldBuiltinFactory.getInstance());
        this.installBuiltin(SLNewObjectBuiltinFactory.getInstance());
        this.installBuiltin(SLEvalBuiltinFactory.getInstance());
        this.installBuiltin(SLImportBuiltinFactory.getInstance());
        this.installBuiltin(SLGetSizeBuiltinFactory.getInstance());
        this.installBuiltin(SLHasSizeBuiltinFactory.getInstance());
        this.installBuiltin(SLIsExecutableBuiltinFactory.getInstance());
        this.installBuiltin(SLIsNullBuiltinFactory.getInstance());
        this.installBuiltin(SLWrapPrimitiveBuiltinFactory.getInstance());
        this.installBuiltin(SLTypeOfBuiltinFactory.getInstance());
        this.installBuiltin(SLIsInstanceBuiltinFactory.getInstance());
        this.installBuiltin(SLJavaTypeBuiltinFactory.getInstance());
    }

    public void installBuiltin(NodeFactory<? extends SLBuiltinNode> factory) {
        RootCallTarget target = this.language.lookupBuiltin(factory);
        String rootName = target.getRootNode().getName();
        this.getFunctionRegistry().register(rootName, target);
    }

    public AllocationReporter getAllocationReporter() {
        return this.allocationReporter;
    }

    public static Object fromForeignValue(Object a) {
        if (a instanceof Long || a instanceof SLBigNumber || a instanceof String || a instanceof Boolean) {
            return a;
        }
        if (a instanceof Character) {
            return SLContext.fromForeignCharacter(((Character)a).charValue());
        }
        if (a instanceof Number) {
            return SLContext.fromForeignNumber(a);
        }
        if (a instanceof TruffleObject) {
            return a;
        }
        if (a instanceof SLContext) {
            return a;
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Value is not a truffle value.");
    }

    @CompilerDirectives.TruffleBoundary
    private static long fromForeignNumber(Object a) {
        return ((Number)a).longValue();
    }

    @CompilerDirectives.TruffleBoundary
    private static String fromForeignCharacter(char c) {
        return String.valueOf(c);
    }

    public CallTarget parse(Source source) {
        return this.env.parsePublic(source, new String[0]);
    }

    public TruffleObject getPolyglotBindings() {
        return (TruffleObject)this.env.getPolyglotBindings();
    }

    public static SLContext get(Node node) {
        return (SLContext)REFERENCE.get(node);
    }
}

