/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.parser;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLRootNode;
import com.oracle.truffle.sl.nodes.SLStatementNode;
import com.oracle.truffle.sl.nodes.controlflow.SLBlockNode;
import com.oracle.truffle.sl.nodes.controlflow.SLBreakNode;
import com.oracle.truffle.sl.nodes.controlflow.SLContinueNode;
import com.oracle.truffle.sl.nodes.controlflow.SLDebuggerNode;
import com.oracle.truffle.sl.nodes.controlflow.SLFunctionBodyNode;
import com.oracle.truffle.sl.nodes.controlflow.SLIfNode;
import com.oracle.truffle.sl.nodes.controlflow.SLReturnNode;
import com.oracle.truffle.sl.nodes.controlflow.SLWhileNode;
import com.oracle.truffle.sl.nodes.expression.SLAddNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLBigIntegerLiteralNode;
import com.oracle.truffle.sl.nodes.expression.SLDivNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLEqualNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLFunctionLiteralNode;
import com.oracle.truffle.sl.nodes.expression.SLInvokeNode;
import com.oracle.truffle.sl.nodes.expression.SLLessOrEqualNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLLessThanNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLLogicalAndNode;
import com.oracle.truffle.sl.nodes.expression.SLLogicalNotNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLLogicalOrNode;
import com.oracle.truffle.sl.nodes.expression.SLLongLiteralNode;
import com.oracle.truffle.sl.nodes.expression.SLMulNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLParenExpressionNode;
import com.oracle.truffle.sl.nodes.expression.SLReadPropertyNode;
import com.oracle.truffle.sl.nodes.expression.SLReadPropertyNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLStringLiteralNode;
import com.oracle.truffle.sl.nodes.expression.SLSubNodeGen;
import com.oracle.truffle.sl.nodes.expression.SLWritePropertyNode;
import com.oracle.truffle.sl.nodes.expression.SLWritePropertyNodeGen;
import com.oracle.truffle.sl.nodes.local.SLReadArgumentNode;
import com.oracle.truffle.sl.nodes.local.SLReadLocalVariableNodeGen;
import com.oracle.truffle.sl.nodes.local.SLWriteLocalVariableNode;
import com.oracle.truffle.sl.nodes.local.SLWriteLocalVariableNodeGen;
import com.oracle.truffle.sl.nodes.util.SLUnboxNode;
import com.oracle.truffle.sl.nodes.util.SLUnboxNodeGen;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.Token;

public class SLNodeFactory {
    private final Source source;
    private final Map<String, RootCallTarget> allFunctions;
    private int functionStartPos;
    private String functionName;
    private int functionBodyStartPos;
    private int parameterCount;
    private FrameDescriptor frameDescriptor;
    private List<SLStatementNode> methodNodes;
    private LexicalScope lexicalScope;
    private final SLLanguage language;

    public SLNodeFactory(SLLanguage language, Source source) {
        this.language = language;
        this.source = source;
        this.allFunctions = new HashMap<String, RootCallTarget>();
    }

    public Map<String, RootCallTarget> getAllFunctions() {
        return this.allFunctions;
    }

    public void startFunction(Token nameToken, Token bodyStartToken) {
        assert (this.functionStartPos == 0);
        assert (this.functionName == null);
        assert (this.functionBodyStartPos == 0);
        assert (this.parameterCount == 0);
        assert (this.frameDescriptor == null);
        assert (this.lexicalScope == null);
        this.functionStartPos = nameToken.getStartIndex();
        this.functionName = nameToken.getText();
        this.functionBodyStartPos = bodyStartToken.getStartIndex();
        this.frameDescriptor = new FrameDescriptor();
        this.methodNodes = new ArrayList<SLStatementNode>();
        this.startBlock();
    }

    public void addFormalParameter(Token nameToken) {
        SLReadArgumentNode readArg = new SLReadArgumentNode(this.parameterCount);
        readArg.setSourceSection(nameToken.getStartIndex(), nameToken.getText().length());
        SLExpressionNode assignment = this.createAssignment(this.createStringLiteral(nameToken, false), readArg, this.parameterCount);
        this.methodNodes.add(assignment);
        ++this.parameterCount;
    }

    public void finishFunction(SLStatementNode bodyNode) {
        if (bodyNode == null) {
            this.lexicalScope = this.lexicalScope.outer;
        } else {
            this.methodNodes.add(bodyNode);
            int bodyEndPos = bodyNode.getSourceEndIndex();
            SourceSection functionSrc = this.source.createSection(this.functionStartPos, bodyEndPos - this.functionStartPos);
            SLStatementNode methodBlock = this.finishBlock(this.methodNodes, this.parameterCount, this.functionBodyStartPos, bodyEndPos - this.functionBodyStartPos);
            assert (this.lexicalScope == null) : "Wrong scoping of blocks in parser";
            SLFunctionBodyNode functionBodyNode = new SLFunctionBodyNode(methodBlock);
            functionBodyNode.setSourceSection(functionSrc.getCharIndex(), functionSrc.getCharLength());
            SLRootNode rootNode = new SLRootNode(this.language, this.frameDescriptor, functionBodyNode, functionSrc, this.functionName);
            this.allFunctions.put(this.functionName, Truffle.getRuntime().createCallTarget((RootNode)rootNode));
        }
        this.functionStartPos = 0;
        this.functionName = null;
        this.functionBodyStartPos = 0;
        this.parameterCount = 0;
        this.frameDescriptor = null;
        this.lexicalScope = null;
    }

    public void startBlock() {
        this.lexicalScope = new LexicalScope(this.lexicalScope);
    }

    public SLStatementNode finishBlock(List<SLStatementNode> bodyNodes, int startPos, int length) {
        return this.finishBlock(bodyNodes, 0, startPos, length);
    }

    public SLStatementNode finishBlock(List<SLStatementNode> bodyNodes, int skipCount, int startPos, int length) {
        this.lexicalScope = this.lexicalScope.outer;
        if (SLNodeFactory.containsNull(bodyNodes)) {
            return null;
        }
        ArrayList<SLStatementNode> flattenedNodes = new ArrayList<SLStatementNode>(bodyNodes.size());
        this.flattenBlocks(bodyNodes, flattenedNodes);
        int n = flattenedNodes.size();
        for (int i = skipCount; i < n; ++i) {
            SLStatementNode statement = (SLStatementNode)((Object)flattenedNodes.get(i));
            if (!statement.hasSource() || SLNodeFactory.isHaltInCondition(statement)) continue;
            statement.addStatementTag();
        }
        SLBlockNode blockNode = new SLBlockNode(flattenedNodes.toArray(new SLStatementNode[flattenedNodes.size()]));
        blockNode.setSourceSection(startPos, length);
        return blockNode;
    }

    private static boolean isHaltInCondition(SLStatementNode statement) {
        return statement instanceof SLIfNode || statement instanceof SLWhileNode;
    }

    private void flattenBlocks(Iterable<? extends SLStatementNode> bodyNodes, List<SLStatementNode> flattenedNodes) {
        for (SLStatementNode sLStatementNode : bodyNodes) {
            if (sLStatementNode instanceof SLBlockNode) {
                this.flattenBlocks(((SLBlockNode)sLStatementNode).getStatements(), flattenedNodes);
                continue;
            }
            flattenedNodes.add(sLStatementNode);
        }
    }

    SLStatementNode createDebugger(Token debuggerToken) {
        SLDebuggerNode debuggerNode = new SLDebuggerNode();
        SLNodeFactory.srcFromToken(debuggerNode, debuggerToken);
        return debuggerNode;
    }

    public SLStatementNode createBreak(Token breakToken) {
        SLBreakNode breakNode = new SLBreakNode();
        SLNodeFactory.srcFromToken(breakNode, breakToken);
        return breakNode;
    }

    public SLStatementNode createContinue(Token continueToken) {
        SLContinueNode continueNode = new SLContinueNode();
        SLNodeFactory.srcFromToken(continueNode, continueToken);
        return continueNode;
    }

    public SLStatementNode createWhile(Token whileToken, SLExpressionNode conditionNode, SLStatementNode bodyNode) {
        if (conditionNode == null || bodyNode == null) {
            return null;
        }
        conditionNode.addStatementTag();
        int start = whileToken.getStartIndex();
        int end = bodyNode.getSourceEndIndex();
        SLWhileNode whileNode = new SLWhileNode(conditionNode, bodyNode);
        whileNode.setSourceSection(start, end - start);
        return whileNode;
    }

    public SLStatementNode createIf(Token ifToken, SLExpressionNode conditionNode, SLStatementNode thenPartNode, SLStatementNode elsePartNode) {
        if (conditionNode == null || thenPartNode == null) {
            return null;
        }
        conditionNode.addStatementTag();
        int start = ifToken.getStartIndex();
        int end = elsePartNode == null ? thenPartNode.getSourceEndIndex() : elsePartNode.getSourceEndIndex();
        SLIfNode ifNode = new SLIfNode(conditionNode, thenPartNode, elsePartNode);
        ifNode.setSourceSection(start, end - start);
        return ifNode;
    }

    public SLStatementNode createReturn(Token t, SLExpressionNode valueNode) {
        int start = t.getStartIndex();
        int length = valueNode == null ? t.getText().length() : valueNode.getSourceEndIndex() - start;
        SLReturnNode returnNode = new SLReturnNode(valueNode);
        returnNode.setSourceSection(start, length);
        return returnNode;
    }

    public SLExpressionNode createBinary(Token opToken, SLExpressionNode leftNode, SLExpressionNode rightNode) {
        SLExpressionNode result;
        if (leftNode == null || rightNode == null) {
            return null;
        }
        SLUnboxNode leftUnboxed = SLUnboxNodeGen.create(leftNode);
        SLUnboxNode rightUnboxed = SLUnboxNodeGen.create(rightNode);
        switch (opToken.getText()) {
            case "+": {
                result = SLAddNodeGen.create(leftUnboxed, rightUnboxed);
                break;
            }
            case "*": {
                result = SLMulNodeGen.create(leftUnboxed, rightUnboxed);
                break;
            }
            case "/": {
                result = SLDivNodeGen.create(leftUnboxed, rightUnboxed);
                break;
            }
            case "-": {
                result = SLSubNodeGen.create(leftUnboxed, rightUnboxed);
                break;
            }
            case "<": {
                result = SLLessThanNodeGen.create(leftUnboxed, rightUnboxed);
                break;
            }
            case "<=": {
                result = SLLessOrEqualNodeGen.create(leftUnboxed, rightUnboxed);
                break;
            }
            case ">": {
                result = SLLogicalNotNodeGen.create(SLLessOrEqualNodeGen.create(leftUnboxed, rightUnboxed));
                break;
            }
            case ">=": {
                result = SLLogicalNotNodeGen.create(SLLessThanNodeGen.create(leftUnboxed, rightUnboxed));
                break;
            }
            case "==": {
                result = SLEqualNodeGen.create(leftUnboxed, rightUnboxed);
                break;
            }
            case "!=": {
                result = SLLogicalNotNodeGen.create(SLEqualNodeGen.create(leftUnboxed, rightUnboxed));
                break;
            }
            case "&&": {
                result = new SLLogicalAndNode(leftUnboxed, rightUnboxed);
                break;
            }
            case "||": {
                result = new SLLogicalOrNode(leftUnboxed, rightUnboxed);
                break;
            }
            default: {
                throw new RuntimeException("unexpected operation: " + opToken.getText());
            }
        }
        int start = leftNode.getSourceCharIndex();
        int length = rightNode.getSourceEndIndex() - start;
        result.setSourceSection(start, length);
        result.addExpressionTag();
        return result;
    }

    public SLExpressionNode createCall(SLExpressionNode functionNode, List<SLExpressionNode> parameterNodes, Token finalToken) {
        if (functionNode == null || SLNodeFactory.containsNull(parameterNodes)) {
            return null;
        }
        SLInvokeNode result = new SLInvokeNode(functionNode, parameterNodes.toArray(new SLExpressionNode[parameterNodes.size()]));
        int startPos = functionNode.getSourceCharIndex();
        int endPos = finalToken.getStartIndex() + finalToken.getText().length();
        result.setSourceSection(startPos, endPos - startPos);
        result.addExpressionTag();
        return result;
    }

    public SLExpressionNode createAssignment(SLExpressionNode nameNode, SLExpressionNode valueNode) {
        return this.createAssignment(nameNode, valueNode, null);
    }

    public SLExpressionNode createAssignment(SLExpressionNode nameNode, SLExpressionNode valueNode, Integer argumentIndex) {
        FrameSlot frameSlot;
        if (nameNode == null || valueNode == null) {
            return null;
        }
        String name = ((SLStringLiteralNode)nameNode).executeGeneric(null);
        FrameSlot existingSlot = this.lexicalScope.locals.put(name, frameSlot = this.frameDescriptor.findOrAddFrameSlot((Object)name, (Object)argumentIndex, FrameSlotKind.Illegal));
        boolean newVariable = existingSlot == null;
        SLWriteLocalVariableNode result = SLWriteLocalVariableNodeGen.create(valueNode, frameSlot, nameNode, newVariable);
        if (valueNode.hasSource()) {
            int start = nameNode.getSourceCharIndex();
            int length = valueNode.getSourceEndIndex() - start;
            result.setSourceSection(start, length);
        }
        if (argumentIndex == null) {
            result.addExpressionTag();
        }
        return result;
    }

    public SLExpressionNode createRead(SLExpressionNode nameNode) {
        if (nameNode == null) {
            return null;
        }
        String name = ((SLStringLiteralNode)nameNode).executeGeneric(null);
        FrameSlot frameSlot = this.lexicalScope.locals.get(name);
        SLExpressionNode result = frameSlot != null ? SLReadLocalVariableNodeGen.create(frameSlot) : new SLFunctionLiteralNode(name);
        result.setSourceSection(nameNode.getSourceCharIndex(), nameNode.getSourceLength());
        result.addExpressionTag();
        return result;
    }

    public SLExpressionNode createStringLiteral(Token literalToken, boolean removeQuotes) {
        String literal = literalToken.getText();
        if (removeQuotes) {
            assert (literal.length() >= 2 && literal.startsWith("\"") && literal.endsWith("\""));
            literal = literal.substring(1, literal.length() - 1);
        }
        SLStringLiteralNode result = new SLStringLiteralNode(literal.intern());
        SLNodeFactory.srcFromToken(result, literalToken);
        result.addExpressionTag();
        return result;
    }

    public SLExpressionNode createNumericLiteral(Token literalToken) {
        SLExpressionNode result;
        try {
            result = new SLLongLiteralNode(Long.parseLong(literalToken.getText()));
        }
        catch (NumberFormatException ex) {
            result = new SLBigIntegerLiteralNode(new BigInteger(literalToken.getText()));
        }
        SLNodeFactory.srcFromToken(result, literalToken);
        result.addExpressionTag();
        return result;
    }

    public SLExpressionNode createParenExpression(SLExpressionNode expressionNode, int start, int length) {
        if (expressionNode == null) {
            return null;
        }
        SLParenExpressionNode result = new SLParenExpressionNode(expressionNode);
        result.setSourceSection(start, length);
        return result;
    }

    public SLExpressionNode createReadProperty(SLExpressionNode receiverNode, SLExpressionNode nameNode) {
        if (receiverNode == null || nameNode == null) {
            return null;
        }
        SLReadPropertyNode result = SLReadPropertyNodeGen.create(receiverNode, nameNode);
        int startPos = receiverNode.getSourceCharIndex();
        int endPos = nameNode.getSourceEndIndex();
        result.setSourceSection(startPos, endPos - startPos);
        result.addExpressionTag();
        return result;
    }

    public SLExpressionNode createWriteProperty(SLExpressionNode receiverNode, SLExpressionNode nameNode, SLExpressionNode valueNode) {
        if (receiverNode == null || nameNode == null || valueNode == null) {
            return null;
        }
        SLWritePropertyNode result = SLWritePropertyNodeGen.create(receiverNode, nameNode, valueNode);
        int start = receiverNode.getSourceCharIndex();
        int length = valueNode.getSourceEndIndex() - start;
        result.setSourceSection(start, length);
        result.addExpressionTag();
        return result;
    }

    private static void srcFromToken(SLStatementNode node, Token token) {
        node.setSourceSection(token.getStartIndex(), token.getText().length());
    }

    private static boolean containsNull(List<?> list) {
        for (Object e : list) {
            if (e != null) continue;
            return true;
        }
        return false;
    }

    static class LexicalScope {
        protected final LexicalScope outer;
        protected final Map<String, FrameSlot> locals;

        LexicalScope(LexicalScope outer) {
            this.outer = outer;
            this.locals = new HashMap<String, FrameSlot>();
            if (outer != null) {
                this.locals.putAll(outer.locals);
            }
        }
    }
}

