/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.memory.MemoryFence;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLTypes;
import com.oracle.truffle.sl.nodes.SLTypesGen;
import com.oracle.truffle.sl.nodes.util.SLUnboxNode;
import com.oracle.truffle.sl.runtime.SLBigNumber;
import com.oracle.truffle.sl.runtime.SLFunction;
import com.oracle.truffle.sl.runtime.SLNull;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SLUnboxNode.class)
public final class SLUnboxNodeGen
extends SLUnboxNode {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @Node.Child
    private SLExpressionNode child0_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private FromForeign0Data fromForeign0_cache;

    private SLUnboxNodeGen(SLExpressionNode child0) {
        this.child0_ = child0;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0xFD) == 0 && (state_0 & 0xFF) != 0) {
            return this.executeGeneric_boolean0(state_0, frameValue);
        }
        if ((state_0 & 0xFB) == 0 && (state_0 & 0xFF) != 0) {
            return this.executeGeneric_long1(state_0, frameValue);
        }
        return this.executeGeneric_generic2(state_0, frameValue);
    }

    private Object executeGeneric_boolean0(int state_0, VirtualFrame frameValue) {
        boolean child0Value_;
        try {
            child0Value_ = this.child0_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 2) != 0);
        return SLUnboxNode.fromBoolean(child0Value_);
    }

    private Object executeGeneric_long1(int state_0, VirtualFrame frameValue) {
        long child0Value_;
        try {
            child0Value_ = this.child0_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 4) != 0);
        return SLUnboxNode.fromLong(child0Value_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object fromForeign1Boundary(int state_0, Object child0Value_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary fromForeign1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_);
            Object object = SLUnboxNode.fromForeign(child0Value_, fromForeign1_interop__);
            return object;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    private Object executeGeneric_generic2(int state_0, VirtualFrame frameValue) {
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && child0Value_ instanceof String) {
            String child0Value__ = (String)child0Value_;
            return SLUnboxNode.fromString(child0Value__);
        }
        if ((state_0 & 2) != 0 && child0Value_ instanceof Boolean) {
            boolean child0Value__ = (Boolean)child0Value_;
            return SLUnboxNode.fromBoolean(child0Value__);
        }
        if ((state_0 & 4) != 0 && child0Value_ instanceof Long) {
            long child0Value__ = (Long)child0Value_;
            return SLUnboxNode.fromLong(child0Value__);
        }
        if ((state_0 & 8) != 0 && SLTypesGen.isImplicitSLBigNumber((state_0 & 0x300) >>> 8, child0Value_)) {
            SLBigNumber child0Value__ = SLTypesGen.asImplicitSLBigNumber((state_0 & 0x300) >>> 8, child0Value_);
            return SLUnboxNode.fromBigNumber(child0Value__);
        }
        if ((state_0 & 0x10) != 0 && child0Value_ instanceof SLFunction) {
            SLFunction child0Value__ = (SLFunction)child0Value_;
            return SLUnboxNode.fromFunction(child0Value__);
        }
        if ((state_0 & 0x20) != 0 && SLTypes.isSLNull(child0Value_)) {
            SLNull child0Value__ = SLTypes.asSLNull(child0Value_);
            return SLUnboxNode.fromFunction(child0Value__);
        }
        if ((state_0 & 0xC0) != 0) {
            if ((state_0 & 0x40) != 0) {
                FromForeign0Data s6_ = this.fromForeign0_cache;
                while (s6_ != null) {
                    if (s6_.interop_.accepts(child0Value_)) {
                        return SLUnboxNode.fromForeign(child0Value_, s6_.interop_);
                    }
                    s6_ = s6_.next_;
                }
            }
            if ((state_0 & 0x80) != 0) {
                return this.fromForeign1Boundary(state_0, child0Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        boolean child0Value_;
        int state_0 = this.state_0_;
        if ((state_0 & 0xC0) != 0) {
            return SLTypesGen.expectBoolean(this.executeGeneric(frameValue));
        }
        try {
            child0Value_ = this.child0_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return SLTypesGen.expectBoolean(this.executeAndSpecialize(ex.getResult()));
        }
        if ((state_0 & 2) != 0) {
            return SLUnboxNode.fromBoolean(child0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return SLTypesGen.expectBoolean(this.executeAndSpecialize(child0Value_));
    }

    @Override
    public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
        long child0Value_;
        int state_0 = this.state_0_;
        if ((state_0 & 0xC0) != 0) {
            return SLTypesGen.expectLong(this.executeGeneric(frameValue));
        }
        try {
            child0Value_ = this.child0_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return SLTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
        }
        if ((state_0 & 4) != 0) {
            return SLUnboxNode.fromLong(child0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return SLTypesGen.expectLong(this.executeAndSpecialize(child0Value_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0xFB) == 0 && (state_0 & 0xFF) != 0) {
                this.executeLong(frameValue);
                return;
            }
            if ((state_0 & 0xFD) == 0 && (state_0 & 0xFF) != 0) {
                this.executeBoolean(frameValue);
                return;
            }
            this.executeGeneric(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object child0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            Object object;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            if (child0Value instanceof String) {
                String child0Value_ = (String)child0Value;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                String string = SLUnboxNode.fromString(child0Value_);
                return string;
            }
            if (child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                Boolean bl = SLUnboxNode.fromBoolean(child0Value_);
                return bl;
            }
            if (child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                Long l = SLUnboxNode.fromLong(child0Value_);
                return l;
            }
            int sLBigNumberCast0 = SLTypesGen.specializeImplicitSLBigNumber(child0Value);
            if (sLBigNumberCast0 != 0) {
                SLBigNumber child0Value_2 = SLTypesGen.asImplicitSLBigNumber(sLBigNumberCast0, child0Value);
                state_0 |= sLBigNumberCast0 << 8;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                SLBigNumber sLBigNumber = SLUnboxNode.fromBigNumber(child0Value_2);
                return sLBigNumber;
            }
            if (child0Value instanceof SLFunction) {
                SLFunction child0Value_ = (SLFunction)child0Value;
                this.state_0_ = state_0 |= 0x10;
                lock.unlock();
                hasLock = false;
                SLFunction child0Value_2 = SLUnboxNode.fromFunction(child0Value_);
                return child0Value_2;
            }
            if (SLTypes.isSLNull(child0Value)) {
                SLNull child0Value_ = SLTypes.asSLNull(child0Value);
                this.state_0_ = state_0 |= 0x20;
                lock.unlock();
                hasLock = false;
                SLNull child0Value_2 = SLUnboxNode.fromFunction(child0Value_);
                return child0Value_2;
            }
            if (exclude == 0) {
                int count6_ = 0;
                FromForeign0Data s6_ = this.fromForeign0_cache;
                if ((state_0 & 0x40) != 0) {
                    while (s6_ != null && !s6_.interop_.accepts(child0Value)) {
                        s6_ = s6_.next_;
                        ++count6_;
                    }
                }
                if (s6_ == null && count6_ < 5) {
                    s6_ = (FromForeign0Data)super.insert((Node)new FromForeign0Data(this.fromForeign0_cache));
                    s6_.interop_ = (InteropLibrary)s6_.insertAccessor(INTEROP_LIBRARY_.create(child0Value));
                    MemoryFence.storeStore();
                    this.fromForeign0_cache = s6_;
                    this.state_0_ = state_0 |= 0x40;
                }
                if (s6_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object2 = SLUnboxNode.fromForeign(child0Value, s6_.interop_);
                    return object2;
                }
            }
            InteropLibrary fromForeign1_interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                fromForeign1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value);
                this.exclude_ = exclude |= 1;
                this.fromForeign0_cache = null;
                state_0 &= 0xFFFFFFBF;
                this.state_0_ = state_0 |= 0x80;
                lock.unlock();
                hasLock = false;
                object = SLUnboxNode.fromForeign(child0Value, fromForeign1_interop__);
            }
            catch (Throwable throwable) {
                encapsulating_.set(prev_);
                throw throwable;
            }
            encapsulating_.set(prev_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        FromForeign0Data s6_;
        int state_0 = this.state_0_;
        if ((state_0 & 0xFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0xFF & (state_0 & 0xFF) - 1) == 0 && ((s6_ = this.fromForeign0_cache) == null || s6_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static SLUnboxNode create(SLExpressionNode child0) {
        return new SLUnboxNodeGen(child0);
    }

    @GeneratedBy(value=SLUnboxNode.class)
    private static final class FromForeign0Data
    extends Node {
        @Node.Child
        FromForeign0Data next_;
        @Node.Child
        InteropLibrary interop_;

        FromForeign0Data(FromForeign0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

