/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.sl.nodes.SLTypes;
import com.oracle.truffle.sl.runtime.SLBigNumber;

@TypeSystemReference(value=SLTypes.class)
@GenerateUncached
public abstract class SLToMemberNode
extends Node {
    static final int LIMIT = 5;

    public abstract String execute(Object var1) throws UnknownIdentifierException;

    @Specialization
    protected static String fromString(String value) {
        return value;
    }

    @Specialization
    protected static String fromBoolean(boolean value) {
        return String.valueOf(value);
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected static String fromLong(long value) {
        return String.valueOf(value);
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected static String fromBigNumber(SLBigNumber value) {
        return value.toString();
    }

    @Specialization(limit="LIMIT")
    protected static String fromInterop(Object value, @CachedLibrary(value="value") InteropLibrary interop) throws UnknownIdentifierException {
        try {
            if (interop.fitsInLong(value)) {
                return SLToMemberNode.longToString(interop.asLong(value));
            }
            if (interop.isString(value)) {
                return interop.asString(value);
            }
            if (interop.isNumber(value) && value instanceof SLBigNumber) {
                return SLToMemberNode.bigNumberToString((SLBigNumber)value);
            }
            throw SLToMemberNode.error(value);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static UnknownIdentifierException error(Object value) {
        return UnknownIdentifierException.create((String)value.toString());
    }

    @CompilerDirectives.TruffleBoundary
    private static String bigNumberToString(SLBigNumber value) {
        return value.toString();
    }

    @CompilerDirectives.TruffleBoundary
    private static String longToString(long longValue) {
        return String.valueOf(longValue);
    }
}

