/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.local;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.sl.nodes.SLTypesGen;
import com.oracle.truffle.sl.nodes.local.SLReadLocalVariableNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SLReadLocalVariableNode.class)
public final class SLReadLocalVariableNodeGen
extends SLReadLocalVariableNode {
    private final FrameSlot slot;
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;

    private SLReadLocalVariableNodeGen(FrameSlot slot) {
        this.slot = slot;
    }

    @Override
    protected FrameSlot getSlot() {
        return this.slot;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && frameValue.isLong(this.getSlot())) {
            return this.readLong(frameValue);
        }
        if ((state_0 & 2) != 0 && frameValue.isBoolean(this.getSlot())) {
            return this.readBoolean(frameValue);
        }
        if ((state_0 & 4) != 0) {
            return this.readObject(frameValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 4) != 0) {
            return SLTypesGen.expectBoolean(this.executeGeneric(frameValue));
        }
        if ((state_0 & 2) != 0 && frameValue.isBoolean(this.getSlot())) {
            return this.readBoolean(frameValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return SLTypesGen.expectBoolean(this.executeAndSpecialize(frameValue));
    }

    @Override
    public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 4) != 0) {
            return SLTypesGen.expectLong(this.executeGeneric(frameValue));
        }
        if ((state_0 & 1) != 0 && frameValue.isLong(this.getSlot())) {
            return this.readLong(frameValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return SLTypesGen.expectLong(this.executeAndSpecialize(frameValue));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 6) == 0 && state_0 != 0) {
                this.executeLong(frameValue);
                return;
            }
            if ((state_0 & 5) == 0 && state_0 != 0) {
                this.executeBoolean(frameValue);
                return;
            }
            this.executeGeneric(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(VirtualFrame frameValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            if ((exclude & 1) == 0 && frameValue.isLong(this.getSlot())) {
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                Long l = this.readLong(frameValue);
                return l;
            }
            if ((exclude & 2) == 0 && frameValue.isBoolean(this.getSlot())) {
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                Boolean bl = this.readBoolean(frameValue);
                return bl;
            }
            this.exclude_ = exclude |= 3;
            state_0 &= 0xFFFFFFFC;
            this.state_0_ = state_0 |= 4;
            lock.unlock();
            hasLock = false;
            Object object = this.readObject(frameValue);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static SLReadLocalVariableNode create(FrameSlot slot) {
        return new SLReadLocalVariableNodeGen(slot);
    }
}

