/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;

@ExportLibrary(value=InteropLibrary.class)
public final class NodeObjectDescriptorKeys
implements TruffleObject {
    private final String keyName;

    NodeObjectDescriptorKeys(String keyName) {
        this.keyName = keyName;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    boolean isArrayElementReadable(long index) {
        return index >= 0L && index < 1L;
    }

    @ExportMessage
    long getArraySize() {
        return 1L;
    }

    @ExportMessage
    Object readArrayElement(long index, @Cached BranchProfile exception) throws InvalidArrayIndexException {
        if (!this.isArrayElementReadable(index)) {
            exception.enter();
            throw InvalidArrayIndexException.create((long)index);
        }
        return this.keyName;
    }
}

