/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.sl.nodes.interop.NodeObjectDescriptorKeys;

public abstract class NodeObjectDescriptor
implements TruffleObject {
    private final String name;

    private NodeObjectDescriptor(String name) {
        assert (name != null);
        this.name = name;
    }

    public static NodeObjectDescriptor readVariable(String name) {
        return new ReadDescriptor(name);
    }

    public static NodeObjectDescriptor writeVariable(String name, SourceSection sourceSection) {
        return new WriteDescriptor(name, sourceSection);
    }

    Object readMember(String member, @Cached BranchProfile error) throws UnknownIdentifierException {
        if (this.isMemberReadable(member)) {
            return this.name;
        }
        error.enter();
        throw UnknownIdentifierException.create((String)member);
    }

    abstract boolean isMemberReadable(String var1);

    @ExportLibrary(value=InteropLibrary.class)
    static final class NameSymbol
    implements TruffleObject {
        private final String name;
        private final SourceSection sourceSection;

        NameSymbol(String name, SourceSection sourceSection) {
            this.name = name;
            this.sourceSection = sourceSection;
        }

        @ExportMessage
        boolean isString() {
            return true;
        }

        @ExportMessage
        String asString() {
            return this.name;
        }

        @ExportMessage
        boolean hasSourceLocation() {
            return this.sourceSection != null;
        }

        @ExportMessage
        SourceSection getSourceLocation() throws UnsupportedMessageException {
            if (this.sourceSection != null) {
                return this.sourceSection;
            }
            throw UnsupportedMessageException.create();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class WriteDescriptor
    extends NodeObjectDescriptor {
        private static final TruffleObject KEYS_WRITE = new NodeObjectDescriptorKeys("writeVariableName");
        private final Object nameSymbol;

        WriteDescriptor(String name, SourceSection sourceSection) {
            super(name);
            this.nameSymbol = new NameSymbol(name, sourceSection);
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @Override
        @ExportMessage
        boolean isMemberReadable(String member) {
            return "writeVariableName".equals(member);
        }

        @ExportMessage
        Object getMembers(boolean includeInternal) {
            return KEYS_WRITE;
        }

        @Override
        @ExportMessage
        Object readMember(String member, @Cached BranchProfile error) throws UnknownIdentifierException {
            super.readMember(member, error);
            return this.nameSymbol;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class ReadDescriptor
    extends NodeObjectDescriptor {
        private static final TruffleObject KEYS_READ = new NodeObjectDescriptorKeys("readVariableName");

        ReadDescriptor(String name) {
            super(name);
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @Override
        @ExportMessage
        boolean isMemberReadable(String member) {
            return "readVariableName".equals(member);
        }

        @ExportMessage
        Object getMembers(boolean includeInternal) {
            return KEYS_READ;
        }

        @Override
        @ExportMessage
        Object readMember(String member, @Cached BranchProfile error) throws UnknownIdentifierException {
            return super.readMember(member, error);
        }
    }
}

