/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.util.SLToMemberNode;
import com.oracle.truffle.sl.runtime.SLUndefinedNameException;

@NodeInfo(shortName=".=")
@NodeChildren(value={@NodeChild(value="receiverNode"), @NodeChild(value="nameNode"), @NodeChild(value="valueNode")})
public abstract class SLWritePropertyNode
extends SLExpressionNode {
    static final int LIBRARY_LIMIT = 3;

    @Specialization(guards={"arrays.hasArrayElements(receiver)"}, limit="LIBRARY_LIMIT")
    protected Object writeArray(Object receiver, Object index, Object value, @CachedLibrary(value="receiver") InteropLibrary arrays, @CachedLibrary(value="index") InteropLibrary numbers) {
        try {
            arrays.writeArrayElement(receiver, numbers.asLong(index), value);
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw SLUndefinedNameException.undefinedProperty(this, index);
        }
        return value;
    }

    @Specialization(limit="LIBRARY_LIMIT")
    protected Object writeObject(Object receiver, Object name, Object value, @CachedLibrary(value="receiver") InteropLibrary objectLibrary, @Cached SLToMemberNode asMember) {
        try {
            objectLibrary.writeMember(receiver, asMember.execute(name), value);
        }
        catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw SLUndefinedNameException.undefinedProperty(this, name);
        }
        return value;
    }
}

