/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.memory.MemoryFence;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.expression.SLReadPropertyNode;
import com.oracle.truffle.sl.nodes.util.SLToMemberNode;
import com.oracle.truffle.sl.nodes.util.SLToMemberNodeGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SLReadPropertyNode.class)
public final class SLReadPropertyNodeGen
extends SLReadPropertyNode {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @Node.Child
    private SLExpressionNode receiverNode_;
    @Node.Child
    private SLExpressionNode nameNode_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private ReadArray0Data readArray0_cache;
    @Node.Child
    private ReadObject0Data readObject0_cache;
    @Node.Child
    private SLToMemberNode readObject1_asMember_;

    private SLReadPropertyNodeGen(SLExpressionNode receiverNode, SLExpressionNode nameNode) {
        this.receiverNode_ = receiverNode;
        this.nameNode_ = nameNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExplodeLoop
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object receiverNodeValue_ = this.receiverNode_.executeGeneric(frameValue);
        Object nameNodeValue_ = this.nameNode_.executeGeneric(frameValue);
        if (state_0 != 0) {
            Node prev_;
            EncapsulatingNodeReference encapsulating_;
            if ((state_0 & 1) != 0) {
                ReadArray0Data s0_ = this.readArray0_cache;
                while (s0_ != null) {
                    if (s0_.arrays_.accepts(receiverNodeValue_) && s0_.numbers_.accepts(nameNodeValue_) && s0_.arrays_.hasArrayElements(receiverNodeValue_)) {
                        return this.readArray(receiverNodeValue_, nameNodeValue_, s0_.arrays_, s0_.numbers_);
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 2) != 0) {
                encapsulating_ = EncapsulatingNodeReference.getCurrent();
                prev_ = encapsulating_.set((Node)this);
                try {
                    InteropLibrary readArray1_arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (readArray1_arrays__.hasArrayElements(receiverNodeValue_)) {
                        Object object = this.readArray1Boundary(state_0, receiverNodeValue_, nameNodeValue_);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }
            if ((state_0 & 4) != 0) {
                ReadObject0Data s2_ = this.readObject0_cache;
                while (s2_ != null) {
                    if (s2_.objects_.accepts(receiverNodeValue_) && s2_.objects_.hasMembers(receiverNodeValue_)) {
                        return this.readObject(receiverNodeValue_, nameNodeValue_, s2_.objects_, s2_.asMember_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state_0 & 8) != 0) {
                encapsulating_ = EncapsulatingNodeReference.getCurrent();
                prev_ = encapsulating_.set((Node)this);
                try {
                    InteropLibrary readObject1_objects__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (readObject1_objects__.hasMembers(receiverNodeValue_)) {
                        Object object = this.readObject1Boundary(state_0, receiverNodeValue_, nameNodeValue_);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(receiverNodeValue_, nameNodeValue_);
    }

    @CompilerDirectives.TruffleBoundary
    private Object readArray1Boundary(int state_0, Object receiverNodeValue_, Object nameNodeValue_) {
        InteropLibrary readArray1_arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
        InteropLibrary readArray1_numbers__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
        return this.readArray(receiverNodeValue_, nameNodeValue_, readArray1_arrays__, readArray1_numbers__);
    }

    @CompilerDirectives.TruffleBoundary
    private Object readObject1Boundary(int state_0, Object receiverNodeValue_, Object nameNodeValue_) {
        InteropLibrary readObject1_objects__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
        return this.readObject(receiverNodeValue_, nameNodeValue_, readObject1_objects__, this.readObject1_asMember_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeGeneric(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object receiverNodeValue, Object nameNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            if ((exclude & 1) == 0) {
                Object arrays__;
                int count0_ = 0;
                ReadArray0Data s0_ = this.readArray0_cache;
                if ((state_0 & 1) != 0) {
                    while (!(s0_ == null || s0_.arrays_.accepts(receiverNodeValue) && s0_.numbers_.accepts(nameNodeValue) && s0_.arrays_.hasArrayElements(receiverNodeValue))) {
                        s0_ = s0_.next_;
                        ++count0_;
                    }
                }
                if (s0_ == null && (arrays__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(receiverNodeValue))).hasArrayElements(receiverNodeValue) && count0_ < 3) {
                    s0_ = (ReadArray0Data)super.insert((Node)new ReadArray0Data(this.readArray0_cache));
                    s0_.arrays_ = s0_.insertAccessor(arrays__);
                    s0_.numbers_ = (InteropLibrary)s0_.insertAccessor(INTEROP_LIBRARY_.create(nameNodeValue));
                    MemoryFence.storeStore();
                    this.readArray0_cache = s0_;
                    this.state_0_ = state_0 |= 1;
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    arrays__ = this.readArray(receiverNodeValue, nameNodeValue, s0_.arrays_, s0_.numbers_);
                    return arrays__;
                }
            }
            InteropLibrary readArray1_numbers__ = null;
            InteropLibrary readArray1_arrays__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                readArray1_arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                if (readArray1_arrays__.hasArrayElements(receiverNodeValue)) {
                    readArray1_numbers__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    this.exclude_ = exclude |= 1;
                    this.readArray0_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.readArray(receiverNodeValue, nameNodeValue, readArray1_arrays__, readArray1_numbers__);
                    return object;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            if ((exclude & 2) == 0) {
                Object objects__;
                int count2_ = 0;
                ReadObject0Data s2_ = this.readObject0_cache;
                if ((state_0 & 4) != 0) {
                    while (!(s2_ == null || s2_.objects_.accepts(receiverNodeValue) && s2_.objects_.hasMembers(receiverNodeValue))) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && (objects__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(receiverNodeValue))).hasMembers(receiverNodeValue) && count2_ < 3) {
                    s2_ = (ReadObject0Data)super.insert((Node)new ReadObject0Data(this.readObject0_cache));
                    s2_.objects_ = s2_.insertAccessor(objects__);
                    s2_.asMember_ = s2_.insertAccessor(SLToMemberNodeGen.create());
                    MemoryFence.storeStore();
                    this.readObject0_cache = s2_;
                    this.state_0_ = state_0 |= 4;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    objects__ = this.readObject(receiverNodeValue, nameNodeValue, s2_.objects_, s2_.asMember_);
                    return objects__;
                }
            }
            InteropLibrary readObject1_objects__ = null;
            EncapsulatingNodeReference encapsulating_2 = EncapsulatingNodeReference.getCurrent();
            Node prev_2 = encapsulating_2.set((Node)this);
            try {
                readObject1_objects__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                if (readObject1_objects__.hasMembers(receiverNodeValue)) {
                    this.readObject1_asMember_ = (SLToMemberNode)super.insert((Node)SLToMemberNodeGen.create());
                    this.exclude_ = exclude |= 2;
                    this.readObject0_cache = null;
                    state_0 &= 0xFFFFFFFB;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.readObject(receiverNodeValue, nameNodeValue, readObject1_objects__, this.readObject1_asMember_);
                    return object;
                }
            }
            finally {
                encapsulating_2.set(prev_2);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.receiverNode_, this.nameNode_}, new Object[]{receiverNodeValue, nameNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            ReadArray0Data s0_ = this.readArray0_cache;
            ReadObject0Data s2_ = this.readObject0_cache;
            if (!(s0_ != null && s0_.next_ != null || s2_ != null && s2_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static SLReadPropertyNode create(SLExpressionNode receiverNode, SLExpressionNode nameNode) {
        return new SLReadPropertyNodeGen(receiverNode, nameNode);
    }

    @GeneratedBy(value=SLReadPropertyNode.class)
    private static final class ReadObject0Data
    extends Node {
        @Node.Child
        ReadObject0Data next_;
        @Node.Child
        InteropLibrary objects_;
        @Node.Child
        SLToMemberNode asMember_;

        ReadObject0Data(ReadObject0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=SLReadPropertyNode.class)
    private static final class ReadArray0Data
    extends Node {
        @Node.Child
        ReadArray0Data next_;
        @Node.Child
        InteropLibrary arrays_;
        @Node.Child
        InteropLibrary numbers_;

        ReadArray0Data(ReadArray0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

