/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.util.SLToMemberNode;
import com.oracle.truffle.sl.runtime.SLUndefinedNameException;

@NodeInfo(shortName=".")
@NodeChildren(value={@NodeChild(value="receiverNode"), @NodeChild(value="nameNode")})
public abstract class SLReadPropertyNode
extends SLExpressionNode {
    static final int LIBRARY_LIMIT = 3;

    @Specialization(guards={"arrays.hasArrayElements(receiver)"}, limit="LIBRARY_LIMIT")
    protected Object readArray(Object receiver, Object index, @CachedLibrary(value="receiver") InteropLibrary arrays, @CachedLibrary(value="index") InteropLibrary numbers) {
        try {
            return arrays.readArrayElement(receiver, numbers.asLong(index));
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            throw SLUndefinedNameException.undefinedProperty(this, index);
        }
    }

    @Specialization(guards={"objects.hasMembers(receiver)"}, limit="LIBRARY_LIMIT")
    protected Object readObject(Object receiver, Object name, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached SLToMemberNode asMember) {
        try {
            return objects.readMember(receiver, asMember.execute(name));
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            throw SLUndefinedNameException.undefinedProperty(this, name);
        }
    }
}

