/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.runtime.SLContext;
import com.oracle.truffle.sl.runtime.SLFunction;

@NodeInfo(shortName="func")
public final class SLFunctionLiteralNode
extends SLExpressionNode {
    private final String functionName;
    @CompilerDirectives.CompilationFinal
    private SLFunction cachedFunction;

    public SLFunctionLiteralNode(String functionName) {
        this.functionName = functionName;
    }

    @Override
    public SLFunction executeGeneric(VirtualFrame frame) {
        SLFunction function;
        SLLanguage l = SLLanguage.get(this);
        CompilerAsserts.partialEvaluationConstant((Object)((Object)l));
        if (l.isSingleContext()) {
            function = this.cachedFunction;
            if (function == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedFunction = function = SLContext.get(this).getFunctionRegistry().lookup(this.functionName, true);
            }
        } else {
            if (this.cachedFunction != null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedFunction = null;
            }
            function = SLContext.get(this).getFunctionRegistry().lookup(this.functionName, true);
        }
        return function;
    }
}

