/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLTypesGen;
import com.oracle.truffle.sl.nodes.expression.SLDivNode;
import com.oracle.truffle.sl.runtime.SLBigNumber;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SLDivNode.class)
public final class SLDivNodeGen
extends SLDivNode {
    @Node.Child
    private SLExpressionNode leftNode_;
    @Node.Child
    private SLExpressionNode rightNode_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;

    private SLDivNodeGen(SLExpressionNode leftNode, SLExpressionNode rightNode) {
        this.leftNode_ = leftNode;
        this.rightNode_ = rightNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 6) == 0 && (state_0 & 7) != 0) {
            return this.executeGeneric_long_long0(state_0, frameValue);
        }
        return this.executeGeneric_generic1(state_0, frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeGeneric_long_long0(int state_0, VirtualFrame frameValue) {
        long rightNodeValue_;
        long leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        try {
            return this.div(leftNodeValue_, rightNodeValue_);
        }
        catch (ArithmeticException ex) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                this.exclude_ |= 1;
                this.state_0_ &= 0xFFFFFFFE;
            }
            finally {
                lock.unlock();
            }
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeGeneric_generic1(int state_0, VirtualFrame frameValue) {
        Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
        Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && leftNodeValue_ instanceof Long) {
            long leftNodeValue__ = (Long)leftNodeValue_;
            if (rightNodeValue_ instanceof Long) {
                long rightNodeValue__ = (Long)rightNodeValue_;
                try {
                    return this.div(leftNodeValue__, rightNodeValue__);
                }
                catch (ArithmeticException ex) {
                    Lock lock = this.getLock();
                    lock.lock();
                    try {
                        this.exclude_ |= 1;
                        this.state_0_ &= 0xFFFFFFFE;
                    }
                    finally {
                        lock.unlock();
                    }
                    return this.executeAndSpecialize(leftNodeValue__, rightNodeValue__);
                }
            }
        }
        if ((state_0 & 2) != 0 && SLTypesGen.isImplicitSLBigNumber((state_0 & 0x18) >>> 3, leftNodeValue_)) {
            SLBigNumber leftNodeValue__ = SLTypesGen.asImplicitSLBigNumber((state_0 & 0x18) >>> 3, leftNodeValue_);
            if (SLTypesGen.isImplicitSLBigNumber((state_0 & 0x60) >>> 5, rightNodeValue_)) {
                SLBigNumber rightNodeValue__ = SLTypesGen.asImplicitSLBigNumber((state_0 & 0x60) >>> 5, rightNodeValue_);
                return this.div(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 4) != 0 && SLDivNodeGen.fallbackGuard_(leftNodeValue_, rightNodeValue_)) {
            return this.typeError(leftNodeValue_, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
        long rightNodeValue_;
        long leftNodeValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 4) != 0) {
            return SLTypesGen.expectLong(this.executeGeneric(frameValue));
        }
        try {
            leftNodeValue_ = this.leftNode_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return SLTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        try {
            rightNodeValue_ = this.rightNode_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return SLTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        if ((state_0 & 1) != 0) {
            try {
                return this.div(leftNodeValue_, rightNodeValue_);
            }
            catch (ArithmeticException ex) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    this.exclude_ |= 1;
                    this.state_0_ &= 0xFFFFFFFE;
                }
                finally {
                    lock.unlock();
                }
                return SLTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return SLTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 6) == 0 && (state_0 & 7) != 0) {
                this.executeLong(frameValue);
                return;
            }
            this.executeGeneric(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int sLBigNumberCast0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            if (exclude == 0 && leftNodeValue instanceof Long) {
                long leftNodeValue_ = (Long)leftNodeValue;
                if (rightNodeValue instanceof Long) {
                    long rightNodeValue_ = (Long)rightNodeValue;
                    this.state_0_ = state_0 |= 1;
                    try {
                        lock.unlock();
                        hasLock = false;
                        Long l = this.div(leftNodeValue_, rightNodeValue_);
                        return l;
                    }
                    catch (ArithmeticException ex) {
                        lock.lock();
                        try {
                            this.exclude_ |= 1;
                            this.state_0_ &= 0xFFFFFFFE;
                        }
                        finally {
                            lock.unlock();
                        }
                        Object object = this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                        if (hasLock) {
                            lock.unlock();
                        }
                        return object;
                    }
                }
            }
            if ((sLBigNumberCast0 = SLTypesGen.specializeImplicitSLBigNumber(leftNodeValue)) != 0) {
                SLBigNumber leftNodeValue_ = SLTypesGen.asImplicitSLBigNumber(sLBigNumberCast0, leftNodeValue);
                int sLBigNumberCast1 = SLTypesGen.specializeImplicitSLBigNumber(rightNodeValue);
                if (sLBigNumberCast1 != 0) {
                    SLBigNumber rightNodeValue_ = SLTypesGen.asImplicitSLBigNumber(sLBigNumberCast1, rightNodeValue);
                    state_0 |= sLBigNumberCast0 << 3;
                    state_0 |= sLBigNumberCast1 << 5;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    SLBigNumber sLBigNumber = this.div(leftNodeValue_, rightNodeValue_);
                    return sLBigNumber;
                }
            }
            this.state_0_ = state_0 |= 4;
            lock.unlock();
            hasLock = false;
            Object object = this.typeError(leftNodeValue, rightNodeValue);
            return object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 7) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 7 & (state_0 & 7) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean fallbackGuard_(Object leftNodeValue, Object rightNodeValue) {
        return !SLTypesGen.isImplicitSLBigNumber(leftNodeValue) || !SLTypesGen.isImplicitSLBigNumber(rightNodeValue);
    }

    public static SLDivNode create(SLExpressionNode leftNode, SLExpressionNode rightNode) {
        return new SLDivNodeGen(leftNode, rightNode);
    }
}

