/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.sl.SLException;
import com.oracle.truffle.sl.nodes.SLBinaryNode;
import com.oracle.truffle.sl.runtime.SLBigNumber;

@NodeInfo(shortName="/")
public abstract class SLDivNode
extends SLBinaryNode {
    @Specialization(rewriteOn={ArithmeticException.class})
    protected long div(long left, long right) throws ArithmeticException {
        long result = left / right;
        if ((left & right & result) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return result;
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected SLBigNumber div(SLBigNumber left, SLBigNumber right) {
        return new SLBigNumber(left.getValue().divide(right.getValue()));
    }

    @Fallback
    protected Object typeError(Object left, Object right) {
        throw SLException.typeError(this, left, right);
    }
}

