/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLTypesGen;
import com.oracle.truffle.sl.nodes.expression.SLAddNode;
import com.oracle.truffle.sl.runtime.SLBigNumber;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SLAddNode.class)
public final class SLAddNodeGen
extends SLAddNode {
    @Node.Child
    private SLExpressionNode leftNode_;
    @Node.Child
    private SLExpressionNode rightNode_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;

    private SLAddNodeGen(SLExpressionNode leftNode, SLExpressionNode rightNode) {
        this.leftNode_ = leftNode;
        this.rightNode_ = rightNode;
    }

    private boolean fallbackGuard_(int state_0, Object leftNodeValue, Object rightNodeValue) {
        if (SLTypesGen.isImplicitSLBigNumber(leftNodeValue) && SLTypesGen.isImplicitSLBigNumber(rightNodeValue)) {
            return false;
        }
        return (state_0 & 4) != 0 || !this.isString(leftNodeValue, rightNodeValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0xE) == 0 && (state_0 & 0xF) != 0) {
            return this.executeGeneric_long_long0(state_0, frameValue);
        }
        return this.executeGeneric_generic1(state_0, frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeGeneric_long_long0(int state_0, VirtualFrame frameValue) {
        long rightNodeValue_;
        long leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        try {
            return this.add(leftNodeValue_, rightNodeValue_);
        }
        catch (ArithmeticException ex) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                this.exclude_ |= 1;
                this.state_0_ &= 0xFFFFFFFE;
            }
            finally {
                lock.unlock();
            }
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeGeneric_generic1(int state_0, VirtualFrame frameValue) {
        Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
        Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && leftNodeValue_ instanceof Long) {
            long leftNodeValue__ = (Long)leftNodeValue_;
            if (rightNodeValue_ instanceof Long) {
                long rightNodeValue__ = (Long)rightNodeValue_;
                try {
                    return this.add(leftNodeValue__, rightNodeValue__);
                }
                catch (ArithmeticException ex) {
                    Lock lock = this.getLock();
                    lock.lock();
                    try {
                        this.exclude_ |= 1;
                        this.state_0_ &= 0xFFFFFFFE;
                    }
                    finally {
                        lock.unlock();
                    }
                    return this.executeAndSpecialize(leftNodeValue__, rightNodeValue__);
                }
            }
        }
        if ((state_0 & 2) != 0 && SLTypesGen.isImplicitSLBigNumber((state_0 & 0x30) >>> 4, leftNodeValue_)) {
            SLBigNumber leftNodeValue__ = SLTypesGen.asImplicitSLBigNumber((state_0 & 0x30) >>> 4, leftNodeValue_);
            if (SLTypesGen.isImplicitSLBigNumber((state_0 & 0xC0) >>> 6, rightNodeValue_)) {
                SLBigNumber rightNodeValue__ = SLTypesGen.asImplicitSLBigNumber((state_0 & 0xC0) >>> 6, rightNodeValue_);
                return this.add(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 0xC) != 0) {
            if ((state_0 & 4) != 0 && this.isString(leftNodeValue_, rightNodeValue_)) {
                return this.add(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 8) != 0 && this.fallbackGuard_(state_0, leftNodeValue_, rightNodeValue_)) {
                return this.typeError(leftNodeValue_, rightNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
        long rightNodeValue_;
        long leftNodeValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 8) != 0) {
            return SLTypesGen.expectLong(this.executeGeneric(frameValue));
        }
        try {
            leftNodeValue_ = this.leftNode_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return SLTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        try {
            rightNodeValue_ = this.rightNode_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return SLTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        if ((state_0 & 1) != 0) {
            try {
                return this.add(leftNodeValue_, rightNodeValue_);
            }
            catch (ArithmeticException ex) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    this.exclude_ |= 1;
                    this.state_0_ &= 0xFFFFFFFE;
                }
                finally {
                    lock.unlock();
                }
                return SLTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return SLTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0xE) == 0 && (state_0 & 0xF) != 0) {
                this.executeLong(frameValue);
                return;
            }
            this.executeGeneric(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int sLBigNumberCast0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            if (exclude == 0 && leftNodeValue instanceof Long) {
                long leftNodeValue_ = (Long)leftNodeValue;
                if (rightNodeValue instanceof Long) {
                    long rightNodeValue_ = (Long)rightNodeValue;
                    this.state_0_ = state_0 |= 1;
                    try {
                        lock.unlock();
                        hasLock = false;
                        Long l = this.add(leftNodeValue_, rightNodeValue_);
                        return l;
                    }
                    catch (ArithmeticException ex) {
                        lock.lock();
                        try {
                            this.exclude_ |= 1;
                            this.state_0_ &= 0xFFFFFFFE;
                        }
                        finally {
                            lock.unlock();
                        }
                        Object object = this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                        if (hasLock) {
                            lock.unlock();
                        }
                        return object;
                    }
                }
            }
            if ((sLBigNumberCast0 = SLTypesGen.specializeImplicitSLBigNumber(leftNodeValue)) != 0) {
                SLBigNumber leftNodeValue_ = SLTypesGen.asImplicitSLBigNumber(sLBigNumberCast0, leftNodeValue);
                int sLBigNumberCast1 = SLTypesGen.specializeImplicitSLBigNumber(rightNodeValue);
                if (sLBigNumberCast1 != 0) {
                    SLBigNumber rightNodeValue_ = SLTypesGen.asImplicitSLBigNumber(sLBigNumberCast1, rightNodeValue);
                    state_0 |= sLBigNumberCast0 << 4;
                    state_0 |= sLBigNumberCast1 << 6;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    SLBigNumber sLBigNumber = this.add(leftNodeValue_, rightNodeValue_);
                    return sLBigNumber;
                }
            }
            if (this.isString(leftNodeValue, rightNodeValue)) {
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                String string = this.add(leftNodeValue, rightNodeValue);
                return string;
            }
            this.state_0_ = state_0 |= 8;
            lock.unlock();
            hasLock = false;
            Object object = this.typeError(leftNodeValue, rightNodeValue);
            return object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0xF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static SLAddNode create(SLExpressionNode leftNode, SLExpressionNode rightNode) {
        return new SLAddNodeGen(leftNode, rightNode);
    }
}

