/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.controlflow;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.nodes.BlockNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.sl.nodes.SLStatementNode;
import com.oracle.truffle.sl.nodes.local.SLScopedNode;
import com.oracle.truffle.sl.nodes.local.SLWriteLocalVariableNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@NodeInfo(shortName="block", description="The node implementing a source code block")
public final class SLBlockNode
extends SLStatementNode
implements BlockNode.ElementExecutor<SLStatementNode> {
    @Node.Child
    private BlockNode<SLStatementNode> block;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private SLWriteLocalVariableNode[] writeNodesCache;
    @CompilerDirectives.CompilationFinal
    private int parentBlockIndex = -1;

    public SLBlockNode(SLStatementNode[] bodyNodes) {
        this.block = bodyNodes.length > 0 ? BlockNode.create((Node[])bodyNodes, (BlockNode.ElementExecutor)this) : null;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        if (this.block != null) {
            this.block.executeVoid(frame, 0);
        }
    }

    public List<SLStatementNode> getStatements() {
        if (this.block == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.block.getElements()));
    }

    public void executeVoid(VirtualFrame frame, SLStatementNode node, int index, int argument) {
        node.executeVoid(frame);
    }

    public SLWriteLocalVariableNode[] getDeclaredLocalVariables() {
        SLWriteLocalVariableNode[] writeNodes = this.writeNodesCache;
        if (writeNodes == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            writeNodes = this.findDeclaredLocalVariables();
            this.writeNodesCache = writeNodes;
        }
        return writeNodes;
    }

    public int getParentBlockIndex() {
        return this.parentBlockIndex;
    }

    private SLWriteLocalVariableNode[] findDeclaredLocalVariables() {
        if (this.block == null) {
            return new SLWriteLocalVariableNode[0];
        }
        final ArrayList writeNodes = new ArrayList(4);
        final int[] varsIndex = new int[]{0};
        NodeUtil.forEachChild(this.block, (NodeVisitor)new NodeVisitor(){

            public boolean visit(Node node) {
                SLWriteLocalVariableNode wn;
                SLScopedNode scopedNode;
                if (node instanceof InstrumentableNode.WrapperNode) {
                    NodeUtil.forEachChild((Node)node, (NodeVisitor)this);
                    return true;
                }
                if (node instanceof SLScopedNode) {
                    scopedNode = (SLScopedNode)node;
                    scopedNode.setVisibleVariablesIndexOnEnter(varsIndex[0]);
                }
                if (!(node instanceof SLBlockNode)) {
                    NodeUtil.forEachChild((Node)node, (NodeVisitor)this);
                }
                if (node instanceof SLWriteLocalVariableNode && (wn = (SLWriteLocalVariableNode)node).isDeclaration()) {
                    writeNodes.add(wn);
                    varsIndex[0] = varsIndex[0] + 1;
                }
                if (node instanceof SLScopedNode) {
                    scopedNode = (SLScopedNode)node;
                    scopedNode.setVisibleVariablesIndexOnExit(varsIndex[0]);
                }
                return true;
            }
        });
        Node parentBlock = this.findBlock();
        SLWriteLocalVariableNode[] parentVariables = null;
        if (parentBlock instanceof SLBlockNode) {
            parentVariables = ((SLBlockNode)parentBlock).getDeclaredLocalVariables();
        }
        SLWriteLocalVariableNode[] variables = writeNodes.toArray(new SLWriteLocalVariableNode[writeNodes.size()]);
        this.parentBlockIndex = variables.length;
        if (parentVariables == null || parentVariables.length == 0) {
            return variables;
        }
        int parentVariablesIndex = ((SLBlockNode)parentBlock).getParentBlockIndex();
        int visibleVarsIndex = this.getVisibleVariablesIndexOnEnter();
        int allVarsLength = variables.length + visibleVarsIndex + parentVariables.length - parentVariablesIndex;
        SLWriteLocalVariableNode[] allVariables = Arrays.copyOf(variables, allVarsLength);
        System.arraycopy(parentVariables, 0, allVariables, variables.length, visibleVarsIndex);
        System.arraycopy(parentVariables, parentVariablesIndex, allVariables, variables.length + visibleVarsIndex, parentVariables.length - parentVariablesIndex);
        return allVariables;
    }
}

