/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImplicitCast;
import com.oracle.truffle.api.dsl.TypeCast;
import com.oracle.truffle.api.dsl.TypeCheck;
import com.oracle.truffle.api.dsl.TypeSystem;
import com.oracle.truffle.sl.runtime.SLBigNumber;
import com.oracle.truffle.sl.runtime.SLNull;
import java.math.BigInteger;

@TypeSystem(value={long.class, boolean.class})
public abstract class SLTypes {
    @TypeCheck(value=SLNull.class)
    public static boolean isSLNull(Object value) {
        return value == SLNull.SINGLETON;
    }

    @TypeCast(value=SLNull.class)
    public static SLNull asSLNull(Object value) {
        assert (SLTypes.isSLNull(value));
        return SLNull.SINGLETON;
    }

    @CompilerDirectives.TruffleBoundary
    @ImplicitCast
    public static SLBigNumber castBigNumber(long value) {
        return new SLBigNumber(BigInteger.valueOf(value));
    }
}

