/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;

@NodeInfo(shortName="stacktrace")
public abstract class SLStackTraceBuiltin
extends SLBuiltinNode {
    @Specialization
    public String trace() {
        return SLStackTraceBuiltin.createStackTrace();
    }

    @CompilerDirectives.TruffleBoundary
    private static String createStackTrace() {
        final StringBuilder str = new StringBuilder();
        Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Integer>(){
            private int skip = 1;

            public Integer visitFrame(FrameInstance frameInstance) {
                if (this.skip > 0) {
                    --this.skip;
                    return null;
                }
                CallTarget callTarget = frameInstance.getCallTarget();
                Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY);
                RootNode rn = ((RootCallTarget)callTarget).getRootNode();
                if (rn.isInternal() || rn.getLanguageInfo() == null) {
                    return 1;
                }
                if (str.length() > 0) {
                    str.append(System.getProperty("line.separator"));
                }
                str.append("Frame: ").append(rn.toString());
                FrameDescriptor frameDescriptor = frame.getFrameDescriptor();
                for (FrameSlot s : frameDescriptor.getSlots()) {
                    str.append(", ").append(s.getIdentifier()).append("=").append(frame.getValue(s));
                }
                return null;
            }
        });
        return str.toString();
    }
}

