/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.sl.SLException;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;
import com.oracle.truffle.sl.runtime.SLContext;
import java.io.BufferedReader;
import java.io.IOException;

@NodeInfo(shortName="readln")
public abstract class SLReadlnBuiltin
extends SLBuiltinNode {
    @Specialization
    public String readln() {
        String result = this.doRead(SLContext.get(this).getInput());
        if (result == null) {
            result = "";
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private String doRead(BufferedReader in) {
        try {
            return in.readLine();
        }
        catch (IOException ex) {
            throw new SLException(ex.getMessage(), this);
        }
    }
}

