/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.memory.MemoryFence;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.sl.builtins.SLGetSizeBuiltin;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SLGetSizeBuiltin.class)
public final class SLGetSizeBuiltinFactory
implements NodeFactory<SLGetSizeBuiltin> {
    private static final SLGetSizeBuiltinFactory INSTANCE = new SLGetSizeBuiltinFactory();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private SLGetSizeBuiltinFactory() {
    }

    public Class<SLGetSizeBuiltin> getNodeClass() {
        return SLGetSizeBuiltin.class;
    }

    public List<Class<? extends Node>> getExecutionSignature() {
        return Arrays.asList(SLExpressionNode.class);
    }

    public List<List<Class<?>>> getNodeSignatures() {
        return Arrays.asList(Arrays.asList(SLExpressionNode[].class));
    }

    public SLGetSizeBuiltin createNode(Object ... arguments) {
        if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof SLExpressionNode[])) {
            return SLGetSizeBuiltinFactory.create((SLExpressionNode[])arguments[0]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static NodeFactory<SLGetSizeBuiltin> getInstance() {
        return INSTANCE;
    }

    public static SLGetSizeBuiltin create(SLExpressionNode[] arguments) {
        return new SLGetSizeBuiltinNodeGen(arguments);
    }

    @GeneratedBy(value=SLGetSizeBuiltin.class)
    public static final class SLGetSizeBuiltinNodeGen
    extends SLGetSizeBuiltin {
        @Node.Child
        private SLExpressionNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private GetSize0Data getSize0_cache;

        private SLGetSizeBuiltinNodeGen(SLExpressionNode[] arguments) {
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        @ExplodeLoop
        protected Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.executeGeneric(frameValue);
            if (state_0 != 0) {
                if ((state_0 & 1) != 0) {
                    GetSize0Data s0_ = this.getSize0_cache;
                    while (s0_ != null) {
                        if (s0_.arrays_.accepts(arguments0Value_)) {
                            return this.getSize(arguments0Value_, s0_.arrays_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 2) != 0) {
                    return this.getSize1Boundary(state_0, arguments0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object getSize1Boundary(int state_0, Object arguments0Value_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary getSize1_arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value_);
                Object object = this.getSize(arguments0Value_, getSize1_arrays__);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                Object object;
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                if (exclude == 0) {
                    int count0_ = 0;
                    GetSize0Data s0_ = this.getSize0_cache;
                    if ((state_0 & 1) != 0) {
                        while (s0_ != null && !s0_.arrays_.accepts(arguments0Value)) {
                            s0_ = s0_.next_;
                            ++count0_;
                        }
                    }
                    if (s0_ == null && count0_ < 3) {
                        s0_ = (GetSize0Data)super.insert((Node)new GetSize0Data(this.getSize0_cache));
                        s0_.arrays_ = (InteropLibrary)s0_.insertAccessor(INTEROP_LIBRARY_.create(arguments0Value));
                        MemoryFence.storeStore();
                        this.getSize0_cache = s0_;
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s0_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object2 = this.getSize(arguments0Value, s0_.arrays_);
                        return object2;
                    }
                }
                InteropLibrary getSize1_arrays__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    getSize1_arrays__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value);
                    this.exclude_ = exclude |= 1;
                    this.getSize0_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    object = this.getSize(arguments0Value, getSize1_arrays__);
                }
                catch (Throwable throwable) {
                    encapsulating_.set(prev_);
                    throw throwable;
                }
                encapsulating_.set(prev_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            GetSize0Data s0_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.getSize0_cache) == null || s0_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @GeneratedBy(value=SLGetSizeBuiltin.class)
        private static final class GetSize0Data
        extends Node {
            @Node.Child
            GetSize0Data next_;
            @Node.Child
            InteropLibrary arrays_;

            GetSize0Data(GetSize0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

