/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.memory.MemoryFence;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.sl.builtins.SLEvalBuiltin;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SLEvalBuiltin.class)
public final class SLEvalBuiltinFactory
implements NodeFactory<SLEvalBuiltin> {
    private static final SLEvalBuiltinFactory INSTANCE = new SLEvalBuiltinFactory();

    private SLEvalBuiltinFactory() {
    }

    public Class<SLEvalBuiltin> getNodeClass() {
        return SLEvalBuiltin.class;
    }

    public List<Class<? extends Node>> getExecutionSignature() {
        return Arrays.asList(SLExpressionNode.class, SLExpressionNode.class);
    }

    public List<List<Class<?>>> getNodeSignatures() {
        return Arrays.asList(Arrays.asList(SLExpressionNode[].class));
    }

    public SLEvalBuiltin createNode(Object ... arguments) {
        if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof SLExpressionNode[])) {
            return SLEvalBuiltinFactory.create((SLExpressionNode[])arguments[0]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static NodeFactory<SLEvalBuiltin> getInstance() {
        return INSTANCE;
    }

    public static SLEvalBuiltin create(SLExpressionNode[] arguments) {
        return new SLEvalBuiltinNodeGen(arguments);
    }

    @GeneratedBy(value=SLEvalBuiltin.class)
    public static final class SLEvalBuiltinNodeGen
    extends SLEvalBuiltin {
        @Node.Child
        private SLExpressionNode arguments0_;
        @Node.Child
        private SLExpressionNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private EvalCachedData evalCached_cache;

        private SLEvalBuiltinNodeGen(SLExpressionNode[] arguments) {
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        @ExplodeLoop
        protected Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.executeGeneric(frameValue);
            Object arguments1Value_ = this.arguments1_.executeGeneric(frameValue);
            if (state_0 != 0 && arguments0Value_ instanceof String) {
                String arguments0Value__ = (String)arguments0Value_;
                if (arguments1Value_ instanceof String) {
                    String arguments1Value__ = (String)arguments1Value_;
                    if ((state_0 & 1) != 0) {
                        EvalCachedData s0_ = this.evalCached_cache;
                        while (s0_ != null) {
                            if (SLEvalBuiltin.stringsEqual(s0_.cachedId_, arguments0Value__) && SLEvalBuiltin.stringsEqual(s0_.cachedCode_, arguments1Value__)) {
                                return this.evalCached(arguments0Value__, arguments1Value__, s0_.cachedId_, s0_.cachedCode_, s0_.callNode_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        return this.evalUncached(arguments0Value__, arguments1Value__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                if (arguments0Value instanceof String) {
                    String arguments0Value_ = (String)arguments0Value;
                    if (arguments1Value instanceof String) {
                        String arguments1Value_ = (String)arguments1Value;
                        if (exclude == 0) {
                            String cachedCode__;
                            String cachedId__;
                            int count0_ = 0;
                            EvalCachedData s0_ = this.evalCached_cache;
                            if ((state_0 & 1) != 0) {
                                while (!(s0_ == null || SLEvalBuiltin.stringsEqual(s0_.cachedId_, arguments0Value_) && SLEvalBuiltin.stringsEqual(s0_.cachedCode_, arguments1Value_))) {
                                    s0_ = s0_.next_;
                                    ++count0_;
                                }
                            }
                            if (s0_ == null && SLEvalBuiltin.stringsEqual(cachedId__ = arguments0Value_, arguments0Value_) && SLEvalBuiltin.stringsEqual(cachedCode__ = arguments1Value_, arguments1Value_) && count0_ < 2) {
                                s0_ = (EvalCachedData)super.insert((Node)new EvalCachedData(this.evalCached_cache));
                                s0_.cachedId_ = cachedId__;
                                s0_.cachedCode_ = cachedCode__;
                                s0_.callNode_ = s0_.insertAccessor(DirectCallNode.create((CallTarget)this.parse(arguments0Value_, arguments1Value_)));
                                MemoryFence.storeStore();
                                this.evalCached_cache = s0_;
                                this.state_0_ = state_0 |= 1;
                            }
                            if (s0_ != null) {
                                lock.unlock();
                                hasLock = false;
                                Object object = this.evalCached(arguments0Value_, arguments1Value_, s0_.cachedId_, s0_.cachedCode_, s0_.callNode_);
                                return object;
                            }
                        }
                        this.exclude_ = exclude |= 1;
                        this.evalCached_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.evalUncached(arguments0Value_, arguments1Value_);
                        return object;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            EvalCachedData s0_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.evalCached_cache) == null || s0_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @GeneratedBy(value=SLEvalBuiltin.class)
        private static final class EvalCachedData
        extends Node {
            @Node.Child
            EvalCachedData next_;
            @CompilerDirectives.CompilationFinal
            String cachedId_;
            @CompilerDirectives.CompilationFinal
            String cachedCode_;
            @Node.Child
            DirectCallNode callNode_;

            EvalCachedData(EvalCachedData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

