/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;
import com.oracle.truffle.sl.runtime.SLContext;

@NodeInfo(shortName="eval")
public abstract class SLEvalBuiltin
extends SLBuiltinNode {
    static final int LIMIT = 2;

    @Specialization(guards={"stringsEqual(cachedId, id)", "stringsEqual(cachedCode, code)"}, limit="LIMIT")
    public Object evalCached(String id, String code, @Cached(value="id") String cachedId, @Cached(value="code") String cachedCode, @Cached(value="create(parse(id, code))") DirectCallNode callNode) {
        return callNode.call(new Object[0]);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(replaces={"evalCached"})
    public Object evalUncached(String id, String code) {
        return this.parse(id, code).call(new Object[0]);
    }

    protected CallTarget parse(String id, String code) {
        Source source = Source.newBuilder((String)id, (CharSequence)code, (String)"(eval)").build();
        return SLContext.get(this).parse(source);
    }

    protected static boolean stringsEqual(String a, String b) {
        return a.equals(b);
    }
}

