/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.debug;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilerListener;
import com.oracle.truffle.runtime.AbstractCompilationTask;
import com.oracle.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedDirectCallNode;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;

public final class StatisticsListener
extends AbstractGraalTruffleRuntimeListener {
    static final int EXPECTED_TIERS = 2;
    private long firstCompilation;
    private int compilations;
    private int invalidations;
    private int failures;
    private int temporaryBailouts;
    private int permanentBailouts;
    private int success;
    private int queues;
    private int dequeues;
    private int splits;
    private final IdentityStatistics<String> temporaryBailoutReasons = new IdentityStatistics();
    private final IdentityStatistics<String> permanentBailoutReasons = new IdentityStatistics();
    private final IdentityStatistics<String> failureReasons = new IdentityStatistics();
    private final IdentityStatistics<String> invalidatedReasons = new IdentityStatistics();
    private final IdentityStatistics<String> dequeuedReasons = new IdentityStatistics();
    private final TargetLongStatistics timeToQueue = new TargetLongStatistics();
    private final TargetLongStatistics timeInQueue = new TargetLongStatistics();
    private final TargetIntStatistics nodeCount = new TargetIntStatistics();
    private final IdentityStatistics<Class<?>> nodeStatistics = new IdentityStatistics();
    private final TargetIntStatistics callCount = new TargetIntStatistics();
    private final TargetIntStatistics callCountIndirect = new TargetIntStatistics();
    private final TargetIntStatistics callCountDirect = new TargetIntStatistics();
    private final TargetIntStatistics callCountDirectDispatched = new TargetIntStatistics();
    private final TargetIntStatistics callCountDirectInlined = new TargetIntStatistics();
    private final TargetIntStatistics callCountDirectCloned = new TargetIntStatistics();
    private final TargetIntStatistics callCountDirectNotCloned = new TargetIntStatistics();
    private final TargetIntStatistics loopCount = new TargetIntStatistics();
    private final CompilationStatistics[] tieredStatistics = new CompilationStatistics[2];
    private final Map<OptimizedCallTarget, Long> timeQueued;
    private final ThreadLocal<CurrentCompilationStatistics> currentCompilationStatistics;

    private StatisticsListener(OptimizedTruffleRuntime runtime) {
        super(runtime);
        for (int i = 0; i < this.tieredStatistics.length; ++i) {
            this.tieredStatistics[i] = new CompilationStatistics();
        }
        this.timeQueued = new HashMap<OptimizedCallTarget, Long>();
        this.currentCompilationStatistics = new ThreadLocal();
    }

    public static void install(OptimizedTruffleRuntime runtime) {
        runtime.addListener(new StatisticsDispatcher(runtime));
    }

    public static StatisticsListener createEngineListener(OptimizedTruffleRuntime runtime) {
        return new StatisticsListener(runtime);
    }

    @Override
    public synchronized void onCompilationSplit(OptimizedDirectCallNode callNode) {
        ++this.splits;
    }

    @Override
    public synchronized void onCompilationQueued(OptimizedCallTarget target, int tier) {
        ++this.queues;
        long currentTime = System.nanoTime();
        if (this.firstCompilation == 0L) {
            this.firstCompilation = currentTime;
        }
        this.timeQueued.put(target, currentTime);
        long timeStamp = target.getInitializedTimestamp();
        if (timeStamp != 0L) {
            this.timeToQueue.accept(currentTime - timeStamp, target);
        }
    }

    @Override
    public synchronized void onCompilationDequeued(OptimizedCallTarget target, Object source, CharSequence reason, int tier) {
        ++this.dequeues;
        this.dequeuedReasons.accept(Arrays.asList(Objects.toString(reason)), target);
        this.timeQueued.remove(target);
    }

    @Override
    public synchronized void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
        ++this.invalidations;
        String useReason = reason == null ? "Unknown Reason" : reason.toString();
        this.invalidatedReasons.accept(Arrays.asList(useReason), target);
    }

    @Override
    public void onCompilationStarted(OptimizedCallTarget target, AbstractCompilationTask task) {
        ++this.compilations;
        CurrentCompilationStatistics times = new CurrentCompilationStatistics(task.tier());
        this.currentCompilationStatistics.set(times);
        Long timeStamp = this.timeQueued.get(target);
        if (timeStamp != null) {
            this.timeInQueue.accept(times.compilationStarted - timeStamp, target);
        }
        this.timeQueued.remove(target);
    }

    @Override
    public synchronized void onCompilationTruffleTierFinished(OptimizedCallTarget target, AbstractCompilationTask task, TruffleCompilerListener.GraphInfo graph) {
        CurrentCompilationStatistics current = this.currentCompilationStatistics.get();
        current.truffleTierFinished = System.nanoTime();
        this.nodeStatistics.accept(StatisticsListener.nodeClasses(task), target);
        CallTargetNodeStatistics callTargetStat = new CallTargetNodeStatistics(task);
        this.nodeCount.accept(callTargetStat.getNodeCount(), target);
        this.callCount.accept(callTargetStat.getCallCount(), target);
        this.callCountIndirect.accept(callTargetStat.getCallCountIndirect(), target);
        this.callCountDirect.accept(callTargetStat.getCallCountDirect(), target);
        this.callCountDirectDispatched.accept(callTargetStat.getCallCountDirectDispatched(), target);
        this.callCountDirectInlined.accept(callTargetStat.getCallCountDirectInlined(), target);
        this.callCountDirectCloned.accept(callTargetStat.getCallCountDirectCloned(), target);
        this.callCountDirectNotCloned.accept(callTargetStat.getCallCountDirectNotCloned(), target);
        this.loopCount.accept(callTargetStat.getLoopCount(), target);
        CompilationStatistics s = this.getStatisticsForTier(current.tier);
        s.truffleTierNodeCount.accept(graph.getNodeCount(), target);
        if (target.engine.callTargetStatisticDetails) {
            s.truffleTierNodeStatistics.accept(Arrays.asList(graph.getNodeTypes(true)), target);
        }
    }

    private CompilationStatistics getStatisticsForTier(int tier) {
        if (tier <= 0 || tier > 2) {
            throw new AssertionError((Object)"Unexpected tier");
        }
        return this.tieredStatistics[tier - 1];
    }

    private static Collection<Class<?>> nodeClasses(AbstractCompilationTask task) {
        final ArrayList nodeClasses = new ArrayList();
        for (TruffleCompilable ast : task.inlinedTargets()) {
            ((OptimizedCallTarget)ast).accept(new NodeVisitor(){

                public boolean visit(Node node) {
                    if (node != null) {
                        nodeClasses.add(node.getClass());
                    }
                    return true;
                }
            });
        }
        return nodeClasses;
    }

    @Override
    public synchronized void onCompilationGraalTierFinished(OptimizedCallTarget target, TruffleCompilerListener.GraphInfo graph) {
        CurrentCompilationStatistics current = this.currentCompilationStatistics.get();
        current.graalTierFinished = System.nanoTime();
        CompilationStatistics s = this.getStatisticsForTier(current.tier);
        s.graalTierNodeCount.accept(graph.getNodeCount(), target);
        if (target.engine.callTargetStatisticDetails) {
            s.graalTierNodeStatistics.accept(Arrays.asList(graph.getNodeTypes(true)), target);
        }
    }

    @Override
    public synchronized void onCompilationSuccess(OptimizedCallTarget target, AbstractCompilationTask task, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        ++this.success;
        long compilationDone = System.nanoTime();
        CurrentCompilationStatistics current = this.currentCompilationStatistics.get();
        assert (current.tier == task.tier());
        long compilationTime = compilationDone - current.compilationStarted;
        int codeSize = result.getTargetCodeSize();
        CompilationStatistics s = this.getStatisticsForTier(current.tier);
        s.compilationTime.accept(compilationTime, target);
        s.compilationTimeTruffleTier.accept(current.truffleTierFinished - current.compilationStarted, target);
        s.compilationTimeGraalTier.accept(current.graalTierFinished - current.truffleTierFinished, target);
        s.compilationTimeCodeInstallation.accept(compilationDone - current.graalTierFinished, target);
        s.compilationResultCodeSize.accept(codeSize, target);
        s.compilationResultTotalFrameSize.accept(result.getTotalFrameSize(), target);
        s.compilationResultExceptionHandlers.accept(result.getExceptionHandlersCount(), target);
        s.compilationResultInfopoints.accept(result.getInfopointsCount(), target);
        s.compilationResultInfopointStatistics.accept(Arrays.asList(result.getInfopoints()), target);
        s.compilationResultMarks.accept(result.getMarksCount(), target);
        s.compilationResultDataPatches.accept(result.getDataPatchesCount(), target);
    }

    @Override
    public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout, int tier, Supplier<String> lazyStackTrace) {
        if (bailout) {
            if (permanentBailout) {
                ++this.permanentBailouts;
                this.permanentBailoutReasons.accept(Arrays.asList(reason), target);
            } else {
                ++this.temporaryBailouts;
                this.temporaryBailoutReasons.accept(Arrays.asList(reason), target);
            }
        } else {
            ++this.failures;
            this.failureReasons.accept(Arrays.asList(reason), target);
        }
        CurrentCompilationStatistics times = this.currentCompilationStatistics.get();
        this.getStatisticsForTier((int)times.tier).compilationTime.accept(System.nanoTime() - times.compilationStarted, target);
    }

    @Override
    public void onEngineClosed(EngineData runtimeData) {
        this.printStatistics(runtimeData);
    }

    static String formatLabel(String s) {
        return s;
    }

    private void printStatistics(EngineData runtimeData) {
        OptimizedTruffleRuntime rt = this.runtime;
        long endTime = System.nanoTime();
        StringWriter logMessage = new StringWriter();
        try (PrintWriter out = new PrintWriter(logMessage);){
            out.print("Truffle runtime statistics for engine " + runtimeData.id);
            StatisticsListener.printStatistic(out, "  Compilations", this.compilations);
            StatisticsListener.printStatistic(out, "    Success", this.success);
            StatisticsListener.printStatistic(out, "    Temporary Bailouts", this.temporaryBailouts);
            this.temporaryBailoutReasons.printStatistics(out, StatisticsListener::formatLabel, true, false);
            StatisticsListener.printStatistic(out, "    Permanent Bailouts", this.permanentBailouts);
            this.permanentBailoutReasons.printStatistics(out, StatisticsListener::formatLabel, true, false);
            StatisticsListener.printStatistic(out, "    Failed", this.failures);
            this.failureReasons.printStatistics(out, StatisticsListener::formatLabel, true, false);
            StatisticsListener.printStatistic(out, "    Interrupted", this.compilations - (this.success + this.failures + this.temporaryBailouts + this.permanentBailouts));
            StatisticsListener.printStatistic(out, "  Invalidated", this.invalidations);
            this.invalidatedReasons.printStatistics(out, StatisticsListener::formatLabel, true, false);
            StatisticsListener.printStatistic(out, "  Queues", this.queues);
            StatisticsListener.printStatistic(out, "  Dequeues", this.dequeues);
            this.dequeuedReasons.printStatistics(out, StatisticsListener::formatLabel, true, false);
            StatisticsListener.printStatistic(out, "  Splits", this.splits);
            StatisticsListener.printStatistic(out, "  Compilation Accuracy", 1.0 - (double)this.invalidations / (double)this.compilations);
            StatisticsListener.printStatistic(out, "  Queue Accuracy", 1.0 - (double)this.dequeues / (double)this.queues);
            long compilationTimeSum = 0L;
            for (int i = 0; i < this.tieredStatistics.length; ++i) {
                compilationTimeSum += this.tieredStatistics[i].compilationTime.getSum();
            }
            StatisticsListener.printStatistic(out, "  Compilation Utilization", (double)compilationTimeSum / (double)(endTime - this.firstCompilation));
            StatisticsListener.printStatistic(out, "  Remaining Compilation Queue", rt.getCompilationQueueSize());
            StatisticsListener.printStatisticTime(out, "  Time to queue", this.timeToQueue);
            StatisticsListener.printStatisticTime(out, "  Time waiting in queue", this.timeInQueue);
            StatisticsListener.printStatistic(out, "---------------------------");
            StatisticsListener.printStatistic(out, "AST node statistics ");
            StatisticsListener.printStatistic(out, "  Truffle node count", this.nodeCount);
            StatisticsListener.printStatistic(out, "  Truffle call count", this.callCount);
            StatisticsListener.printStatistic(out, "    Indirect", this.callCountIndirect);
            StatisticsListener.printStatistic(out, "    Direct", this.callCountDirect);
            StatisticsListener.printStatistic(out, "      Dispatched", this.callCountDirectDispatched);
            StatisticsListener.printStatistic(out, "      Inlined", this.callCountDirectInlined);
            StatisticsListener.printStatistic(out, "      ----------");
            StatisticsListener.printStatistic(out, "      Cloned", this.callCountDirectCloned);
            StatisticsListener.printStatistic(out, "      Not Cloned", this.callCountDirectNotCloned);
            StatisticsListener.printStatistic(out, "  Truffle loops", this.loopCount);
            if (runtimeData.callTargetStatisticDetails) {
                StatisticsListener.printStatistic(out, "Truffle nodes");
                this.nodeStatistics.printStatistics(out, Class::getSimpleName, false, true);
            }
            for (int tierIndex = 0; tierIndex < 2; ++tierIndex) {
                StatisticsListener.printStatistic(out, "---------------------------");
                StatisticsListener.printStatistic(out, "Compilation Tier " + (tierIndex + 1));
                CompilationStatistics s = this.tieredStatistics[tierIndex];
                StatisticsListener.printStatisticRate(out, "  Compilation Rate", (double)s.compilationResultCodeSize.getSum() / ((double)s.compilationTime.getSum() / 1.0E9), "bytes/second");
                StatisticsListener.printStatisticRate(out, "    Truffle Tier Rate", (double)s.compilationResultCodeSize.getSum() / ((double)s.compilationTimeTruffleTier.getSum() / 1.0E9), "bytes/second");
                StatisticsListener.printStatisticRate(out, "    Graal Tier Rate", (double)s.compilationResultCodeSize.getSum() / ((double)s.compilationTimeGraalTier.getSum() / 1.0E9), "bytes/second");
                StatisticsListener.printStatisticRate(out, "    Installation Rate", (double)s.compilationResultCodeSize.getSum() / ((double)s.compilationTimeCodeInstallation.getSum() / 1.0E9), "bytes/second");
                StatisticsListener.printStatisticTime(out, "  Time for compilation (us)", s.compilationTime);
                StatisticsListener.printStatisticTime(out, "    Truffle Tier (us)", s.compilationTimeTruffleTier);
                StatisticsListener.printStatisticTime(out, "    Graal Tier (us)", s.compilationTimeGraalTier);
                StatisticsListener.printStatisticTime(out, "    Code Installation (us)", s.compilationTimeCodeInstallation);
                StatisticsListener.printStatistic(out, "  Graal node count");
                StatisticsListener.printStatistic(out, "    After Truffle Tier", s.truffleTierNodeCount);
                StatisticsListener.printStatistic(out, "    After Graal Tier", s.graalTierNodeCount);
                StatisticsListener.printStatistic(out, "  Graal compilation result");
                StatisticsListener.printStatistic(out, "    Code size", s.compilationResultCodeSize);
                StatisticsListener.printStatistic(out, "    Total frame size", s.compilationResultTotalFrameSize);
                StatisticsListener.printStatistic(out, "    Exception handlers", s.compilationResultExceptionHandlers);
                StatisticsListener.printStatistic(out, "    Infopoints", s.compilationResultInfopoints);
                s.compilationResultInfopointStatistics.printStatistics(out, Function.identity(), false, true);
                StatisticsListener.printStatistic(out, "  Marks", s.compilationResultMarks);
                StatisticsListener.printStatistic(out, "  Data references", s.compilationResultDataPatches);
                if (!runtimeData.callTargetStatisticDetails) continue;
                StatisticsListener.printStatistic(out, "  Graal nodes after Truffle tier");
                s.truffleTierNodeStatistics.printStatistics(out, Function.identity(), false, true);
                StatisticsListener.printStatistic(out, "  Graal nodes after Graal tier");
                s.graalTierNodeStatistics.printStatistics(out, Function.identity(), false, true);
            }
        }
        TruffleLogger logger = runtimeData.getEngineLogger();
        logger.log(Level.INFO, logMessage.toString());
    }

    private static void printStatistic(PrintWriter out, String label) {
        out.printf("%n  %-30s:", label);
    }

    private static void printStatistic(PrintWriter out, String label, long value) {
        out.printf("%n  %-30s: %d", label, value);
    }

    private static void printStatistic(PrintWriter out, String label, double value) {
        out.printf("%n  %-30s: %f", label, value);
    }

    private static void printStatistic(PrintWriter out, String label, TargetIntStatistics value) {
        out.printf("%n  %-30s: count=%4d, sum=%10d, min=%8d, average=%12.2f, max=%8d, maxTarget=%s", label, value.getCount(), value.getSum(), value.getMin(), value.getAverage(), value.getMax(), value.getMaxName());
    }

    private static void printStatisticTime(PrintWriter out, String label, TargetLongStatistics value) {
        out.printf("%n  %-30s: count=%4d, sum=%10d, min=%8d, average=%12.2f, max=%8d, maxTarget=%s", label, value.getCount(), value.getSum() / 1000L, value.getMin() / 1000L, value.getAverage() / 1000.0, value.getMax() / 1000L, value.getMaxName());
    }

    private static void printStatisticRate(PrintWriter out, String label, double value, String unit) {
        out.printf("%n  %-30s: %12.2f %s", label, Double.isNaN(value) ? 0.0 : value, unit);
    }

    private static final class IdentityStatistics<T> {
        final Map<T, TargetIntStatistics> types = new HashMap<T, TargetIntStatistics>();
        private int elementCount;

        private IdentityStatistics() {
        }

        public void printStatistics(PrintWriter out, Function<T, String> toStringFunction, boolean onlyCount, boolean normalize) {
            if (normalize) {
                this.normalize();
            }
            this.types.keySet().stream().sorted(Comparator.comparing(c -> -this.types.get(c).getSum())).forEach(c -> {
                String label = String.format("      %s", toStringFunction.apply(c));
                TargetIntStatistics statistic = this.types.get(c);
                if (onlyCount) {
                    StatisticsListener.printStatistic(out, label, statistic.getCount());
                } else {
                    StatisticsListener.printStatistic(out, label, statistic);
                }
            });
        }

        private void normalize() {
            for (TargetIntStatistics stat : this.types.values()) {
                while (stat.getCount() < (long)this.elementCount) {
                    stat.accept(0, null);
                }
            }
        }

        public void accept(Collection<T> elements, OptimizedCallTarget target) {
            ++this.elementCount;
            HashMap<Object, Integer> histogram = new HashMap<Object, Integer>();
            for (T t : elements) {
                histogram.compute(t, (key, count) -> count == null ? 1 : count + 1);
            }
            for (Map.Entry entry : histogram.entrySet()) {
                Object element = entry.getKey();
                Integer count2 = (Integer)entry.getValue();
                this.types.computeIfAbsent(element, key -> new TargetIntStatistics()).accept(count2, target);
            }
        }
    }

    private static final class TargetLongStatistics
    extends LongSummaryStatistics {
        private String maxName;

        private TargetLongStatistics() {
        }

        public void accept(long value, OptimizedCallTarget target) {
            if (value > this.getMax()) {
                this.maxName = target.getName();
            }
            super.accept(value);
        }

        public String getMaxName() {
            return this.maxName;
        }

        @Override
        @Deprecated(since="20.3")
        public void accept(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated(since="20.3")
        public void combine(LongSummaryStatistics other) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class TargetIntStatistics
    extends IntSummaryStatistics {
        private String maxName;

        private TargetIntStatistics() {
        }

        public void accept(int value, OptimizedCallTarget target) {
            if (value > this.getMax() && target != null) {
                this.maxName = target.getName();
            }
            super.accept(value);
        }

        public String getMaxName() {
            return this.maxName;
        }

        @Override
        @Deprecated(since="20.3")
        public void accept(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated(since="20.3")
        public void combine(IntSummaryStatistics other) {
            throw new UnsupportedOperationException();
        }
    }

    static final class CompilationStatistics {
        final TargetLongStatistics compilationTime = new TargetLongStatistics();
        final TargetLongStatistics compilationTimeTruffleTier = new TargetLongStatistics();
        final TargetLongStatistics compilationTimeGraalTier = new TargetLongStatistics();
        final TargetLongStatistics compilationTimeCodeInstallation = new TargetLongStatistics();
        final TargetIntStatistics truffleTierNodeCount = new TargetIntStatistics();
        final IdentityStatistics<String> truffleTierNodeStatistics = new IdentityStatistics();
        final TargetIntStatistics graalTierNodeCount = new TargetIntStatistics();
        final IdentityStatistics<String> graalTierNodeStatistics = new IdentityStatistics();
        final TargetIntStatistics compilationResultCodeSize = new TargetIntStatistics();
        final TargetIntStatistics compilationResultExceptionHandlers = new TargetIntStatistics();
        final TargetIntStatistics compilationResultInfopoints = new TargetIntStatistics();
        final IdentityStatistics<String> compilationResultInfopointStatistics = new IdentityStatistics();
        final TargetIntStatistics compilationResultMarks = new TargetIntStatistics();
        final TargetIntStatistics compilationResultTotalFrameSize = new TargetIntStatistics();
        final TargetIntStatistics compilationResultDataPatches = new TargetIntStatistics();

        CompilationStatistics() {
        }
    }

    private static final class StatisticsDispatcher
    extends AbstractGraalTruffleRuntimeListener {
        private StatisticsDispatcher(OptimizedTruffleRuntime runtime) {
            super(runtime);
        }

        @Override
        public void onCompilationQueued(OptimizedCallTarget target, int tier) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationQueued(target, tier);
            }
        }

        @Override
        public void onCompilationStarted(OptimizedCallTarget target, AbstractCompilationTask task) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationStarted(target, task);
            }
        }

        @Override
        public void onCompilationSplit(OptimizedDirectCallNode callNode) {
            StatisticsListener listener = callNode.getCallTarget().engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationSplit(callNode);
            }
        }

        @Override
        public void onCompilationSplitFailed(OptimizedDirectCallNode callNode, CharSequence reason) {
            StatisticsListener listener = callNode.getCallTarget().engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationSplitFailed(callNode, reason);
            }
        }

        @Override
        public void onCompilationDequeued(OptimizedCallTarget target, Object source, CharSequence reason, int tier) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationDequeued(target, source, reason, tier);
            }
        }

        @Override
        public void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationInvalidated(target, source, reason);
            }
        }

        @Override
        public void onCompilationTruffleTierFinished(OptimizedCallTarget target, AbstractCompilationTask task, TruffleCompilerListener.GraphInfo graph) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationTruffleTierFinished(target, task, graph);
            }
        }

        @Override
        public void onCompilationGraalTierFinished(OptimizedCallTarget target, TruffleCompilerListener.GraphInfo graph) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationGraalTierFinished(target, graph);
            }
        }

        @Override
        public void onCompilationSuccess(OptimizedCallTarget target, AbstractCompilationTask task, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationSuccess(target, task, graph, result);
            }
        }

        @Override
        public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout, int tier, Supplier<String> lazyStackTrace) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationFailed(target, reason, bailout, permanentBailout, tier, lazyStackTrace);
            }
        }

        @Override
        public void onEngineClosed(EngineData runtimeData) {
            StatisticsListener listener = runtimeData.statisticsListener;
            if (listener != null) {
                listener.onEngineClosed(runtimeData);
            }
        }
    }

    static class CurrentCompilationStatistics {
        final long compilationStarted = System.nanoTime();
        long truffleTierFinished;
        long graalTierFinished;
        final int tier;

        CurrentCompilationStatistics(int tier) {
            this.tier = tier;
        }
    }

    private static final class CallTargetNodeStatistics {
        private int nodeCount;
        private int callCountIndirect;
        private int callCountDirectDispatched;
        private int callCountDirectInlined;
        private int callCountDirectCloned;
        private int callCountDirectNotCloned;
        private int loopCount;

        CallTargetNodeStatistics(AbstractCompilationTask task) {
            for (TruffleCompilable ast : task.inlinedTargets()) {
                ((OptimizedCallTarget)ast).accept(this::visitNode);
            }
            this.callCountDirectInlined = task.countInlinedCalls();
            this.callCountDirectDispatched = task.countCalls() - this.callCountDirectInlined;
        }

        private boolean visitNode(Node node) {
            if (node == null) {
                return true;
            }
            ++this.nodeCount;
            if (node instanceof DirectCallNode) {
                OptimizedDirectCallNode optimizedDirectCallNode;
                OptimizedDirectCallNode optimizedDirectCallNode2 = optimizedDirectCallNode = node instanceof OptimizedDirectCallNode ? (OptimizedDirectCallNode)node : null;
                if (optimizedDirectCallNode != null && optimizedDirectCallNode.getCallTarget().isSplit()) {
                    ++this.callCountDirectCloned;
                } else {
                    ++this.callCountDirectNotCloned;
                }
            } else if (node instanceof IndirectCallNode) {
                ++this.callCountIndirect;
            } else if (node instanceof LoopNode) {
                ++this.loopCount;
            }
            return true;
        }

        public int getCallCountDirectCloned() {
            return this.callCountDirectCloned;
        }

        public int getCallCountDirectNotCloned() {
            return this.callCountDirectNotCloned;
        }

        public int getNodeCount() {
            return this.nodeCount;
        }

        public int getCallCount() {
            return this.getCallCountDirect() + this.callCountIndirect;
        }

        public int getCallCountDirect() {
            return this.callCountDirectDispatched + this.callCountDirectInlined;
        }

        public int getCallCountIndirect() {
            return this.callCountIndirect;
        }

        public int getCallCountDirectDispatched() {
            return this.callCountDirectDispatched;
        }

        public int getCallCountDirectInlined() {
            return this.callCountDirectInlined;
        }

        public int getLoopCount() {
            return this.loopCount;
        }
    }
}

