/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.nfi.NFIType;

@GenerateAOT
abstract class ConvertTypeNode
extends Node {
    ConvertTypeNode() {
    }

    abstract Object execute(NFIType var1, Object var2) throws UnsupportedTypeException;

    @GenerateUncached
    static abstract class ConvertFromNativeNode
    extends ConvertTypeNode {
        ConvertFromNativeNode() {
        }

        @Specialization(guards={"type.cachedState == convertImpl.typeState"}, limit="3")
        Object doCached(NFIType type, Object value, @Cached(value="type.cachedState.createFromNative()") OptimizedConvertTypeNode convertImpl) throws UnsupportedTypeException {
            return convertImpl.execute(type, value);
        }

        @Specialization(replaces={"doCached"})
        Object doGeneric(NFIType type, Object value) throws UnsupportedTypeException {
            return ((ConvertTypeNode)((Object)type.cachedState.fromNativeFactory.getUncachedInstance())).execute(type, value);
        }
    }

    @GenerateUncached
    static abstract class ConvertToNativeNode
    extends ConvertTypeNode {
        ConvertToNativeNode() {
        }

        @Specialization(guards={"type.cachedState == convertImpl.typeState"}, limit="3")
        Object doCached(NFIType type, Object value, @Cached(value="type.cachedState.createToNative()") OptimizedConvertTypeNode convertImpl) throws UnsupportedTypeException {
            return convertImpl.execute(type, value);
        }

        @Specialization(replaces={"doCached"})
        Object doGeneric(NFIType type, Object value) throws UnsupportedTypeException {
            return ((ConvertTypeNode)((Object)type.cachedState.toNativeFactory.getUncachedInstance())).execute(type, value);
        }
    }

    static final class OptimizedConvertTypeNode
    extends ConvertTypeNode {
        final NFIType.TypeCachedState typeState;
        @Node.Child
        ConvertTypeNode convertImpl;

        OptimizedConvertTypeNode(NFIType.TypeCachedState typeState, ConvertTypeNode convertImpl) {
            this.typeState = typeState;
            this.convertImpl = convertImpl;
        }

        @Override
        Object execute(NFIType type, Object value) throws UnsupportedTypeException {
            assert (type.cachedState == this.typeState);
            return this.convertImpl.execute(type, value);
        }
    }
}

